/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.pattern.LXPattern;

public class PatternClipEvent
extends LXClipEvent<PatternClipEvent> {
    private final PatternClipLane lane;
    private LXPattern pattern;
    protected static final String KEY_PATTERN_INDEX = "patternIndex";

    public PatternClipEvent(PatternClipLane lane, Cursor cursor, int patternIndex) {
        this(lane, lane.channel.patterns.get(patternIndex));
        this.setCursor(cursor);
    }

    PatternClipEvent(PatternClipLane lane, LXPattern pattern) {
        super(lane, pattern);
        this.lane = lane;
        this.pattern = pattern;
    }

    PatternClipEvent(PatternClipLane lane, Cursor cursor, LXPattern pattern) {
        this(lane, pattern);
        this.setCursor(cursor);
    }

    public LXPattern getPattern() {
        return this.pattern;
    }

    public PatternClipEvent setPattern(LXPattern pattern) {
        if (this.pattern != pattern) {
            this.pattern = pattern;
            this.lane.onChange.bang();
        }
        return this;
    }

    @Override
    public void execute() {
        this.lane.playPatternEvent(this);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_PATTERN_INDEX, (Number)this.pattern.getIndex());
    }
}

