/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.PatternClipEvent;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;

public class PatternClipLane
extends LXClipLane<PatternClipEvent>
implements LXChannel.Listener {
    public final LXChannel channel;
    private boolean internalTrigger = false;

    PatternClipLane(LXClip clip) {
        super(clip);
        this.channel = (LXChannel)clip.bus;
        this.channel.addListener(this);
    }

    @Override
    public void patternRemoved(LXChannel channel, LXPattern pattern) {
        boolean changed = false;
        int i = 0;
        while (i < this.mutableEvents.size()) {
            PatternClipEvent event = (PatternClipEvent)this.mutableEvents.get(i);
            if (event.getPattern() == pattern) {
                if (!changed) {
                    this.mutableEvents.begin();
                    changed = true;
                }
                this.mutableEvents.remove(i);
                --i;
            }
            ++i;
        }
        if (changed) {
            this.mutableEvents.commit();
            this.onChange.bang();
        }
    }

    private void triggerPattern(LXPattern pattern) {
        this.internalTrigger = true;
        this.channel.goPattern(pattern);
        this.internalTrigger = false;
    }

    void playPatternEvent(PatternClipEvent pattern) {
        this.triggerPattern(pattern.getPattern());
    }

    void recordPatternEvent(LXPattern pattern) {
        if (!this.internalTrigger) {
            this.recordEvent(new PatternClipEvent(this, pattern));
            this.overdubActive = true;
        }
    }

    public List<Integer> findEventIndices(LXPattern pattern) {
        ArrayList<Integer> indices = null;
        int i = 0;
        for (PatternClipEvent event : this.events) {
            if (event.getPattern() == pattern) {
                if (indices == null) {
                    indices = new ArrayList<Integer>();
                }
                indices.add(i);
            }
            ++i;
        }
        return indices;
    }

    @Override
    public String getPath() {
        return "Pattern";
    }

    @Override
    public String getLabel() {
        return "Pattern";
    }

    private LXPattern getPatternBeforeCursor(Cursor to) {
        if (!this.events.isEmpty()) {
            int index = this.cursorPlayIndex(to);
            return ((PatternClipEvent)this.events.get(index > 0 ? index - 1 : index)).getPattern();
        }
        return null;
    }

    private LXPattern getPatternAtCursor(Cursor to) {
        if (!this.events.isEmpty()) {
            int index = this.cursorInsertIndex(to);
            return ((PatternClipEvent)this.events.get(index > 0 ? index - 1 : index)).getPattern();
        }
        return null;
    }

    private void triggerPatternAtCursor(Cursor to) {
        LXPattern pattern = this.getPatternAtCursor(to);
        if (pattern != null && this.channel.getTargetPattern() != pattern) {
            this.triggerPattern(pattern);
        }
    }

    @Override
    void initializeCursorPlayback(Cursor to) {
        this.triggerPatternAtCursor(to);
    }

    @Override
    void loopCursor(Cursor from, Cursor to) {
        if (this.overdubActive) {
            LXPattern loopEnd;
            LXPattern loopStart = this.getPatternBeforeCursor(to);
            if (loopStart != (loopEnd = this.getPatternBeforeCursor(from))) {
                this.recordEvent(new PatternClipEvent(this, to, loopEnd));
            }
        } else {
            this.triggerPatternAtCursor(to);
        }
    }

    @Override
    void overdubCursor(Cursor from, Cursor to, boolean inclusive) {
        if (this.overdubActive) {
            int stitchIndex;
            boolean changed = false;
            this.mutableEvents.begin();
            PatternClipEvent stitchOuter = null;
            if (!this.mutableEvents.isEmpty()) {
                int endIndex;
                int startIndex = this.cursorPlayIndex(from);
                int n = endIndex = inclusive ? this.cursorInsertIndex(to) : this.cursorPlayIndex(to);
                if (this.CursorOp().isBefore(to, this.clip.length.cursor)) {
                    stitchOuter = new PatternClipEvent(this, to, ((PatternClipEvent)this.events.get(endIndex > 0 ? endIndex - 1 : endIndex)).getPattern());
                }
                if (endIndex > startIndex) {
                    this.mutableEvents.removeRange(startIndex, endIndex);
                    changed = true;
                }
            }
            if (!this.recordQueue.isEmpty()) {
                this.commitRecordQueue(false);
                changed = true;
            }
            if (stitchOuter != null && ((stitchIndex = this.cursorInsertIndex(stitchOuter.cursor)) == 0 || ((PatternClipEvent)this.events.get(stitchIndex - 1)).getPattern() != stitchOuter.getPattern())) {
                this.mutableEvents.add(stitchIndex, stitchOuter);
                changed = true;
            }
            this.mutableEvents.commit();
            if (changed) {
                this.onChange.bang();
            }
        } else {
            this.playCursor(from, to, inclusive);
        }
    }

    @Override
    protected PatternClipEvent loadEvent(LX lx, JsonObject eventObj) {
        int numPatterns = this.channel.patterns.size();
        int patternIndex = eventObj.get("patternIndex").getAsInt();
        if (!LXUtils.inRange(patternIndex, 0, numPatterns - 1)) {
            LX.error("Invalid pattern index found in PatternClipLane.loadEvent on channel with " + numPatterns + " patterns: " + String.valueOf(eventObj));
            return null;
        }
        return new PatternClipEvent(this, this.channel.patterns.get(patternIndex));
    }

    @Override
    public void dispose() {
        this.channel.removeListener(this);
        super.dispose();
    }
}

