/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import heronarts.lx.color.LXColor;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

public class ColorParameter
extends AggregateParameter {
    public final CompoundParameter hue;
    public final CompoundParameter saturation;
    public final CompoundParameter brightness;
    public static final String PATH_BRIGHTNESS = "brightness";
    public static final String PATH_SATURATION = "saturation";
    public static final String PATH_HUE = "hue";
    protected int color;

    public ColorParameter(String label) {
        this(label, -16777216);
    }

    public ColorParameter(String label, int color) {
        super(label, Double.longBitsToDouble(color));
        double h = LXColor.h(color);
        this.hue = new CompoundParameter("Hue", Double.isNaN(h) ? 0.0 : h, 0.0, 359.0).setWrappable(true).setDescription("Hue component of the color");
        this.saturation = new CompoundParameter("Saturation", LXColor.s(color), 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Saturation component of the color");
        this.brightness = new CompoundParameter("Brightness", LXColor.b(color), 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Brightness component of the color");
        this.addSubparameter(PATH_BRIGHTNESS, this.brightness);
        this.addSubparameter(PATH_SATURATION, this.saturation);
        this.addSubparameter(PATH_HUE, this.hue);
        this.color = color;
    }

    @Override
    public LXListenableNormalizedParameter getRemoteControl() {
        return this.hue;
    }

    @Override
    public ColorParameter setDescription(String description) {
        return (ColorParameter)super.setDescription(description);
    }

    public int getColor() {
        return this.color;
    }

    public int getBaseColor() {
        return this.getColor();
    }

    public int calcColor() {
        return LXColor.hsb(this.hue.getValue(), this.saturation.getValue(), this.brightness.getValue());
    }

    public ColorParameter setColor(int color) {
        this.setValue(Double.longBitsToDouble(color));
        return this;
    }

    public boolean isBlack() {
        return this.brightness.getValue() == 0.0;
    }

    public String getHexString() {
        return String.format("0x%08x", this.color);
    }

    @Override
    protected double onUpdateValue(double value) {
        this.color = (int)Double.doubleToRawLongBits(value);
        return value;
    }

    @Override
    protected void updateSubparameters(double value) {
        double b = LXColor.b(this.color);
        this.brightness.setValue(b);
        if (b > 0.0) {
            double s = LXColor.s(this.color);
            this.saturation.setValue(s);
            if (s > 0.0) {
                this.hue.setValue(LXColor.h(this.color));
            }
        }
    }

    @Override
    protected void onSubparameterUpdate(LXParameter p) {
        this.setColor(LXColor.hsb(this.hue.getBaseValue(), this.saturation.getBaseValue(), this.brightness.getBaseValue()));
    }
}

