/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.utils.LXUtils;

public class GradientUtils {

    public static interface BlendFunction {
        public static final BlendFunction RGB = new BlendFunction(){

            @Override
            public int blend(ColorStop c1, ColorStop c2, float lerp) {
                int r = LXUtils.lerpi(c1.r, c2.r, lerp);
                int g = LXUtils.lerpi(c1.g, c2.g, lerp);
                int b = LXUtils.lerpi(c1.b, c2.b, lerp);
                return LXColor.rgba(r, g, b, 255);
            }

            @Override
            public int blend(ColorParameter c1, ColorParameter c2, float lerp) {
                return LXColor.lerp(c1.getColor(), c2.getColor(), lerp);
            }
        };
        public static final BlendFunction HSV = BlendFunction._HSV(HueInterpolation.HSV);
        public static final BlendFunction HSVM = BlendFunction._HSV(HueInterpolation.HSVM);
        public static final BlendFunction HSVCW = BlendFunction._HSV(HueInterpolation.HSVCW);
        public static final BlendFunction HSVCCW = BlendFunction._HSV(HueInterpolation.HSVCCW);

        public int blend(ColorStop var1, ColorStop var2, float var3);

        public int blend(ColorParameter var1, ColorParameter var2, float var3);

        public static BlendFunction _HSV(final HueInterpolation hueLerp) {
            return new BlendFunction(){

                @Override
                public int blend(ColorStop c1, ColorStop c2, float lerp) {
                    float hue1 = c1.hue;
                    float hue2 = c2.hue;
                    float sat1 = c1.saturation;
                    float sat2 = c2.saturation;
                    if (c1.isBlack()) {
                        hue1 = hue2;
                        sat1 = sat2;
                    } else if (c2.isBlack()) {
                        hue2 = hue1;
                        sat2 = sat1;
                    }
                    return LXColor.hsb(hueLerp.lerp(hue1, hue2, lerp), LXUtils.lerpf(sat1, sat2, lerp), LXUtils.lerpf(c1.brightness, c2.brightness, lerp));
                }

                @Override
                public int blend(ColorParameter c1, ColorParameter c2, float lerp) {
                    float sat1;
                    float sat2;
                    float hue1;
                    float hue2;
                    if (c1.isBlack()) {
                        hue1 = hue2 = c2.hue.getValuef();
                        sat1 = sat2 = c2.saturation.getValuef();
                    } else if (c2.isBlack()) {
                        hue2 = hue1 = c1.hue.getValuef();
                        sat2 = sat1 = c1.saturation.getValuef();
                    } else {
                        hue1 = c1.hue.getValuef();
                        hue2 = c2.hue.getValuef();
                        sat1 = c1.saturation.getValuef();
                        sat2 = c2.saturation.getValuef();
                    }
                    return LXColor.hsb(hueLerp.lerp(hue1, hue2, lerp), LXUtils.lerpf(sat1, sat2, lerp), LXUtils.lerpf(c1.brightness.getValuef(), c2.brightness.getValuef(), lerp));
                }
            };
        }
    }

    public static enum BlendMode {
        RGB("RGB", null, BlendFunction.RGB),
        HSV("HSV", HueInterpolation.HSV, BlendFunction.HSV),
        HSVM("HSV-Min", HueInterpolation.HSVM, BlendFunction.HSVM),
        HSVCW("HSV-CW", HueInterpolation.HSVCW, BlendFunction.HSVCW),
        HSVCCW("HSV-CCW", HueInterpolation.HSVCCW, BlendFunction.HSVCCW);

        public final String label;
        public final HueInterpolation hueInterpolation;
        public final BlendFunction function;

        private BlendMode(String label, HueInterpolation hueInterpolation, BlendFunction function) {
            this.label = label;
            this.hueInterpolation = hueInterpolation;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class ColorStop {
        private float hue;
        private float saturation;
        private float brightness;
        private int r;
        private int g;
        private int b;

        public void set(ColorParameter color) {
            this.set(color, 0.0f);
        }

        public void set(ColorParameter color, float hueOffset) {
            this.set(color, hueOffset, 0.0f, 0.0f);
        }

        public void set(ColorParameter color, float hueOffset, float saturationOffset, float brightnessOffset) {
            this.hue = color.hue.getValuef() + hueOffset;
            this.saturation = LXUtils.clampf(color.saturation.getValuef() + saturationOffset, 0.0f, 100.0f);
            this.brightness = LXUtils.clampf(color.brightness.getValuef() + brightnessOffset, 0.0f, 100.0f);
            this.setRGB(LXColor.hsb(this.hue, this.saturation, this.brightness));
        }

        public void set(LXDynamicColor color) {
            this.set(color, 0.0f);
        }

        public void set(LXDynamicColor color, float hueOffset) {
            int c = color.getColor();
            this.hue = color.getHuef() + hueOffset;
            this.saturation = color.getSaturation();
            this.brightness = LXColor.b(c);
            this.setRGB(LXColor.hsb(this.hue, this.saturation, this.brightness));
        }

        public void set(LXDynamicColor color, float hueOffset, float saturationOffset, float brightnessOffset) {
            int c = color.getColor();
            this.hue = color.getHuef() + hueOffset;
            this.saturation = LXUtils.clampf(LXColor.s(c) + saturationOffset, 0.0f, 100.0f);
            this.brightness = LXUtils.clampf(LXColor.b(c) + brightnessOffset, 0.0f, 100.0f);
            this.setRGB(LXColor.hsb(this.hue, this.saturation, this.brightness));
        }

        public void setRGB(int c) {
            this.r = (c & 0xFF0000) >>> 16;
            this.g = (c & 0xFF00) >>> 8;
            this.b = c & 0xFF;
        }

        public void set(ColorStop that) {
            this.hue = that.hue;
            this.saturation = that.saturation;
            this.brightness = that.brightness;
            this.r = that.r;
            this.g = that.g;
            this.b = that.b;
        }

        public boolean isBlack() {
            return this.brightness == 0.0f;
        }

        public String toString() {
            return String.format("rgb(%d,%d,%d) hsb(%f,%f,%f)", this.r, this.g, this.b, Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
        }
    }

    public static class ColorStops {
        public final ColorStop[] stops = new ColorStop[6];
        public int numStops = 1;

        public ColorStops() {
            int i = 0;
            while (i < this.stops.length) {
                this.stops[i] = new ColorStop();
                ++i;
            }
        }

        public void setPaletteGradient(LXPalette palette, int start, int num) {
            int first = Math.min(start, palette.swatch.colors.size() - 1);
            int last = first + num;
            int i = 0;
            int j = 0;
            for (LXDynamicColor color : palette.swatch.colors) {
                if (j >= first && j < last) {
                    this.stops[i++].set(color);
                }
                ++j;
            }
            this.setNumStops(i);
        }

        public void setNumStops(int numStops) {
            this.numStops = numStops;
            if (this.numStops > 0) {
                this.stops[numStops].set(this.stops[numStops - 1]);
            }
        }

        public int getColor(float lerp, BlendFunction blendFunction) {
            int stop = (int)Math.floor(lerp *= (float)(this.numStops - 1));
            return blendFunction.blend(this.stops[stop], this.stops[stop + 1], lerp - (float)stop);
        }
    }

    public static interface GradientFunction {
        public int getGradientColor(float var1);
    }

    public static class GrayTable {
        private static final int SIZE = 256;
        private final LXNormalizedParameter invert;
        private final LXNormalizedParameter level;
        private double previousInvert = -1.0;
        private double previousLevel = -1.0;
        private boolean dirty = true;
        public final int[] lut;

        public GrayTable(LXNormalizedParameter invert) {
            this(invert, 0);
        }

        public GrayTable(LXNormalizedParameter invert, int padding) {
            this(invert, null, padding);
        }

        public GrayTable(LXNormalizedParameter invert, LXNormalizedParameter level) {
            this(invert, level, 0);
        }

        public GrayTable(LXNormalizedParameter invert, LXNormalizedParameter level, int padding) {
            this.invert = invert;
            this.level = level;
            this.lut = new int[256 + padding];
        }

        public void update() {
            double level;
            double invert = this.invert.getNormalized();
            double d = level = this.level != null ? this.level.getNormalized() : 1.0;
            if (invert != this.previousInvert || level != this.previousLevel) {
                this.dirty = true;
                this.previousInvert = invert;
                this.previousLevel = level;
            }
            if (this.dirty) {
                int i = 0;
                while (i < 256) {
                    int b = (int)(level * LXUtils.lerp(i, 255.9 - (double)i, invert));
                    this.lut[i] = 0xFF000000 | b << 16 | b << 8 | b;
                    ++i;
                }
                i = 256;
                while (i < this.lut.length) {
                    this.lut[i] = this.lut[255];
                    ++i;
                }
                this.dirty = false;
            }
        }

        public int get(float b) {
            return this.lut[(int)(2.559f * b)];
        }
    }

    public static interface HueInterpolation {
        public static final HueInterpolation HSV = (hue1, hue2, lerp) -> LXUtils.lerpf(hue1, hue2, lerp);
        public static final HueInterpolation HSVM = (hue1, hue2, lerp) -> {
            if (hue2 - hue1 > 180.0f) {
                hue1 += 360.0f;
            } else if (hue1 - hue2 > 180.0f) {
                hue2 += 360.0f;
            }
            return LXUtils.lerpf(hue1, hue2, lerp);
        };
        public static final HueInterpolation HSVCW = (hue1, hue2, lerp) -> {
            if (hue2 < hue1) {
                hue2 += 360.0f;
            }
            return LXUtils.lerpf(hue1, hue2, lerp);
        };
        public static final HueInterpolation HSVCCW = (hue1, hue2, lerp) -> {
            if (hue1 < hue2) {
                hue1 += 360.0f;
            }
            return LXUtils.lerpf(hue1, hue2, lerp);
        };

        public float lerp(float var1, float var2, float var3);
    }
}

