/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import heronarts.lx.utils.LXUtils;

public class LXColor {
    public static final int CLEAR = 0;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int ALPHA_MASK = -16777216;
    public static final int R_MASK = 0xFF0000;
    public static final int G_MASK = 65280;
    public static final int B_MASK = 255;
    public static final int RB_MASK = 0xFF00FF;
    public static final int RGB_MASK = 0xFFFFFF;
    public static final int AG_MASK = -16711936;
    public static final int ALPHA_SHIFT = 24;
    public static final int R_SHIFT = 16;
    public static final int G_SHIFT = 8;
    public static final int MAX_HUE = 360;
    private static final float BRIGHTNESS_SCALE = 0.39215687f;
    private static final float H_COEFF = 0.0027777778f;
    private static final float S_COEFF = 0.01f;
    private static final float B_COEFF = 2.55f;
    public static final int BLEND_ALPHA_FULL = 256;
    public static final int BLEND_ALPHA_HALF = 128;

    public static byte alpha(int argb) {
        return (byte)((argb & 0xFF000000) >>> 24);
    }

    public static byte red(int argb) {
        return (byte)((argb & 0xFF0000) >>> 16);
    }

    public static byte green(int argb) {
        return (byte)((argb & 0xFF00) >>> 8);
    }

    public static byte blue(int argb) {
        return (byte)(argb & 0xFF);
    }

    public static int toRGBA(int argb) {
        return argb >>> 24 | argb << 8;
    }

    public static int toABGR(int argb) {
        return argb & 0xFF00FF00 | argb << 16 & 0xFF0000 | argb >> 16 & 0xFF;
    }

    public static float h(int rgb) {
        int min;
        int max;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int n = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        int n2 = min = r < g ? r : g;
        if (b < min) {
            min = b;
        }
        if (max == 0) {
            return 0.0f;
        }
        float range = max - min;
        if (range == 0.0f) {
            return 0.0f;
        }
        float rc = (float)(max - r) / range;
        float gc = (float)(max - g) / range;
        float bc = (float)(max - b) / range;
        float h = r == max ? bc - gc : (g == max ? 2.0f + rc - bc : 4.0f + gc - rc);
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        return 360.0f * h;
    }

    public static float s(int rgb) {
        int min;
        int max;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int n = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        int n2 = min = r < g ? r : g;
        if (b < min) {
            min = b;
        }
        return max == 0 ? 0.0f : (float)(max - min) * 100.0f / (float)max;
    }

    public static float b(int rgb) {
        int max;
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int n = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        return (float)max * 0.39215687f;
    }

    public static float luminosity(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return (float)(r + r + r + b + g + g + g + g >> 3) * 0.39215687f;
    }

    public static int gray(double brightness) {
        int b = 0xFF & (int)(brightness * 2.559);
        return 0xFF000000 | b << 16 | b << 8 | b;
    }

    public static int grayn(double brightness) {
        int b = 0xFF & (int)(brightness * 255.9);
        return 0xFF000000 | b << 16 | b << 8 | b;
    }

    public static int gray(float brightness) {
        int b = 0xFF & (int)(brightness * 2.559f);
        return 0xFF000000 | b << 16 | b << 8 | b;
    }

    public static int grayn(float brightness) {
        int b = 0xFF & (int)(brightness * 255.9f);
        return 0xFF000000 | b << 16 | b << 8 | b;
    }

    public static final int rgb(int r, int g, int b) {
        return LXColor.rgba(r, g, b, 255);
    }

    public static final int rgbf(float r, float g, float b) {
        return LXColor.rgba((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), 255);
    }

    public static final int rgba(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static final int hsb(double h, double s, double b) {
        return LXColor.hsb((float)h, (float)s, (float)b);
    }

    public static final int hsba(double h, double s, double b, double a) {
        return LXColor.hsba((float)h, (float)s, (float)b, (float)a);
    }

    public static int hsb(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        float brightness255 = brightness * 2.55f;
        if (saturation == 0.0f) {
            g = b = (int)(brightness255 + 0.5f);
            r = b;
        } else {
            float h1 = hue * 0.0027777778f;
            float h = (h1 - (float)Math.floor(h1)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float s1 = saturation * 0.01f;
            float p255 = brightness255 * (1.0f - s1);
            float q255 = brightness255 * (1.0f - s1 * f);
            float t255 = brightness255 * (1.0f - s1 * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness255 + 0.5f);
                    g = (int)(t255 + 0.5f);
                    b = (int)(p255 + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q255 + 0.5f);
                    g = (int)(brightness255 + 0.5f);
                    b = (int)(p255 + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p255 + 0.5f);
                    g = (int)(brightness255 + 0.5f);
                    b = (int)(t255 + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p255 + 0.5f);
                    g = (int)(q255 + 0.5f);
                    b = (int)(brightness255 + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t255 + 0.5f);
                    g = (int)(p255 + 0.5f);
                    b = (int)(brightness255 + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness255 + 0.5f);
                    g = (int)(p255 + 0.5f);
                    b = (int)(q255 + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static final int hsa(float h, float s, float a) {
        return LXColor.hsba(h, s, 100.0f, a);
    }

    public static int hsba(float h, float s, float b, float a) {
        return LXColor.min(255, (int)(a * 255.0f)) << 24 | LXColor.hsb(h, s, b) & 0xFFFFFF;
    }

    public static int blendMask(double alpha) {
        return (int)(alpha * 256.0);
    }

    public static int scaleBrightness(int src, float amount) {
        return LXColor.multiply(src, LXColor.grayn(amount), 256);
    }

    public static int scaleBrightness(int src, double amount) {
        return LXColor.multiply(src, LXColor.grayn(amount), 256);
    }

    public static int blend(int dst, int src, Blend blendMode) {
        switch (blendMode) {
            case ADD: {
                return LXColor.add(dst, src, 256);
            }
            case SUBTRACT: {
                return LXColor.subtract(dst, src, 256);
            }
            case MULTIPLY: {
                return LXColor.multiply(dst, src, 256);
            }
            case SCREEN: {
                return LXColor.screen(dst, src, 256);
            }
            case LIGHTEST: {
                return LXColor.lightest(dst, src, 256);
            }
            case DARKEST: {
                return LXColor.darkest(dst, src, 256);
            }
            case DODGE: {
                return LXColor.dodge(dst, src, 256);
            }
            case BURN: {
                return LXColor.burn(dst, src, 256);
            }
            case HIGHLIGHT: {
                return LXColor.highlight(dst, src, 256);
            }
            case SPOTLIGHT: {
                return LXColor.spotlight(dst, src, 256);
            }
            case LERP: {
                return LXColor.lerp(dst, src, 256);
            }
        }
        throw new IllegalArgumentException("Unimplemented blend mode: " + String.valueOf((Object)blendMode));
    }

    public static int lerp(int dst, int src) {
        return LXColor.lerp(dst, src, 256);
    }

    public static int lerp(int dst, int src, double alpha) {
        return LXColor.lerp(dst, src, (int)(alpha * 256.0));
    }

    public static int lerp(int dst, int src, float alpha) {
        return LXColor.lerp(dst, src, (int)(alpha * 256.0f));
    }

    public static int lerp(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + (src & 0xFF00FF) * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + (src & 0xFF00) * srcAlpha >>> 8 & 0xFF00;
    }

    public static int add(int dst, int src) {
        return LXColor.add(dst, src, 256);
    }

    public static int add(int dst, int src, double alpha) {
        return LXColor.add(dst, src, (int)(alpha * 256.0));
    }

    public static int add(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int rb = (dst & 0xFF00FF) + ((src & 0xFF00FF) * srcAlpha >>> 8 & 0xFF00FF);
        int gn = (dst & 0xFF00) + ((src & 0xFF00) * srcAlpha >>> 8);
        return LXColor.min((dst >>> 24) + a, 255) << 24 | LXColor.min(rb & 0xFFFF0000, 0xFF0000) | LXColor.min(gn & 0xFFFF00, 65280) | LXColor.min(rb & 0xFFFF, 255);
    }

    public static int subtract(int dst, int src) {
        return LXColor.subtract(dst, src, 256);
    }

    public static int subtract(int dst, int src, double alpha) {
        return LXColor.subtract(dst, src, (int)(alpha * 256.0));
    }

    public static int subtract(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int rb = (src & 0xFF00FF) * srcAlpha >>> 8;
        int gn = (src & 0xFF00) * srcAlpha >>> 8;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | LXColor.max((dst & 0xFF0000) - (rb & 0xFF0000), 0) | LXColor.max((dst & 0xFF00) - (gn & 0xFF00), 0) | LXColor.max((dst & 0xFF) - (rb & 0xFF), 0);
    }

    public static int multiply(int dst, int src) {
        return LXColor.multiply(dst, src, 256);
    }

    public static int multiply(int dst, int src, double alpha) {
        return LXColor.multiply(dst, src, (int)(alpha * 256.0));
    }

    public static int multiply(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int dstG = dst & 0xFF00;
        int dstR = (dst & 0xFF0000) >> 16;
        int dstB = dst & 0xFF;
        int rb = ((src & 0xFF0000) * (dstR + 1) | (src & 0xFF) * (dstB + 1)) >>> 8 & 0xFF00FF;
        int g = (src & 0xFF00) * (dstG + 256) >>> 16 & 0xFF00;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | dstG * dstAlpha + g * srcAlpha >>> 8 & 0xFF00;
    }

    public static int screen(int dst, int src) {
        return LXColor.screen(dst, src, 256);
    }

    public static int screen(int dst, int src, double alpha) {
        return LXColor.screen(dst, src, (int)(alpha * 256.0));
    }

    public static int screen(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int dstRb = dst & 0xFF00FF;
        int dstGn = dst & 0xFF00;
        int srcGn = src & 0xFF00;
        int dstR = (dst & 0xFF0000) >> 16;
        int dstB = dst & 0xFF;
        int rbSub = ((src & 0xFF0000) * (dstR + 1) | (src & 0xFF) * (dstB + 1)) >>> 8 & 0xFF00FF;
        int gnSub = srcGn * (dstGn + 256) >> 16 & 0xFF00;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | dstRb * dstAlpha + (dstRb + (src & 0xFF00FF) - rbSub) * srcAlpha >>> 8 & 0xFF00FF | dstGn * dstAlpha + (dstGn + srcGn - gnSub) * srcAlpha >>> 8 & 0xFF00;
    }

    public static int lightest(int dst, int src) {
        return LXColor.lightest(dst, src, 256);
    }

    public static int lightest(int dst, int src, double alpha) {
        return LXColor.lightest(dst, src, (int)(alpha * 256.0));
    }

    public static int lightest(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int rb = LXColor.max(src & 0xFF0000, dst & 0xFF0000) | LXColor.max(src & 0xFF, dst & 0xFF);
        int gn = LXColor.max(src & 0xFF00, dst & 0xFF00);
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + gn * srcAlpha >>> 8 & 0xFF00;
    }

    public static int darkest(int dst, int src) {
        return LXColor.darkest(dst, src, 256);
    }

    public static int darkest(int dst, int src, double alpha) {
        return LXColor.darkest(dst, src, (int)(alpha * 256.0));
    }

    public static int darkest(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int rb = LXColor.min(src & 0xFF0000, dst & 0xFF0000) | LXColor.min(src & 0xFF, dst & 0xFF);
        int gn = LXColor.min(src & 0xFF00, dst & 0xFF00);
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + gn * srcAlpha >>> 8 & 0xFF00;
    }

    public static int difference(int dst, int src) {
        return LXColor.difference(dst, src, 256);
    }

    public static int difference(int dst, int src, double alpha) {
        return LXColor.difference(dst, src, (int)(alpha * 256.0));
    }

    public static int difference(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int r = (dst & 0xFF0000) - (src & 0xFF0000);
        int g = (dst & 0xFF00) - (src & 0xFF00);
        int b = (dst & 0xFF) - (src & 0xFF);
        int rb = (r < 0 ? -r : r) | (b < 0 ? -b : b);
        int gn = g < 0 ? -g : g;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + gn * srcAlpha >>> 8 & 0xFF00;
    }

    public static int dodge(int dst, int src) {
        return LXColor.dodge(dst, src, 256);
    }

    public static int dodge(int dst, int src, double alpha) {
        return LXColor.dodge(dst, src, (int)(alpha * 256.0));
    }

    public static int dodge(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int r = (dst & 0xFF0000) / (256 - ((src & 0xFF0000) >> 16));
        int g = ((dst & 0xFF00) << 8) / (256 - ((src & 0xFF00) >> 8));
        int b = ((dst & 0xFF) << 8) / (256 - (src & 0xFF));
        int rb = (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) | (b > 255 ? 255 : b);
        int gn = g > 65280 ? 65280 : g & 0xFF00;
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + gn * srcAlpha >>> 8 & 0xFF00;
    }

    public static int burn(int dst, int src) {
        return LXColor.burn(dst, src, 256);
    }

    public static int burn(int dst, int src, double alpha) {
        return LXColor.burn(dst, src, (int)(alpha * 256.0));
    }

    public static int burn(int dst, int src, int alpha) {
        int a;
        int srcAlpha = a + ((a = (src >>> 24) * alpha >> 8 & 0xFF) >= 127 ? 1 : 0);
        int dstAlpha = 256 - srcAlpha;
        int r = (0xFF0000 - (dst & 0xFF0000)) / (1 + (src & 0xFF));
        int g = (65280 - (dst & 0xFF00) << 8) / (1 + (src & 0xFF));
        int b = (255 - (dst & 0xFF) << 8) / (1 + (src & 0xFF));
        int rb = 0xFF00FF - (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) - (b > 255 ? 255 : b);
        int gn = 65280 - (g > 65280 ? 65280 : g & 0xFF00);
        return LXColor.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * dstAlpha + rb * srcAlpha >>> 8 & 0xFF00FF | (dst & 0xFF00) * dstAlpha + gn * srcAlpha >>> 8 & 0xFF00;
    }

    public static int highlight(int dst, int src) {
        return LXColor.highlight(dst, src, 256);
    }

    public static int highlight(int dst, int src, double alpha) {
        return LXColor.highlight(dst, src, (int)(alpha * 256.0));
    }

    public static int highlight(int dst, int src, int alpha) {
        return LXColor.add(dst, LXColor.multiply(dst, src, 256), alpha);
    }

    public static int spotlight(int dst, int src) {
        return LXColor.spotlight(dst, src, 256);
    }

    public static int spotlight(int dst, int src, double alpha) {
        return LXColor.spotlight(dst, src, (int)(alpha * 256.0));
    }

    public static int spotlight(int dst, int src, int alpha) {
        int dstMax = LXUtils.max(dst & 0xFF, (dst & 0xFF00) >> 8, (dst & 0xFF0000) >> 16);
        int dstMlt = dst & 0xFF000000 | dstMax << 16 | dstMax << 8 | dstMax;
        return LXColor.add(dst, LXColor.multiply(dstMlt, src, 256), alpha);
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static void map(int[] src, int srcNum, int[] dst, int dstNum) {
        LXColor.map(src, 0, srcNum, dst, 0, dstNum);
    }

    public static void map(int[] src, int srcOffset, int srcNum, int[] dst, int dstOffset, int dstNum) {
        int i = 0;
        while (i < dstNum) {
            int srcIndex = (int)(((double)srcNum - 1.0) * ((double)i / ((double)dstNum - 1.0)));
            dst[dstOffset + i] = src[srcOffset + srcIndex];
            ++i;
        }
    }

    public static void maplerp(int[] src, int srcNum, int[] dst, int dstNum) {
        LXColor.maplerp(src, 0, srcNum, dst, 0, dstNum);
    }

    public static void maplerp(int[] src, int srcOffset, int srcNum, int[] dst, int dstOffset, int dstNum) {
        int i = 0;
        while (i < dstNum) {
            double srcIndex = (int)(((double)srcNum - 1.0) * ((double)i / ((double)dstNum - 1.0)));
            int srcInt = (int)srcIndex;
            double lerp = srcIndex - (double)srcInt;
            dst[dstOffset + i] = lerp > 0.0 && srcInt < srcNum - 1 ? LXColor.lerp(src[srcOffset + srcInt], src[srcOffset + srcInt + 1], lerp) : src[srcOffset + srcInt];
            ++i;
        }
    }

    public static enum Blend {
        LERP,
        ADD,
        SUBTRACT,
        MULTIPLY,
        SCREEN,
        LIGHTEST,
        DARKEST,
        DODGE,
        BURN,
        HIGHLIGHT,
        SPOTLIGHT;

    }
}

