/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXSerializable;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.TriggerParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LXSwatch
extends LXComponent
implements LXLoopTask,
LXOscComponent,
LXComponent.Renamable {
    private final List<Listener> listeners = new ArrayList<Listener>();
    public static final int MAX_COLORS = 5;
    private final List<LXDynamicColor> mutableColors = new ArrayList<LXDynamicColor>();
    public final List<LXDynamicColor> colors = Collections.unmodifiableList(this.mutableColors);
    public final TriggerParameter recall = new TriggerParameter("Recall", () -> this.lx.engine.palette.setSwatch(this)).setDescription("Restores the values of this swatch");
    public final BooleanParameter autoCycleEligible = new BooleanParameter("Cycle", true).setDescription("Whether the swatch is eligible for auto-cycle");
    private int index = 0;
    private static final String KEY_COLORS = "colors";

    public LXSwatch(LX lx) {
        super(lx, "Swatch");
        this.mutableColors.add(new LXDynamicColor(this));
        this.addArray("color", this.colors);
        this.addParameter("recall", this.recall);
        this.addParameter("autoCycleEligible", this.autoCycleEligible);
    }

    LXSwatch(LXPalette palette, boolean setParent) {
        this(palette.getLX());
        if (setParent) {
            this.setParent(palette);
        }
    }

    static LXSwatch staticCopy(LXSwatch that) {
        LXSwatch swatch = new LXSwatch(that.lx);
        swatch.mutableColors.clear();
        for (LXDynamicColor color : that.colors) {
            LXDynamicColor c2 = new LXDynamicColor(swatch);
            c2.primary.setColor(color.getColor());
            swatch.mutableColors.add(c2);
        }
        return swatch;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        String path = super.getPath();
        if (path != null) {
            return path;
        }
        return "swatches/" + (this.index + 1);
    }

    private void _reindexColors() {
        int i = 0;
        for (LXDynamicColor color : this.colors) {
            color.setIndex(i++);
        }
    }

    @Override
    public void loop(double deltaMs) {
        for (LXDynamicColor color : this.colors) {
            color.loop(deltaMs);
        }
    }

    public LXDynamicColor getColor(int index) {
        if (index >= this.colors.size()) {
            return this.colors.get(this.colors.size() - 1);
        }
        return this.colors.get(index);
    }

    public LXDynamicColor addColor() {
        int initialColor = this.colors.get(this.colors.size() - 1).getColor();
        return this.addColor(new LXDynamicColor(this, initialColor), -1);
    }

    public LXDynamicColor addColor(int index, JsonObject colorObj) {
        LXDynamicColor newColor = new LXDynamicColor(this);
        newColor.load(this.lx, colorObj);
        return this.addColor(newColor, index);
    }

    private LXDynamicColor addColor(LXDynamicColor color, int index) {
        if (index == 0 || index >= 5) {
            throw new IllegalArgumentException("Cannot add color at invalid index: " + index);
        }
        if (this.mutableColors.size() >= 5) {
            throw new IllegalStateException("Cannot add more than 5 to a swatch.");
        }
        if (index < 0) {
            this.mutableColors.add(color);
        } else {
            this.mutableColors.add(index, color);
        }
        this._reindexColors();
        for (Listener listener : this.listeners) {
            listener.colorAdded(this, color);
        }
        return color;
    }

    public LXDynamicColor removeColor() {
        if (this.mutableColors.isEmpty()) {
            throw new IllegalStateException("Cannot remove color from empty swatch");
        }
        return this.removeColor(this.mutableColors.size() - 1);
    }

    public LXDynamicColor removeColor(LXDynamicColor color) {
        Objects.requireNonNull(color, "Cannot LXSwatch.removeColor(null)");
        int index = this.colors.indexOf(color);
        if (index < 0) {
            throw new IllegalStateException("Cannot remove color that does not exist in swatch");
        }
        return this.removeColor(index);
    }

    public LXDynamicColor removeColor(int index) {
        if (index < 0 || index >= this.colors.size()) {
            throw new IllegalStateException("Cannot remove color at invalid index: " + index);
        }
        if (index == 0) {
            throw new IllegalStateException("Cannot remove first color from a swatch");
        }
        LXDynamicColor color = this.mutableColors.remove(index);
        this._reindexColors();
        for (Listener listener : this.listeners) {
            listener.colorRemoved(this, color);
        }
        LX.dispose(color);
        return color;
    }

    public LXSwatch addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXSwatch.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXSwatch removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXSwatch.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_COLORS, (JsonElement)LXSerializable.Utils.toArray(lx, this.colors));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        int ci = 0;
        if (obj.has(KEY_COLORS)) {
            JsonArray colorsArr = obj.get(KEY_COLORS).getAsJsonArray();
            for (JsonElement colorElem : colorsArr) {
                JsonObject colorObj = colorElem.getAsJsonObject();
                if (ci >= this.colors.size()) {
                    LXDynamicColor color = new LXDynamicColor(this);
                    color.load(lx, colorObj);
                    this.addColor(color, -1);
                } else {
                    this.colors.get(ci).load(lx, colorObj);
                }
                ++ci;
            }
        } else {
            ci = 1;
        }
        while (this.colors.size() > ci) {
            this.removeColor();
        }
        for (LXDynamicColor color : this.colors) {
            color.trigger();
        }
    }

    @Override
    public void dispose() {
        for (LXDynamicColor color : this.colors) {
            LX.dispose(color);
        }
        this.mutableColors.clear();
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXSwatch.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    public static interface Listener {
        public void colorAdded(LXSwatch var1, LXDynamicColor var2);

        public void colorRemoved(LXSwatch var1, LXDynamicColor var2);
    }
}

