/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.color;

import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

public class LinkedColorParameter
extends ColorParameter {
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.STATIC).setDescription("Whether to use a custom color or a fixed palette swatch index");
    public final LXPalette.IndexSelector index = new LXPalette.IndexSelector("Index");

    public LinkedColorParameter(String label) {
        this(label, -16777216);
    }

    public LinkedColorParameter(String label, int color) {
        super(label, color);
        this.addSubparameter("mode", this.mode);
        this.addSubparameter("index", this.index);
    }

    @Override
    public LinkedColorParameter setDescription(String description) {
        return (LinkedColorParameter)super.setDescription(description);
    }

    public LinkedColorParameter setMode(Mode mode) {
        this.mode.setValue((Object)mode);
        return this;
    }

    public LinkedColorParameter setIndex(int index) {
        this.index.setValue(index);
        return this;
    }

    public LXDynamicColor getPaletteColor() {
        return this.getParent().getLX().engine.palette.swatch.getColor(this.index.getValuei() - 1);
    }

    @Override
    protected void onSubparameterUpdate(LXParameter p) {
        if (this.mode.getEnum() == Mode.PALETTE) {
            this.setColor(this.getPaletteColor().getColor());
        } else {
            super.onSubparameterUpdate(p);
        }
    }

    @Override
    public int calcColor() {
        switch (this.mode.getEnum()) {
            case PALETTE: {
                return this.getPaletteColor().getColor();
            }
        }
        return super.calcColor();
    }

    @Override
    public int getColor() {
        switch (this.mode.getEnum()) {
            case PALETTE: {
                return this.getPaletteColor().getColor();
            }
        }
        return super.getColor();
    }

    public static enum Mode {
        STATIC("Static"),
        PALETTE("Palette");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

