/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.command;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXPath;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXChannelClip;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.MidiNoteClipEvent;
import heronarts.lx.clip.MidiNoteClipLane;
import heronarts.lx.clip.ParameterClipEvent;
import heronarts.lx.clip.ParameterClipLane;
import heronarts.lx.clip.PatternClipEvent;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.color.LXSwatch;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiMapping;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.modulation.LXModulationContainer;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.modulation.LXParameterModulation;
import heronarts.lx.modulation.LXTriggerModulation;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscConnection;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.snapshot.LXClipSnapshot;
import heronarts.lx.snapshot.LXGlobalSnapshot;
import heronarts.lx.snapshot.LXSnapshot;
import heronarts.lx.snapshot.LXSnapshotEngine;
import heronarts.lx.structure.JsonFixture;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.LXStructure;
import heronarts.lx.structure.view.LXViewDefinition;
import heronarts.lx.utils.LXUtils;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class LXCommand {
    public abstract String getDescription();

    final String getName() {
        try {
            return this.getDescription();
        }
        catch (Exception x) {
            String className = this.getClass().getName();
            int subIndex = className.indexOf(".LXCommand.");
            return className.substring(subIndex + ".LXCommand.".length());
        }
    }

    public abstract void perform(LX var1) throws InvalidCommandException;

    public abstract void undo(LX var1) throws InvalidCommandException;

    public boolean isIgnored() {
        return false;
    }

    public static class Channel {
        private static ComponentReference<LXComponent> validateEffectContainer(LXComponent container) {
            if (!(container instanceof LXEffect.Container)) {
                throw new IllegalArgumentException("Parent of an LXEffect must be an LXEffect.Container");
            }
            return new ComponentReference<LXComponent>(container);
        }

        public static class AddEffect
        extends LXCommand {
            private final ComponentReference<LXComponent> container;
            private final Class<? extends LXEffect> effectClass;
            private ComponentReference<LXEffect> effect = null;
            private JsonObject effectObj = null;

            public AddEffect(LXComponent parent, Class<? extends LXEffect> effectClass) {
                this(parent, effectClass, null);
            }

            public AddEffect(LXComponent parent, Class<? extends LXEffect> effectClass, JsonObject effectObj) {
                this.container = Channel.validateEffectContainer(parent);
                this.effectClass = effectClass;
                this.effectObj = effectObj;
            }

            @Override
            public String getDescription() {
                return "Add Effect";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    LXEffect instance = lx.instantiateEffect(this.effectClass);
                    if (this.effectObj != null) {
                        instance.load(lx, this.effectObj);
                    }
                    this.effectObj = LXSerializable.Utils.toObject(instance);
                    ((LXEffect.Container)((Object)this.container.get())).addEffect(instance);
                    this.effect = new ComponentReference<LXEffect>(instance);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }

            @Override
            public void undo(LX lx) {
                if (this.effect == null) {
                    throw new IllegalStateException("Effect was not successfully added, cannot undo");
                }
                LXEffect effect = this.effect.get();
                effect.getContainer().removeEffect(effect);
            }
        }

        public static class AddPattern
        extends LXCommand {
            private final ComponentReference<LXChannel> channel;
            private final Class<? extends LXPattern> patternClass;
            private ComponentReference<LXPattern> pattern = null;
            private JsonObject patternObj;
            private int patternIndex;

            public AddPattern(LXChannel channel, Class<? extends LXPattern> patternClass) {
                this(channel, patternClass, null);
            }

            public AddPattern(LXChannel channel, Class<? extends LXPattern> patternClass, JsonObject patternObject) {
                this(channel, patternClass, patternObject, -1);
            }

            public AddPattern(LXChannel channel, Class<? extends LXPattern> patternClass, JsonObject patternObject, int patternIndex) {
                this.channel = new ComponentReference<LXChannel>(channel);
                this.patternClass = patternClass;
                this.patternObj = patternObject;
                this.patternIndex = patternIndex;
            }

            @Override
            public String getDescription() {
                return "Add Pattern";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    LXPattern instance = lx.instantiatePattern(this.patternClass);
                    if (this.patternObj != null) {
                        instance.load(lx, this.patternObj);
                    }
                    this.patternObj = LXSerializable.Utils.toObject(instance);
                    this.channel.get().addPattern(instance, this.patternIndex);
                    this.pattern = new ComponentReference<LXPattern>(instance);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }

            @Override
            public void undo(LX lx) {
                if (this.pattern == null) {
                    throw new IllegalStateException("Pattern was not successfully added, cannot undo");
                }
                this.channel.get().removePattern(this.pattern.get());
            }
        }

        public static class GoPattern
        extends LXCommand {
            private final ComponentReference<LXChannel> channel;
            private final ComponentReference<LXPattern> prevPattern;
            private final ComponentReference<LXPattern> nextPattern;

            public GoPattern(LXChannel channel, LXPattern nextPattern) {
                this.channel = new ComponentReference<LXChannel>(channel);
                this.prevPattern = new ComponentReference<LXPattern>(channel.getActivePattern());
                this.nextPattern = new ComponentReference<LXPattern>(nextPattern);
            }

            @Override
            public String getDescription() {
                return "Change Pattern";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.channel.get().goPattern(this.nextPattern.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.channel.get().goPattern(this.prevPattern.get());
            }
        }

        public static class MoveEffect
        extends LXCommand {
            private final ComponentReference<LXComponent> parent;
            private final ComponentReference<LXEffect> effect;
            private final int fromIndex;
            private final int toIndex;

            public MoveEffect(LXComponent parent, LXEffect effect, int toIndex) {
                this.parent = Channel.validateEffectContainer(parent);
                this.effect = new ComponentReference<LXEffect>(effect);
                this.fromIndex = effect.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move Effect";
            }

            @Override
            public void perform(LX lx) {
                LXComponent parent = this.parent.get();
                if (parent instanceof LXBus) {
                    ((LXBus)parent).moveEffect(this.effect.get(), this.toIndex);
                } else if (parent instanceof LXPattern) {
                    ((LXPattern)parent).moveEffect(this.effect.get(), this.toIndex);
                }
            }

            @Override
            public void undo(LX lx) {
                LXComponent parent = this.parent.get();
                if (parent instanceof LXBus) {
                    ((LXBus)parent).moveEffect(this.effect.get(), this.fromIndex);
                } else if (parent instanceof LXPattern) {
                    ((LXPattern)parent).moveEffect(this.effect.get(), this.fromIndex);
                }
            }
        }

        public static class MovePattern
        extends LXCommand {
            private final ComponentReference<LXChannel> channel;
            private final ComponentReference<LXPattern> pattern;
            private final int fromIndex;
            private final int toIndex;

            public MovePattern(LXChannel channel, LXPattern pattern, int toIndex) {
                this.channel = new ComponentReference<LXChannel>(channel);
                this.pattern = new ComponentReference<LXPattern>(pattern);
                this.fromIndex = pattern.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move Pattern";
            }

            @Override
            public void perform(LX lx) {
                this.channel.get().movePattern(this.pattern.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) {
                this.channel.get().movePattern(this.pattern.get(), this.fromIndex);
            }
        }

        public static class PatternCycle
        extends LXCommand {
            private final ComponentReference<LXChannel> channel;
            private final ComponentReference<LXPattern> prevPattern;
            private ComponentReference<LXPattern> targetPattern;

            public PatternCycle(LXChannel channel) {
                LXPattern prev;
                this.channel = new ComponentReference<LXChannel>(channel);
                this.prevPattern = channel.isPlaylist() && !channel.isInTransition() ? ((prev = channel.getActivePattern()) != null ? new ComponentReference<LXPattern>(prev) : null) : null;
            }

            @Override
            public String getDescription() {
                return "Pattern Cycle";
            }

            @Override
            public boolean isIgnored() {
                return this.prevPattern == null;
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                LXChannel channel = this.channel.get();
                if (this.targetPattern == null) {
                    channel.triggerPatternCycle.trigger();
                    this.targetPattern = new ComponentReference<LXPattern>(channel.getTargetPattern());
                } else {
                    this.channel.get().goPattern(this.targetPattern.get());
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                if (this.prevPattern != null) {
                    this.channel.get().goPattern(this.prevPattern.get());
                }
            }
        }

        public static class ReloadEffect
        extends RemoveEffect {
            public ReloadEffect(LXComponent container, LXEffect effect) {
                super(container, effect);
            }

            @Override
            protected void checkLocked() {
            }

            @Override
            public boolean isIgnored() {
                return true;
            }

            @Override
            public String getDescription() {
                return "Reload Effect";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                super.perform(lx);
                super.undo(lx);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                throw new IllegalStateException("May not explicitly undo ReloadEffect command");
            }
        }

        public static class ReloadPattern
        extends RemovePattern {
            public ReloadPattern(LXChannel channel, LXPattern pattern) {
                super(channel, pattern);
            }

            @Override
            public boolean isIgnored() {
                return true;
            }

            @Override
            public String getDescription() {
                return "Reload Pattern";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                super.perform(lx);
                super.undo(lx);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                throw new IllegalStateException("May not explicitly undo ReloadPattern command");
            }
        }

        public static class RemoveEffect
        extends RemoveComponent {
            private final ComponentReference<LXComponent> container;
            private final ComponentReference<LXEffect> effect;
            private final JsonObject effectObj;
            private final int effectIndex;

            public RemoveEffect(LXComponent container, LXEffect effect) {
                super(effect);
                this.container = Channel.validateEffectContainer(container);
                this.effect = new ComponentReference<LXEffect>(effect);
                this.effectObj = LXSerializable.Utils.toObject(effect);
                this.effectIndex = effect.getIndex();
            }

            @Override
            public String getDescription() {
                return "Remove Effect";
            }

            protected void checkLocked() {
                if (this.effect.get().locked.isOn()) {
                    throw new IllegalStateException("Locked effects cannot be removed, UI should disallow this");
                }
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.checkLocked();
                ((LXEffect.Container)((Object)this.container.get())).removeEffect(this.effect.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                LXEffect.Container container = (LXEffect.Container)((Object)this.container.get());
                container.loadEffect(lx, this.effectObj, this.effectIndex);
                super.undo(lx);
            }
        }

        public static class RemovePattern
        extends RemoveComponent {
            private final ComponentReference<LXChannel> channel;
            private final ComponentReference<LXPattern> pattern;
            private final JsonObject patternObj;
            private final int patternIndex;
            private final boolean isActive;
            private final boolean isFocused;

            public RemovePattern(LXChannel channel, LXPattern pattern) {
                super(pattern);
                if (!channel.patterns.contains(pattern)) {
                    throw new IllegalArgumentException("Cannot remove pattern not present on channel: " + String.valueOf(pattern) + " !! " + String.valueOf(channel));
                }
                this.channel = new ComponentReference<LXChannel>(channel);
                this.pattern = new ComponentReference<LXPattern>(pattern);
                this.patternObj = LXSerializable.Utils.toObject(pattern);
                this.patternIndex = pattern.getIndex();
                this.isActive = channel.getActivePattern() == pattern;
                this.isFocused = channel.getFocusedPattern() == pattern;
            }

            @Override
            public String getDescription() {
                return "Delete Pattern";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.channel.get().removePattern(this.pattern.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                LXChannel channel = this.channel.get();
                LXPattern pattern = channel.loadPattern(this.patternObj, this.patternIndex);
                if (this.isActive) {
                    channel.goPattern(pattern, true);
                }
                if (this.isFocused) {
                    channel.focusedPattern.setValue(pattern.getIndex());
                }
                super.undo(lx);
            }
        }

        public static class SetFader
        extends LXCommand {
            private final Parameter.SetNormalized setEnabled;
            private final Parameter.SetValue setFader;

            public SetFader(LXAbstractChannel channel, boolean enabled, double fader) {
                this.setEnabled = new Parameter.SetNormalized(channel.enabled, enabled);
                this.setFader = new Parameter.SetValue(channel.fader, fader);
            }

            @Override
            public String getDescription() {
                return "Set Channel Fader";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.setEnabled.perform(lx);
                this.setFader.perform(lx);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.setEnabled.undo(lx);
                this.setFader.undo(lx);
            }
        }
    }

    public static class Clip {

        public static class Add
        extends LXCommand {
            private final ComponentReference<LXBus> bus;
            private final int index;
            private JsonObject clipObj;
            private JsonObject oldClipObj;
            private boolean enableSnapshot;

            public Add(LXBus bus, int index, boolean enableSnapshot) {
                this(bus, index, null, enableSnapshot);
            }

            public Add(LXBus bus, int index, JsonObject clipObj) {
                this(bus, index, clipObj, false);
            }

            private Add(LXBus bus, int index, JsonObject clipObj, boolean enableSnapshot) {
                this.bus = new ComponentReference<LXBus>(bus);
                this.index = index;
                this.clipObj = clipObj;
                this.enableSnapshot = enableSnapshot;
            }

            @Override
            public String getDescription() {
                return "Add Clip";
            }

            @Override
            public void perform(LX lx) {
                LXBus bus = this.bus.get();
                LXClip existing = bus.getClip(this.index);
                this.oldClipObj = null;
                if (existing != null) {
                    this.oldClipObj = LXSerializable.Utils.toObject(lx, existing);
                    bus.removeClip(this.index);
                }
                LXClip clip = this.clipObj != null ? bus.addClip(this.clipObj, this.index) : bus.addClip(this.index, this.enableSnapshot);
                this.clipObj = LXSerializable.Utils.toObject(lx, clip);
            }

            @Override
            public void undo(LX lx) {
                LXBus bus = this.bus.get();
                bus.removeClip(this.index);
                if (this.oldClipObj != null) {
                    bus.addClip(this.oldClipObj, this.index);
                }
            }
        }

        public static class Event {

            public static class Midi {

                public static class EditNote
                extends LXCommand {
                    protected final ComponentReference<MidiNoteClipLane> clipLane;
                    protected int noteOnIndex = -1;
                    protected List<MidiNoteClipEvent> originalEvents;
                    protected final Cursor fromStart;
                    protected final Cursor fromEnd;
                    protected final int fromPitch;
                    protected final int fromVelocity;
                    private final Cursor toStart;
                    private final Cursor toEnd;
                    private int toPitch;
                    private int toVelocity;

                    public EditNote(MidiNoteClipLane clipLane, int pitch, int velocity, Cursor start, Cursor end) {
                        this.clipLane = new ComponentReference<MidiNoteClipLane>(clipLane);
                        this.fromPitch = pitch;
                        this.fromVelocity = velocity;
                        this.fromStart = start.clone();
                        this.fromEnd = end.clone();
                        this.toPitch = pitch;
                        this.toVelocity = velocity;
                        this.toStart = start.clone();
                        this.toEnd = end.clone();
                    }

                    public EditNote(MidiNoteClipLane clipLane, MidiNoteClipEvent noteOn) {
                        this(clipLane, noteOn.midiNote.getPitch(), noteOn.midiNote.getVelocity(), noteOn.cursor, noteOn.getNoteOff().cursor);
                        this.setNote(noteOn);
                    }

                    protected void setNote(MidiNoteClipEvent midiNote) {
                        if (!midiNote.isNoteOn()) {
                            throw new IllegalArgumentException("Must pass NOTE ON to Clip.Event.Midi.EditNote");
                        }
                        if (midiNote.getNoteOff() == null) {
                            throw new IllegalArgumentException("EditNote must have valid note-off pair");
                        }
                        this.noteOnIndex = this.clipLane.get().events.indexOf(midiNote);
                    }

                    @Override
                    public String getDescription() {
                        return "Edit Note";
                    }

                    public EditNote updatePitch(int pitch) {
                        this.toPitch = pitch;
                        return this;
                    }

                    public EditNote updateVelocity(int velocity) {
                        this.toVelocity = LXUtils.constrain(velocity, 1, 127);
                        return this;
                    }

                    public EditNote updateCursor(Cursor start, Cursor end) {
                        this.toStart.set(start);
                        this.toEnd.set(end);
                        return this;
                    }

                    public EditNote update(int pitch, Cursor start, Cursor end) {
                        this.updatePitch(pitch);
                        this.updateCursor(start, end);
                        return this;
                    }

                    public EditNote update(int pitch, int velocity, Cursor start, Cursor end) {
                        this.updatePitch(pitch);
                        this.updateVelocity(velocity);
                        this.updateCursor(start, end);
                        return this;
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        Cursor.Operator CursorOp;
                        MidiNoteClipLane clipLane = this.clipLane.get();
                        if (this.originalEvents == null) {
                            this.originalEvents = new ArrayList<MidiNoteClipEvent>(clipLane.events);
                        }
                        boolean cursorMoved = !(CursorOp = clipLane.clip.CursorOp()).isEqual(this.fromStart, this.toStart) || !CursorOp.isEqual(this.fromEnd, this.toEnd);
                        clipLane.editNote(this.originalEvents.get(this.noteOnIndex), this.toPitch, this.toVelocity, this.toStart, this.toEnd, this.originalEvents, true, cursorMoved);
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        if (this.originalEvents == null) {
                            throw new InvalidCommandException(new IllegalStateException("Cannot undo Clip.Event.Midi.EditNote that was not performed (or double-undo?)"));
                        }
                        MidiNoteClipLane clipLane = this.clipLane.get();
                        MidiNoteClipEvent noteOn = this.originalEvents.get(this.noteOnIndex);
                        clipLane.editNote(noteOn, this.fromPitch, this.fromVelocity, this.fromStart, this.fromEnd, this.originalEvents, false, false);
                        this.originalEvents = null;
                    }
                }

                public static class InsertNote
                extends EditNote {
                    private MidiNoteClipEvent noteOn = null;

                    public InsertNote(MidiNoteClipLane clipLane, int pitch, int velocity, Cursor start, Cursor end) {
                        super(clipLane, pitch, velocity, start, end);
                    }

                    @Override
                    public String getDescription() {
                        return "Add Note";
                    }

                    @Override
                    public boolean isIgnored() {
                        return this.noteOn == null;
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        if (this.noteOn == null) {
                            MidiNoteClipLane clipLane = (MidiNoteClipLane)this.clipLane.get();
                            this.noteOn = clipLane.insertNote(this.fromPitch, this.fromVelocity, this.fromStart, this.fromEnd);
                            if (this.noteOn != null) {
                                this.setNote(this.noteOn);
                                super.perform(lx);
                            }
                        } else {
                            super.perform(lx);
                        }
                    }

                    public MidiNoteClipEvent getNote() {
                        return this.noteOn;
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        if (this.noteOn != null) {
                            super.undo(lx);
                            MidiNoteClipLane clipLane = (MidiNoteClipLane)this.clipLane.get();
                            MidiNoteClipEvent event = (MidiNoteClipEvent)clipLane.events.get(this.noteOnIndex);
                            clipLane.removeNote(event);
                            this.noteOn = null;
                        }
                    }
                }

                public static class RemoveNote
                extends LXCommand {
                    private final ComponentReference<MidiNoteClipLane> clipLane;
                    private final int noteOnIndex;
                    private final JsonObject preState;

                    public RemoveNote(MidiNoteClipLane clipLane, MidiNoteClipEvent midiNote) {
                        if (!midiNote.isNoteOn()) {
                            throw new IllegalArgumentException("Must pass NOTE ON to Clip.Event.Midi.RemoveNote");
                        }
                        this.clipLane = new ComponentReference<MidiNoteClipLane>(clipLane);
                        this.noteOnIndex = clipLane.events.indexOf(midiNote);
                        this.preState = LXSerializable.Utils.toObject(clipLane, true);
                    }

                    @Override
                    public String getDescription() {
                        return "Delete Note";
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        try {
                            MidiNoteClipLane clipLane = this.clipLane.get();
                            clipLane.removeNote((MidiNoteClipEvent)clipLane.events.get(this.noteOnIndex));
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.clipLane.get().load(lx, this.preState);
                    }
                }

                public static class SetChannel
                extends LXCommand {
                    private final ComponentReference<MidiNoteClipLane> clipLane;
                    private final int noteOnIndex;
                    private final int fromChannel;
                    private int toChannel;

                    public SetChannel(MidiNoteClipLane clipLane, MidiNoteClipEvent midiNote) {
                        if (!midiNote.isNoteOn()) {
                            throw new IllegalArgumentException("Must pass NOTE ON to Clip.Event.Midi.SetChannel");
                        }
                        this.clipLane = new ComponentReference<MidiNoteClipLane>(clipLane);
                        this.noteOnIndex = clipLane.events.indexOf(midiNote);
                        this.toChannel = this.fromChannel = midiNote.midiNote.getChannel();
                    }

                    @Override
                    public String getDescription() {
                        return "Change Channel";
                    }

                    private void setChannel(int channel) throws InvalidCommandException {
                        try {
                            MidiNoteClipLane clipLane = this.clipLane.get();
                            MidiNoteClipEvent noteOn = (MidiNoteClipEvent)clipLane.events.get(this.noteOnIndex);
                            noteOn.midiNote.setChannel(channel);
                            MidiNoteClipEvent noteOff = noteOn.getNoteOff();
                            if (noteOff != null) {
                                noteOff.midiNote.setChannel(channel);
                            }
                            clipLane.onChange.bang();
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    public SetChannel update(int toChannel) {
                        this.toChannel = LXUtils.constrain(toChannel, 0, 15);
                        return this;
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        this.setChannel(this.toChannel);
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.setChannel(this.fromChannel);
                    }
                }

                public static class SetVelocity
                extends LXCommand {
                    private final ComponentReference<MidiNoteClipLane> clipLane;
                    private final int noteOnIndex;
                    private final int fromVelocity;
                    private int toVelocity;

                    public SetVelocity(MidiNoteClipLane clipLane, MidiNoteClipEvent midiNote) {
                        if (!midiNote.isNoteOn()) {
                            throw new IllegalArgumentException("Must pass NOTE ON to Clip.Event.Midi.SetVelocity");
                        }
                        this.clipLane = new ComponentReference<MidiNoteClipLane>(clipLane);
                        this.noteOnIndex = clipLane.events.indexOf(midiNote);
                        this.toVelocity = this.fromVelocity = midiNote.midiNote.getVelocity();
                    }

                    @Override
                    public String getDescription() {
                        return "Change Velocity";
                    }

                    private void setVelocity(int velocity) throws InvalidCommandException {
                        try {
                            MidiNoteClipLane clipLane = this.clipLane.get();
                            ((MidiNoteClipEvent)clipLane.events.get((int)this.noteOnIndex)).midiNote.setVelocity(velocity);
                            clipLane.onChange.bang();
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    public SetVelocity update(int toVelocity) {
                        this.toVelocity = LXUtils.constrain(toVelocity, 1, 127);
                        return this;
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        this.setVelocity(this.toVelocity);
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.setVelocity(this.fromVelocity);
                    }
                }
            }

            public static class Parameter {

                public static class InsertEvent
                extends LXCommand {
                    private final ComponentReference<ParameterClipLane> clipLane;
                    private final Cursor cursor;
                    private final double normalized;
                    private int undoIndex;
                    private ParameterClipEvent insertEvent;

                    public InsertEvent(ParameterClipLane lane, Cursor cursor, double normalized) {
                        this.clipLane = new ComponentReference<ParameterClipLane>(lane);
                        this.cursor = cursor.clone();
                        this.normalized = normalized;
                    }

                    @Override
                    public String getDescription() {
                        return "Insert Clip Event";
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        ParameterClipLane clipLane = this.clipLane.get();
                        this.insertEvent = clipLane.insertEvent(this.cursor, this.normalized);
                        this.undoIndex = clipLane.events.indexOf(this.insertEvent);
                    }

                    public ParameterClipEvent getEvent() {
                        return this.insertEvent;
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        ParameterClipLane clipLane = this.clipLane.get();
                        try {
                            clipLane.removeEvent((ParameterClipEvent)clipLane.events.get(this.undoIndex));
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }
                }

                public static class MoveEvent
                extends LXCommand {
                    private final ComponentReference<ParameterClipLane> clipLane;
                    private final int eventIndex;
                    private final Cursor fromCursor;
                    private Cursor toCursor;
                    private final double fromNormalized;
                    private double toNormalized;

                    public MoveEvent(ParameterClipLane lane, ParameterClipEvent clipEvent) {
                        this.clipLane = new ComponentReference<ParameterClipLane>(lane);
                        this.fromCursor = clipEvent.cursor.clone();
                        this.toCursor = clipEvent.cursor.clone();
                        this.toNormalized = this.fromNormalized = clipEvent.getNormalized();
                        this.eventIndex = lane.events.indexOf(clipEvent);
                    }

                    public MoveEvent update(Cursor cursor, double normalized) {
                        this.toCursor.set(cursor);
                        this.toNormalized = normalized;
                        return this;
                    }

                    @Override
                    public String getDescription() {
                        return "Move Clip Event";
                    }

                    private void moveTo(Cursor cursor, double normalized) throws InvalidCommandException {
                        ParameterClipLane clipLane = this.clipLane.get();
                        try {
                            ParameterClipEvent clipEvent = (ParameterClipEvent)clipLane.events.get(this.eventIndex);
                            clipEvent.setNormalized(normalized);
                            clipLane.moveEvent(clipEvent, cursor);
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        this.moveTo(this.toCursor, this.toNormalized);
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.moveTo(this.fromCursor, this.fromNormalized);
                    }
                }

                public static class SetValues
                extends LXCommand {
                    private final ComponentReference<ParameterClipLane> clipLane;
                    private final Map<ParameterClipEvent, Double> toValues;
                    private JsonObject preState = null;
                    private JsonObject postState = null;

                    public SetValues(ParameterClipLane clipLane, Map<ParameterClipEvent, Double> toValues) {
                        this.clipLane = new ComponentReference<ParameterClipLane>(clipLane);
                        this.toValues = toValues;
                    }

                    @Override
                    public String getDescription() {
                        return "Set Event Values";
                    }

                    public SetValues update() {
                        this.postState = null;
                        return this;
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        ParameterClipLane clipLane = this.clipLane.get();
                        if (this.preState == null) {
                            this.preState = LXSerializable.Utils.toObject(clipLane, true);
                        }
                        if (this.postState != null) {
                            clipLane.load(lx, this.postState);
                        } else {
                            clipLane.setEventsNormalized(this.toValues);
                            this.postState = LXSerializable.Utils.toObject(clipLane, true);
                        }
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.clipLane.get().load(lx, this.preState);
                    }
                }
            }

            public static class Pattern {

                public static class Increment
                extends LXCommand {
                    private final ComponentReference<PatternClipLane> clipLane;
                    private final int eventIndex;
                    private final int fromPatternIndex;
                    private final int increment;

                    public Increment(PatternClipLane lane, PatternClipEvent clipEvent, int increment) {
                        this.clipLane = new ComponentReference<PatternClipLane>(lane);
                        this.eventIndex = lane.events.indexOf(clipEvent);
                        this.increment = increment;
                        this.fromPatternIndex = clipEvent.getPattern().getIndex();
                    }

                    @Override
                    public String getDescription() {
                        return "Modify Pattern Event";
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        PatternClipLane lane = this.clipLane.get();
                        try {
                            PatternClipEvent event = (PatternClipEvent)lane.events.get(this.eventIndex);
                            LXPattern pattern = event.getPattern();
                            int index = pattern.getIndex();
                            int newIndex = LXUtils.constrain(index + this.increment, 0, pattern.getChannel().patterns.size() - 1);
                            if (newIndex != index) {
                                event.setPattern(pattern.getChannel().patterns.get(newIndex));
                            }
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        PatternClipLane lane = this.clipLane.get();
                        try {
                            PatternClipEvent event = (PatternClipEvent)lane.events.get(this.eventIndex);
                            event.setPattern(event.getPattern().getChannel().patterns.get(this.fromPatternIndex));
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }
                }

                public static class InsertEvent
                extends MoveEvent {
                    private PatternClipEvent event = null;

                    public InsertEvent(PatternClipLane clipLane, Cursor cursor, int patternIndex) {
                        super(clipLane, cursor);
                        this.fromPatternIndex = patternIndex;
                        this.toPatternIndex = patternIndex;
                    }

                    @Override
                    public String getDescription() {
                        return "Add Pattern Change";
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        if (this.event == null) {
                            PatternClipLane clipLane = (PatternClipLane)this.clipLane.get();
                            this.event = new PatternClipEvent(clipLane, this.fromCursor, this.fromPatternIndex);
                            clipLane.insertEvent(this.event);
                            this.setEvent(this.event);
                        }
                        super.perform(lx);
                    }

                    public PatternClipEvent getEvent() {
                        return this.event;
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        PatternClipLane clipLane = (PatternClipLane)this.clipLane.get();
                        clipLane.removeEvent((PatternClipEvent)clipLane.events.get(this.eventIndex));
                        this.event = null;
                    }
                }

                public static class MoveEvent
                extends LXCommand {
                    protected final ComponentReference<PatternClipLane> clipLane;
                    protected int eventIndex;
                    protected final Cursor fromCursor;
                    protected final Cursor toCursor;
                    protected int fromPatternIndex;
                    protected int toPatternIndex;

                    protected MoveEvent(PatternClipLane lane, Cursor cursor) {
                        this.clipLane = new ComponentReference<PatternClipLane>(lane);
                        this.fromCursor = cursor.clone();
                        this.toCursor = cursor.clone();
                    }

                    public MoveEvent(PatternClipLane lane, PatternClipEvent clipEvent) {
                        this(lane, clipEvent, clipEvent.cursor);
                    }

                    public MoveEvent(PatternClipLane lane, PatternClipEvent clipEvent, Cursor cursor) {
                        this(lane, clipEvent.cursor);
                        this.setEvent(clipEvent);
                        this.toCursor.set(cursor);
                        this.toPatternIndex = clipEvent.getPattern().getIndex();
                    }

                    protected void setEvent(PatternClipEvent clipEvent) {
                        this.eventIndex = this.clipLane.get().events.indexOf(clipEvent);
                        this.fromPatternIndex = clipEvent.getPattern().getIndex();
                    }

                    public MoveEvent update(Cursor cursor, int toPatternIndex) {
                        this.toCursor.set(cursor);
                        this.toPatternIndex = toPatternIndex;
                        return this;
                    }

                    @Override
                    public String getDescription() {
                        return "Move Pattern Event";
                    }

                    private void moveTo(Cursor cursor, int patternIndex) throws InvalidCommandException {
                        PatternClipLane clipLane = this.clipLane.get();
                        try {
                            PatternClipEvent clipEvent = (PatternClipEvent)clipLane.events.get(this.eventIndex);
                            clipLane.moveEvent(clipEvent, cursor);
                            clipEvent.setPattern(clipEvent.getPattern().getChannel().patterns.get(patternIndex));
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        this.moveTo(this.toCursor, this.toPatternIndex);
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.moveTo(this.fromCursor, this.fromPatternIndex);
                    }
                }

                public static class RemoveReferences
                extends LXCommand {
                    private final ComponentReference<PatternClipLane> clipLane;
                    private final List<Integer> eventIndices;
                    private final JsonObject preState;

                    public RemoveReferences(PatternClipLane clipLane, List<Integer> eventIndices) {
                        this.clipLane = new ComponentReference<PatternClipLane>(clipLane);
                        this.eventIndices = new ArrayList<Integer>(eventIndices);
                        this.preState = LXSerializable.Utils.toObject(clipLane, true);
                    }

                    @Override
                    public String getDescription() {
                        return "Remove Pattern";
                    }

                    @Override
                    public void perform(LX lx) throws InvalidCommandException {
                        PatternClipLane clipLane = this.clipLane.get();
                        try {
                            clipLane.removeEvents(this.eventIndices);
                        }
                        catch (Exception x) {
                            throw new InvalidCommandException(x);
                        }
                    }

                    @Override
                    public void undo(LX lx) throws InvalidCommandException {
                        this.clipLane.get().load(lx, this.preState);
                    }
                }
            }

            public static class Remove<T extends LXClipEvent<T>>
            extends LXCommand {
                private final ComponentReference<LXClipLane<T>> clipLane;
                private final int eventIndex;
                private final JsonObject preState;

                public Remove(LXClipLane<T> clipLane, LXClipEvent<T> clipEvent) {
                    this.clipLane = new ComponentReference<LXClipLane<LXClipLane<T>>>(clipLane);
                    this.eventIndex = clipLane.events.indexOf(clipEvent);
                    this.preState = LXSerializable.Utils.toObject(clipLane, true);
                }

                @Override
                public String getDescription() {
                    return "Delete Event";
                }

                @Override
                public void perform(LX lx) throws InvalidCommandException {
                    LXClipLane<LXClipEvent> clipLane = this.clipLane.get();
                    try {
                        clipLane.removeEvent((LXClipEvent)clipLane.events.get(this.eventIndex));
                    }
                    catch (Exception x) {
                        throw new InvalidCommandException(x);
                    }
                }

                @Override
                public void undo(LX lx) throws InvalidCommandException {
                    this.clipLane.get().load(lx, this.preState);
                }
            }

            public static class RemoveRange
            extends LXCommand {
                private final ComponentReference<LXClipLane<?>> clipLane;
                private final Cursor from;
                private final Cursor to;
                private boolean didRemove = false;
                private JsonObject preState = null;

                public RemoveRange(LXClipLane<?> clipLane, Cursor from, Cursor to) {
                    this.clipLane = new ComponentReference(clipLane);
                    this.from = from.clone();
                    this.to = to.clone();
                }

                @Override
                public String getDescription() {
                    return "Delete Range";
                }

                @Override
                public boolean isIgnored() {
                    return !this.didRemove;
                }

                @Override
                public void perform(LX lx) throws InvalidCommandException {
                    LXClipLane<?> clipLane = this.clipLane.get();
                    this.preState = LXSerializable.Utils.toObject(clipLane, true);
                    this.didRemove = clipLane.removeRange(this.from, this.to);
                }

                @Override
                public void undo(LX lx) throws InvalidCommandException {
                    this.clipLane.get().load(lx, this.preState);
                }
            }

            public static class SetCursors<T extends LXClipEvent<?>>
            extends LXCommand {
                private final ComponentReference<LXClipLane<T>> clipLane;
                private JsonObject preState = null;
                private JsonObject postState = null;
                private final Cursor fromSelectionMin;
                private final Cursor fromSelectionMax;
                private final Cursor toSelectionMin;
                private final Cursor toSelectionMax;
                private final Map<T, Double> fromValues;
                private final Map<T, Cursor> fromCursors;
                private final Map<T, Cursor> toCursors;
                private final Runnable undoHook;
                private ArrayList<T> originalEvents = null;
                private Operation operation;

                public SetCursors(LXClipLane<T> clipLane, Cursor fromSelectionMin, Cursor fromSelectionMax, Map<T, Double> fromValues, Map<T, Cursor> fromCursors, Map<T, Cursor> toCursors) {
                    this(clipLane, fromSelectionMin, fromSelectionMax, fromValues, fromCursors, toCursors, null);
                }

                public SetCursors(LXClipLane<T> clipLane, Cursor fromSelectionMin, Cursor fromSelectionMax, Map<T, Double> fromValues, Map<T, Cursor> fromCursors, Map<T, Cursor> toCursors, Runnable undoHook) {
                    this.clipLane = new ComponentReference<LXClipLane<LXClipLane<T>>>(clipLane);
                    this.fromValues = fromValues;
                    this.fromCursors = fromCursors;
                    this.toCursors = toCursors;
                    this.undoHook = undoHook;
                    this.fromSelectionMin = fromSelectionMin.immutable();
                    this.fromSelectionMax = fromSelectionMax.immutable();
                    this.toSelectionMin = fromSelectionMin.clone();
                    this.toSelectionMax = fromSelectionMax.clone();
                }

                @Override
                public String getDescription() {
                    return "Set Event Cursors";
                }

                public SetCursors<T> update(Cursor selectionMin, Cursor selectionMax, Operation operation) {
                    this.postState = null;
                    this.operation = operation;
                    this.toSelectionMin.set(selectionMin);
                    this.toSelectionMax.set(selectionMax);
                    return this;
                }

                @Override
                public void perform(LX lx) throws InvalidCommandException {
                    LXClipLane<T> clipLane = this.clipLane.get();
                    if (this.originalEvents == null) {
                        this.originalEvents = new ArrayList(clipLane.events);
                    }
                    if (this.preState == null) {
                        this.preState = LXSerializable.Utils.toObject(clipLane, true);
                    }
                    if (this.postState != null) {
                        clipLane.load(lx, this.postState);
                    } else {
                        clipLane.setEventsCursors(this.originalEvents, this.fromSelectionMin, this.fromSelectionMax, this.toSelectionMin, this.toSelectionMax, this.fromValues, this.fromCursors, this.toCursors, this.operation);
                        this.postState = LXSerializable.Utils.toObject(clipLane, true);
                    }
                }

                @Override
                public void undo(LX lx) throws InvalidCommandException {
                    this.clipLane.get().load(lx, this.preState);
                    this.originalEvents = null;
                    if (this.undoHook != null) {
                        this.undoHook.run();
                    }
                }

                public static enum Operation {
                    NONE,
                    STRETCH_TO_LEFT,
                    SHORTEN_FROM_LEFT,
                    CLEAR_FROM_LEFT,
                    REVERSE_LEFT_TO_RIGHT,
                    STRETCH_TO_RIGHT,
                    SHORTEN_FROM_RIGHT,
                    CLEAR_FROM_RIGHT,
                    REVERSE_RIGHT_TO_LEFT,
                    MOVE_LEFT,
                    MOVE_RIGHT;


                    public boolean isClear() {
                        return switch (this) {
                            case CLEAR_FROM_LEFT, CLEAR_FROM_RIGHT -> true;
                            default -> false;
                        };
                    }

                    public boolean isReverse() {
                        return switch (this) {
                            case REVERSE_LEFT_TO_RIGHT, REVERSE_RIGHT_TO_LEFT -> true;
                            default -> false;
                        };
                    }
                }
            }
        }

        public static enum Marker {
            LOOP_START("Loop Start"),
            LOOP_BRACE("Loop"),
            LOOP_END("Loop End"),
            PLAY_START("Start"),
            PLAY_END("End");

            private final String label;

            public Cursor getCursor(LXClip clip) {
                switch (this) {
                    case LOOP_START: 
                    case LOOP_BRACE: {
                        return clip.loopStart.cursor;
                    }
                    case LOOP_END: {
                        return clip.loopEnd.cursor;
                    }
                    case PLAY_END: {
                        return clip.playEnd.cursor;
                    }
                    case PLAY_START: {
                        return clip.playStart.cursor;
                    }
                }
                return null;
            }

            public void setCursor(LXClip clip, Cursor cursor) {
                switch (this) {
                    case LOOP_BRACE: {
                        clip.setLoopBrace(cursor);
                        break;
                    }
                    case LOOP_END: {
                        clip.setLoopEnd(cursor);
                        break;
                    }
                    case LOOP_START: {
                        clip.setLoopStart(cursor);
                        break;
                    }
                    case PLAY_END: {
                        clip.setPlayEnd(cursor);
                        break;
                    }
                    case PLAY_START: {
                        clip.setPlayStart(cursor);
                    }
                }
            }

            private Marker(String label) {
                this.label = label;
            }
        }

        public static class MoveLane
        extends LXCommand {
            private final ComponentReference<LXClipLane<?>> lane;
            private final int fromIndex;
            private final int toIndex;

            public MoveLane(LXClipLane<?> lane, int index) {
                this.lane = new ComponentReference(lane);
                this.fromIndex = lane.getIndex();
                this.toIndex = index;
            }

            @Override
            public String getDescription() {
                return "Move Clip Lane";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                LXClipLane<?> lane = this.lane.get();
                lane.clip.moveClipLane(lane, this.toIndex);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                LXClipLane<?> lane = this.lane.get();
                lane.clip.moveClipLane(lane, this.fromIndex);
            }
        }

        public static class MoveMarker
        extends SetMarker {
            public MoveMarker(LXClip clip, Marker marker, Cursor increment) {
                this(clip, marker, increment, Operation.ADD);
            }

            public MoveMarker(LXClip clip, Marker marker, Cursor increment, Operation op) {
                super(clip, marker, op.perform(marker.getCursor(clip), increment));
            }

            public static enum Operation {
                ADD,
                SUBTRACT;


                private Cursor perform(Cursor cursor, Cursor increment) {
                    switch (this) {
                        case SUBTRACT: {
                            return cursor.subtract(increment);
                        }
                    }
                    return cursor.add(increment);
                }
            }
        }

        public static class Record
        extends LXCommand {
            private final ComponentReference<LXClip> clip;
            private final JsonObject clipObjPre;
            private JsonObject clipObjPost = null;

            public Record(LXClip clip) {
                this.clip = new ComponentReference<LXClip>(clip);
                this.clipObjPre = LXSerializable.Utils.toObject(clip.getLX(), clip);
            }

            @Override
            public String getDescription() {
                return "Record Clip";
            }

            @Override
            public void perform(LX lx) {
                LXClip clip = this.clip.get();
                if (this.clipObjPost == null) {
                    this.clipObjPost = LXSerializable.Utils.toObject(lx, clip);
                } else {
                    clip.load(lx, this.clipObjPost);
                }
            }

            @Override
            public void undo(LX lx) {
                this.clip.get().load(lx, this.clipObjPre);
            }
        }

        public static class Remove
        extends LXCommand {
            private final ComponentReference<LXBus> bus;
            private final int index;
            private final JsonObject clipObj;

            public Remove(LXClip clip) {
                this.bus = new ComponentReference<LXBus>(clip.bus);
                this.clipObj = LXSerializable.Utils.toObject(clip);
                this.index = clip.getIndex();
            }

            @Override
            public String getDescription() {
                return "Remove Clip";
            }

            @Override
            public void perform(LX lx) {
                this.bus.get().removeClip(this.index);
            }

            @Override
            public void undo(LX lx) {
                this.bus.get().addClip(this.clipObj, this.index);
            }
        }

        public static class RemoveParameterLane
        extends RemoveComponent {
            private final ComponentReference<LXClip> clip;
            private final ComponentReference<ParameterClipLane> parameterLane;
            private final int laneIndex;
            private final JsonObject laneObj;

            public RemoveParameterLane(ParameterClipLane parameterLane) {
                super(parameterLane);
                this.clip = new ComponentReference<LXClip>(parameterLane.clip);
                this.parameterLane = new ComponentReference<ParameterClipLane>(parameterLane);
                this.laneIndex = parameterLane.getIndex();
                this.laneObj = LXSerializable.Utils.toObject(parameterLane.getLX(), parameterLane);
            }

            @Override
            public String getDescription() {
                return "Remove Clip Lane";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                ParameterClipLane clipLane = this.parameterLane.get();
                clipLane.clip.removeParameterLane(clipLane);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                ParameterClipLane lane = this.clip.get().addParameterLane(lx, this.laneObj, this.laneIndex);
                if (lane != null) {
                    super.undo(lx);
                }
            }
        }

        public static class SetMarker
        extends LXCommand {
            private final ComponentReference<LXClip> clip;
            public final Marker marker;
            private final Cursor fromCursor;
            private Cursor toCursor;

            public SetMarker(LXClip clip, Marker marker, Cursor toCursor) {
                this.clip = new ComponentReference<LXClip>(clip);
                this.marker = marker;
                this.fromCursor = this.marker.getCursor(clip).clone();
                this.toCursor = toCursor.clone();
            }

            @Override
            public String getDescription() {
                return "Move Clip " + this.marker.label;
            }

            public SetMarker update(Cursor toCursor) {
                this.toCursor.set(toCursor);
                return this;
            }

            @Override
            public void perform(LX lx) {
                this.marker.setCursor(this.clip.get(), this.toCursor);
            }

            @Override
            public void undo(LX lx) {
                LXClip clip = this.clip.get();
                this.marker.setCursor(clip, this.fromCursor);
            }
        }
    }

    public static class ComponentReference<T extends LXComponent> {
        private final LX lx;
        private final int componentId;

        public ComponentReference(T component) {
            this.lx = ((LXComponent)component).getLX();
            this.componentId = ((LXComponent)component).getId();
        }

        public T get() {
            return (T)this.lx.getComponent(this.componentId);
        }
    }

    public static class Device {

        public static class ClearRemoteControls
        extends RemoteControls {
            public ClearRemoteControls(LXDeviceComponent device) {
                super(device);
            }

            @Override
            public String getDescription() {
                return "Clear Remote Controls";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                ((LXDeviceComponent)this.device.get()).clearCustomRemoteControls();
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                ((LXDeviceComponent)this.device.get()).setCustomRemoteControls(this.toControls(this.oldCustomControls));
            }
        }

        public static class LoadPreset
        extends LXCommand {
            private final ComponentReference<LXComponent> device;
            private final JsonObject deviceObj;
            private final File file;

            public LoadPreset(LXComponent device, File file) {
                if (!(device instanceof LXPresetComponent)) {
                    throw new IllegalArgumentException("Cannot load a preset for a non-preset device: " + device.getClass().getName());
                }
                this.device = new ComponentReference<LXComponent>(device);
                this.deviceObj = LXSerializable.Utils.toObject(device);
                this.file = file;
            }

            @Override
            public String getDescription() {
                return "Load Preset " + this.file.getName();
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.device.get().loadPreset(this.file);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.device.get().load(lx, this.deviceObj);
            }
        }

        private static abstract class RemoteControls
        extends LXCommand {
            protected final ComponentReference<LXDeviceComponent> device;
            protected final String[] oldCustomControls;

            protected String[] toPaths(LXDeviceComponent device, LXListenableNormalizedParameter[] remoteControls) {
                if (remoteControls == null) {
                    return null;
                }
                String[] paths = new String[remoteControls.length];
                int i = 0;
                while (i < remoteControls.length) {
                    paths[i] = remoteControls[i] == null ? null : remoteControls[i].getCanonicalPath(device);
                    ++i;
                }
                return paths;
            }

            protected LXListenableNormalizedParameter[] toControls(String[] paths) {
                LXDeviceComponent device = this.device.get();
                LXListenableNormalizedParameter[] remoteControls = new LXListenableNormalizedParameter[paths.length];
                int i = 0;
                while (i < paths.length) {
                    remoteControls[i] = paths[i] == null ? null : (LXListenableNormalizedParameter)LXPath.getParameter(device, paths[i]);
                    ++i;
                }
                return remoteControls;
            }

            protected RemoteControls(LXDeviceComponent device) {
                this.device = new ComponentReference<LXDeviceComponent>(device);
                this.oldCustomControls = this.toPaths(device, device.getCustomRemoteControls());
            }
        }

        public static class SetRemoteControls
        extends RemoteControls {
            private final String[] newCustomControls;

            public SetRemoteControls(LXDeviceComponent device, LXListenableNormalizedParameter[] remoteControls) {
                super(device);
                this.newCustomControls = this.toPaths(device, remoteControls);
            }

            @Override
            public String getDescription() {
                return "Update Remote Controls";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                ((LXDeviceComponent)this.device.get()).setCustomRemoteControls(this.toControls(this.newCustomControls));
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                if (this.oldCustomControls == null) {
                    ((LXDeviceComponent)this.device.get()).clearCustomRemoteControls();
                } else {
                    ((LXDeviceComponent)this.device.get()).setCustomRemoteControls(this.toControls(this.oldCustomControls));
                }
            }
        }
    }

    public static class InvalidCommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected InvalidCommandException(Exception cause) {
            super(cause.getMessage(), cause);
        }
    }

    public static class Midi {

        public static class AddMapping
        extends LXCommand {
            private final LXShortMessage message;
            private final ParameterReference<LXNormalizedParameter> parameter;
            private LXMidiMapping mapping;

            public AddMapping(LXShortMessage message, LXNormalizedParameter parameter) {
                this.message = message;
                this.parameter = new ParameterReference<LXNormalizedParameter>(parameter);
            }

            @Override
            public String getDescription() {
                return "Add MIDI Mapping";
            }

            @Override
            public void perform(LX lx) {
                this.mapping = LXMidiMapping.create(lx, this.message, this.parameter.get());
                lx.engine.midi.addMapping(this.mapping);
            }

            @Override
            public void undo(LX lx) {
                lx.engine.midi.removeMapping(this.mapping);
            }
        }

        public static class AddTemplate
        extends LXCommand {
            private ComponentReference<LXMidiTemplate> template = null;
            private final Class<? extends LXMidiTemplate> templateClass;
            private JsonObject templateObj = null;

            public AddTemplate(Class<? extends LXMidiTemplate> templateClass) {
                this.templateClass = templateClass;
            }

            @Override
            public String getDescription() {
                return "Add MIDI Template";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    LXMidiTemplate template = lx.instantiateComponent(this.templateClass, LXMidiTemplate.class);
                    this.template = new ComponentReference<LXMidiTemplate>(template);
                    if (this.templateObj != null) {
                        template.load(lx, this.templateObj);
                    } else {
                        template.initializeDefaultIO();
                    }
                    lx.engine.midi.addTemplate(template);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                if (this.template == null) {
                    throw new IllegalStateException("Template was not successfully added, cannot undo");
                }
                LXMidiTemplate template = this.template.get();
                this.templateObj = LXSerializable.Utils.toObject(template);
                lx.engine.midi.removeTemplate(template);
            }
        }

        public static class MoveTemplate
        extends LXCommand {
            private final ComponentReference<LXMidiTemplate> midiTemplate;
            private final int fromIndex;
            private final int toIndex;

            public MoveTemplate(LXMidiTemplate midiTemplate, int toIndex) {
                this.midiTemplate = new ComponentReference<LXMidiTemplate>(midiTemplate);
                this.fromIndex = midiTemplate.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move MIDI Template";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.midi.moveTemplate(this.midiTemplate.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.midi.moveTemplate(this.midiTemplate.get(), this.fromIndex);
            }
        }

        public static class RemoveMapping
        extends LXCommand {
            private LXMidiMapping mapping;
            private final JsonObject mappingObj;

            public RemoveMapping(LX lx, LXMidiMapping mapping) {
                this.mapping = mapping;
                this.mappingObj = LXSerializable.Utils.toObject(lx, mapping);
            }

            @Override
            public String getDescription() {
                return "Delete MIDI Mapping";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.midi.removeMapping(this.mapping);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.mapping = LXMidiMapping.create(lx, this.mappingObj);
                lx.engine.midi.addMapping(this.mapping);
            }
        }

        public static class RemoveTemplate
        extends RemoveComponent {
            private final ComponentReference<LXMidiTemplate> midiTemplate;
            private JsonObject templateObj;
            private int fromIndex;

            public RemoveTemplate(LXMidiTemplate midiTemplate) {
                super(midiTemplate);
                this.midiTemplate = new ComponentReference<LXMidiTemplate>(midiTemplate);
            }

            @Override
            public String getDescription() {
                return "Delete MIDI Template";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                LXMidiTemplate midiTemplate = this.midiTemplate.get();
                this.fromIndex = midiTemplate.getIndex();
                this.templateObj = LXSerializable.Utils.toObject(midiTemplate);
                lx.engine.midi.removeTemplate(midiTemplate);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                try {
                    LXMidiTemplate template = lx.instantiateComponent(this.templateObj.get("class").getAsString(), LXMidiTemplate.class);
                    template.load(lx, this.templateObj);
                    lx.engine.midi.addTemplate(template);
                    lx.engine.midi.moveTemplate(template, this.fromIndex);
                    super.undo(lx);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }
        }
    }

    public static class Mixer {

        public static class AddChannel
        extends LXCommand {
            private final Class<? extends LXPattern> patternClass;
            private ComponentReference<LXChannel> channel;
            private JsonObject channelObj = null;
            private final int index;

            public AddChannel() {
                this(null, null, -1);
            }

            public AddChannel(JsonObject channelObj) {
                this(channelObj, null, -1);
            }

            public AddChannel(JsonObject channelObj, int index) {
                this(channelObj, null, index);
            }

            public AddChannel(Class<? extends LXPattern> patternClass) {
                this(null, patternClass, -1);
            }

            public AddChannel(JsonObject channelObj, Class<? extends LXPattern> patternClass) {
                this(channelObj, patternClass, -1);
            }

            public AddChannel(JsonObject channelObj, Class<? extends LXPattern> patternClass, int index) {
                this.index = index;
                this.channelObj = channelObj;
                this.patternClass = patternClass;
            }

            @Override
            public String getDescription() {
                return "Add Channel";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                LXChannel channel;
                if (this.patternClass != null) {
                    try {
                        channel = lx.engine.mixer.addChannel(this.index, new LXPattern[]{lx.instantiatePattern(this.patternClass)});
                    }
                    catch (LX.InstantiationException x) {
                        throw new InvalidCommandException(x);
                    }
                } else {
                    channel = lx.engine.mixer.addChannel(this.index, this.channelObj);
                }
                this.channelObj = LXSerializable.Utils.toObject(channel);
                this.channel = new ComponentReference<LXChannel>(channel);
                lx.engine.mixer.setFocusedChannel(channel);
                lx.engine.mixer.selectChannel(channel);
            }

            @Override
            public void undo(LX lx) {
                if (this.channel == null) {
                    throw new IllegalStateException("Channel was not successfully added, cannot undo");
                }
                lx.engine.mixer.removeChannel(this.channel.get());
            }
        }

        public static class DropChannel
        extends LXCommand {
            private final ComponentReference<LXAbstractChannel> channel;
            private final ComponentReference<LXGroup> toGroup;
            private final ComponentReference<LXGroup> fromGroup;
            private final int fromIndex;
            private final int toIndex;

            public DropChannel(LXAbstractChannel channel, int index, LXGroup group) {
                this.channel = new ComponentReference<LXAbstractChannel>(channel);
                this.fromGroup = channel.isInGroup() ? new ComponentReference<LXGroup>(channel.getGroup()) : null;
                this.toGroup = group != null ? new ComponentReference<LXGroup>(group) : null;
                this.toIndex = index;
                int fromIndex = channel.getIndex();
                if (channel.isGroup() && fromIndex > index) {
                    fromIndex += ((LXGroup)channel).channels.size();
                }
                this.fromIndex = fromIndex;
            }

            @Override
            public String getDescription() {
                return "Move Channel";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.mixer.moveChannel(this.channel.get(), this.toIndex, this.toGroup != null ? this.toGroup.get() : null);
            }

            @Override
            public void undo(LX lx) {
                lx.engine.mixer.moveChannel(this.channel.get(), this.fromIndex, this.fromGroup != null ? this.fromGroup.get() : null);
            }
        }

        public static class GroupSelectedChannels
        extends LXCommand {
            private final List<ComponentReference<LXChannel>> groupChannels = new ArrayList<ComponentReference<LXChannel>>();
            private ComponentReference<LXGroup> group;

            public GroupSelectedChannels(LX lx) {
                for (LXChannel channel : lx.engine.mixer.getSelectedChannelsForGroup()) {
                    this.groupChannels.add(new ComponentReference<LXChannel>(channel));
                }
            }

            @Override
            public String getDescription() {
                return "Add Group";
            }

            @Override
            public void perform(LX lx) {
                if (!this.isIgnored()) {
                    ArrayList<LXChannel> channels = new ArrayList<LXChannel>(this.groupChannels.size());
                    for (ComponentReference<LXChannel> channel : this.groupChannels) {
                        channels.add(channel.get());
                    }
                    this.group = new ComponentReference<LXGroup>(lx.engine.mixer.addGroup(channels));
                }
            }

            @Override
            public void undo(LX lx) {
                if (this.group != null) {
                    this.group.get().ungroup();
                }
            }

            @Override
            public boolean isIgnored() {
                return this.groupChannels.isEmpty();
            }
        }

        public static class MoveChannel
        extends LXCommand {
            private final ComponentReference<LXAbstractChannel> channel;
            private final int delta;

            public MoveChannel(LXAbstractChannel channel, int delta) {
                this.channel = new ComponentReference<LXAbstractChannel>(channel);
                this.delta = delta;
            }

            @Override
            public String getDescription() {
                return "Move Channel";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.mixer.moveChannel(this.channel.get(), this.delta);
            }

            @Override
            public void undo(LX lx) {
                lx.engine.mixer.moveChannel(this.channel.get(), -this.delta);
            }
        }

        public static class RemoveChannel
        extends RemoveComponent {
            private final ComponentReference<LXAbstractChannel> channel;
            private final JsonObject channelObj;
            private final int index;
            private Parameter.SetNormalized focusedChannel;
            private final List<RemoveChannel> groupChildren = new ArrayList<RemoveChannel>();

            public RemoveChannel(LXAbstractChannel channel) {
                super(channel);
                this.channel = new ComponentReference<LXAbstractChannel>(channel);
                this.channelObj = LXSerializable.Utils.toObject(channel);
                this.index = channel.getIndex();
                this.focusedChannel = new Parameter.SetNormalized(channel.getLX().engine.mixer.focusedChannel);
                if (channel instanceof LXGroup) {
                    for (LXChannel child : ((LXGroup)channel).channels) {
                        this.groupChildren.add(new RemoveChannel(child));
                    }
                }
            }

            @Override
            public String getDescription() {
                return "Delete Channel";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.mixer.removeChannel(this.channel.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.undo(lx, false);
            }

            public void undo(LX lx, boolean multiRemove) throws InvalidCommandException {
                lx.engine.mixer.loadChannel(this.channelObj, this.index);
                for (RemoveChannel child : this.groupChildren) {
                    child.undo(lx);
                }
                this.focusedChannel.undo(lx);
                if (!multiRemove) {
                    lx.engine.mixer.selectChannel(this.channel.get());
                }
                super.undo(lx);
            }
        }

        public static class RemoveSelectedChannels
        extends LXCommand {
            private final List<RemoveChannel> removedChannels = new ArrayList<RemoveChannel>();

            public RemoveSelectedChannels(LX lx) {
                ArrayList<LXAbstractChannel> removeChannels = new ArrayList<LXAbstractChannel>();
                for (LXAbstractChannel channel : lx.engine.mixer.channels) {
                    if (!channel.selected.isOn() || removeChannels.contains(channel.getGroup())) continue;
                    removeChannels.add(channel);
                }
                for (LXAbstractChannel removeChannel : removeChannels) {
                    this.removedChannels.add(new RemoveChannel(removeChannel));
                }
            }

            @Override
            public String getDescription() {
                return "Delete Channels";
            }

            @Override
            public void perform(LX lx) {
                for (RemoveChannel remove : this.removedChannels) {
                    remove.perform(lx);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (LXBus lXBus : lx.engine.mixer.channels) {
                    lXBus.selected.setValue(false);
                }
                lx.engine.mixer.masterBus.selected.setValue(false);
                for (RemoveChannel removeChannel : this.removedChannels) {
                    removeChannel.undo(lx, true);
                }
            }
        }

        public static class Ungroup
        extends LXCommand {
            private final ComponentReference<LXGroup> group;
            private final JsonObject groupObj;
            private final int index;
            private final List<ComponentReference<LXChannel>> groupChannels = new ArrayList<ComponentReference<LXChannel>>();

            public Ungroup(LXGroup group) {
                this.group = new ComponentReference<LXGroup>(group);
                this.groupObj = LXSerializable.Utils.toObject(group);
                this.index = group.getIndex();
            }

            @Override
            public String getDescription() {
                return "Ungroup Channels";
            }

            @Override
            public void perform(LX lx) {
                for (LXChannel channel : this.group.get().channels) {
                    this.groupChannels.add(new ComponentReference<LXChannel>(channel));
                }
                this.group.get().ungroup();
            }

            @Override
            public void undo(LX lx) {
                LXGroup group = lx.engine.mixer.addGroup(this.index);
                group.load(lx, this.groupObj);
                for (ComponentReference<LXChannel> channel : this.groupChannels) {
                    group.addChannel(channel.get());
                }
            }
        }

        public static class UngroupChannel
        extends LXCommand {
            private final ComponentReference<LXGroup> group;
            private final ComponentReference<LXChannel> channel;
            private final int index;

            public UngroupChannel(LXChannel channel) {
                this.group = new ComponentReference<LXGroup>(channel.getGroup());
                this.channel = new ComponentReference<LXChannel>(channel);
                this.index = channel.getIndex();
            }

            @Override
            public String getDescription() {
                return "Ungroup Channel";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.mixer.ungroup(this.channel.get());
            }

            @Override
            public void undo(LX lx) {
                lx.engine.mixer.group(this.group.get(), this.channel.get(), this.index);
            }
        }
    }

    public static class Modulation {

        public static class AddModulation
        extends LXCommand {
            private final ComponentReference<LXModulationEngine> engine;
            private final ModulationSourceReference source;
            private final ParameterReference<LXCompoundModulation.Target> target;
            private ComponentReference<LXCompoundModulation> modulation;
            private JsonObject modulationObj = null;

            public AddModulation(LXModulationEngine engine, LXNormalizedParameter source, LXCompoundModulation.Target target) {
                this.engine = new ComponentReference<LXModulationEngine>(engine);
                this.source = new ModulationSourceReference(source);
                this.target = new ParameterReference<LXCompoundModulation.Target>(target);
            }

            @Override
            public String getDescription() {
                return "Add Modulation";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    LXCompoundModulation.Target target = this.target.get();
                    LXCompoundModulation modulation = new LXCompoundModulation(this.engine.get(), this.source.get(), target);
                    if (this.modulationObj != null) {
                        modulation.load(lx, this.modulationObj);
                    } else {
                        this.modulationObj = LXSerializable.Utils.toObject(lx, modulation);
                    }
                    this.engine.get().addModulation(modulation);
                    this.modulation = new ComponentReference<LXCompoundModulation>(modulation);
                }
                catch (LXParameterModulation.ModulationException mx) {
                    throw new InvalidCommandException(mx);
                }
            }

            @Override
            public void undo(LX lx) {
                this.engine.get().removeModulation(this.modulation.get());
            }

            class ModulationSourceReference {
                private final ParameterReference<LXNormalizedParameter> parameter;
                private final ComponentReference<LXComponent> component;
                private final boolean isComponent;

                public ModulationSourceReference(LXNormalizedParameter source) {
                    if (source instanceof LXComponent) {
                        this.isComponent = true;
                        this.component = new ComponentReference<LXComponent>((LXComponent)((Object)source));
                        this.parameter = null;
                    } else {
                        this.isComponent = false;
                        this.component = null;
                        this.parameter = new ParameterReference<LXNormalizedParameter>(source);
                    }
                }

                public LXNormalizedParameter get() {
                    return this.isComponent ? (LXNormalizedParameter)((Object)this.component.get()) : this.parameter.get();
                }
            }
        }

        public static class AddModulator
        extends LXCommand {
            private final ComponentReference<LXModulationEngine> modulation;
            private final Class<? extends LXModulator> modulatorClass;
            private final int modulationColor;
            private JsonObject modulatorObj;
            private ComponentReference<LXModulator> modulator;

            public AddModulator(LXModulationEngine modulation, Class<? extends LXModulator> modulatorClass) {
                this(modulation, modulatorClass, null);
            }

            public AddModulator(LXModulationEngine modulation, Class<? extends LXModulator> modulatorClass, int modulationColor) {
                this(modulation, modulatorClass, null, modulationColor);
            }

            public AddModulator(LXModulationEngine modulation, Class<? extends LXModulator> modulatorClass, JsonObject modulatorObj) {
                this(modulation, modulatorClass, modulatorObj, -1);
            }

            public AddModulator(LXModulationEngine modulation, Class<? extends LXModulator> modulatorClass, JsonObject modulatorObj, int modulationColor) {
                this.modulation = new ComponentReference<LXModulationEngine>(modulation);
                this.modulatorClass = modulatorClass;
                this.modulatorObj = modulatorObj;
                this.modulationColor = modulationColor;
            }

            @Override
            public String getDescription() {
                return "Add " + LXComponent.getComponentName(this.modulatorClass);
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    int count;
                    LXModulator instance = lx.instantiateModulator(this.modulatorClass);
                    if (this.modulationColor >= 0) {
                        instance.modulationColor.setValue(this.modulationColor);
                    }
                    if (this.modulatorObj == null && (count = this.modulation.get().getModulatorCount(this.modulatorClass)) > 0) {
                        instance.label.setValue(instance.getLabel() + " " + (count + 1));
                    }
                    this.modulation.get().addModulator(instance, this.modulatorObj);
                    if (this.modulatorObj == null) {
                        this.modulatorObj = LXSerializable.Utils.toObject(instance);
                    }
                    instance.autostart();
                    this.modulator = new ComponentReference<LXModulator>(instance);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }

            @Override
            public void undo(LX lx) {
                this.modulation.get().removeModulator(this.modulator.get());
            }
        }

        public static class AddTrigger
        extends LXCommand {
            private final ComponentReference<LXModulationEngine> engine;
            private final ParameterReference<BooleanParameter> source;
            private final ParameterReference<BooleanParameter> target;
            private ComponentReference<LXTriggerModulation> trigger;

            public AddTrigger(LXModulationEngine engine, BooleanParameter source, BooleanParameter target) {
                this.engine = new ComponentReference<LXModulationEngine>(engine);
                this.source = new ParameterReference<BooleanParameter>(source);
                this.target = new ParameterReference<BooleanParameter>(target);
            }

            @Override
            public String getDescription() {
                return "Add Trigger";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                try {
                    LXTriggerModulation trigger = new LXTriggerModulation(this.engine.get(), this.source.get(), this.target.get());
                    this.engine.get().addTrigger(trigger);
                    this.trigger = new ComponentReference<LXTriggerModulation>(trigger);
                }
                catch (LXParameterModulation.ModulationException mx) {
                    throw new InvalidCommandException(mx);
                }
            }

            @Override
            public void undo(LX lx) {
                this.engine.get().removeTrigger(this.trigger.get());
            }
        }

        public static class MoveModulator
        extends LXCommand {
            private final ComponentReference<LXModulationEngine> modulation;
            private final ComponentReference<LXModulator> modulator;
            private final int fromIndex;
            private final int toIndex;

            public MoveModulator(LXModulationEngine modulation, LXModulator modulator, int index) {
                this.modulation = new ComponentReference<LXModulationEngine>(modulation);
                this.modulator = new ComponentReference<LXModulator>(modulator);
                this.fromIndex = modulator.getIndex();
                this.toIndex = index;
            }

            @Override
            public String getDescription() {
                return "Move Modulator";
            }

            @Override
            public void perform(LX lx) {
                this.modulation.get().moveModulator(this.modulator.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) {
                this.modulation.get().moveModulator(this.modulator.get(), this.fromIndex);
            }
        }

        public static class Remove
        extends LXCommand {
            private final List<LXCommand> remove = new ArrayList<LXCommand>();

            public Remove(LXModulationEngine engine, List<LXParameterModulation> modulations) {
                for (LXParameterModulation modulation : modulations) {
                    if (modulation instanceof LXCompoundModulation) {
                        this.remove.add(new RemoveModulation(engine, (LXCompoundModulation)modulation));
                        continue;
                    }
                    if (!(modulation instanceof LXTriggerModulation)) continue;
                    this.remove.add(new RemoveTrigger(engine, (LXTriggerModulation)modulation));
                }
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                for (LXCommand remove : this.remove) {
                    remove.perform(lx);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (LXCommand remove : this.remove) {
                    remove.undo(lx);
                }
            }

            @Override
            public String getDescription() {
                return "Remove Modulations";
            }
        }

        public static class RemoveModulation
        extends RemoveComponent {
            private final ComponentReference<LXModulationEngine> engine;
            private ComponentReference<LXCompoundModulation> modulation;
            private final JsonObject modulationObj;

            public RemoveModulation(LXModulationEngine engine, LXCompoundModulation modulation) {
                super(modulation);
                this.engine = new ComponentReference<LXModulationEngine>(engine);
                this.modulation = new ComponentReference<LXCompoundModulation>(modulation);
                this.modulationObj = LXSerializable.Utils.toObject(modulation);
            }

            @Override
            public String getDescription() {
                return "Delete Modulation";
            }

            @Override
            public void perform(LX lx) {
                this.engine.get().removeModulation(this.modulation.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                try {
                    LXCompoundModulation modulation = new LXCompoundModulation(lx, this.engine.get(), this.modulationObj);
                    this.engine.get().addModulation(modulation);
                    modulation.load(lx, this.modulationObj);
                    this.modulation = new ComponentReference<LXCompoundModulation>(modulation);
                    super.undo(lx);
                }
                catch (LXParameterModulation.ModulationException mx) {
                    throw new InvalidCommandException(mx);
                }
            }
        }

        public static class RemoveModulations
        extends LXCommand {
            private final List<RemoveModulation> removeModulations = new ArrayList<RemoveModulation>();

            public RemoveModulations(LXCompoundModulation.Target parameter) {
                for (LXCompoundModulation modulation : parameter.getModulations()) {
                    this.removeModulations.add(new RemoveModulation(modulation.scope, modulation));
                }
            }

            @Override
            public void perform(LX lx) {
                for (RemoveModulation remove : this.removeModulations) {
                    remove.perform(lx);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (RemoveModulation remove : this.removeModulations) {
                    remove.undo(lx);
                }
            }

            @Override
            public String getDescription() {
                return "Remove Modulations";
            }
        }

        public static class RemoveModulator
        extends RemoveComponent {
            private final ComponentReference<LXModulationEngine> modulation;
            private final ComponentReference<LXModulator> modulator;
            private final JsonObject modulatorObj;
            private final int index;

            public RemoveModulator(LXModulationEngine modulation, LXModulator modulator) {
                super(modulator);
                this.modulation = new ComponentReference<LXModulationEngine>(modulation);
                this.modulator = new ComponentReference<LXModulator>(modulator);
                this.index = modulator.getIndex();
                this.modulatorObj = LXSerializable.Utils.toObject(modulator);
            }

            @Override
            public String getDescription() {
                return "Delete Modulator";
            }

            @Override
            public void perform(LX lx) {
                this.modulation.get().removeModulator(this.modulator.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                try {
                    LXModulator instance = lx.instantiateModulator(this.modulatorObj.get("class").getAsString());
                    instance.load(lx, this.modulatorObj);
                    this.modulation.get().addModulator(instance, this.index);
                    instance.start();
                    super.undo(lx);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
            }
        }

        public static class RemoveTrigger
        extends RemoveComponent {
            private final ComponentReference<LXModulationEngine> engine;
            private ComponentReference<LXTriggerModulation> trigger;
            private final JsonObject triggerObj;

            public RemoveTrigger(LXModulationEngine engine, LXTriggerModulation trigger) {
                super(trigger);
                this.engine = new ComponentReference<LXModulationEngine>(engine);
                this.trigger = new ComponentReference<LXTriggerModulation>(trigger);
                this.triggerObj = LXSerializable.Utils.toObject(trigger);
            }

            @Override
            public String getDescription() {
                return "Delete Trigger";
            }

            @Override
            public void perform(LX lx) {
                this.engine.get().removeTrigger(this.trigger.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                try {
                    LXTriggerModulation trigger = new LXTriggerModulation(lx, this.engine.get(), this.triggerObj);
                    this.engine.get().addTrigger(trigger);
                    trigger.load(lx, this.triggerObj);
                    this.trigger = new ComponentReference<LXTriggerModulation>(trigger);
                    super.undo(lx);
                }
                catch (LXParameterModulation.ModulationException mx) {
                    throw new InvalidCommandException(mx);
                }
            }
        }
    }

    public static class Osc {

        public static class AddInput
        extends LXCommand {
            private LXOscConnection.Input input;

            @Override
            public String getDescription() {
                return "Add OSC input";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.input = lx.engine.osc.addInput();
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.osc.removeInput(this.input);
            }
        }

        public static class AddOutput
        extends LXCommand {
            private LXOscConnection.Output output;

            @Override
            public String getDescription() {
                return "Add OSC output";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.output = lx.engine.osc.addOutput();
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.osc.removeOutput(this.output);
            }
        }

        public static class RemoveInput
        extends RemoveComponent {
            private final ComponentReference<LXOscConnection.Input> input;
            private final JsonObject inputObj;

            public RemoveInput(LXOscConnection.Input input) {
                super(input);
                this.input = new ComponentReference<LXOscConnection.Input>(input);
                this.inputObj = LXSerializable.Utils.toObject(input);
            }

            @Override
            public String getDescription() {
                return "Delete OSC input";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.osc.removeInput(this.input.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.osc.addInput(this.inputObj, -1);
                super.undo(lx);
            }
        }

        public static class RemoveOutput
        extends RemoveComponent {
            private final ComponentReference<LXOscConnection.Output> output;
            private final JsonObject outputObj;

            public RemoveOutput(LXOscConnection.Output output) {
                super(output);
                this.output = new ComponentReference<LXOscConnection.Output>(output);
                this.outputObj = LXSerializable.Utils.toObject(output);
            }

            @Override
            public String getDescription() {
                return "Delete OSC output";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.osc.removeOutput(this.output.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.osc.addOutput(this.outputObj, -1);
                super.undo(lx);
            }
        }
    }

    public static class Palette {

        public static class AddColor
        extends LXCommand {
            private final ComponentReference<LXSwatch> swatch;
            private ComponentReference<LXDynamicColor> color;
            private JsonObject colorObj;

            public AddColor(LXSwatch swatch) {
                this.swatch = new ComponentReference<LXSwatch>(swatch);
            }

            @Override
            public String getDescription() {
                return "Add Color";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                if (this.colorObj == null) {
                    this.color = new ComponentReference<LXDynamicColor>(this.swatch.get().addColor());
                    this.colorObj = LXSerializable.Utils.toObject(lx, this.color.get());
                } else {
                    this.swatch.get().addColor(-1, this.colorObj);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.swatch.get().removeColor(this.color.get());
            }
        }

        public static class ImportSwatches
        extends LXCommand {
            private final File file;
            private List<ImportedSwatch> importedSwatches;

            public ImportSwatches(LXPalette palette, File file) {
                this.file = file;
            }

            @Override
            public String getDescription() {
                return "Import Swatches " + this.file.getName();
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                block3: {
                    block2: {
                        if (this.importedSwatches != null) break block2;
                        this.importedSwatches = new ArrayList<ImportedSwatch>();
                        List<LXSwatch> imported = lx.engine.palette.importSwatches(this.file);
                        if (imported == null) break block3;
                        for (LXSwatch swatch : imported) {
                            this.importedSwatches.add(new ImportedSwatch(swatch));
                        }
                        break block3;
                    }
                    for (ImportedSwatch swatch : this.importedSwatches) {
                        lx.engine.palette.addSwatch(swatch.swatchObj, -1);
                    }
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                int i = this.importedSwatches.size() - 1;
                while (i >= 0) {
                    lx.engine.palette.removeSwatch(this.importedSwatches.get((int)i).swatch.get());
                    --i;
                }
            }

            private static class ImportedSwatch {
                private final ComponentReference<LXSwatch> swatch;
                private final JsonObject swatchObj;

                private ImportedSwatch(LXSwatch swatch) {
                    this.swatch = new ComponentReference<LXSwatch>(swatch);
                    this.swatchObj = LXSerializable.Utils.toObject(swatch.getLX(), swatch);
                }
            }
        }

        public static class MoveSwatch
        extends LXCommand {
            private final ComponentReference<LXSwatch> swatch;
            private final int fromIndex;
            private final int toIndex;

            public MoveSwatch(LXSwatch swatch, int toIndex) {
                this.swatch = new ComponentReference<LXSwatch>(swatch);
                this.fromIndex = swatch.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move Swatch";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.palette.moveSwatch(this.swatch.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) {
                lx.engine.palette.moveSwatch(this.swatch.get(), this.fromIndex);
            }
        }

        public static class RemoveColor
        extends RemoveComponent {
            private final ComponentReference<LXSwatch> swatch;
            private final ComponentReference<LXDynamicColor> color;
            private final int index;
            private final JsonObject colorObj;

            public RemoveColor(LXDynamicColor color) {
                super(color);
                this.swatch = new ComponentReference<LXSwatch>(color.getSwatch());
                this.color = new ComponentReference<LXDynamicColor>(color);
                this.colorObj = LXSerializable.Utils.toObject(this.color.get());
                this.index = color.getIndex();
            }

            @Override
            public String getDescription() {
                return "Delete Color";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.swatch.get().removeColor(this.color.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.swatch.get().addColor(this.index, this.colorObj);
                super.undo(lx);
            }
        }

        public static class RemoveSwatch
        extends RemoveComponent {
            private final ComponentReference<LXSwatch> swatch;
            private final JsonObject swatchObj;
            private final int swatchIndex;

            public RemoveSwatch(LXSwatch swatch) {
                super(swatch);
                this.swatch = new ComponentReference<LXSwatch>(swatch);
                this.swatchObj = LXSerializable.Utils.toObject(swatch);
                this.swatchIndex = swatch.getIndex();
            }

            @Override
            public String getDescription() {
                return "Delete Swatch";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.engine.palette.removeSwatch(this.swatch.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.palette.addSwatch(this.swatchObj, this.swatchIndex);
                super.undo(lx);
            }
        }

        public static class SaveSwatch
        extends LXCommand {
            private ComponentReference<LXSwatch> swatch;
            private JsonObject swatchObj;
            private int index = -1;
            private JsonObject initialObj;

            public SaveSwatch() {
            }

            public SaveSwatch(JsonObject initialObj, int index) {
                this.index = index;
                this.initialObj = initialObj;
            }

            @Override
            public String getDescription() {
                return "Save Color Swatch";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                if (this.swatch != null) {
                    lx.engine.palette.addSwatch(this.swatchObj, this.index);
                } else {
                    LXSwatch swatch = this.initialObj != null ? lx.engine.palette.addSwatch(this.initialObj, this.index) : lx.engine.palette.saveSwatch();
                    this.index = swatch.getIndex();
                    this.swatchObj = LXSerializable.Utils.toObject(swatch);
                    this.swatch = new ComponentReference<LXSwatch>(swatch);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.palette.removeSwatch(this.swatch.get());
            }
        }

        public static class SetSwatch
        extends LXCommand {
            private final ComponentReference<LXSwatch> swatch;
            private JsonObject originalSwatch;
            private boolean set = false;

            public SetSwatch(LXSwatch swatch) {
                this.swatch = new ComponentReference<LXSwatch>(swatch);
            }

            @Override
            public String getDescription() {
                return "Set Swatch Colors";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.originalSwatch = LXSerializable.Utils.toObject(lx.engine.palette.swatch, true);
                this.set = lx.engine.palette.setSwatch(this.swatch.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.engine.palette.swatch.load(lx, this.originalSwatch);
            }

            @Override
            public boolean isIgnored() {
                return !this.set;
            }
        }
    }

    public static class Parameter {

        public static class Decrement
        extends LXCommand {
            private final ParameterReference<DiscreteParameter> parameter;
            private final int originalValue;
            private final int amount;
            private final boolean alwaysWrap;

            public Decrement(DiscreteParameter parameter) {
                this(parameter, 1, false);
            }

            public Decrement(DiscreteParameter parameter, int amount) {
                this(parameter, amount, false);
            }

            public Decrement(DiscreteParameter parameter, boolean alwaysWrap) {
                this(parameter, 1, alwaysWrap);
            }

            public Decrement(DiscreteParameter parameter, int amount, boolean alwaysWrap) {
                this.parameter = new ParameterReference<DiscreteParameter>(parameter);
                this.originalValue = parameter.getBaseValuei();
                this.amount = amount;
                this.alwaysWrap = alwaysWrap;
            }

            @Override
            public String getDescription() {
                return "Change " + this.parameter.get().getLabel();
            }

            @Override
            public void perform(LX lx) {
                if (this.alwaysWrap) {
                    this.parameter.get().decrement(this.amount, true);
                } else {
                    this.parameter.get().decrement(this.amount);
                }
            }

            @Override
            public void undo(LX lx) {
                this.parameter.get().setValue(this.originalValue);
            }
        }

        public static class Increment
        extends LXCommand {
            private final ParameterReference<DiscreteParameter> parameter;
            private final int originalValue;
            private final int amount;
            private boolean alwaysWrap;

            public Increment(DiscreteParameter parameter) {
                this(parameter, 1);
            }

            public Increment(DiscreteParameter parameter, boolean alwaysWrap) {
                this(parameter, 1, alwaysWrap);
            }

            public Increment(DiscreteParameter parameter, int amount) {
                this(parameter, amount, false);
            }

            public Increment(DiscreteParameter parameter, int amount, boolean alwaysWrap) {
                this.parameter = new ParameterReference<DiscreteParameter>(parameter);
                this.originalValue = parameter.getBaseValuei();
                this.amount = amount;
                this.alwaysWrap = alwaysWrap;
            }

            @Override
            public String getDescription() {
                return "Change " + this.parameter.get().getLabel();
            }

            @Override
            public void perform(LX lx) {
                if (this.alwaysWrap) {
                    this.parameter.get().increment(this.amount, true);
                } else {
                    this.parameter.get().increment(this.amount);
                }
            }

            @Override
            public void undo(LX lx) {
                this.parameter.get().setValue(this.originalValue);
            }
        }

        public static class Reset
        extends LXCommand {
            private final ParameterReference<LXParameter> parameter;
            private final double originalValue;
            private final String originalString;

            public Reset(LXParameter parameter) {
                this.parameter = new ParameterReference<LXParameter>(parameter);
                this.originalValue = parameter.getBaseValue();
                this.originalString = parameter instanceof StringParameter ? ((StringParameter)parameter).getString() : null;
            }

            @Override
            public String getDescription() {
                return "Reset " + this.parameter.get().getLabel();
            }

            @Override
            public void perform(LX lx) {
                this.parameter.get().reset();
            }

            @Override
            public void undo(LX lx) {
                LXParameter parameter = this.parameter.get();
                if (parameter instanceof StringParameter) {
                    ((StringParameter)parameter).setValue(this.originalString);
                }
                parameter.setValue(this.originalValue);
            }
        }

        public static class SetColor
        extends LXCommand {
            private final ParameterReference<ColorParameter> colorParameter;
            private final double originalHue;
            private final double originalSaturation;
            private double updateHue;
            private double updateSaturation;

            public SetColor(ColorParameter colorParameter) {
                this(colorParameter, colorParameter.hue.getBaseValue(), colorParameter.saturation.getBaseValue());
            }

            public SetColor(ColorParameter colorParameter, double hue, double saturation) {
                this.colorParameter = new ParameterReference<ColorParameter>(colorParameter);
                this.originalHue = colorParameter.hue.getBaseValue();
                this.originalSaturation = colorParameter.saturation.getBaseValue();
                this.updateHue = hue;
                this.updateSaturation = saturation;
            }

            @Override
            public String getDescription() {
                return "Update Color";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.colorParameter.get().hue.setValue(this.updateHue);
                this.colorParameter.get().saturation.setValue(this.updateSaturation);
            }

            public SetColor update(double hue, double saturation) {
                this.updateHue = hue;
                this.updateSaturation = saturation;
                return this;
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.colorParameter.get().hue.setValue(this.originalHue);
                this.colorParameter.get().saturation.setValue(this.originalSaturation);
            }
        }

        public static class SetIndex
        extends SetValue {
            public SetIndex(DiscreteParameter parameter, int index) {
                super(parameter, index + parameter.getMinValue());
            }
        }

        public static class SetNormalized
        extends LXCommand {
            private final ParameterReference<LXNormalizedParameter> parameter;
            private final double originalValue;
            private double newValue;

            public SetNormalized(LXNormalizedParameter parameter) {
                this(parameter, parameter.getBaseNormalized());
            }

            public SetNormalized(BooleanParameter parameter, boolean value) {
                this((LXNormalizedParameter)parameter, value ? 1 : 0);
            }

            public SetNormalized(LXNormalizedParameter parameter, double newValue) {
                this.parameter = new ParameterReference<LXNormalizedParameter>(parameter);
                this.originalValue = parameter.getBaseNormalized();
                this.newValue = newValue;
            }

            public LXNormalizedParameter getParameter() {
                return this.parameter.get();
            }

            @Override
            public String getDescription() {
                return "Change " + this.parameter.get().getLabel();
            }

            @Override
            public void undo(LX lx) {
                this.parameter.get().setNormalized(this.originalValue);
            }

            @Override
            public void perform(LX lx) {
                this.parameter.get().setNormalized(this.newValue);
            }

            public SetNormalized update(double newValue) {
                this.newValue = newValue;
                return this;
            }
        }

        public static class SetString
        extends LXCommand {
            private final ParameterReference<StringParameter> parameter;
            private final String originalValue;
            private final String newValue;

            public SetString(StringParameter parameter, String value) {
                this.parameter = new ParameterReference<StringParameter>(parameter);
                this.originalValue = parameter.getString();
                this.newValue = value;
            }

            @Override
            public void undo(LX lx) {
                this.parameter.get().setValue(this.originalValue);
            }

            @Override
            public String getDescription() {
                return "Change " + this.parameter.get().getLabel();
            }

            @Override
            public void perform(LX lx) {
                this.parameter.get().setValue(this.newValue);
            }
        }

        public static class SetValue
        extends LXCommand {
            private final boolean isDiscrete;
            private final ParameterReference<DiscreteParameter> discreteParameter;
            private final int originalDiscreteValue;
            private int newDiscreteValue;
            private final ParameterReference<LXParameter> genericParameter;
            private final double originalGenericValue;
            private double newGenericValue;

            public SetValue(DiscreteParameter parameter, int value) {
                this.isDiscrete = true;
                this.discreteParameter = new ParameterReference<DiscreteParameter>(parameter);
                this.originalDiscreteValue = parameter.getBaseValuei();
                this.newDiscreteValue = value;
                this.genericParameter = null;
                this.originalGenericValue = 0.0;
                this.newGenericValue = 0.0;
            }

            public SetValue(LXParameter parameter, double value) {
                if (parameter instanceof DiscreteParameter) {
                    this.isDiscrete = true;
                    this.discreteParameter = new ParameterReference<DiscreteParameter>((DiscreteParameter)parameter);
                    this.originalDiscreteValue = ((DiscreteParameter)parameter).getBaseValuei();
                    this.newDiscreteValue = (int)value;
                    this.genericParameter = null;
                    this.originalGenericValue = 0.0;
                    this.newGenericValue = 0.0;
                } else {
                    this.isDiscrete = false;
                    this.genericParameter = new ParameterReference<LXParameter>(parameter);
                    this.originalGenericValue = parameter.getBaseValue();
                    this.newGenericValue = value;
                    this.discreteParameter = null;
                    this.originalDiscreteValue = 0;
                    this.newDiscreteValue = 0;
                }
            }

            public LXParameter getParameter() {
                return this.isDiscrete ? this.discreteParameter.get() : this.genericParameter.get();
            }

            public SetValue updateDiscrete(int value) {
                if (!this.isDiscrete) {
                    throw new IllegalStateException("Cannot update non-discrete parameter with integer value");
                }
                this.newDiscreteValue = value;
                return this;
            }

            public SetValue update(double value) {
                if (this.isDiscrete) {
                    throw new IllegalStateException("Cannot update discrete parameter with double value");
                }
                this.newGenericValue = value;
                return this;
            }

            @Override
            public String getDescription() {
                return "Change " + this.getParameter().getLabel();
            }

            @Override
            public void perform(LX lx) {
                if (this.isDiscrete) {
                    this.discreteParameter.get().setValue(this.newDiscreteValue);
                } else {
                    this.genericParameter.get().setValue(this.newGenericValue);
                }
            }

            @Override
            public void undo(LX lx) {
                if (this.isDiscrete) {
                    this.discreteParameter.get().setValue(this.originalDiscreteValue);
                } else {
                    this.genericParameter.get().setValue(this.originalGenericValue);
                }
            }
        }

        public static class Toggle
        extends LXCommand {
            private final ParameterReference<BooleanParameter> parameter;
            private final boolean originalValue;

            public Toggle(BooleanParameter parameter) {
                this.parameter = new ParameterReference<BooleanParameter>(parameter);
                this.originalValue = parameter.isOn();
            }

            @Override
            public String getDescription() {
                return "Toggle " + this.parameter.get().getLabel();
            }

            @Override
            public void perform(LX lx) {
                this.parameter.get().toggle();
            }

            @Override
            public void undo(LX lx) {
                this.parameter.get().setValue(this.originalValue);
            }
        }
    }

    public static class ParameterReference<T extends LXParameter> {
        private final T rawParameter;
        private final Class<? extends LXComponent> componentCls;
        private final ComponentReference<LXComponent> component;
        private final String parameterPath;

        public ParameterReference(T parameter) {
            LXComponent component = parameter.getParent();
            if (component != null) {
                this.component = new ComponentReference<LXComponent>(component);
                this.componentCls = component.getClass();
                this.parameterPath = parameter.getPath();
                this.rawParameter = null;
            } else {
                this.rawParameter = parameter;
                this.component = null;
                this.componentCls = null;
                this.parameterPath = null;
            }
        }

        public T get() {
            if (this.rawParameter != null) {
                return this.rawParameter;
            }
            LXComponent component = this.component.get();
            if (component == null) {
                LX.error("Bad internal state, component " + this.component.componentId + " of type " + this.componentCls.getName() + " does not exist, cannot get parameter: " + this.parameterPath);
                return null;
            }
            return (T)component.getParameter(this.parameterPath);
        }
    }

    public static abstract class RemoveComponent
    extends LXCommand {
        private final List<Modulation.RemoveModulation> removeModulations = new ArrayList<Modulation.RemoveModulation>();
        private final List<Modulation.RemoveTrigger> removeTriggers = new ArrayList<Modulation.RemoveTrigger>();
        private final List<Midi.RemoveMapping> removeMidiMappings = new ArrayList<Midi.RemoveMapping>();
        private final List<Snapshots.RemoveView> removeSnapshotViews = new ArrayList<Snapshots.RemoveView>();
        private final List<Clip.RemoveParameterLane> removeClipLanes = new ArrayList<Clip.RemoveParameterLane>();
        private final List<Clip.Event.Pattern.RemoveReferences> removePatternClipEvents = new ArrayList<Clip.Event.Pattern.RemoveReferences>();

        private void _removeModulations(LXModulationEngine modulation, LXComponent component) {
            List<LXCompoundModulation> compounds = modulation.findModulations(component, modulation.modulations);
            if (compounds != null) {
                for (LXCompoundModulation compound : compounds) {
                    this.removeModulations.add(new Modulation.RemoveModulation(modulation, compound));
                }
            }
        }

        private void _removeTriggers(LXModulationEngine modulation, LXComponent component) {
            List<LXTriggerModulation> triggers = modulation.findModulations(component, modulation.triggers);
            if (triggers != null) {
                for (LXTriggerModulation trigger : triggers) {
                    this.removeTriggers.add(new Modulation.RemoveTrigger(modulation, trigger));
                }
            }
        }

        private void removeMidiMappings(LXMidiEngine midi, LXComponent component) {
            List<LXMidiMapping> mappings = midi.findMappings(component);
            if (mappings != null) {
                for (LXMidiMapping mapping : mappings) {
                    this.removeMidiMappings.add(new Midi.RemoveMapping(midi.getLX(), mapping));
                }
            }
        }

        protected void removeModulationMappings(LXModulationEngine modulation, LXComponent component) {
            this._removeModulations(modulation, component);
            this._removeTriggers(modulation, component);
        }

        protected void removeSnapshotViews(LXSnapshotEngine snapshots, LXComponent component) {
            List<LXSnapshot.View> views = snapshots.findSnapshotViews(component);
            if (views != null) {
                for (LXSnapshot.View view : views) {
                    this.removeSnapshotViews.add(new Snapshots.RemoveView(view));
                }
            }
        }

        protected void removeClipLanes(LXBus bus, LXComponent component) {
            for (LXClip clip : bus.clips) {
                List<ParameterClipLane> lanes;
                if (clip == null || (lanes = clip.findClipLanes(component)) == null) continue;
                for (ParameterClipLane lane : lanes) {
                    this.removeClipLanes.add(new Clip.RemoveParameterLane(lane));
                }
            }
        }

        protected void removePatternClipEvents(LXPattern pattern) {
            for (LXClip clip : pattern.getChannel().clips) {
                if (clip == null || !(clip instanceof LXChannelClip)) continue;
                LXChannelClip channelClip = (LXChannelClip)clip;
                List<Integer> eventIndices = channelClip.patternLane.findEventIndices(pattern);
                if (eventIndices == null) continue;
                this.removePatternClipEvents.add(new Clip.Event.Pattern.RemoveReferences(channelClip.patternLane, eventIndices));
            }
        }

        protected RemoveComponent(LXComponent component) {
            LXComponent parent = component.getParent();
            while (parent != null) {
                if (parent instanceof LXModulationContainer) {
                    this.removeModulationMappings(((LXModulationContainer)((Object)parent)).getModulationEngine(), component);
                }
                parent = parent.getParent();
            }
            this.removeMidiMappings(component.getLX().engine.midi, component);
            this.removeSnapshotViews(component.getLX().engine.snapshots, component);
            LXComponent lXComponent = component;
            Objects.requireNonNull(lXComponent);
            LXComponent lXComponent2 = lXComponent;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LXPattern.class, LXEffect.class}, (Object)lXComponent2, 0)) {
                case 0: {
                    LXPattern pattern = (LXPattern)lXComponent2;
                    this.removeClipLanes(pattern.getChannel(), pattern);
                    this.removePatternClipEvents(pattern);
                    break;
                }
                case 1: {
                    LXEffect effect = (LXEffect)lXComponent2;
                    if (effect.isBusEffect()) {
                        this.removeClipLanes(effect.getBus(), effect);
                        break;
                    }
                    if (!effect.isPatternEffect()) break;
                    this.removeClipLanes(effect.getPattern().getChannel(), effect);
                    break;
                }
            }
        }

        @Override
        public void undo(LX lx) throws InvalidCommandException {
            for (Modulation.RemoveModulation modulation : this.removeModulations) {
                modulation.undo(lx);
            }
            for (Modulation.RemoveTrigger trigger : this.removeTriggers) {
                trigger.undo(lx);
            }
            for (Midi.RemoveMapping mapping : this.removeMidiMappings) {
                mapping.undo(lx);
            }
            for (Snapshots.RemoveView view : this.removeSnapshotViews) {
                view.undo(lx);
            }
            for (Clip.RemoveParameterLane lane : this.removeClipLanes) {
                lane.undo(lx);
            }
            for (Clip.Event.Pattern.RemoveReferences patternReferences : this.removePatternClipEvents) {
                patternReferences.undo(lx);
            }
        }
    }

    public static class Snapshots {

        public static class AddSnapshot
        extends LXCommand {
            private ComponentReference<LXGlobalSnapshot> snapshot;
            private JsonObject initialObj = null;
            private JsonObject snapshotObj = null;
            private final int index;

            public AddSnapshot() {
                this.index = -1;
            }

            public AddSnapshot(JsonObject snapshotObj, int index) {
                this.initialObj = snapshotObj;
                this.index = index;
            }

            @Override
            public String getDescription() {
                return "Add Snapshot";
            }

            @Override
            public void perform(LX lx) {
                if (this.snapshotObj == null) {
                    LXGlobalSnapshot instance;
                    if (this.initialObj != null) {
                        instance = new LXGlobalSnapshot(lx);
                        instance.load(lx, this.initialObj);
                        lx.engine.snapshots.addSnapshot(instance, this.index);
                    } else {
                        instance = lx.engine.snapshots.addSnapshot();
                    }
                    this.snapshot = new ComponentReference<LXGlobalSnapshot>(instance);
                    this.snapshotObj = LXSerializable.Utils.toObject(lx, instance);
                } else {
                    LXGlobalSnapshot instance = new LXGlobalSnapshot(lx);
                    instance.load(lx, this.snapshotObj);
                    this.snapshot = new ComponentReference<LXGlobalSnapshot>(instance);
                    lx.engine.snapshots.addSnapshot(instance);
                }
            }

            @Override
            public void undo(LX lx) {
                lx.engine.snapshots.removeSnapshot(this.snapshot.get());
            }
        }

        public static class MoveSnapshot
        extends LXCommand {
            private final ComponentReference<LXGlobalSnapshot> snapshot;
            private final int fromIndex;
            private final int toIndex;

            public MoveSnapshot(LXGlobalSnapshot snapshot, int toIndex) {
                this.snapshot = new ComponentReference<LXGlobalSnapshot>(snapshot);
                this.fromIndex = snapshot.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move Snapshot";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.snapshots.moveSnapshot(this.snapshot.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) {
                lx.engine.snapshots.moveSnapshot(this.snapshot.get(), this.fromIndex);
            }
        }

        public static class Recall
        extends LXCommand {
            private final ComponentReference<LXGlobalSnapshot> snapshot;
            private final List<LXCommand> commands = new ArrayList<LXCommand>();
            private boolean recalled = false;

            public Recall(LXGlobalSnapshot snapshot) {
                this.snapshot = new ComponentReference<LXGlobalSnapshot>(snapshot);
            }

            @Override
            public void perform(LX lx) {
                this.commands.clear();
                this.recalled = lx.engine.snapshots.recall(this.snapshot.get(), this.commands);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (LXCommand command : this.commands) {
                    command.undo(lx);
                }
            }

            @Override
            public boolean isIgnored() {
                return !this.recalled;
            }

            @Override
            public String getDescription() {
                return "Recall Snapshot";
            }
        }

        public static class RecallImmediate
        extends LXCommand {
            private final ComponentReference<LXClipSnapshot> snapshot;
            private final List<LXCommand> commands = new ArrayList<LXCommand>();

            public RecallImmediate(LXClipSnapshot snapshot) {
                this.snapshot = new ComponentReference<LXClipSnapshot>(snapshot);
            }

            @Override
            public void perform(LX lx) {
                this.commands.clear();
                this.snapshot.get().recallImmediate(this.commands);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (LXCommand command : this.commands) {
                    command.undo(lx);
                }
            }

            @Override
            public String getDescription() {
                return "Recall Clip Snapshot";
            }
        }

        public static class RemoveSnapshot
        extends RemoveComponent {
            private final ComponentReference<LXGlobalSnapshot> snapshot;
            private final JsonObject snapshotObj;
            private final int snapshotIndex;

            public RemoveSnapshot(LXGlobalSnapshot snapshot) {
                super(snapshot);
                this.snapshot = new ComponentReference<LXGlobalSnapshot>(snapshot);
                this.snapshotObj = LXSerializable.Utils.toObject(snapshot);
                this.snapshotIndex = snapshot.getIndex();
            }

            @Override
            public String getDescription() {
                return "Delete Snapshot";
            }

            @Override
            public void perform(LX lx) {
                lx.engine.snapshots.removeSnapshot(this.snapshot.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                LXGlobalSnapshot snapshot = new LXGlobalSnapshot(lx);
                snapshot.load(lx, this.snapshotObj);
                lx.engine.snapshots.addSnapshot(snapshot, this.snapshotIndex);
                super.undo(lx);
            }
        }

        private static class RemoveView
        extends LXCommand {
            private ComponentReference<LXSnapshot> snapshot;
            private LXSnapshot.View view;
            private final JsonObject viewObj;

            public RemoveView(LXSnapshot.View view) {
                this.snapshot = new ComponentReference<LXSnapshot>(view.getSnapshot());
                this.view = view;
                this.viewObj = LXSerializable.Utils.toObject(view.getSnapshot().getLX(), view);
            }

            @Override
            public String getDescription() {
                return "Delete Snapshot View";
            }

            @Override
            public void perform(LX lx) {
                this.snapshot.get().removeView(this.view);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.view = this.snapshot.get().addView(this.viewObj);
            }
        }

        public static class Update
        extends LXCommand {
            private final ComponentReference<LXSnapshot> snapshot;
            private JsonObject previousState;

            public Update(LXSnapshot snapshot) {
                this.snapshot = new ComponentReference<LXSnapshot>(snapshot);
            }

            @Override
            public String getDescription() {
                return "Update Snapshot";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                this.previousState = LXSerializable.Utils.toObject(lx, this.snapshot.get());
                this.snapshot.get().update();
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                this.snapshot.get().load(lx, this.previousState);
            }
        }
    }

    public static class Structure {

        public static class AddFixture
        extends LXCommand {
            private ComponentReference<LXFixture> fixture;
            private final Class<? extends LXFixture> fixtureClass;
            private JsonObject fixtureObj;
            private final String fixtureType;
            private final int index;

            public AddFixture(Class<? extends LXFixture> fixtureClass) {
                this(fixtureClass, null, -1);
            }

            public AddFixture(Class<? extends LXFixture> fixtureClass, int index) {
                this(fixtureClass, null, index);
            }

            public AddFixture(Class<? extends LXFixture> fixtureClass, JsonObject fixtureObj) {
                this(fixtureClass, fixtureObj, -1);
            }

            public AddFixture(Class<? extends LXFixture> fixtureClass, JsonObject fixtureObj, int index) {
                this.fixtureClass = fixtureClass;
                this.fixtureObj = fixtureObj;
                this.fixtureType = null;
                this.index = index;
            }

            public AddFixture(String fixtureType) {
                this.fixtureClass = null;
                this.fixtureType = fixtureType;
                this.index = -1;
            }

            @Override
            public String getDescription() {
                return "Add Fixture";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                LXFixture fixture;
                if (this.fixtureClass != null) {
                    try {
                        fixture = lx.instantiateFixture(this.fixtureClass);
                        fixture.label.setValue(fixture.label.getString() + " " + (lx.structure.fixtures.size() + 1));
                    }
                    catch (LX.InstantiationException x) {
                        throw new InvalidCommandException(x);
                    }
                } else if (this.fixtureType != null) {
                    fixture = new JsonFixture(lx, this.fixtureType);
                    fixture.label.setValue(fixture.label.getString() + " " + (lx.structure.fixtures.size() + 1));
                } else {
                    throw new IllegalStateException("AddFixture action has neither fixtureClass nor fixtureType");
                }
                if (this.fixtureObj != null) {
                    fixture.load(lx, this.fixtureObj);
                    fixture.selected.setValue(false);
                }
                this.fixtureObj = LXSerializable.Utils.toObject(fixture);
                lx.structure.addFixture(fixture, this.index);
                this.fixture = new ComponentReference<LXFixture>(fixture);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.structure.removeFixture(this.fixture.get());
            }
        }

        public static class AddView
        extends LXCommand {
            private ComponentReference<LXViewDefinition> view;
            private JsonObject viewObj;
            private int index = -1;
            private JsonObject initialObj;

            public AddView() {
            }

            public AddView(JsonObject initialObj, int index) {
                this.index = index;
                this.initialObj = initialObj;
            }

            @Override
            public String getDescription() {
                return "Add View";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                if (this.view != null) {
                    lx.structure.views.addView(this.viewObj, this.index);
                } else {
                    LXViewDefinition view = this.initialObj != null ? lx.structure.views.addView(this.initialObj, this.index) : lx.structure.views.addView();
                    this.index = view.getIndex();
                    this.viewObj = LXSerializable.Utils.toObject(view);
                    this.view = new ComponentReference<LXViewDefinition>(view);
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.structure.views.removeView(this.view.get());
            }
        }

        public static class ImportViews
        extends LXCommand {
            private final File file;
            private List<ImportedView> importedViews;

            public ImportViews(File file) {
                this.file = file;
            }

            @Override
            public String getDescription() {
                return "Import Views " + this.file.getName();
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                block3: {
                    block2: {
                        if (this.importedViews != null) break block2;
                        this.importedViews = new ArrayList<ImportedView>();
                        List<LXViewDefinition> imported = lx.structure.importViews(this.file);
                        if (imported == null) break block3;
                        for (LXViewDefinition view : imported) {
                            this.importedViews.add(new ImportedView(view));
                        }
                        break block3;
                    }
                    for (ImportedView view : this.importedViews) {
                        lx.structure.views.addView(view.viewObj, -1);
                    }
                }
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                int i = this.importedViews.size() - 1;
                while (i >= 0) {
                    lx.structure.views.removeView(this.importedViews.get((int)i).view.get());
                    --i;
                }
            }

            private static class ImportedView {
                private final ComponentReference<LXViewDefinition> view;
                private final JsonObject viewObj;

                private ImportedView(LXViewDefinition view) {
                    this.view = new ComponentReference<LXViewDefinition>(view);
                    this.viewObj = LXSerializable.Utils.toObject(view.getLX(), view);
                }
            }
        }

        public static class ModifyFixturePositions
        extends LXCommand {
            private final Map<String, Parameter.SetValue> setValues = new HashMap<String, Parameter.SetValue>();
            private boolean inUpdate = false;

            @Override
            public String getDescription() {
                return "Modify Fixture Position";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                if (this.inUpdate) {
                    return;
                }
                for (Parameter.SetValue setValue : this.setValues.values()) {
                    setValue.perform(lx);
                }
            }

            public void update(LX lx, LXParameter parameter, double delta) {
                this.inUpdate = true;
                String path = parameter.getCanonicalPath();
                Parameter.SetValue setValue = null;
                if (this.setValues.containsKey(path)) {
                    setValue = this.setValues.get(path);
                    setValue.update(parameter.getValue() + delta);
                } else {
                    setValue = new Parameter.SetValue(parameter, parameter.getValue() + delta);
                    this.setValues.put(path, setValue);
                }
                setValue.perform(lx);
                lx.command.perform(this);
                this.inUpdate = false;
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (Parameter.SetValue setValue : this.setValues.values()) {
                    setValue.undo(lx);
                }
            }
        }

        public static class MoveFixture
        extends LXCommand {
            private final ComponentReference<LXFixture> fixture;
            private final int originalIndex;
            private final int index;

            public MoveFixture(LXFixture fixture, int index) {
                this.fixture = new ComponentReference<LXFixture>(fixture);
                this.originalIndex = fixture.getIndex();
                this.index = index;
            }

            @Override
            public String getDescription() {
                return "Move Fixture";
            }

            @Override
            public void perform(LX lx) {
                lx.structure.moveFixture(this.fixture.get(), this.index);
            }

            @Override
            public void undo(LX lx) {
                lx.structure.moveFixture(this.fixture.get(), this.originalIndex);
            }
        }

        public static class MoveView
        extends LXCommand {
            private final ComponentReference<LXViewDefinition> view;
            private final int fromIndex;
            private final int toIndex;

            public MoveView(LXViewDefinition view, int toIndex) {
                this.view = new ComponentReference<LXViewDefinition>(view);
                this.fromIndex = view.getIndex();
                this.toIndex = toIndex;
            }

            @Override
            public String getDescription() {
                return "Move View";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.structure.views.moveView(this.view.get(), this.toIndex);
            }

            @Override
            public void undo(LX lx) {
                lx.structure.views.moveView(this.view.get(), this.fromIndex);
            }
        }

        public static class NewModel
        extends LXCommand {
            private final List<RemoveFixture> removeFixtures = new ArrayList<RemoveFixture>();

            public NewModel(LXStructure structure) {
                for (LXFixture fixture : structure.fixtures) {
                    this.removeFixtures.add(new RemoveFixture(fixture));
                }
            }

            @Override
            public String getDescription() {
                return "New Model";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.structure.newDynamicModel();
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (RemoveFixture remove : this.removeFixtures) {
                    remove.undo(lx);
                }
            }
        }

        public static class RemoveFixture
        extends RemoveComponent {
            private ComponentReference<LXFixture> fixture;
            private final int index;
            private final JsonObject fixtureObj;

            public RemoveFixture(LXFixture fixture) {
                super(fixture);
                this.fixture = new ComponentReference<LXFixture>(fixture);
                this.fixtureObj = LXSerializable.Utils.toObject(fixture);
                this.index = fixture.getIndex();
            }

            @Override
            public String getDescription() {
                return "Delete Fixture";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.structure.removeFixture(this.fixture.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                try {
                    LXFixture fixture = lx.instantiateFixture(this.fixtureObj.get("class").getAsString());
                    fixture.load(lx, this.fixtureObj);
                    lx.structure.addFixture(fixture, this.index);
                }
                catch (LX.InstantiationException x) {
                    throw new InvalidCommandException(x);
                }
                super.undo(lx);
            }
        }

        public static class RemoveSelectedFixtures
        extends LXCommand {
            private final List<RemoveFixture> removeFixtures = new ArrayList<RemoveFixture>();

            public RemoveSelectedFixtures(LXStructure structure) {
                for (LXFixture fixture : structure.getSelectedFixtures()) {
                    this.removeFixtures.add(new RemoveFixture(fixture));
                }
            }

            @Override
            public String getDescription() {
                return "Delete Fixtures";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                ArrayList<LXFixture> selectedFixtures = new ArrayList<LXFixture>();
                for (RemoveFixture remove : this.removeFixtures) {
                    selectedFixtures.add(remove.fixture.get());
                }
                lx.structure.removeFixtures(selectedFixtures);
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                for (RemoveFixture remove : this.removeFixtures) {
                    remove.undo(lx);
                }
                for (RemoveFixture remove : this.removeFixtures) {
                    remove.fixture.get().selected.setValue(true);
                }
            }
        }

        public static class RemoveView
        extends RemoveComponent {
            private final ComponentReference<LXViewDefinition> view;
            private final JsonObject viewObj;
            private final int viewIndex;

            public RemoveView(LXViewDefinition view) {
                super(view);
                this.view = new ComponentReference<LXViewDefinition>(view);
                this.viewObj = LXSerializable.Utils.toObject(view);
                this.viewIndex = view.getIndex();
            }

            @Override
            public String getDescription() {
                return "Delete View";
            }

            @Override
            public void perform(LX lx) throws InvalidCommandException {
                lx.structure.views.removeView(this.view.get());
            }

            @Override
            public void undo(LX lx) throws InvalidCommandException {
                lx.structure.views.addView(this.viewObj, this.viewIndex);
                super.undo(lx);
            }
        }
    }
}

