/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.dmx;

import heronarts.lx.LXCategory;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.dmx.AbstractDmxModulator;
import heronarts.lx.dmx.LXDmxEngine;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;

@LXModulator.Global(value="DMX Color")
@LXModulator.Device(value="DMX Color")
@LXCategory(value="DMX")
public class DmxColorModulator
extends AbstractDmxModulator
implements LXOscComponent {
    public final EnumParameter<LXDmxEngine.ByteOrder> byteOrder = new EnumParameter<LXDmxEngine.ByteOrder>("Byte Order", LXDmxEngine.ByteOrder.RGB);
    public final BooleanParameter updatePalette = new BooleanParameter("Palette", false).setDescription("Updates the global palette's active swatch with the DMX color");
    public final DiscreteParameter paletteIndex = new LXPalette.IndexSelector("Index").setDescription("Target index in the global palette's active swatch");
    public final BooleanParameter setPaletteFixed = new BooleanParameter("Fixed", true).setDescription("When sending DMX color to the palette, also set the target color mode to Fixed");
    public final ColorParameter color = new ColorParameter("Color", -16777216).setDescription("Color received by DMX");

    public DmxColorModulator() {
        this("DMX Color");
    }

    public DmxColorModulator(String label) {
        super(label, 3);
        this.addParameter("byteOrder", this.byteOrder);
        this.addParameter("updatePalette", this.updatePalette);
        this.addParameter("paletteIndex", this.paletteIndex);
        this.addParameter("setPaletteFixed", this.setPaletteFixed);
        this.addParameter("color", this.color);
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        LXDmxEngine.ByteOrder byteOrder = this.byteOrder.getEnum();
        int color = this.lx.engine.dmx.getColor(this.universe.getValuei(), this.channel.getValuei(), byteOrder);
        this.color.setColor(color);
        if (this.updatePalette.isOn()) {
            int index = this.paletteIndex.getValuei() - 1;
            while (this.lx.engine.palette.swatch.colors.size() <= index) {
                this.lx.engine.palette.swatch.addColor().primary.setColor(-16777216);
            }
            this.lx.engine.palette.swatch.getColor((int)index).primary.setColor(color);
            if (this.setPaletteFixed.isOn()) {
                this.lx.engine.palette.swatch.getColor((int)index).mode.setValue((Object)LXDynamicColor.Mode.FIXED);
            }
        }
        return this.color.getValue();
    }

    public int getColor() {
        return this.color.getColor();
    }
}

