/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.dmx;

import heronarts.lx.LXCategory;
import heronarts.lx.dmx.AbstractDmxModulator;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

@LXModulator.Global(value="DMX Channel")
@LXModulator.Device(value="DMX Channel")
@LXCategory(value="DMX")
public class DmxModulator
extends AbstractDmxModulator
implements LXOscComponent,
LXNormalizedParameter,
LXTriggerSource {
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.CHANNEL_8).setDescription("8-bit = one DMX channel, 16-bit = two DMX channels, Range = part of one DMX channel");
    public final DiscreteParameter min = new DiscreteParameter("Min", 0, 256).setDescription("Minimum input value for range");
    public final DiscreteParameter max = new DiscreteParameter("Max", 255, 0, 256).setDescription("Maximum input value for range");
    public final BooleanParameter rangeActive = new BooleanParameter("Range Active", false).setDescription("True in range mode when DMX value is within [min-max] inclusive");
    private boolean internal = false;

    public DmxModulator() {
        this("DMX");
    }

    public DmxModulator(String label) {
        super(label);
        this.addParameter("mode", this.mode);
        this.addParameter("min", this.min);
        this.addParameter("max", this.max);
        this.addParameter("rangeActive", this.rangeActive);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.mode) {
            Mode mode = this.mode.getEnum();
            this.setBytes(mode.bytes);
            this.rangeActive.setValue(false);
        }
        if (this.internal) {
            return;
        }
        this.internal = true;
        if (p == this.min) {
            int min = this.min.getValuei();
            if (this.max.getValuei() < min) {
                this.max.setValue(min);
            }
        } else if (p == this.max) {
            int max = this.max.getValuei();
            if (this.min.getValuei() > max) {
                this.min.setValue(max);
            }
        }
        this.internal = false;
    }

    @Override
    protected double computeValue(double deltaMs) {
        Mode mode = this.mode.getEnum();
        int universe = this.universe.getValuei();
        int channel = this.channel.getValuei();
        switch (mode) {
            case CHANNEL_16: {
                byte byte1 = this.lx.engine.dmx.getByte(universe, channel);
                byte byte2 = this.lx.engine.dmx.getByte(universe, channel + 1);
                return (double)((byte1 & 0xFF) << 8 | byte2 & 0xFF) / 65535.0;
            }
            case RANGE: {
                int min = this.min.getValuei();
                int max = this.max.getValuei();
                int dmx = this.lx.engine.dmx.getValuei(universe, channel);
                boolean active = dmx >= min && dmx <= max;
                this.rangeActive.setValue(active);
                if (active) {
                    return max == min ? 1.0 : ((double)dmx - (double)min) / (double)(max - min);
                }
                return 0.0;
            }
        }
        return this.lx.engine.dmx.getNormalized(universe, channel);
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.rangeActive;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("May not setNormalized on DmxModulator");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    public static enum Mode {
        CHANNEL_8("8-bit", 1),
        CHANNEL_16("16-bit", 2),
        RANGE("Range", 1);

        public final String label;
        public final int bytes;

        private Mode(String label, int bytes) {
            this.label = label;
            this.bytes = bytes;
        }

        public String toString() {
            return this.label;
        }
    }
}

