/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.dmx;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.color.LXColor;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.output.ArtNetDatagram;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class LXDmxEngine
extends LXComponent {
    public final EnumParameter<LXOscEngine.IOState> artNetReceiveState = ((EnumParameter)new EnumParameter<LXOscEngine.IOState>("Art-Net RX State", LXOscEngine.IOState.STOPPED).setMappable(false)).setDescription("The state of the Art-Net receiver");
    public final BooleanParameter artNetReceiveActive = new BooleanParameter("Art-Net Active", false).setMappable(false).setDescription("Enables or disables Art-Net DMX input");
    public final DiscreteParameter artNetReceivePort = new DiscreteParameter("Art-Net RX Port", 6454, 1, 65535).setDescription("UDP port on which the engine listens for Art-Net").setMappable(false).setUnits(LXParameter.Units.INTEGER);
    public final TriggerParameter artNetActivity = new TriggerParameter("Art-Net Activity").setMappable(false).setDescription("Triggers when art-net input is received");
    private ArtNetReceiver artNetReceiver = null;
    public static final int MAX_CHANNEL = 512;
    public static final int MAX_UNIVERSE = 512;
    private final byte[][] data = new byte[512][512];

    public LXDmxEngine(LX lx) {
        super(lx);
        this.addParameter("artNetReceivePort", this.artNetReceivePort);
        this.addParameter("artNetReceiveActive", this.artNetReceiveActive);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.artNetReceiveActive) {
            this.stopReceiver(LXOscEngine.IOState.STOPPED);
            if (this.artNetReceiveActive.isOn()) {
                this.startReceiver();
            }
        } else if (p == this.artNetReceivePort && this.artNetReceiveActive.isOn()) {
            this.startReceiver();
        }
    }

    private void stopReceiver(LXOscEngine.IOState state) {
        if (this.artNetReceiver != null) {
            this.artNetReceiver.interrupt();
            this.artNetReceiver.socket.close();
            this.artNetReceiver = null;
        }
        this.artNetReceiveState.setValue((Object)state);
    }

    private void startReceiver() {
        if (this.artNetReceiver != null) {
            this.stopReceiver(LXOscEngine.IOState.STOPPED);
        }
        this.artNetReceiveState.setValue((Object)LXOscEngine.IOState.BINDING);
        int artNetPort = this.artNetReceivePort.getValuei();
        try {
            DatagramSocket socket = new DatagramSocket(artNetPort);
            this.artNetReceiver = new ArtNetReceiver(socket);
            this.artNetReceiver.start();
            this.artNetReceiveState.setValue((Object)LXOscEngine.IOState.BOUND);
        }
        catch (SocketException sx) {
            LXDmxEngine.error(sx, "Could not create Art-Net listener socket: " + sx.getMessage());
            this.lx.pushError("Failed to start Art-Net receiver on port " + artNetPort + "\n" + sx.getLocalizedMessage());
            this.artNetReceiveState.setValue((Object)LXOscEngine.IOState.SOCKET_ERROR);
        }
        catch (Throwable x) {
            LXDmxEngine.error(x, "Unknown error starting art-net receiver: " + x.getMessage());
            this.lx.pushError("Uknown error starting Art-Net receiver on port " + artNetPort + "\n" + x.getLocalizedMessage());
            this.artNetReceiveState.setValue((Object)LXOscEngine.IOState.SOCKET_ERROR);
        }
    }

    public int getColor(int universe, int channel) {
        return this.getColor(universe, channel, ByteOrder.RGB);
    }

    public int getColor(int universe, int channel, ByteOrder byteOrder) {
        return LXColor.rgba(this.data[universe][channel + byteOrder.r], this.data[universe][channel + byteOrder.g], this.data[universe][channel + byteOrder.b], 255);
    }

    public byte getByte(int universe, int channel) {
        return this.data[universe][channel];
    }

    public int getValuei(int universe, int channel) {
        return this.data[universe][channel] & 0xFF;
    }

    public double getNormalized(int universe, int channel) {
        return (double)(this.data[universe][channel] & 0xFF) / 255.0;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.artNetReceiveActive.reset();
            this.artNetReceivePort.reset();
        }
    }

    @Override
    public void dispose() {
        this.stopReceiver(LXOscEngine.IOState.STOPPED);
        super.dispose();
    }

    public static void error(String log) {
        LX.error("[ArtNet] " + log);
    }

    public static void error(Throwable x, String log) {
        LX.error(x, "[ArtNet] " + log);
    }

    public static void log(String log) {
        LX.log("[ArtNet] " + log);
    }

    private class ArtNetReceiver
    extends Thread {
        private final DatagramSocket socket;

        private ArtNetReceiver(DatagramSocket socket) {
            super("Art-Net Receiver Thread");
            this.socket = socket;
        }

        private boolean checkHeader(byte[] dmxData, int offset) {
            int i = 0;
            while (i < ArtNetDatagram.HEADER.length) {
                if (dmxData[offset + i] != ArtNetDatagram.HEADER[i]) {
                    LXDmxEngine.error("Packet missing valid Art-Net header");
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void run() {
            LXDmxEngine.log("Starting Art-Net listener on port 6454");
            byte[] buffer = new byte[530];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            while (!this.isInterrupted()) {
                try {
                    this.socket.receive(packet);
                    LXDmxEngine.this.artNetActivity.trigger();
                    byte[] dmxData = packet.getData();
                    int offset = packet.getOffset();
                    int dmxOffset = offset + 18;
                    if (!this.checkHeader(dmxData, offset)) continue;
                    int universe = dmxData[offset + 14] & 0xFF | (dmxData[offset + 15] & 0xFF) << 8;
                    if (universe >= 512) {
                        LXDmxEngine.error("Ignoring packet, universe exceeds max: " + universe);
                        continue;
                    }
                    int dataLength = dmxData[offset + 17] & 0xFF | (dmxData[offset + 16] & 0xFF) << 8;
                    System.arraycopy(dmxData, dmxOffset, LXDmxEngine.this.data[universe], 0, dataLength);
                }
                catch (Throwable x) {
                    if (this.isInterrupted()) break;
                    LXDmxEngine.error(x, x.getMessage());
                }
            }
            try {
                this.socket.close();
            }
            catch (Throwable x) {
                LX.error(x, "Error closing Art-Net DatagramSocket: " + x.getMessage());
            }
            LXDmxEngine.log("Art-Net receiver thread finished.");
        }
    }

    public static enum ByteOrder {
        RGB(0, 1, 2),
        RBG(0, 2, 1),
        GRB(1, 0, 2),
        GBR(2, 0, 1),
        BRG(1, 2, 0),
        BGR(2, 1, 0);

        public final int r;
        public final int g;
        public final int b;

        private ByteOrder(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

