/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.ModelBuffer;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Core")
@LXComponent.Description(value="Blends the content from prior frames to create blur motion")
public class BlurEffect
extends LXEffect {
    public final CompoundParameter level = new CompoundParameter("Level", 0.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Level of the blur relative to original signal");
    public final CompoundParameter decay = new CompoundParameter("Decay", 1.0, 0.01, 60.0).setDescription("Decay time for the motion blur to diminish to decay factor").setExponent(3.0).setUnits(LXParameter.Units.SECONDS);
    public final CompoundParameter decayFactor = new CompoundParameter("Factor", 0.5, 0.01, 1.0).setDescription("Decay factor, the level reached in decay time (e.g. half-life if at 50%)").setUnits(LXParameter.Units.PERCENT_NORMALIZED);
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.MIX).setDescription("Which blending mode the blur uses");
    private final ModelBuffer blurBuffer;

    public BlurEffect(LX lx) {
        super(lx);
        this.blurBuffer = new ModelBuffer(lx, -16777216);
        this.addParameter("level", this.level);
        this.addParameter("decay", this.decay);
        this.addParameter("decayFactor", this.decayFactor);
        this.addParameter("mode", this.mode);
    }

    @Override
    protected void onEnable() {
        int[] blurArray = this.blurBuffer.getArray();
        int i = 0;
        while (i < blurArray.length) {
            blurArray[i] = -16777216;
            ++i;
        }
    }

    private static int decrementColor(int argb) {
        int r = (argb & 0xFF0000) >> 16;
        int g = (argb & 0xFF00) >> 8;
        int b = argb & 0xFF;
        r = LXUtils.max(0, r - 1);
        g = LXUtils.max(0, g - 1);
        b = LXUtils.max(0, b - 1);
        return argb & 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Override
    public void run(double deltaMs, double amount) {
        int i;
        LXPoint p;
        int blurAlpha = (int)(256.0 * amount * this.level.getValue());
        int[] blurColors = this.blurBuffer.getArray();
        double decayScale = Math.pow(this.decayFactor.getValue(), deltaMs / (1000.0 * this.decay.getValue()));
        int decayColor = LXColor.grayn(decayScale);
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            p = lXPointArray[n2];
            i = p.index;
            int pre = blurColors[i];
            blurColors[i] = LXColor.multiply(blurColors[i], decayColor, 256);
            if (blurColors[i] == pre && pre != -16777216) {
                blurColors[i] = BlurEffect.decrementColor(pre);
            }
            blurColors[i] = LXColor.lightest(blurColors[i], this.colors[i], 256);
            ++n2;
        }
        if (blurAlpha > 0) {
            switch (this.mode.getEnum()) {
                case MIX: {
                    lXPointArray = this.model.points;
                    n = this.model.points.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = lXPointArray[n2];
                        i = p.index;
                        this.colors[i] = LXColor.lerp(this.colors[i], blurColors[i], blurAlpha);
                        ++n2;
                    }
                    break;
                }
                case ADD: {
                    lXPointArray = this.model.points;
                    n = this.model.points.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = lXPointArray[n2];
                        i = p.index;
                        this.colors[i] = LXColor.add(this.colors[i], blurColors[i], blurAlpha);
                        ++n2;
                    }
                    break;
                }
                case SCREEN: {
                    lXPointArray = this.model.points;
                    n = this.model.points.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = lXPointArray[n2];
                        i = p.index;
                        this.colors[i] = LXColor.screen(this.colors[i], blurColors[i], blurAlpha);
                        ++n2;
                    }
                    break;
                }
                case MULTIPLY: {
                    lXPointArray = this.model.points;
                    n = this.model.points.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = lXPointArray[n2];
                        i = p.index;
                        this.colors[i] = LXColor.multiply(this.colors[i], blurColors[i], blurAlpha);
                        ++n2;
                    }
                    break;
                }
                case LIGHTEST: {
                    lXPointArray = this.model.points;
                    n = this.model.points.length;
                    n2 = 0;
                    while (n2 < n) {
                        p = lXPointArray[n2];
                        i = p.index;
                        this.colors[i] = LXColor.lightest(this.colors[i], blurColors[i], blurAlpha);
                        ++n2;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.blurBuffer.dispose();
        super.dispose();
    }

    public static enum Mode {
        MIX("Mix"),
        ADD("Add"),
        SCREEN("Screen"),
        MULTIPLY("Multiply"),
        LIGHTEST("Lightest");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

