/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;

@LXCategory(value="Color")
@LXComponent.Description(value="Adjusts the shape of brightness response curves")
public class DynamicsEffect
extends LXEffect {
    private final int[] lookupTable = new int[256];
    private final int[] rTable = new int[256];
    private final int[] gTable = new int[256];
    private final int[] bTable = new int[256];
    private final List<ParameterMonitor> lookupParameters = new ArrayList<ParameterMonitor>();
    private final List<ParameterMonitor> channelParameters = new ArrayList<ParameterMonitor>();
    public final CompoundParameter floor = new CompoundParameter("Floor", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Minimum possible value");
    public final CompoundParameter ceiling = new CompoundParameter("Ceiling", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Maximum possible value");
    public final CompoundParameter shape = new CompoundParameter("Shape", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Shaping factor");
    public final CompoundParameter contrast = new CompoundParameter("Contrast", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Contrast factor");
    public final CompoundParameter gain = new CompoundParameter("Gain", 1.0, 1.0, 10.0).setExponent(2.0).setDescription("Gain factor");
    public final CompoundParameter gate = new CompoundParameter("Gate", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Minimum incoming level to generate output");
    public final CompoundParameter redAmount = new CompoundParameter("Red", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of effect to apply to red channel");
    public final CompoundParameter greenAmount = new CompoundParameter("Green", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of effect to apply to green channel");
    public final CompoundParameter blueAmount = new CompoundParameter("Blue", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of effect to apply to blue channel");
    public final MutableParameter waveChanged = new MutableParameter("Wave Changed");

    public DynamicsEffect(LX lx) {
        super(lx);
        this.addLookupParameter("ceiling", this.ceiling);
        this.addLookupParameter("contrast", this.contrast);
        this.addLookupParameter("gain", this.gain);
        this.addLookupParameter("floor", this.floor);
        this.addLookupParameter("gate", this.gate);
        this.addLookupParameter("shape", this.shape);
        this.addChannelParameter("red", this.redAmount);
        this.addChannelParameter("green", this.greenAmount);
        this.addChannelParameter("blue", this.blueAmount);
        this.buildLookupTable();
    }

    private void addLookupParameter(String path, CompoundParameter parameter) {
        super.addParameter(path, parameter);
        this.lookupParameters.add(new ParameterMonitor(parameter));
    }

    private void addChannelParameter(String path, CompoundParameter parameter) {
        super.addParameter(path, parameter);
        this.channelParameters.add(new ParameterMonitor(parameter));
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        for (ParameterMonitor monitor : this.lookupParameters) {
            if (monitor.parameter != p) continue;
            monitor.clean();
            this.buildLookupTable();
            this.waveChanged.bang();
        }
    }

    public int[] getLookupTable() {
        return this.lookupTable;
    }

    private void buildLookupTable() {
        float floor = 255.0f * this.floor.getValuef();
        float ceiling = 255.0f * this.ceiling.getValuef();
        float shape = this.shape.getValuef();
        float gain = this.gain.getValuef();
        float gate = this.gate.getValuef();
        float gateFactor = gate < 1.0f ? 1.0f / (1.0f - gate) : 0.0f;
        float shapePow = 1.0f;
        if (shape >= 0.0f) {
            shapePow = 1.0f - shape * 0.75f;
        } else if (shape < 0.0f) {
            shapePow = 1.0f - 3.0f * shape;
        }
        float contrast = this.contrast.getValuef();
        float contrastPow = 1.0f;
        contrastPow = contrast >= 0.0f ? 1.0f - contrast * 0.75f : 1.0f - contrast * 3.0f;
        int i = 0;
        while (i < this.lookupTable.length) {
            float lerp = (float)i / (float)(this.lookupTable.length - 1);
            lerp = LXUtils.maxf(0.0f, lerp - gate) * gateFactor;
            lerp = 0.5f + (float)Math.pow(2.0f * Math.abs(lerp - 0.5f), contrastPow) * (lerp > 0.5f ? 0.5f : -0.5f);
            lerp = (float)Math.pow(lerp, shapePow);
            this.lookupTable[i] = (int)LXUtils.lerpf(floor, ceiling, LXUtils.clampf(lerp * gain, 0.0f, 1.0f));
            ++i;
        }
        this.buildRGBTables();
    }

    private void buildRGBTables() {
        float r = this.redAmount.getValuef();
        float g = this.greenAmount.getValuef();
        float b = this.blueAmount.getValuef();
        int i = 0;
        while (i < this.lookupTable.length) {
            this.rTable[i] = (int)LXUtils.lerpf(i, this.lookupTable[i], r);
            this.gTable[i] = (int)LXUtils.lerpf(i, this.lookupTable[i], g);
            this.bTable[i] = (int)LXUtils.lerpf(i, this.lookupTable[i], b);
            ++i;
        }
    }

    private void rebuildTablesIfNecessary() {
        boolean rebuild = false;
        for (ParameterMonitor monitor : this.lookupParameters) {
            if (!monitor.checkForChange()) continue;
            rebuild = true;
        }
        if (rebuild) {
            this.buildLookupTable();
            this.waveChanged.bang();
            for (ParameterMonitor monitor : this.channelParameters) {
                monitor.clean();
            }
        } else {
            boolean rebuildRGB = false;
            for (ParameterMonitor monitor : this.channelParameters) {
                if (!monitor.checkForChange()) continue;
                rebuildRGB = true;
            }
            if (rebuildRGB) {
                this.buildRGBTables();
            }
        }
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        this.rebuildTablesIfNecessary();
        if (enabledAmount < 1.0) {
            float enabledf = (float)enabledAmount;
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                int i = p.index;
                int c = this.colors[i];
                int a = c & 0xFF000000;
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                r = (int)LXUtils.lerpf(r, this.rTable[r], enabledf);
                g = (int)LXUtils.lerpf(g, this.gTable[g], enabledf);
                b = (int)LXUtils.lerpf(b, this.bTable[b], enabledf);
                this.colors[i] = a | r << 16 | g << 8 | b;
                ++n2;
            }
        } else {
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n3 = 0;
            while (n3 < n) {
                LXPoint p = lXPointArray[n3];
                int i = p.index;
                int c = this.colors[i];
                int a = c & 0xFF000000;
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                this.colors[i] = a | this.rTable[r] << 16 | this.gTable[g] << 8 | this.bTable[b];
                ++n3;
            }
        }
    }

    private class ParameterMonitor {
        private final CompoundParameter parameter;
        private double lastValue;

        private ParameterMonitor(CompoundParameter parameter) {
            this.parameter = parameter;
            this.lastValue = parameter.getValue();
        }

        public boolean checkForChange() {
            double value = this.parameter.getValue();
            boolean dirty = value != this.lastValue;
            this.lastValue = value;
            return dirty;
        }

        public void clean() {
            this.lastValue = this.parameter.getValue();
        }
    }
}

