/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.Interval;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Core")
@LXComponent.Description(value="Freeze-frames the visual output based on controls or tempo")
public class FreezeEffect
extends LXEffect {
    private final ModelBuffer buffer;
    public final Interval interval;
    public final BooleanParameter lock;
    public final BooleanParameter hold;
    public final TriggerParameter resample;
    public final CompoundParameter mix;
    public final CompoundParameter attackMs;
    public final CompoundParameter releaseMs;
    public final EnumParameter<Mode> mode;
    private boolean capture;
    private boolean engage;
    private double basis;
    private int replaceInMask;

    public FreezeEffect(LX lx) {
        super(lx);
        this.buffer = new ModelBuffer(this.lx);
        this.interval = new Interval();
        this.lock = new BooleanParameter("Lock", false).setDescription("Locks the freeze effect active");
        this.hold = new BooleanParameter("Hold", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Freezes the frame only while held");
        this.resample = new TriggerParameter("Resample", this::resample).setDescription("Samples a new underlying frame");
        this.mix = new CompoundParameter("Mix", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Level of the frozen frame");
        this.attackMs = new CompoundParameter("Attack", 0.0, 0.0, 1000.0).setUnits(LXParameter.Units.MILLISECONDS_RAW).setDescription("Time to blend into the frozen frame");
        this.releaseMs = new CompoundParameter("Release", 50.0, 0.0, 10000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS_RAW).setDescription("Time to blend out from the frozen frame");
        this.mode = new EnumParameter<Mode>("Mode", Mode.REPLACE).setDescription("How to blend the frozen frame");
        this.capture = false;
        this.engage = false;
        this.basis = 0.0;
        this.replaceInMask = -16777216;
        this.addParameter("lock", this.lock);
        this.addParameter("hold", this.hold);
        this.addParameter("resample", this.resample);
        this.addParameter("mix", this.mix);
        this.addParameter("attackMs", this.attackMs);
        this.addParameter("releaseMs", this.releaseMs);
        this.addParameter("mode", this.mode);
        this.addModulator("interval", this.interval);
        this.interval.triggerOut.addListener(this);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.lock) {
            if (!this.hold.isOn() && this.lock.isOn()) {
                this.capture = true;
                this.engage = true;
            }
        } else if (p == this.hold) {
            if (!this.lock.isOn() && this.hold.isOn()) {
                this.capture = true;
                this.engage = true;
            }
        } else if (p == this.interval.triggerOut && this.interval.triggerOut.isOn()) {
            this.capture = true;
        }
    }

    private void resample() {
        this.capture = true;
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        double mix;
        int blendMask;
        int[] array = this.buffer.getArray();
        if (this.capture) {
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                array[p.index] = this.colors[p.index];
                ++n2;
            }
            this.capture = false;
            if (this.engage && this.attackMs.getValue() == 0.0) {
                this.basis = 1.0;
            }
            this.engage = false;
        }
        Mode mode = this.mode.getEnum();
        LXBlend.FunctionalBlend.BlendFunction blend = mode.function;
        if (this.lock.isOn() || this.hold.isOn()) {
            this.basis = LXUtils.min(1.0, this.basis + deltaMs / this.attackMs.getValue());
            if (mode == Mode.REPLACE) {
                blend = this::replaceIn;
                this.replaceInMask = LXColor.grayn(this.mix.getValue());
            }
        } else {
            this.basis = LXUtils.max(0.0, this.basis - deltaMs / this.releaseMs.getValue());
        }
        if (this.basis > 0.0 && (blendMask = LXColor.blendMask(mix = this.basis * this.mix.getValue() * enabledAmount)) > 0) {
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n3 = 0;
            while (n3 < n) {
                LXPoint p = lXPointArray[n3];
                this.colors[p.index] = blend.apply(this.colors[p.index], array[p.index], blendMask);
                ++n3;
            }
        }
    }

    private int replaceIn(int dst, int src, int alpha) {
        return LXColor.lightest(LXColor.multiply(src, this.replaceInMask, 256), dst, 256 - alpha);
    }

    @Override
    public void dispose() {
        this.interval.triggerOut.removeListener(this);
        super.dispose();
    }

    public static enum Mode {
        REPLACE("Replace", LXColor::lerp),
        MULTIPLY("Multiply", LXColor::multiply),
        ADD("Add", LXColor::add),
        SPOTLIGHT("Spotlight", LXColor::spotlight),
        HIGHLIGHT("Highlight", LXColor::highlight),
        SUBTRACT("Subtract", LXColor::subtract),
        DIFFERENCE("Difference", LXColor::difference);

        public final String label;
        public final LXBlend.FunctionalBlend.BlendFunction function;

        private Mode(String label, LXBlend.FunctionalBlend.BlendFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }
}

