/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.model.LXModel;
import heronarts.lx.modulator.LinearEnvelope;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.structure.view.LXViewDefinition;
import java.util.List;
import java.util.Map;

public abstract class LXEffect
extends LXDeviceComponent
implements LXComponent.Renamable,
LXOscComponent {
    public final BooleanParameter enabled = new BooleanParameter("Enabled", true).setDescription("Whether the effect is enabled");
    public final BooleanParameter locked = new BooleanParameter("Locked", false).setDescription("Whether the effect is locked");
    protected boolean hasDamping = true;
    protected final MutableParameter enabledDampingAttack = new MutableParameter(250.0);
    protected final MutableParameter enabledDampingRelease = new MutableParameter(250.0);
    protected final LinearEnvelope enabledDamped = new LinearEnvelope(1.0, 1.0, 0.0);
    private boolean initialize = true;
    private boolean onEnable = false;
    private boolean onDisable = false;
    public final Profiler profiler = new Profiler();
    private int index = -1;
    private final LXParameterListener enabledListener = p -> {
        if (this.locked.isOn()) {
            LX.error(new IllegalStateException("LXEffect.enabled was toggled while LXEffect.locked was true, UX should not make this possible."));
        }
        if (this.enabled.isOn()) {
            if (this.hasDamping) {
                this.enabledDamped.setRangeFromHereTo(1.0, this.enabledDampingAttack.getValue()).start();
            }
            this.onEnable = true;
        } else {
            if (this.hasDamping) {
                this.enabledDamped.setRangeFromHereTo(0.0, this.enabledDampingRelease.getValue()).start();
            }
            this.onDisable = true;
        }
    };

    protected LXEffect(LX lx) {
        super(lx);
        this.label.setDescription("The name of this effect");
        this.enabled.addListener(this.enabledListener);
        this.addParameter("enabled", this.enabled);
        this.addParameter("locked", this.locked);
        this.addModulator(this.enabledDamped);
    }

    @Override
    public boolean isHiddenControl(LXParameter parameter) {
        return parameter == this.enabled || parameter == this.locked || super.isHiddenControl(parameter);
    }

    public LXEffect setDamping(boolean hasDamping) {
        this.hasDamping = hasDamping;
        return this;
    }

    public LXEffect setDampingTime(double dampingTimeMs) {
        this.hasDamping = true;
        this.enabledDampingAttack.setValue(dampingTimeMs);
        this.enabledDampingRelease.setValue(dampingTimeMs);
        return this;
    }

    protected LXEffect setDampingTime(double dampingTimeEnabledMs, double dampingTimeDisabledMs) {
        this.hasDamping = true;
        this.enabledDampingAttack.setValue(dampingTimeEnabledMs);
        this.enabledDampingRelease.setValue(dampingTimeDisabledMs);
        return this;
    }

    @Override
    public LXModel getModelView() {
        LXViewDefinition view = (LXViewDefinition)this.view.getObject();
        if (view != null) {
            return view.getModelView();
        }
        if (this.isPatternEffect()) {
            return this.getPattern().getModelView();
        }
        return super.getModelView();
    }

    @Override
    public String getPath() {
        return "effect/" + (this.index + 1);
    }

    public final LXEffect setIndex(int index) {
        this.index = index;
        return this;
    }

    public final int getIndex() {
        return this.index;
    }

    public final LXEffect setBus(LXBus bus) {
        this.setParent(bus);
        return this;
    }

    public boolean isBusEffect() {
        return this.getParent() instanceof LXBus;
    }

    public boolean isPatternEffect() {
        return this.getParent() instanceof LXPattern;
    }

    public Container getContainer() {
        return (Container)((Object)this.getParent());
    }

    public LXBus getBus() {
        return (LXBus)this.getParent();
    }

    public final LXEffect setPattern(LXPattern pattern) {
        this.setParent(pattern);
        return this;
    }

    public LXPattern getPattern() {
        return (LXPattern)this.getParent();
    }

    public final boolean isEnabled() {
        return this.enabled.isOn();
    }

    public final LXEffect toggle() {
        this.enabled.toggle();
        return this;
    }

    public final LXEffect enable() {
        this.enabled.setValue(true);
        return this;
    }

    public final LXEffect disable() {
        this.enabled.setValue(false);
        return this;
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    @Override
    public final void onLoop(double deltaMs) {
        if (this.initialize) {
            if (this.enabled.isOn()) {
                this.onEnable();
            }
            this.initialize = false;
        }
        if (this.onEnable) {
            this.onEnable();
            this.onEnable = false;
        } else if (this.onDisable && (!this.hasDamping || this.enabledDamped.finished())) {
            this.onDisable();
            this.onDisable = false;
        }
        long runStart = System.nanoTime();
        if (this.hasDamping) {
            double enabledDamped = this.enabledDamped.getValue();
            if (enabledDamped > 0.0) {
                this.run(deltaMs, enabledDamped);
            }
        } else {
            this.run(deltaMs, this.enabled.isOn() ? 1 : 0);
        }
        this.profiler.runNanos = System.nanoTime() - runStart;
    }

    protected abstract void run(double var1, double var3);

    @Override
    public void dispose() {
        this.enabled.removeListener(this.enabledListener);
        super.dispose();
    }

    public static interface Container {
        public List<LXEffect> getEffects();

        default public LXEffect getEffect(int i) {
            return this.getEffects().get(i);
        }

        default public LXEffect getEffect(String label) {
            for (LXEffect effect : this.getEffects()) {
                if (!effect.getLabel().equals(label)) continue;
                return effect;
            }
            return null;
        }

        default public Container addEffect(LXEffect effect) {
            return this.addEffect(effect, -1);
        }

        public Container addEffect(LXEffect var1, int var2);

        public Container moveEffect(LXEffect var1, int var2);

        public Container removeEffect(LXEffect var1);

        default public LXEffect loadEffect(LX lx, JsonObject effectObj, int index) {
            LXEffect effect;
            String effectClass = effectObj.get("class").getAsString();
            try {
                effect = lx.instantiateEffect(effectClass);
            }
            catch (LX.InstantiationException x) {
                LX.error("Using placeholder class for missing effect: " + effectClass);
                effect = new Placeholder(lx, x);
                lx.pushError(x, effectClass + " could not be loaded. " + x.getMessage());
            }
            effect.load(lx, effectObj);
            this.addEffect(effect, index);
            return effect;
        }
    }

    public static class Placeholder
    extends LXEffect
    implements LXComponent.Placeholder {
        private final LX.InstantiationException instantiationException;
        private String placeholderClassName;
        private JsonObject effectObj = null;

        public Placeholder(LX lx, LX.InstantiationException instantiationException) {
            super(lx);
            this.instantiationException = instantiationException;
        }

        @Override
        public String getPlaceholderTypeName() {
            return "Effect";
        }

        @Override
        public String getPlaceholderClassName() {
            return this.placeholderClassName;
        }

        @Override
        public LX.InstantiationException getInstantiationException() {
            return this.instantiationException;
        }

        @Override
        public void save(LX lx, JsonObject object) {
            super.save(lx, object);
            if (this.effectObj != null) {
                for (Map.Entry entry : this.effectObj.entrySet()) {
                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        @Override
        public void load(LX lx, JsonObject object) {
            super.load(lx, object);
            this.placeholderClassName = object.get("class").getAsString();
            this.effectObj = object;
        }

        @Override
        protected void run(double deltaMs, double enabledAmount) {
        }
    }

    public class Profiler {
        public long runNanos = 0L;
    }
}

