/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponentName;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXParameterizedMatrix;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Core")
@LXComponentName(value="Linear Mask")
public class LinearMaskEffect
extends LXEffect {
    public final EnumParameter<Axis> axis = new EnumParameter<Axis>("Axis", Axis.Y).setDescription("Which axis the mask operates on");
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.ABS).setDescription("How the mask is directionally applied");
    public final EnumParameter<FadePosition> fadePosition = new EnumParameter<FadePosition>("Fade Position", FadePosition.OUTER).setDescription("Where the fade transition is rendered");
    public final EnumParameter<FadeSize> fadeSize = new EnumParameter<FadeSize>("Fade Size", FadeSize.ABSOLUTE).setDescription("Where the fade size is absolute or relative to the mask size");
    public final CompoundParameter offset = new CompoundParameter("Offset", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Offset position of the mask");
    public final CompoundParameter size = new CompoundParameter("Size", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Size of the mask");
    public final CompoundParameter fade = new CompoundParameter("Fade", 0.25).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Fade size of the mask");
    public final BooleanParameter invert = new BooleanParameter("Invert", false).setDescription("Invert the mask");
    public final BooleanParameter cue = new BooleanParameter("CUE", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Cue the mask effect");
    public final BooleanParameter rotate = new BooleanParameter("Rotate", false).setDescription("Whether to rotate the geometry");
    public final CompoundParameter yaw = new CompoundParameter("Yaw", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Yaw rotation");
    public final CompoundParameter pitch = new CompoundParameter("Pitch", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Pitch rotation");
    public final CompoundParameter roll = new CompoundParameter("Roll", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Roll rotation");
    private final LXParameterizedMatrix transform = new LXParameterizedMatrix();

    public LinearMaskEffect(LX lx) {
        super(lx);
        this.addParameter("offset", this.offset);
        this.addParameter("size", this.size);
        this.addParameter("fade", this.fade);
        this.addParameter("invert", this.invert);
        this.addParameter("axis", this.axis);
        this.addParameter("mode", this.mode);
        this.addParameter("fadePosition", this.fadePosition);
        this.addParameter("fadeSize", this.fadeSize);
        this.addParameter("cue", this.cue);
        this.addTransformParameter("rotate", this.rotate);
        this.addTransformParameter("yaw", this.yaw);
        this.addTransformParameter("pitch", this.pitch);
        this.addTransformParameter("roll", this.roll);
    }

    private void addTransformParameter(String key, LXParameter parameter) {
        this.addParameter(key, parameter);
        this.transform.addParameter(parameter);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        int effectMask = LXColor.blendMask(enabledAmount);
        boolean rotate = this.rotate.isOn();
        if (rotate) {
            this.transform.update(matrix -> matrix.translate(0.5f, 0.5f, 0.5f).rotateZ((float)Math.toRadians(-this.roll.getValue())).rotateX((float)Math.toRadians(-this.pitch.getValue())).rotateY((float)Math.toRadians(-this.yaw.getValue())).translate(-0.5f, -0.5f, -0.5f));
        }
        PositionFunction axisFn = rotate ? this.axis.getEnum().rotatePosition : this.axis.getEnum().basicPosition;
        DistanceFunction distanceFn = this.mode.getEnum().distance;
        FadePosition fadeMode = this.fadePosition.getEnum();
        FadeSize fadeSize = this.fadeSize.getEnum();
        float offset = this.offset.getValuef();
        float size = this.size.getValuef();
        float fade = this.fade.getValuef() * (fadeSize == FadeSize.RELATIVE ? size : 1.0f);
        float falloff = 255.0f / fade;
        boolean invert = this.invert.isOn();
        boolean cue = this.cue.isOn();
        float base = 0.0f;
        switch (fadeMode) {
            case OUTER: {
                base = 255.0f;
                break;
            }
            case INNER: {
                base = 0.0f;
                break;
            }
            case MIDDLE: {
                base = 128.0f;
            }
        }
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            float distance = distanceFn.getDistance(axisFn.getPosition(p, this.transform), offset);
            int mask = (int)LXUtils.constrainf(base - falloff * (distance - size), 0.0f, 255.0f);
            int alpha = invert ? mask : 255 - mask;
            this.colors[p.index] = cue ? LXColor.grayn((float)(255 - alpha) / 255.0f) : LXColor.multiply(this.colors[p.index], alpha << 24, effectMask);
            ++n2;
        }
    }

    public static enum Axis {
        X("X-axis", (p, t) -> p.xn, (p, t) -> t.xn(p)),
        Y("Y-axis", (p, t) -> p.yn, (p, t) -> t.yn(p)),
        Z("Z-axis", (p, t) -> p.zn, (p, t) -> t.zn(p));

        public final String label;
        public final PositionFunction basicPosition;
        public final PositionFunction rotatePosition;

        private Axis(String label, PositionFunction basicPosition, PositionFunction rotatePosition) {
            this.label = label;
            this.basicPosition = basicPosition;
            this.rotatePosition = rotatePosition;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface DistanceFunction {
        public float getDistance(float var1, float var2);
    }

    public static enum FadePosition {
        OUTER("Outer"),
        INNER("Inner"),
        MIDDLE("Middle");

        public final String label;

        private FadePosition(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum FadeSize {
        ABSOLUTE("Abs"),
        RELATIVE("Rel");

        public final String label;

        private FadeSize(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum Mode {
        ABS("Abs", (position, reference) -> Math.abs(position - reference)),
        POS("Pos", (position, reference) -> position - reference),
        NEG("Neg", (position, reference) -> reference - position);

        public final String label;
        public final DistanceFunction distance;

        private Mode(String label, DistanceFunction distance) {
            this.label = label;
            this.distance = distance;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface PositionFunction {
        public float getPosition(LXPoint var1, LXMatrix var2);
    }
}

