/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.texture.SparklePattern;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Texture")
@LXComponent.Description(value="Masks the output with pixel-based sparkling")
public class SparkleEffect
extends LXEffect {
    public final SparklePattern.Engine engine;
    public final CompoundParameter amount;
    public final EnumParameter<MaskMode> maskMode;

    public SparkleEffect(LX lx) {
        super(lx);
        this.engine = new SparklePattern.Engine(this.model);
        this.amount = new CompoundParameter("Amount", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of sparkle to apply");
        this.maskMode = new EnumParameter<MaskMode>("Mode", MaskMode.MULTIPLY).setDescription("How to apply the sparkle mask");
        this.addParameter("amount", this.amount);
        this.addParameters(this.engine.parameters);
        this.addParameter("maskMode", this.maskMode);
    }

    @Override
    protected void onModelChanged(LXModel model) {
        this.engine.setModel(model);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        this.engine.run(deltaMs, this.model, 0.0, (enabledAmount *= this.amount.getValue()) > 0.0);
        if (enabledAmount > 0.0) {
            int blendMask = LXColor.blendMask(enabledAmount);
            LXBlend.FunctionalBlend.BlendFunction mask = this.maskMode.getEnum().function;
            int i = 0;
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                this.colors[p.index] = mask.apply(this.colors[p.index], LXColor.gray(LXUtils.clamp(this.engine.outputLevels[i++], 0.0, 100.0)), blendMask);
                ++n2;
            }
        }
    }

    public static enum MaskMode {
        MULTIPLY("Mask", LXColor::multiply),
        ADD("Add", LXColor::add),
        SPOTLIGHT("Spotlight", LXColor::spotlight),
        HIGHLIGHT("Highlight", LXColor::highlight),
        SUBTRACT("Subtract", LXColor::subtract),
        DIFFERENCE("Difference", LXColor::difference),
        LERP("Lerp", LXColor::lerp);

        public final String label;
        public final LXBlend.FunctionalBlend.BlendFunction function;

        private MaskMode(String label, LXBlend.FunctionalBlend.BlendFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }
}

