/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.Tempo;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.LXWaveshape;
import heronarts.lx.modulator.SawLFO;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Core")
@LXComponent.Description(value="Applies periodic strobing to the output")
public class StrobeEffect
extends LXEffect {
    public final ObjectParameter<LXWaveshape> waveshape = new ObjectParameter<LXWaveshape>("Waveshape", new LXWaveshape[]{LXWaveshape.SIN, LXWaveshape.TRI, LXWaveshape.SQUARE, LXWaveshape.UP, LXWaveshape.DOWN});
    public final BoundedParameter maxFrequency = new BoundedParameter("Max Freq", 5.0, 1.0, 30.0).setDescription("Maximum strobing frequency").setUnits(LXParameter.Units.HERTZ);
    public final BoundedParameter minFrequency = new BoundedParameter("Min Freq", 0.5, 0.1, 1.0).setDescription("Minimium strobing frequency").setUnits(LXParameter.Units.HERTZ);
    public final CompoundParameter speed = new CompoundParameter("Speed", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setExponent(2.0).setDescription("Speed of the strobe effect");
    public final CompoundParameter depth = new CompoundParameter("Depth", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Depth of the strobe effect");
    public final CompoundParameter bias = new CompoundParameter("Bias", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Bias of the strobe effect");
    public final BooleanParameter tempoSync = new BooleanParameter("Sync", false).setDescription("Whether to sync the tempo to a clock division");
    public final EnumParameter<Tempo.Division> tempoDivision = new EnumParameter<Tempo.Division>("Division", Tempo.Division.QUARTER).setDescription("Which tempo division to use when in sync mode");
    public final BoundedParameter tempoPhaseOffset = new BoundedParameter("Phase Offset", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Shifts the phase of the strobe LFO relative to tempo");
    private final SawLFO basis = this.startModulator(new SawLFO(0.0, 1.0, (LXParameter)new FunctionalParameter(){

        @Override
        public double getValue() {
            return 1000.0 / LXUtils.lerp(StrobeEffect.this.minFrequency.getValue(), StrobeEffect.this.maxFrequency.getValue(), StrobeEffect.this.speed.getValue());
        }
    }));

    public StrobeEffect(LX lx) {
        super(lx);
        this.addParameter("speed", this.speed);
        this.addParameter("depth", this.depth);
        this.addParameter("bias", this.bias);
        this.addParameter("waveshape", this.waveshape);
        this.addParameter("tempoSync", this.tempoSync);
        this.addParameter("tempoDivision", this.tempoDivision);
        this.addParameter("tempoPhaseOffset", this.tempoPhaseOffset);
        this.addParameter("minFrequency", this.minFrequency);
        this.addParameter("maxFrequency", this.maxFrequency);
    }

    @Override
    protected void onEnable() {
        this.basis.setBasis(0.0).start();
    }

    public float compute(double basis, boolean useBaseValue) {
        double expPower;
        double strobe = this.waveshape.getObject().compute(basis);
        double bias = useBaseValue ? this.bias.getBaseValue() : this.bias.getValue();
        double d = expPower = bias >= 0.0 ? 1.0 + 3.0 * bias : 1.0 / (1.0 - 3.0 * bias);
        if (expPower != 1.0) {
            strobe = Math.pow(strobe, expPower);
        }
        return LXUtils.lerpf(1.0f, (float)strobe, useBaseValue ? this.depth.getBaseValuef() : this.depth.getValuef());
    }

    private double getTempoBasis() {
        double basis = this.lx.engine.tempo.getBasis(this.tempoDivision.getEnum());
        return (basis + this.tempoPhaseOffset.getValue()) % 1.0;
    }

    @Override
    public void run(double deltaMs, double enabledAmount) {
        double strobeBasis;
        float strobe;
        float amt = (float)enabledAmount * this.depth.getValuef();
        if (amt > 0.0f && (strobe = LXUtils.lerpf(1.0f, this.compute(strobeBasis = this.tempoSync.isOn() ? this.getTempoBasis() : this.basis.getValue(), false), (float)enabledAmount)) < 1.0f) {
            if (strobe == 0.0f) {
                this.setColors(-16777216);
            } else {
                int src = LXColor.gray(100.0f * strobe);
                LXPoint[] lXPointArray = this.model.points;
                int n = this.model.points.length;
                int n2 = 0;
                while (n2 < n) {
                    LXPoint p = lXPointArray[n2];
                    this.colors[p.index] = LXColor.multiply(this.colors[p.index], src, 256);
                    ++n2;
                }
            }
        }
    }
}

