/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect.color;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.GradientUtils;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

@LXCategory(value="Color")
@LXComponent.Description(value="Dynamically remaps color content")
public class ColorizeEffect
extends LXEffect
implements GradientUtils.GradientFunction {
    private static final float AVG_FACTOR = 0.0013071896f;
    private static final float INV_255 = 0.003921569f;
    public final EnumParameter<SourceMode> source = new EnumParameter<SourceMode>("Source", SourceMode.BRIGHTNESS).setDescription("Determines the source of the color mapping");
    public final EnumParameter<GradientUtils.BlendMode> blendMode = new EnumParameter<GradientUtils.BlendMode>("Blend Mode", GradientUtils.BlendMode.RGB).setDescription("Determines the mode of color blending");
    public final EnumParameter<ColorMode> colorMode = new EnumParameter<ColorMode>("Color Mode", ColorMode.FIXED).setDescription("Which source the colors come from");
    public final ColorParameter color1 = new ColorParameter("Color 1", -16777216).setDescription("The first color that is mapped from");
    public final ColorParameter color2 = new ColorParameter("Color 2", -1).setDescription("The second color that is mapped to");
    public final CompoundParameter gradientHue = new CompoundParameter("H-Offset", 0.0, -360.0, 360.0).setUnits(LXParameter.Units.DEGREES).setDescription("Amount of hue gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter gradientSaturation = new CompoundParameter("S-Offset", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Amount of saturation gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter gradientBrightness = new CompoundParameter("B-Offset", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Amount of brightness gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter linkedHue = new CompoundParameter("H-Linked", 0.0, -360.0, 360.0).setUnits(LXParameter.Units.DEGREES).setDescription("Amount of hue gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter linkedSaturation = new CompoundParameter("S-Linked", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Amount of saturation gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter linkedBrightness = new CompoundParameter("B-Linked", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Amount of brightness gradient").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final DiscreteParameter paletteIndex = new LXPalette.IndexSelector("Index").setDescription("Which index at the palette to start from");
    public final DiscreteParameter paletteStops = new DiscreteParameter("Stops", 5, 2, 6).setDescription("How many color stops to use in the palette");
    public final BooleanParameter paletteInvert = new BooleanParameter("Invert", false).setDescription("Invert the direction of the palette gradient");
    public final CompoundParameter paletteDepth = new CompoundParameter("Depth", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Depth of palette generation");
    public final CompoundParameter amount = new CompoundParameter("Amount", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Depth of colorization");
    private final GradientUtils.ColorStops colorStops = new GradientUtils.ColorStops();

    public ColorizeEffect(LX lx) {
        super(lx);
        this.addParameter("source", this.source);
        this.addParameter("gradientHue", this.gradientHue);
        this.addParameter("gradientSaturation", this.gradientSaturation);
        this.addParameter("gradientBrightness", this.gradientBrightness);
        this.addParameter("colorMode", this.colorMode);
        this.addParameter("blendMode", this.blendMode);
        this.addParameter("color1", this.color1);
        this.addParameter("color2", this.color2);
        this.addParameter("paletteIndex", this.paletteIndex);
        this.addParameter("paletteStops", this.paletteStops);
        this.addParameter("paletteInvert", this.paletteInvert);
        this.addParameter("paletteDepth", this.paletteDepth);
        this.addParameter("primaryHue", this.linkedHue);
        this.addParameter("primarySaturation", this.linkedSaturation);
        this.addParameter("primaryBrightness", this.linkedBrightness);
        this.addParameter("amount", this.amount);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.colorMode || p == this.color1 || p == this.gradientHue || p == this.gradientSaturation || p == this.gradientBrightness || p == this.linkedHue || p == this.linkedSaturation || p == this.linkedBrightness) {
            this.setGradientColor();
        }
    }

    private void setGradientColor() {
        if (this.colorMode.getEnum() == ColorMode.RELATIVE) {
            this.color2.brightness.setValue(this.color1.brightness.getValue() + this.gradientBrightness.getValue());
            this.color2.saturation.setValue(this.color1.saturation.getValue() + this.gradientSaturation.getValue());
            this.color2.hue.setValue((360.0 + this.color1.hue.getValue() + this.gradientHue.getValue()) % 360.0);
        } else if (this.colorMode.getEnum() == ColorMode.LINKED) {
            LXDynamicColor swatchColor = this.getSwatchColor();
            this.color1.brightness.setValue((double)swatchColor.getBrightness() + this.linkedBrightness.getValue());
            this.color1.saturation.setValue((double)swatchColor.getSaturation() + this.linkedSaturation.getValue());
            this.color1.hue.setValue((360.0 + swatchColor.getHue() + this.linkedHue.getValue()) % 360.0);
            this.color2.brightness.setValue((double)swatchColor.getBrightness() + this.gradientBrightness.getValue());
            this.color2.saturation.setValue((double)swatchColor.getSaturation() + this.gradientSaturation.getValue());
            this.color2.hue.setValue((360.0 + swatchColor.getHue() + this.gradientHue.getValue()) % 360.0);
        }
    }

    public LXDynamicColor getSwatchColor() {
        return this.lx.engine.palette.getSwatchColor(this.paletteIndex.getValuei() - 1);
    }

    private void setColorStops() {
        switch (this.colorMode.getEnum()) {
            default: {
                this.colorStops.stops[0].set(this.color1);
                this.colorStops.stops[1].set(this.color2);
                this.colorStops.setNumStops(2);
                break;
            }
            case LINKED: {
                LXDynamicColor swatchColor = this.getSwatchColor();
                this.colorStops.stops[0].set(swatchColor, this.linkedHue.getValuef(), this.linkedSaturation.getValuef(), this.linkedBrightness.getValuef());
                this.colorStops.stops[1].set(swatchColor, this.gradientHue.getValuef(), this.gradientSaturation.getValuef(), this.gradientBrightness.getValuef());
                this.colorStops.setNumStops(2);
                break;
            }
            case RELATIVE: {
                this.colorStops.stops[0].set(this.color1);
                this.colorStops.stops[1].set(this.color1, this.gradientHue.getValuef(), this.gradientSaturation.getValuef(), this.gradientBrightness.getValuef());
                this.colorStops.setNumStops(2);
                break;
            }
            case PALETTE: {
                this.colorStops.setPaletteGradient(this.lx.engine.palette, this.paletteIndex.getValuei() - 1, this.paletteStops.getValuei());
            }
        }
    }

    @Override
    public int getGradientColor(float lerp) {
        lerp *= this.paletteDepth.getValuef();
        if (this.paletteInvert.isOn()) {
            lerp = 1.0f - lerp;
        }
        return this.colorStops.getColor(lerp, this.blendMode.getEnum().function);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        float lerpDepth;
        this.setGradientColor();
        this.setColorStops();
        if ((enabledAmount *= this.amount.getValue()) == 0.0) {
            return;
        }
        SourceFunction sourceFunction = this.source.getEnum().lerp;
        GradientUtils.BlendFunction blendFunction = this.blendMode.getEnum().function;
        boolean isPalette = this.colorMode.getEnum() == ColorMode.PALETTE;
        boolean lerpInvert = isPalette ? this.paletteInvert.isOn() : false;
        float f = lerpDepth = isPalette ? this.paletteDepth.getValuef() : 1.0f;
        if (enabledAmount < 1.0) {
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                int i = p.index;
                float lerp = sourceFunction.getLerpFactor(this.colors[i]) * lerpDepth;
                if (lerpInvert) {
                    lerp = 1.0f - lerp;
                }
                int c2 = this.colorStops.getColor(lerp, blendFunction);
                this.colors[i] = LXColor.lerp(this.colors[i], this.colors[i] & 0xFF000000 | c2 & 0xFFFFFF, enabledAmount);
                ++n2;
            }
        } else {
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n3 = 0;
            while (n3 < n) {
                LXPoint p = lXPointArray[n3];
                int i = p.index;
                float lerp = sourceFunction.getLerpFactor(this.colors[i]) * lerpDepth;
                if (lerpInvert) {
                    lerp = 1.0f - lerp;
                }
                int c2 = this.colorStops.getColor(lerp, blendFunction);
                this.colors[i] = this.colors[i] & 0xFF000000 | c2 & 0xFFFFFF;
                ++n3;
            }
        }
    }

    public static enum ColorMode {
        FIXED("Fixed"),
        RELATIVE("Relative"),
        LINKED("Linked"),
        PALETTE("Palette");

        public final String label;

        private ColorMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private static interface SourceFunction {
        public float getLerpFactor(int var1);
    }

    public static enum SourceMode {
        BRIGHTNESS("Brightness", argb -> LXColor.b(argb) * 0.01f),
        LUMINOSITY("Luminosity", argb -> LXColor.luminosity(argb) * 0.01f),
        RED("Red", argb -> 0.003921569f * (float)((argb & 0xFF0000) >> 16)),
        GREEN("Green", argb -> 0.003921569f * (float)((argb & 0xFF00) >> 8)),
        BLUE("Blue", argb -> 0.003921569f * (float)(argb & 0xFF)),
        MIN("Min", argb -> {
            int r = (argb & 0xFF0000) >> 16;
            int g = (argb & 0xFF00) >> 8;
            int b = argb & 0xFF;
            int rg = r < g ? r : g;
            return 0.003921569f * (float)(b < rg ? b : rg);
        }),
        AVERAGE("Average", argb -> {
            int r = (argb & 0xFF0000) >> 16;
            int g = (argb & 0xFF00) >> 8;
            int b = argb & 0xFF;
            return 0.0013071896f * (float)(r + g + b);
        }),
        ALPHA("Alpha", argb -> 0.003921569f * (float)(argb >>> 24));

        private final String name;
        public final SourceFunction lerp;

        private SourceMode(String name, SourceFunction function) {
            this.name = name;
            this.lerp = function;
        }

        public String toString() {
            return this.name;
        }
    }
}

