/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect.color;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.LXComponentName;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.effect.color.ColorMaskEffect;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.color.GradientPattern;

@LXCategory(value="Color")
@LXComponentName(value="Gradient Mask")
@LXComponent.Description(value="Masks content using a dynamic color gradient in 3D space")
public class GradientMaskEffect
extends LXEffect {
    private final ModelBuffer mask;
    public final GradientPattern.Engine engine;
    public final EnumParameter<ColorMaskEffect.Mode> mode;
    public final CompoundParameter depth;
    public final BooleanParameter cueMask;

    public GradientMaskEffect(LX lx) {
        super(lx);
        this.mask = new ModelBuffer(this.lx);
        this.mode = new EnumParameter<ColorMaskEffect.Mode>("Mode", ColorMaskEffect.Mode.MULTIPLY).setDescription("How to apply the color mask");
        this.depth = new CompoundParameter("Depth", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of masking to apply");
        this.cueMask = new BooleanParameter("CUE", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Directly render the mask");
        this.addParameter("depth", this.depth);
        this.addParameter("mode", this.mode);
        this.engine = new GradientPattern.Engine(lx);
        this.addParameters(this.engine.parameters);
        this.addParameter("cueMask", this.cueMask);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        this.engine.onParameterChanged(p);
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        int alpha = LXColor.blendMask(enabledAmount *= this.depth.getValue());
        if (alpha == 0) {
            return;
        }
        boolean cueMask = this.cueMask.isOn();
        int[] maskColors = this.mask.getArray();
        this.engine.run(deltaMs, this.model, cueMask ? this.colors : maskColors);
        if (!cueMask) {
            LXBlend.FunctionalBlend.BlendFunction blend = this.mode.getEnum().function;
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                this.colors[p.index] = blend.apply(this.colors[p.index], maskColors[p.index], alpha);
                ++n2;
            }
        }
    }

    @Override
    public void dispose() {
        this.mask.dispose();
        super.dispose();
    }
}

