/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.effect.midi;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.color.LXColor;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.AHDSREnvelope;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="MIDI")
@LXComponent.Description(value="Gates output levels using MIDI input")
public class GateEffect
extends LXEffect
implements LXDeviceComponent.Midi {
    public final CompoundParameter initial = new CompoundParameter("Initial", 0.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Initial Value");
    public final CompoundParameter peak = new CompoundParameter("Peak", 1.0, 0.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Peak Value");
    public final CompoundParameter delay = new CompoundParameter("Delay", 0.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Delay Time");
    public final CompoundParameter attack = new CompoundParameter("Attack", 100.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Attack Time");
    public final CompoundParameter hold = new CompoundParameter("Hold", 0.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Hold Time");
    public final CompoundParameter decay = new CompoundParameter("Decay", 1000.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Decay Time");
    public final CompoundParameter sustain = new CompoundParameter("Sustain", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sustain Level");
    public final CompoundParameter release = new CompoundParameter("Release", 1000.0, 0.0, 5000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Release Time");
    public final CompoundParameter shape = new CompoundParameter("Shape", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Shape of the envelope response curves");
    public final EnumParameter<EnvelopeMode> envelopeMode = new EnumParameter<EnvelopeMode>("Mode", EnvelopeMode.GATE).setDescription("Envelope Mode");
    public final EnumParameter<TriggerMode> triggerMode = new EnumParameter<TriggerMode>("Trigger Mode", TriggerMode.RETRIG).setDescription("How to retrigger the envelope on overlapping events");
    public final BooleanParameter manualTrigger = new BooleanParameter("Trigger", false).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Manually engage the gate");
    public final TriggerParameter targetTrigger = new TriggerParameter("Trigger").setDescription("Engage the gate from a trigger");
    public final BoundedParameter midiVelocityResponse = new BoundedParameter("Velocity", 25.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Degree to which MIDI velocity influences ceiling level");
    public final BoundedParameter midiNoteResponse = new BoundedParameter("Note Response", 0.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Degree to which MIDI note influences ceiling level");
    private final FunctionalParameter effectivePeak = new FunctionalParameter("Peak"){

        @Override
        public double getValue() {
            return LXUtils.lerp(GateEffect.this.initial.getValue(), GateEffect.this.peak.getValue(), GateEffect.this.amount);
        }
    };
    private final FunctionalParameter shapePow = new FunctionalParameter("Shape"){

        @Override
        public double getValue() {
            double s = GateEffect.this.shape.getValue();
            if (s > 0.0) {
                return LXUtils.lerp(1.0, 3.0, s);
            }
            return 1.0 / LXUtils.lerp(1.0, 3.0, -s);
        }
    };
    public final AHDSREnvelope env = new AHDSREnvelope("ADSR", this.delay, this.attack, this.hold, this.decay, this.sustain, this.release, this.initial, this.effectivePeak).setShape(this.shapePow);
    private float amount = 1.0f;
    private int midiLegatoCount = 0;

    public GateEffect(LX lx) {
        super(lx);
        this.addParameter("initial", this.initial);
        this.addParameter("peak", this.peak);
        this.addParameter("delay", this.delay);
        this.addParameter("attack", this.attack);
        this.addParameter("hold", this.hold);
        this.addParameter("decay", this.decay);
        this.addParameter("sustain", this.sustain);
        this.addParameter("release", this.release);
        this.addParameter("shape", this.shape);
        this.addParameter("envelopeMode", this.envelopeMode);
        this.addParameter("triggerMode", this.triggerMode);
        this.addParameter("manualTrigger", this.manualTrigger);
        this.addParameter("targetTrigger", this.targetTrigger);
        this.addLegacyInternalParameter("midiEnabled", this.midiFilter.enabled);
        this.addParameter("midiVelocityResponse", this.midiVelocityResponse);
        this.addParameter("midiNoteResponse", this.midiNoteResponse);
        this.addLegacyInternalParameter("minNote", this.midiFilter.minNote);
        this.addLegacyInternalParameter("noteRange", this.midiFilter.noteRange);
        this.startModulator(this.env);
        this.onParameterChanged(this.envelopeMode);
        this.onParameterChanged(this.triggerMode);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.midiFilter.enabled) {
            this.midiLegatoCount = 0;
            if (!this.midiFilter.enabled.isOn() && !this.manualTrigger.isOn()) {
                this.env.engage.setValue(false);
            }
        } else if (p == this.manualTrigger) {
            this.amount = 1.0f;
            this.env.engage.setValue(this.manualTrigger.isOn());
        } else if (p == this.targetTrigger) {
            this.env.engage.setValue(this.targetTrigger.isOn());
        } else if (p == this.envelopeMode) {
            EnvelopeMode triggerMode = this.envelopeMode.getEnum();
            this.env.stageMode.setValue((Object)triggerMode.stageMode);
            this.env.oneshot.setValue(triggerMode.oneshot);
        } else if (p == this.triggerMode) {
            this.env.resetMode.setValue(this.triggerMode.getEnum() == TriggerMode.RESET);
        }
    }

    @Override
    protected void run(double deltaMs, double enabledAmount) {
        double level = LXUtils.lerp(100.0, 100.0 * this.env.getValue(), enabledAmount);
        if (level == 0.0) {
            this.setColors(-16777216);
        } else if (level < 100.0) {
            int mask = LXColor.gray(level);
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                this.colors[p.index] = LXColor.multiply(this.colors[p.index], mask, 256);
                ++n2;
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        ++this.midiLegatoCount;
        TriggerMode triggerMode = this.triggerMode.getEnum();
        if (triggerMode == TriggerMode.LEGATO && this.midiLegatoCount > 1) {
            return;
        }
        float velocity = 0.0f;
        float velResponse = this.midiVelocityResponse.getValuef() / 100.0f;
        float scaleVelocity = ((float)note.getVelocity() - this.midiFilter.minVelocity.getValuef() + 1.0f) / this.midiFilter.velocityRange.getValuef();
        velocity = velResponse >= 0.0f ? LXUtils.lerpf(1.0f, scaleVelocity, velResponse) : LXUtils.lerpf(1.0f, 1.0f - scaleVelocity, -velResponse);
        float noteResponse = this.midiNoteResponse.getValuef() / 100.0f;
        if (noteResponse >= 0.0f) {
            float noteVelocity = ((float)note.getPitch() - this.midiFilter.minNote.getValuef() + 1.0f) / this.midiFilter.noteRange.getValuef();
            this.amount = velocity * LXUtils.lerpf(1.0f, noteVelocity, noteResponse);
        } else {
            float noteVelocity = (this.midiFilter.minNote.getValuef() + this.midiFilter.noteRange.getValuef() + 1.0f - (float)note.getPitch()) / this.midiFilter.noteRange.getValuef();
            this.amount = velocity * LXUtils.lerpf(1.0f, noteVelocity, -noteResponse);
        }
        if (this.env.engage.isOn()) {
            switch (triggerMode) {
                case RETRIG: {
                    this.env.retrig.setValue(true);
                    break;
                }
                case RESET: {
                    this.env.engage.setValue(false);
                    this.env.engage.setValue(true);
                    break;
                }
            }
        } else {
            this.env.engage.setValue(true);
        }
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.midiLegatoCount = Math.max(0, this.midiLegatoCount - 1);
        if (this.midiLegatoCount == 0) {
            this.env.engage.setValue(false);
        }
    }

    @Override
    public void midiPanicReceived() {
        if (this.midiLegatoCount > 0) {
            this.midiLegatoCount = 0;
            this.env.engage.setValue(false);
        }
    }

    public static enum EnvelopeMode {
        GATE("Gate", AHDSREnvelope.StageMode.AHDSR, false),
        TRIGGER("1-Shot", AHDSREnvelope.StageMode.AHD, true);

        public final String label;
        public final AHDSREnvelope.StageMode stageMode;
        public final boolean oneshot;

        private EnvelopeMode(String label, AHDSREnvelope.StageMode stageMode, boolean oneshot) {
            this.label = label;
            this.stageMode = stageMode;
            this.oneshot = oneshot;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum TriggerMode {
        RETRIG("Retrig"),
        LEGATO("Legato"),
        RESET("Reset");

        public final String label;

        private TriggerMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

