/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiTerminal;
import heronarts.lx.parameter.BooleanParameter;
import javax.sound.midi.MidiDevice;

public abstract class LXMidiDevice
implements LXMidiTerminal {
    protected final LXMidiEngine engine;
    protected MidiDevice device;
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setMappable(false);
    public final BooleanParameter connected = new BooleanParameter("Connected", true);

    protected LXMidiDevice(LXMidiEngine engine, MidiDevice device) {
        this.engine = engine;
        this.device = device;
        this.enabled.addListener(p -> this.onEnabled(this.enabled.isOn()));
    }

    void setDevice(MidiDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Cannot set null device on LXMidiDevice");
        }
        if (this.device != device) {
            this.close();
            this.device = device;
            this.enabled.bang();
            this.connected.setValue(true);
        }
    }

    MidiDevice getDevice() {
        return this.device;
    }

    protected abstract void close();

    public final LXMidiDevice open() {
        this.enabled.setValue(true);
        return this;
    }

    @Override
    public String getName() {
        return LXMidiEngine.getDeviceName(this.device.getDeviceInfo());
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        return this.device.getDeviceInfo().getDescription();
    }

    protected abstract void onEnabled(boolean var1);

    void dispose() {
        this.close();
        try {
            if (this.device.isOpen()) {
                this.device.close();
            }
        }
        catch (Exception x) {
            LXMidiEngine.error(x, "Unexpected exception closing device " + this.getName());
        }
    }
}

