/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXMappingEngine;
import heronarts.lx.LXSerializable;
import heronarts.lx.Tempo;
import heronarts.lx.command.LXCommand;
import heronarts.lx.midi.LXMidiDevice;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiMapping;
import heronarts.lx.midi.LXMidiMessage;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXMidiSource;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.LXSysexMessage;
import heronarts.lx.midi.MidiBeat;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiSelector;
import heronarts.lx.midi.surface.APC40;
import heronarts.lx.midi.surface.APC40Mk2;
import heronarts.lx.midi.surface.APCmini;
import heronarts.lx.midi.surface.APCminiMk2;
import heronarts.lx.midi.surface.DJM900nxs2;
import heronarts.lx.midi.surface.DJMA9;
import heronarts.lx.midi.surface.DJMV10;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.midi.surface.MidiFighterTwister;
import heronarts.lx.midi.template.AkaiMPD218;
import heronarts.lx.midi.template.AkaiMidiMix;
import heronarts.lx.midi.template.DJTTMidiFighterTwister;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.midi.template.NovationLaunchkeyMk337;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;

public class LXMidiEngine
extends LXComponent
implements LXOscComponent {
    public static final String TEMPLATE_PATH = "template";
    private static final String COREMIDI4J_HEADER = "CoreMIDI4J - ";
    private final List<LXMidiListener> listeners = new ArrayList<LXMidiListener>();
    private final List<DeviceListener> deviceListeners = new ArrayList<DeviceListener>();
    private final List<TemplateListener> templateListeners = new ArrayList<TemplateListener>();
    private final List<MappingListener> mappingListeners = new ArrayList<MappingListener>();
    private final AtomicBoolean hasInputMessage = new AtomicBoolean(false);
    private final List<LXMidiMessage> threadSafeInputQueue = Collections.synchronizedList(new ArrayList());
    private final List<LXMidiMessage> engineThreadInputQueue = new ArrayList<LXMidiMessage>();
    private final List<LXMidiInput> mutableInputs = new CopyOnWriteArrayList<LXMidiInput>();
    private final List<LXMidiOutput> mutableOutputs = new CopyOnWriteArrayList<LXMidiOutput>();
    private final List<LXMidiSurface> mutableSurfaces = new ArrayList<LXMidiSurface>();
    private final List<LXMidiTemplate> mutableTemplates = new ArrayList<LXMidiTemplate>();
    public final List<LXMidiInput> inputs = Collections.unmodifiableList(this.mutableInputs);
    public final List<LXMidiOutput> outputs = Collections.unmodifiableList(this.mutableOutputs);
    public final List<LXMidiSurface> surfaces = Collections.unmodifiableList(this.mutableSurfaces);
    public final List<LXMidiTemplate> templates = Collections.unmodifiableList(this.mutableTemplates);
    private final List<LXMidiMapping> mutableMappings = new ArrayList<LXMidiMapping>();
    public final List<LXMidiMapping> mappings = Collections.unmodifiableList(this.mutableMappings);
    private final ConcurrentHashMap<MidiDevice.Info, LXMidiInput> midiInfoToInput = new ConcurrentHashMap();
    private final ConcurrentHashMap<MidiDevice.Info, LXMidiOutput> midiInfoToOutput = new ConcurrentHashMap();
    private final List<Class<? extends LXMidiTemplate>> registeredTemplates = new ArrayList<Class<? extends LXMidiTemplate>>();
    private final Map<String, List<Class<? extends LXMidiSurface>>> registeredSurfaces = new HashMap<String, List<Class<? extends LXMidiSurface>>>();
    private final InitializationLock initializationLock = new InitializationLock();
    public final BooleanParameter computerKeyboardEnabled = new BooleanParameter("Computer MIDI Keyboard", false).setDescription("Whether the computer keyboard plays notes to MIDI tracks");
    public final DiscreteParameter computerKeyboardOctave = new DiscreteParameter("Computer MIDI Keyboard Octave", 5, 0, 11).setFormatter(v -> {
        int octave = (int)v;
        int lowNote = octave * 12;
        int highNote = lowNote + 14;
        String lowPitch = MidiNote.getPitchString(lowNote);
        String highPitch = MidiNote.getPitchString(highNote);
        return lowPitch + " to " + highPitch + " (" + lowNote + "-" + highNote + ")";
    }, true).setDescription("What octave the MIDI computer keyboard is in");
    public final ObjectParameter<Integer> computerKeyboardVelocity = new ObjectParameter<Integer>("Computer MIDI Keyboard Velocity", new Integer[]{1, 20, 40, 60, 80, 100, 127}, Integer.valueOf(100)).setDescription("What velocity the MIDI computer keyboard uses");
    public final DiscreteParameter computerKeyboardChannel = new DiscreteParameter("Computer MIDI Keyboard Channel", 0, 16).setFormatter(v -> "Ch." + (int)(v + 1.0), true).setDescription("What channel the MIDI computer keyboard uses");
    private final MidiDeviceUpdateThread deviceUpdateThread = new MidiDeviceUpdateThread();
    private final List<LXMidiInput> updateInputs = new ArrayList<LXMidiInput>();
    private final List<LXMidiOutput> updateOutputs = new ArrayList<LXMidiOutput>();
    private static final String PATH_NOTE = "note";
    private static final String PATH_CC = "cc";
    private static final String PATH_PITCHBEND = "pitchbend";
    private static final String KEY_INPUTS = "inputs";
    private static final String KEY_SURFACES = "surfaces";
    private final List<JsonObject> rememberMidiInputs = new ArrayList<JsonObject>();
    private boolean inLoadDevices = false;
    private static final String DEVICES_FILE_NAME = ".lxmidi";
    private static final String KEY_MAPPINGS = "mapping";
    private static final String KEY_TEMPLATES = "templates";
    private static final String MIDI_LOG_PREFIX = "[MIDI] ";

    public LXMidiEngine(LX lx) {
        super(lx);
        this._registerSurface(APC40.class);
        this._registerSurface(APC40Mk2.class);
        this._registerSurface(APCmini.class);
        this._registerSurface(APCminiMk2.class);
        this._registerSurface(DJM900nxs2.class);
        this._registerSurface(DJMA9.class);
        this._registerSurface(DJMV10.class);
        this._registerSurface(MidiFighterTwister.class);
        this._registerTemplate(AkaiMidiMix.class);
        this._registerTemplate(AkaiMPD218.class);
        this._registerTemplate(DJTTMidiFighterTwister.class);
        this._registerTemplate(NovationLaunchkeyMk337.class);
        this.computerKeyboardEnabled.setMappable(false);
        this.computerKeyboardOctave.setMappable(false);
        this.computerKeyboardVelocity.setMappable(false);
        this.computerKeyboardVelocity.setWrappable(false);
        this.computerKeyboardChannel.setMappable(false);
        this.addParameter("computerKeyboardEnabled", this.computerKeyboardEnabled);
        this.addParameter("computerKeyboardOctave", this.computerKeyboardOctave);
        this.addParameter("computerKeyboardVelocity", this.computerKeyboardVelocity);
        this.addParameter("computerKeyboardChannel", this.computerKeyboardChannel);
        this.addArray(TEMPLATE_PATH, this.templates);
    }

    private void _registerTemplate(Class<? extends LXMidiTemplate> templateClass) {
        if (this.registeredTemplates.contains(templateClass)) {
            throw new IllegalStateException("Template class is already registered: " + templateClass.getName());
        }
        this.registeredTemplates.add(templateClass);
    }

    public void registerTemplate(Class<? extends LXMidiTemplate> templateClass) {
        this.lx.registry.checkRegistration();
        this._registerTemplate(templateClass);
    }

    public List<Class<? extends LXMidiTemplate>> getRegisteredTemplateClasses() {
        return Collections.unmodifiableList(this.registeredTemplates);
    }

    private void _registerSurface(Class<? extends LXMidiSurface> surfaceClass) {
        this._registerSurface(LXMidiSurface.getDeviceName(surfaceClass), surfaceClass);
    }

    private void _registerSurface(String deviceName, Class<? extends LXMidiSurface> surfaceClass) {
        List<Class<? extends LXMidiSurface>> surfaces;
        if (!this.registeredSurfaces.containsKey(deviceName)) {
            surfaces = new ArrayList<Class<? extends LXMidiSurface>>();
            this.registeredSurfaces.put(deviceName, surfaces);
        } else {
            surfaces = this.registeredSurfaces.get(deviceName);
        }
        if (surfaces.contains(surfaceClass)) {
            throw new IllegalStateException("Surface class is already registered: " + deviceName + " -> " + surfaceClass.getName());
        }
        surfaces.add(surfaceClass);
    }

    @Deprecated
    public LXMidiEngine registerSurface(String deviceName, Class<? extends LXMidiSurface> surfaceClass) {
        this.lx.registry.checkRegistration();
        this._registerSurface(deviceName, surfaceClass);
        this.whenReady(() -> this.checkForNewSurfaceClass(surfaceClass));
        return this;
    }

    public LXMidiEngine registerSurface(Class<? extends LXMidiSurface> surfaceClass) {
        this.lx.registry.checkRegistration();
        this._registerSurface(surfaceClass);
        this.whenReady(() -> this.checkForNewSurfaceClass(surfaceClass));
        return this;
    }

    public List<Class<? extends LXMidiSurface>> getRegisteredSurfaceClasses() {
        ArrayList<Class<? extends LXMidiSurface>> surfaceClasses = new ArrayList<Class<? extends LXMidiSurface>>();
        for (List<Class<? extends LXMidiSurface>> surfaceList : this.registeredSurfaces.values()) {
            for (Class<? extends LXMidiSurface> surfaceClass : surfaceList) {
                if (surfaceClasses.contains(surfaceClass)) continue;
                surfaceClasses.add(surfaceClass);
            }
        }
        Collections.sort(surfaceClasses, new Comparator<Class<? extends LXMidiSurface>>(){

            @Override
            public int compare(Class<? extends LXMidiSurface> o1, Class<? extends LXMidiSurface> o2) {
                return LXMidiSurface.getSurfaceName(o1).compareToIgnoreCase(LXMidiSurface.getSurfaceName(o2));
            }
        });
        return surfaceClasses;
    }

    public void initialize() {
        this.deviceUpdateThread.start();
        new Thread("LXMidiEngine Device Initialization"){

            @Override
            public void run() {
                LinkedHashMap<MidiDevice.Info, MidiDevice> inputMap = new LinkedHashMap<MidiDevice.Info, MidiDevice>();
                LinkedHashMap<MidiDevice.Info, MidiDevice> outputMap = new LinkedHashMap<MidiDevice.Info, MidiDevice>();
                try {
                    MidiDevice.Info[] infoArray = CoreMidiDeviceProvider.getMidiDeviceInfo();
                    int n = infoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MidiDevice.Info deviceInfo = infoArray[n2];
                        try {
                            MidiDevice device = MidiSystem.getMidiDevice(deviceInfo);
                            if (device.getMaxTransmitters() != 0) {
                                inputMap.put(deviceInfo, device);
                            }
                            if (device.getMaxReceivers() != 0) {
                                outputMap.put(deviceInfo, device);
                            }
                        }
                        catch (MidiUnavailableException mux) {
                            LXMidiEngine.error(mux, "MidiUnavailable on MIDI device initialization thread: " + mux.getLocalizedMessage());
                        }
                        ++n2;
                    }
                }
                catch (Exception x) {
                    LXMidiEngine.error(x, "Unexpected MIDI error, MIDI unavailable: " + x.getLocalizedMessage());
                }
                ((LXMidiEngine)LXMidiEngine.this).lx.engine.addTask(() -> LXMidiEngine.this._initialize(inputMap, outputMap));
            }
        }.start();
    }

    private void _initialize(Map<MidiDevice.Info, MidiDevice> inputMap, Map<MidiDevice.Info, MidiDevice> outputMap) {
        for (Map.Entry<MidiDevice.Info, MidiDevice> pair : inputMap.entrySet()) {
            LXMidiInput input = new LXMidiInput(this, pair.getValue());
            this.midiInfoToInput.put(pair.getKey(), input);
            this.mutableInputs.add(input);
        }
        for (Map.Entry<MidiDevice.Info, MidiDevice> pair : outputMap.entrySet()) {
            LXMidiOutput output = new LXMidiOutput(this, pair.getValue());
            this.midiInfoToOutput.put(pair.getKey(), output);
            this.mutableOutputs.add(output);
        }
        MidiSelector.updateInputs(this.inputs);
        MidiSelector.updateOutputs(this.outputs);
        this.loadDevices();
        for (LXMidiInput input : this.inputs) {
            this.instantiateSurfaces(input, false);
        }
        for (DeviceListener listener : this.deviceListeners) {
            for (LXMidiInput input : this.inputs) {
                listener.inputAdded(this, input);
            }
            for (LXMidiOutput output : this.outputs) {
                listener.outputAdded(this, output);
            }
            for (LXMidiSurface surface : this.surfaces) {
                listener.surfaceAdded(this, surface);
            }
        }
        this.initializationLock.onReady();
        boolean listening = false;
        try {
            if (CoreMidiDeviceProvider.isLibraryLoaded()) {
                CoreMidiDeviceProvider.addNotificationListener(() -> {
                    MidiDeviceUpdateThread midiDeviceUpdateThread = this.deviceUpdateThread;
                    synchronized (midiDeviceUpdateThread) {
                        this.deviceUpdateThread.notify();
                    }
                });
                listening = true;
            }
        }
        catch (CoreMidiException cmx) {
            LXMidiEngine.error((Exception)((Object)cmx), "Could not initialize CoreMidi notification listener: " + cmx.getMessage());
        }
        if (!listening) {
            this.deviceUpdateThread.setPolling();
        }
    }

    public void disposeSurfaces() {
        for (LXMidiSurface surface : this.surfaces) {
            surface.dispose();
        }
        this.mutableSurfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        MidiDeviceUpdateThread midiDeviceUpdateThread = this.deviceUpdateThread;
        synchronized (midiDeviceUpdateThread) {
            this.deviceUpdateThread.interrupt();
        }
        for (LXMidiInput input : this.inputs) {
            input.dispose();
        }
        this.mutableInputs.clear();
        for (LXMidiOutput output : this.outputs) {
            output.dispose();
        }
        this.mutableOutputs.clear();
        super.dispose();
    }

    private void updateMidiDevices(MidiDevice.Info[] midiDeviceInfo) {
        try {
            this.updateInputs.clear();
            this.updateInputs.addAll(this.inputs);
            this.updateOutputs.clear();
            this.updateOutputs.addAll(this.outputs);
            ArrayList<MidiDevice> checkForSurface = null;
            MidiDevice.Info[] infoArray = midiDeviceInfo;
            int n = midiDeviceInfo.length;
            int n2 = 0;
            while (n2 < n) {
                MidiDevice device;
                LXMidiOutput existingOutput;
                MidiDevice.Info deviceInfo = infoArray[n2];
                LXMidiInput existingInput = this.midiInfoToInput.get(deviceInfo);
                if (existingInput != null) {
                    this.updateInputs.remove(existingInput);
                    if (!existingInput.connected.isOn()) {
                        MidiDevice device2 = MidiSystem.getMidiDevice(deviceInfo);
                        this.lx.engine.addTask(() -> existingInput.setDevice(device2));
                    }
                }
                if ((existingOutput = this.midiInfoToOutput.get(deviceInfo)) != null) {
                    this.updateOutputs.remove(existingOutput);
                    if (!existingOutput.connected.isOn()) {
                        device = MidiSystem.getMidiDevice(deviceInfo);
                        this.lx.engine.addTask(() -> existingOutput.setDevice(device));
                    }
                }
                if (existingInput == null && existingOutput == null) {
                    try {
                        device = MidiSystem.getMidiDevice(deviceInfo);
                        String deviceName = LXMidiEngine.getDeviceName(deviceInfo);
                        if (device.getMaxTransmitters() != 0) {
                            LXMidiInput input = LXMidiEngine.findDevice(this.updateInputs, deviceName);
                            if (input != null) {
                                this.updateInputs.remove(input);
                                this.lx.engine.addTask(() -> input.setDevice(device));
                            } else {
                                this.lx.engine.addTask(() -> this.addInput(deviceInfo, device));
                                if (checkForSurface == null) {
                                    checkForSurface = new ArrayList<MidiDevice>();
                                }
                                checkForSurface.add(device);
                            }
                        }
                        if (device.getMaxReceivers() != 0) {
                            LXMidiOutput output = LXMidiEngine.findDevice(this.updateOutputs, deviceName);
                            if (output != null) {
                                this.updateOutputs.remove(output);
                                this.lx.engine.addTask(() -> output.setDevice(device));
                            } else {
                                this.lx.engine.addTask(() -> this.addOutput(deviceInfo, device));
                            }
                        }
                    }
                    catch (MidiUnavailableException mux) {
                        LXMidiEngine.error(mux, "MIDI unavailable in updateMidiDevices: " + mux.getLocalizedMessage());
                    }
                }
                ++n2;
            }
            for (LXMidiInput input : this.updateInputs) {
                this.lx.engine.addTask(() -> {
                    BooleanParameter booleanParameter = lXMidiInput.connected.setValue(false);
                });
            }
            for (LXMidiOutput output : this.updateOutputs) {
                this.lx.engine.addTask(() -> {
                    BooleanParameter booleanParameter = lXMidiOutput.connected.setValue(false);
                });
            }
            if (checkForSurface != null) {
                ArrayList<MidiDevice> checkForSurface2 = checkForSurface;
                this.lx.engine.addTask(() -> {
                    for (MidiDevice device : checkForSurface2) {
                        this.checkForNewSurfaceDevice(device);
                    }
                });
            }
        }
        catch (Exception x) {
            LXMidiEngine.error(x, "Unhandled exception in midi system update: " + x.getLocalizedMessage());
        }
    }

    private void addInput(MidiDevice.Info deviceInfo, MidiDevice device) {
        LXMidiInput input = new LXMidiInput(this, device);
        this.mutableInputs.add(input);
        this.midiInfoToInput.put(deviceInfo, input);
        String inputName = input.getName();
        JsonObject settings = null;
        for (JsonObject remembered : this.rememberMidiInputs) {
            if (!remembered.get("name").getAsString().equals(inputName)) continue;
            settings = remembered;
            break;
        }
        if (settings != null) {
            input.load(this.lx, settings);
            this.rememberMidiInputs.remove(settings);
        }
        for (DeviceListener listener : this.deviceListeners) {
            listener.inputAdded(this, input);
        }
        MidiSelector.updateInputs(this.inputs);
    }

    private void addOutput(MidiDevice.Info deviceInfo, MidiDevice device) {
        LXMidiOutput output = new LXMidiOutput(this, device);
        this.mutableOutputs.add(output);
        this.midiInfoToOutput.put(deviceInfo, output);
        for (DeviceListener listener : this.deviceListeners) {
            listener.outputAdded(this, output);
        }
        MidiSelector.updateOutputs(this.outputs);
    }

    public static String getDeviceName(MidiDevice.Info deviceInfo) {
        String name = deviceInfo.getName();
        if (name.indexOf(COREMIDI4J_HEADER) == 0) {
            name = name.substring(COREMIDI4J_HEADER.length());
        }
        return name;
    }

    private void checkForNewSurfaceDevice(MidiDevice device) {
        for (LXMidiSurface surface : this.surfaces) {
            LXMidiInput input = surface.getInput();
            if (input == null || input.device != device) continue;
            return;
        }
        this.attemptMidiSurface(this.findInput(device));
    }

    private void checkForNewSurfaceClass(Class<? extends LXMidiSurface> surfaceClass) {
        for (LXMidiSurface surface : this.surfaces) {
            if (!surface.getClass().equals(surfaceClass)) continue;
            return;
        }
        String deviceName = LXMidiSurface.getDeviceName(surfaceClass);
        for (LXMidiInput input : this.inputs) {
            if (!input.getName().equals(deviceName)) continue;
            LXMidiOutput output = this.findOutput(input);
            this._addSurface(surfaceClass, input, output, true);
        }
    }

    private void attemptMidiSurface(LXMidiInput input) {
        if (input != null) {
            this.instantiateSurfaces(input, true);
        }
    }

    private void instantiateSurfaces(LXMidiInput input, boolean notifyListeners) {
        for (LXMidiSurface surface : this.surfaces) {
            if (surface.getInput() != input) continue;
            return;
        }
        List<Class<? extends LXMidiSurface>> surfaceClasses = this.registeredSurfaces.get(input.getName());
        if (surfaceClasses != null) {
            LXMidiOutput output = this.findOutput(input);
            surfaceClasses.forEach(surfaceClass -> {
                LXMidiSurface lXMidiSurface = this._addSurface((Class<? extends LXMidiSurface>)surfaceClass, input, output, notifyListeners);
            });
        }
    }

    public LXMidiEngine addSurface(LXMidiSurface surface) {
        this.mutableSurfaces.add(surface);
        for (DeviceListener listener : this.deviceListeners) {
            listener.surfaceAdded(this, surface);
        }
        return this;
    }

    public LXMidiEngine removeSurface(LXMidiSurface surface) {
        if (!this.mutableSurfaces.remove(surface)) {
            throw new IllegalArgumentException("Cannot remove non-existent MIDI surface: " + String.valueOf(surface));
        }
        surface.enabled.setValue(false);
        for (DeviceListener listener : this.deviceListeners) {
            listener.surfaceRemoved(this, surface);
        }
        LX.dispose(surface);
        return this;
    }

    private LXMidiSurface _addSurface(Class<? extends LXMidiSurface> surfaceClass, LXMidiInput input, LXMidiOutput output, boolean notifyListeners) {
        LXMidiSurface surface = this.instantiateSurface(surfaceClass, input, output);
        if (surface != null) {
            this.mutableSurfaces.add(surface);
            if (notifyListeners) {
                for (DeviceListener listener : this.deviceListeners) {
                    listener.surfaceAdded(this, surface);
                }
            }
        }
        return surface;
    }

    public <T extends LXMidiSurface> T instantiateSurface(Class<T> surfaceClass, LXMidiInput input, LXMidiOutput output) {
        try {
            return (T)((LXMidiSurface)surfaceClass.getConstructor(LX.class, LXMidiInput.class, LXMidiOutput.class).newInstance(this.lx, input, output));
        }
        catch (Exception x) {
            LXMidiEngine.error(x, "Could not instantiate midi surface class: " + String.valueOf(surfaceClass));
            return null;
        }
    }

    public LXMidiSurface addSurface(Class<? extends LXMidiSurface> surfaceClass) {
        return this._addSurface(surfaceClass, null, null, true);
    }

    public void whenReady(Runnable runnable) {
        this.initializationLock.whenReady(runnable);
    }

    public List<LXMidiInput> getInputs() {
        return this.inputs;
    }

    public List<LXMidiOutput> getOutputs() {
        return this.outputs;
    }

    public LXMidiInput matchInput(String name) {
        return this.matchInput(new String[]{name});
    }

    public LXMidiInput matchInput(String[] names) {
        return this.matchDevice(this.mutableInputs, names);
    }

    public LXMidiOutput matchOutput(String name) {
        return this.matchOutput(new String[]{name});
    }

    public LXMidiOutput matchOutput(String[] names) {
        return this.matchDevice(this.mutableOutputs, names);
    }

    public LXMidiSurface findSurface(LXMidiInput input) {
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (surface.getInput() != input) continue;
            return surface;
        }
        return null;
    }

    public LXMidiSurface findSurface(String deviceName) {
        return this.findSurface(deviceName, 0);
    }

    public LXMidiSurface findSurface(String deviceName, int index) {
        int i = 0;
        for (LXMidiSurface surface : this.surfaces) {
            if (!surface.getDeviceName().equals(deviceName)) continue;
            if (i >= index) {
                return surface;
            }
            ++i;
        }
        return null;
    }

    public LXMidiSurface findSurfaceClass(String className, int index) {
        int i = 0;
        for (LXMidiSurface surface : this.surfaces) {
            if (!surface.getClass().getName().equals(className)) continue;
            if (i >= index) {
                return surface;
            }
            ++i;
        }
        return null;
    }

    private <T extends LXMidiDevice> T matchDevice(List<T> devices, String[] names) {
        for (LXMidiDevice device : devices) {
            String deviceName = device.getName();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (deviceName.contains(name)) {
                    return (T)device;
                }
                ++n2;
            }
        }
        return null;
    }

    private LXMidiOutput findOutput(LXMidiInput input) {
        int index = 0;
        String inputName = input.getName();
        for (LXMidiInput that : this.mutableInputs) {
            if (that == input) break;
            if (!that.getName().equals(inputName)) continue;
            ++index;
        }
        return LXMidiEngine.findDevice(this.mutableOutputs, inputName, index);
    }

    public LXMidiOutput findOutput(String name) {
        return LXMidiEngine.findDevice(this.mutableOutputs, name);
    }

    public LXMidiOutput findOutput(MidiDevice device) {
        return this.findDevice(this.mutableOutputs, device);
    }

    public LXMidiInput findInput(String name) {
        return LXMidiEngine.findDevice(this.mutableInputs, name);
    }

    public LXMidiInput findInput(String name, int index) {
        return LXMidiEngine.findDevice(this.mutableInputs, name, index);
    }

    public LXMidiInput findInput(MidiDevice device) {
        return this.findDevice(this.mutableInputs, device);
    }

    private <T extends LXMidiDevice> T findDevice(List<T> devices, MidiDevice device) {
        for (LXMidiDevice that : devices) {
            if (that.device != device) continue;
            return (T)that;
        }
        return null;
    }

    private static <T extends LXMidiDevice> T findDevice(List<T> devices, String name) {
        return LXMidiEngine.findDevice(devices, name, 0);
    }

    private static <T extends LXMidiDevice> T findDevice(List<T> devices, String name, int index) {
        int i = 0;
        for (LXMidiDevice device : devices) {
            if (!device.getName().equals(name)) continue;
            if (i >= index) {
                return (T)device;
            }
            ++i;
        }
        return null;
    }

    public LXMidiEngine addListener(LXMidiListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.LXMidiListener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXMidiEngine removeListener(LXMidiListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXMidiEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXMidiEngine addDeviceListener(DeviceListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.DeviceListener");
        if (this.deviceListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.DeviceListener: " + String.valueOf(listener));
        }
        this.deviceListeners.add(listener);
        return this;
    }

    public LXMidiEngine removeDeviceListener(DeviceListener listener) {
        if (!this.deviceListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXMidiEngine.DeviceListener: " + String.valueOf(listener));
        }
        this.deviceListeners.remove(listener);
        return this;
    }

    public LXMidiEngine addTemplateListener(TemplateListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.TemplateListener");
        if (this.templateListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.TemplateListener: " + String.valueOf(listener));
        }
        this.templateListeners.add(listener);
        return this;
    }

    public LXMidiEngine removeTemplateListener(TemplateListener listener) {
        if (!this.templateListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXMidiEngine.TemplateListener: " + String.valueOf(listener));
        }
        this.templateListeners.remove(listener);
        return this;
    }

    public LXMidiEngine addMappingListener(MappingListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiEngine.MappingListener");
        if (this.mappingListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiEngine.MappingListener: " + String.valueOf(listener));
        }
        this.mappingListeners.add(listener);
        return this;
    }

    public LXMidiEngine removeMappingListener(MappingListener listener) {
        if (!this.mappingListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXMidiEngine.MappingListener: " + String.valueOf(listener));
        }
        this.mappingListeners.remove(listener);
        return this;
    }

    void queueInputMessage(LXMidiMessage message) {
        this.threadSafeInputQueue.add(message);
        this.hasInputMessage.set(true);
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        try {
            String path = parts[index];
            LXShortMessage oscMidiMessage = null;
            if (path.equals(PATH_NOTE)) {
                int pitch = message.getInt();
                int velocity = message.getInt();
                int channel = message.getInt();
                oscMidiMessage = new MidiNoteOn(channel, pitch, velocity);
            } else if (path.equals(PATH_CC)) {
                int value = message.getInt();
                int cc = message.getInt();
                int channel = message.getInt();
                oscMidiMessage = new MidiControlChange(channel, cc, value);
            } else if (parts[index].equals(PATH_PITCHBEND)) {
                int msb = message.getInt();
                int channel = message.getInt();
                oscMidiMessage = new MidiPitchBend(channel, msb).setSource(LXMidiSource.OSC);
            }
            if (oscMidiMessage != null) {
                oscMidiMessage.setSource(LXMidiSource.OSC);
                this.dispatch(oscMidiMessage);
                return true;
            }
        }
        catch (InvalidMidiDataException imdx) {
            LXMidiEngine.error("Invalid MIDI message via OSC: " + String.valueOf(message));
            return false;
        }
        return super.handleOscMessage(message, parts, index);
    }

    private void createMapping(LXShortMessage message) {
        LXNormalizedParameter parameter = this.lx.engine.mapping.getControlTarget();
        if (parameter == null) {
            return;
        }
        if (!LXMidiMapping.isValidMessageType(message)) {
            return;
        }
        for (LXMidiMapping mapping : this.mutableMappings) {
            if (mapping.parameter != parameter || !mapping.matches(message)) continue;
            return;
        }
        this.lx.command.perform(new LXCommand.Midi.AddMapping(message, parameter));
        this.lx.engine.mapping.setControlTarget(null);
    }

    private boolean applyMapping(LXShortMessage message) {
        boolean applied = false;
        for (LXMidiMapping mapping : this.mutableMappings) {
            if (!mapping.matches(message)) continue;
            mapping.apply(this.lx, message);
            applied = true;
        }
        return applied;
    }

    public LXMidiEngine addMapping(LXMidiMapping mapping) {
        this.mutableMappings.add(mapping);
        for (MappingListener mappingListener : this.mappingListeners) {
            mappingListener.mappingAdded(this, mapping);
        }
        return this;
    }

    public LXMidiEngine removeMapping(LXMidiMapping mapping) {
        this.mutableMappings.remove(mapping);
        for (MappingListener mappingListener : this.mappingListeners) {
            mappingListener.mappingRemoved(this, mapping);
        }
        return this;
    }

    private List<LXMidiMapping> findParameterMappings(LXParameter parameter) {
        ArrayList<LXMidiMapping> found = null;
        for (LXMidiMapping mapping : this.mappings) {
            if (parameter != mapping.parameter) continue;
            if (found == null) {
                found = new ArrayList<LXMidiMapping>();
            }
            found.add(mapping);
        }
        return found;
    }

    public List<LXMidiMapping> findMappings(LXComponent component) {
        ArrayList<LXMidiMapping> found = null;
        for (LXMidiMapping mapping : this.mappings) {
            if (!component.contains(mapping.parameter)) continue;
            if (found == null) {
                found = new ArrayList<LXMidiMapping>();
            }
            found.add(mapping);
        }
        return found;
    }

    public LXMidiEngine removeParameterMappings(LXParameter parameter) {
        List<LXMidiMapping> remove = this.findParameterMappings(parameter);
        if (remove != null) {
            for (LXMidiMapping mapping : remove) {
                this.removeMapping(mapping);
            }
        }
        return this;
    }

    public LXMidiEngine removeMappings(LXComponent component) {
        List<LXMidiMapping> remove = this.findMappings(component);
        if (remove != null) {
            for (LXMidiMapping mapping : remove) {
                this.removeMapping(mapping);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        if (this.hasInputMessage.compareAndSet(true, false)) {
            this.engineThreadInputQueue.clear();
            List<LXMidiMessage> list = this.threadSafeInputQueue;
            synchronized (list) {
                this.engineThreadInputQueue.addAll(this.threadSafeInputQueue);
                this.threadSafeInputQueue.clear();
            }
            for (LXMidiMessage message : this.engineThreadInputQueue) {
                LXMidiInput input = message.getInput();
                input.dispatch(message);
                if (!input.enabled.isOn()) continue;
                this._dispatch(message);
            }
        }
    }

    private void _dispatch(LXMidiMessage message) {
        if (message instanceof LXShortMessage) {
            this.dispatch((LXShortMessage)message);
        } else if (message instanceof LXSysexMessage) {
            for (LXMidiListener listener : this.listeners) {
                message.dispatch(listener);
            }
        }
    }

    public void dispatch(LXShortMessage message) {
        LXMidiInput input = message.getInput();
        if (input != null) {
            if (input.controlEnabled.isOn()) {
                if (this.lx.engine.mapping.getMode() == LXMappingEngine.Mode.MIDI) {
                    this.createMapping(message);
                    return;
                }
                if (this.applyMapping(message)) {
                    return;
                }
            }
            if (message instanceof MidiBeat && input.syncEnabled.isOn() && this.lx.engine.tempo.clockSource.getObject() == Tempo.ClockSource.MIDI) {
                MidiBeat beat = (MidiBeat)message;
                if (beat.isStop()) {
                    this.lx.engine.tempo.stop();
                } else {
                    double period = beat.getPeriod();
                    if (period != -1.0) {
                        this.lx.engine.tempo.setPeriod(period);
                    }
                    this.lx.engine.tempo.trigger(beat.getBeat(), beat.nanoTime);
                }
            }
        }
        for (LXMidiListener listener : this.listeners) {
            message.dispatch(listener);
        }
        if (input == null || input.channelEnabled.isOn()) {
            for (LXAbstractChannel channelBus : this.lx.engine.mixer.channels) {
                if (!channelBus.midiSource.matches(message.getSource()) || !channelBus.midiFilter.filter(message)) continue;
                channelBus.midiMessage(message);
            }
            this.lx.engine.modulation.midiDispatch(message);
        }
    }

    public void addTemplate(LXMidiTemplate template) {
        if (this.templates.contains(template)) {
            throw new IllegalStateException("Cannot add template twice: " + String.valueOf(template));
        }
        this.mutableTemplates.add(template);
        for (TemplateListener listener : this.templateListeners) {
            listener.templateAdded(this, template);
        }
    }

    public void removeTemplate(LXMidiTemplate template) {
        if (!this.templates.contains(template)) {
            throw new IllegalStateException("Cannot remove template that does not exist: " + String.valueOf(template));
        }
        this.mutableTemplates.remove(template);
        for (TemplateListener listener : this.templateListeners) {
            listener.templateRemoved(this, template);
        }
        LX.dispose(template);
    }

    public void moveTemplate(LXMidiTemplate template, int index) {
        if (!this.templates.contains(template)) {
            throw new IllegalStateException("Cannot move template that does not exist: " + String.valueOf(template));
        }
        this.mutableTemplates.remove(template);
        this.mutableTemplates.add(index, template);
        for (TemplateListener listener : this.templateListeners) {
            listener.templateMoved(this, template);
        }
    }

    private void removeTemplates() {
        int i = this.templates.size() - 1;
        while (i >= 0) {
            this.removeTemplate(this.templates.get(i));
            --i;
        }
    }

    public void panic() {
        try {
            this.dispatch(new MidiPanic());
            for (LXMidiTemplate template : this.templates) {
                template.midiPanicReceived();
            }
            this.lx.pushStatusMessage("Sent a MIDI panic to all devices");
        }
        catch (InvalidMidiDataException imdx) {
            LX.error(imdx, "Failed to generate MIDI panic");
        }
    }

    public void saveDevices() {
        if (this.inLoadDevices) {
            return;
        }
        JsonArray inputs = new JsonArray();
        for (LXMidiInput input : this.mutableInputs) {
            if (!input.enabled.isOn()) continue;
            inputs.add((JsonElement)LXSerializable.Utils.toObject(this.lx, input));
        }
        for (JsonObject remembered : this.rememberMidiInputs) {
            inputs.add((JsonElement)remembered);
        }
        JsonArray surfaces = new JsonArray();
        for (LXMidiSurface surface : this.mutableSurfaces) {
            if (!surface.enabled.isOn() && !surface.hasRememberFlag()) continue;
            surfaces.add((JsonElement)LXSerializable.Utils.toObject(this.lx, surface, true));
        }
        JsonObject object = new JsonObject();
        object.addProperty("version", "1.1.0");
        object.add(KEY_INPUTS, (JsonElement)inputs);
        object.add(KEY_SURFACES, (JsonElement)surfaces);
        File file = this.lx.getMediaFile(DEVICES_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
                writer.setIndent("  ");
                new GsonBuilder().create().toJson((JsonElement)object, writer);
                LXMidiEngine.log("MIDI devices saved to " + file.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LXMidiEngine.error(iox, "Could not export MIDI device settings to file: " + file.toString());
        }
    }

    private void loadDevices() {
        this.inLoadDevices = true;
        this.rememberMidiInputs.clear();
        JsonObject object = this.loadDevicesFile();
        if (object != null) {
            try {
                this._loadDevices(object);
            }
            catch (Exception x) {
                LXMidiEngine.error(x, "Exception in loadDevices");
            }
        }
        this.inLoadDevices = false;
    }

    private void _loadDevices(JsonObject object) {
        if (object.has(KEY_INPUTS)) {
            HashMap<String, Integer> inputCount = new HashMap<String, Integer>();
            JsonArray inputs = object.getAsJsonArray(KEY_INPUTS);
            for (JsonElement element : inputs) {
                JsonObject inputObj = element.getAsJsonObject();
                String inputName = inputObj.get("name").getAsString();
                int count = inputCount.containsKey(inputName) ? (Integer)inputCount.get(inputName) : 0;
                LXMidiInput input = this.findInput(inputName, count);
                inputCount.put(inputName, ++count);
                if (input != null) {
                    input.load(this.lx, inputObj);
                    continue;
                }
                this.rememberMidiInputs.add(inputObj);
            }
        }
        if (object.has(KEY_SURFACES)) {
            JsonArray surfaces = object.getAsJsonArray(KEY_SURFACES);
            for (JsonElement element : surfaces) {
                JsonObject surfaceObj = element.getAsJsonObject();
                String surfaceClass = surfaceObj.get("class").getAsString();
                try {
                    Class<LXMidiSurface> surfaceClazz = this.lx.registry.getClass(surfaceClass).asSubclass(LXMidiSurface.class);
                    LXMidiSurface surface = this._addSurface(surfaceClazz, null, null, false);
                    if (surface == null) continue;
                    surface.load(this.lx, surfaceObj);
                    if (surface.connected.isOn()) {
                        surface.enabled.setValue(true);
                        continue;
                    }
                    surface.setRememberFlag();
                }
                catch (Exception x) {
                    LXMidiEngine.error(x, "Could not restore surface class type: " + surfaceClass);
                }
            }
        }
    }

    private JsonObject loadDevicesFile() {
        File file = this.lx.getMediaFile(DEVICES_FILE_NAME);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileReader fr = new FileReader(file);){
                    return (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fnfx) {
                LXMidiEngine.error(fnfx, "MIDI device settings file does not exist");
            }
            catch (IOException iox) {
                LXMidiEngine.error(iox, "Failed to load MIDI device settings");
            }
        }
        return null;
    }

    @Override
    public void save(LX lx, JsonObject object) {
        super.save(lx, object);
        object.add(KEY_TEMPLATES, (JsonElement)LXSerializable.Utils.toArray(lx, this.templates));
        object.add(KEY_MAPPINGS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableMappings));
    }

    @Override
    public void load(LX lx, JsonObject object) {
        this.removeMappings();
        this.removeTemplates();
        super.load(lx, object);
        if (object.has(KEY_TEMPLATES)) {
            JsonArray templates = object.getAsJsonArray(KEY_TEMPLATES);
            for (JsonElement templateElem : templates) {
                try {
                    JsonObject templateObj = templateElem.getAsJsonObject();
                    LXMidiTemplate template = this.lx.instantiateComponent(templateObj.get("class").getAsString(), LXMidiTemplate.class);
                    template.load(this.lx, templateObj);
                    this.addTemplate(template);
                }
                catch (LX.InstantiationException ix) {
                    LXMidiEngine.error(ix, "Could not create MidiTemplate");
                }
            }
        }
    }

    public void loadMappings(LX lx, JsonObject obj) {
        if (obj.has(KEY_MAPPINGS)) {
            JsonArray mappings = obj.getAsJsonArray(KEY_MAPPINGS);
            for (JsonElement element : mappings) {
                try {
                    this.addMapping(LXMidiMapping.create(this.lx, element.getAsJsonObject()));
                }
                catch (Exception x) {
                    LXMidiEngine.error(x, "Could not load MIDI mapping: " + element.toString());
                }
            }
        }
    }

    public void removeMappings() {
        int i = this.mappings.size() - 1;
        while (i >= 0) {
            this.removeMapping(this.mappings.get(i));
            --i;
        }
    }

    public void exportMappings(File file) {
        JsonObject obj = new JsonObject();
        obj.add(KEY_MAPPINGS, (JsonElement)LXSerializable.Utils.toArray(this.lx, this.mappings, true));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
                writer.setIndent("  ");
                new GsonBuilder().create().toJson((JsonElement)obj, writer);
                LX.log("Mappings saved successfully to " + file.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Could not export MIDI mappings to file: " + file.toString());
        }
    }

    public List<LXMidiMapping> importMappings(File file) {
        this.removeMappings();
        ArrayList<LXMidiMapping> imported = new ArrayList<LXMidiMapping>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader fr = new FileReader(file);){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                if (obj.has(KEY_MAPPINGS)) {
                    JsonArray mappingArr = obj.get(KEY_MAPPINGS).getAsJsonArray();
                    for (JsonElement mappingElem : mappingArr) {
                        try {
                            LXMidiMapping mapping = LXMidiMapping.create(this.lx, mappingElem.getAsJsonObject());
                            this.addMapping(mapping);
                            imported.add(mapping);
                        }
                        catch (Exception x) {
                            LXMidiEngine.error("Invalid mapping in " + String.valueOf(file) + ": " + String.valueOf(mappingElem));
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Could not import MIDI mappings from file: " + file.toString());
        }
        return imported;
    }

    public static final void log(String message) {
        LX.log(MIDI_LOG_PREFIX + message);
    }

    public static final void error(String message) {
        LX.error(MIDI_LOG_PREFIX + message);
    }

    public static final void error(Exception x, String message) {
        LX.error(x, MIDI_LOG_PREFIX + message);
    }

    public static enum Channel {
        CH_1,
        CH_2,
        CH_3,
        CH_4,
        CH_5,
        CH_6,
        CH_7,
        CH_8,
        CH_9,
        CH_10,
        CH_11,
        CH_12,
        CH_13,
        CH_14,
        CH_15,
        CH_16,
        OMNI;


        public boolean matches(ShortMessage message) {
            switch (this) {
                case OMNI: {
                    return true;
                }
            }
            return message.getChannel() == this.ordinal();
        }

        public int getChannel() {
            switch (this) {
                case OMNI: {
                    return -1;
                }
            }
            return this.ordinal();
        }

        public String toString() {
            switch (this) {
                case OMNI: {
                    return "Omni";
                }
            }
            return "Ch." + (this.ordinal() + 1);
        }
    }

    public static interface DeviceListener {
        default public void inputAdded(LXMidiEngine engine, LXMidiInput input) {
        }

        default public void outputAdded(LXMidiEngine engine, LXMidiOutput output) {
        }

        default public void surfaceAdded(LXMidiEngine engine, LXMidiSurface surface) {
        }

        default public void surfaceRemoved(LXMidiEngine engine, LXMidiSurface surface) {
        }
    }

    private class InitializationLock {
        private final List<Runnable> whenReady = new ArrayList<Runnable>();
        private volatile boolean ready = false;

        private InitializationLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void whenReady(Runnable runnable) {
            boolean runNow = false;
            InitializationLock initializationLock = this;
            synchronized (initializationLock) {
                if (this.ready) {
                    runNow = true;
                } else {
                    this.whenReady.add(runnable);
                }
            }
            if (runNow) {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onReady() {
            InitializationLock initializationLock = this;
            synchronized (initializationLock) {
                this.ready = true;
            }
            this.whenReady.forEach(runnable -> runnable.run());
            this.whenReady.clear();
        }
    }

    public static interface MappingListener {
        public void mappingAdded(LXMidiEngine var1, LXMidiMapping var2);

        public void mappingRemoved(LXMidiEngine var1, LXMidiMapping var2);
    }

    private class MidiDeviceUpdateThread
    extends Thread {
        private boolean polling;
        private boolean skipUpdate;

        private MidiDeviceUpdateThread() {
            super("LXMidiEngine Device Update");
            this.polling = false;
            this.skipUpdate = false;
        }

        private synchronized void setPolling() {
            this.polling = true;
            this.skipUpdate = true;
            this.notify();
        }

        @Override
        public synchronized void run() {
            while (!this.isInterrupted()) {
                try {
                    this.wait(this.polling ? 5000 : 0);
                }
                catch (InterruptedException ix) {
                    break;
                }
                if (!this.skipUpdate) {
                    LXMidiEngine.this.updateMidiDevices(CoreMidiDeviceProvider.getMidiDeviceInfo());
                }
                this.skipUpdate = false;
            }
            LXMidiEngine.log("LXMidiEngine Device Update Thread finished.");
        }
    }

    public static interface TemplateListener {
        public void templateAdded(LXMidiEngine var1, LXMidiTemplate var2);

        public void templateRemoved(LXMidiEngine var1, LXMidiTemplate var2);

        public void templateMoved(LXMidiEngine var1, LXMidiTemplate var2);
    }
}

