/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.midi.LXMidiDevice;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiMessage;
import heronarts.lx.midi.LXMidiSource;
import heronarts.lx.midi.LXSysexMessage;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiBeat;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNoteOff;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import heronarts.lx.midi.MidiSelector;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public class LXMidiInput
extends LXMidiDevice
implements LXMidiSource,
LXSerializable {
    private final List<LXMidiListener> listeners = new ArrayList<LXMidiListener>();
    private boolean isOpen = false;
    private Transmitter transmitter = null;
    private final Receiver receiver = new Receiver();
    public final BooleanParameter channelEnabled = new BooleanParameter("Channel", false).setMappable(false).setDescription("Whether midi events from this input are forwarded to channel and modulator devices");
    public final BooleanParameter controlEnabled = new BooleanParameter("Control", false).setMappable(false).setDescription("Whether midi events from this input are used for control mapping");
    public final BooleanParameter syncEnabled = new BooleanParameter("Sync", false).setMappable(false).setDescription("Whether midi clock signal from this input is used to control tempo");
    private boolean inListener = false;
    private final List<LXMidiListener> addListeners = new ArrayList<LXMidiListener>();
    private final List<LXMidiListener> removeListeners = new ArrayList<LXMidiListener>();
    static final String KEY_NAME = "name";
    private static final String KEY_CHANNEL = "channel";
    private static final String KEY_CONTROL = "control";
    private static final String KEY_SYNC = "sync";

    LXMidiInput(LXMidiEngine engine, MidiDevice device) {
        super(engine, device);
        LXParameterListener enabledListener = p -> {
            if (p == this.channelEnabled) {
                MidiSelector.updateInputs(lXMidiEngine.inputs);
            }
            this.enabled.setValue(this.channelEnabled.isOn() || this.controlEnabled.isOn() || this.syncEnabled.isOn());
            engine.saveDevices();
        };
        this.channelEnabled.addListener(enabledListener);
        this.controlEnabled.addListener(enabledListener);
        this.syncEnabled.addListener(enabledListener);
    }

    @Override
    protected void close() {
        if (this.isOpen) {
            try {
                this.transmitter.close();
            }
            finally {
                this.transmitter = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    protected void onEnabled(boolean enabled) {
        if (enabled && !this.isOpen) {
            try {
                if (!this.device.isOpen()) {
                    this.device.open();
                }
                this.transmitter = this.device.getTransmitter();
                this.transmitter.setReceiver(this.receiver);
                this.isOpen = true;
            }
            catch (MidiUnavailableException mux) {
                LXMidiEngine.error("Could not enable LXMidiInput device " + String.valueOf(this) + ": " + mux.getLocalizedMessage());
                this.enabled.setValue(false);
            }
        }
    }

    public LXMidiInput addListener(LXMidiListener listener) {
        Objects.requireNonNull(listener, "May not add null LXMidiInput.LXMidiListener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXMidiInput.LXMidiListener: " + String.valueOf(listener));
        }
        if (this.inListener) {
            this.addListeners.add(listener);
            return this;
        }
        this.listeners.add(listener);
        return this;
    }

    public LXMidiInput removeListener(LXMidiListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXMidiInput.LXMidiListener: " + String.valueOf(listener));
        }
        if (this.inListener) {
            this.removeListeners.add(listener);
            return this;
        }
        this.listeners.remove(listener);
        return this;
    }

    void dispatch(LXMidiMessage message) {
        this.inListener = true;
        for (LXMidiListener listener2 : this.listeners) {
            message.dispatch(listener2);
        }
        this.inListener = false;
        if (!this.removeListeners.isEmpty()) {
            this.removeListeners.forEach(listener -> {
                LXMidiInput lXMidiInput = this.removeListener((LXMidiListener)listener);
            });
            this.removeListeners.clear();
        }
        if (!this.addListeners.isEmpty()) {
            this.addListeners.forEach(listener -> {
                LXMidiInput lXMidiInput = this.addListener((LXMidiListener)listener);
            });
            this.addListeners.clear();
        }
    }

    @Override
    public void save(LX lx, JsonObject object) {
        object.addProperty(KEY_NAME, this.getName());
        object.addProperty(KEY_CHANNEL, Boolean.valueOf(this.channelEnabled.isOn()));
        object.addProperty(KEY_CONTROL, Boolean.valueOf(this.controlEnabled.isOn()));
        object.addProperty(KEY_SYNC, Boolean.valueOf(this.syncEnabled.isOn()));
    }

    @Override
    public void load(LX lx, JsonObject object) {
        LXSerializable.Utils.loadBoolean(this.channelEnabled, object, KEY_CHANNEL);
        LXSerializable.Utils.loadBoolean(this.controlEnabled, object, KEY_CONTROL);
        LXSerializable.Utils.loadBoolean(this.syncEnabled, object, KEY_SYNC);
    }

    private class Receiver
    implements javax.sound.midi.Receiver {
        private static final int PULSES_PER_QUARTER_NOTE = 24;
        private int beatClock = 0;
        private long lastBeatNanos = -1L;

        private Receiver() {
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void send(MidiMessage midiMessage, long timeStamp) {
            void var5_16;
            if (!(midiMessage instanceof ShortMessage)) {
                if (!(midiMessage instanceof SysexMessage)) return;
                LXSysexMessage message = new LXSysexMessage((SysexMessage)midiMessage);
                message.setSource(LXMidiInput.this);
                LXMidiInput.this.engine.queueInputMessage(message);
                return;
            }
            ShortMessage sm = (ShortMessage)midiMessage;
            Object var5_5 = null;
            switch (sm.getCommand()) {
                case 144: {
                    MidiNoteOn midiNoteOn = new MidiNoteOn(sm);
                    break;
                }
                case 128: {
                    MidiNoteOff midiNoteOff = new MidiNoteOff(sm);
                    break;
                }
                case 176: {
                    MidiControlChange midiControlChange = new MidiControlChange(sm);
                    break;
                }
                case 192: {
                    MidiProgramChange midiProgramChange = new MidiProgramChange(sm);
                    break;
                }
                case 224: {
                    MidiPitchBend midiPitchBend = new MidiPitchBend(sm);
                    break;
                }
                case 208: {
                    MidiAftertouch midiAftertouch = new MidiAftertouch(sm);
                    break;
                }
                case 240: {
                    switch (sm.getStatus()) {
                        case 250: {
                            this.beatClock = 0;
                            this.lastBeatNanos = System.nanoTime();
                            MidiBeat midiBeat = new MidiBeat(sm, 0, this.lastBeatNanos);
                            break;
                        }
                        case 251: {
                            if (this.beatClock % 24 != 0) break;
                            this.lastBeatNanos = System.nanoTime();
                            MidiBeat midiBeat = new MidiBeat(sm, this.beatClock / 24, this.lastBeatNanos);
                            break;
                        }
                        case 252: {
                            MidiBeat midiBeat = new MidiBeat(sm, -1, 0L);
                            this.lastBeatNanos = -1L;
                            break;
                        }
                        case 242: {
                            this.lastBeatNanos = -1L;
                            int sixteenthNotes = sm.getData1() + (sm.getData2() << 7);
                            this.beatClock = sixteenthNotes * 24 / 4;
                            break;
                        }
                        case 248: {
                            ++this.beatClock;
                            if (this.beatClock % 24 != 0) break;
                            long now = System.nanoTime();
                            MidiBeat beat = new MidiBeat(sm, this.beatClock / 24, now);
                            if (this.lastBeatNanos > 0L) {
                                beat.setPeriod((double)(now - this.lastBeatNanos) / 1000000.0);
                            }
                            MidiBeat midiBeat = beat;
                            this.lastBeatNanos = now;
                        }
                    }
                    break;
                }
            }
            if (var5_16 == null) return;
            var5_16.setSource(LXMidiInput.this);
            LXMidiInput.this.engine.queueInputMessage((LXMidiMessage)var5_16);
        }
    }
}

