/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiMessage;
import heronarts.lx.midi.LXMidiSource;
import javax.sound.midi.SysexMessage;

public class LXSysexMessage
extends SysexMessage
implements LXMidiMessage {
    public static final byte START_SYSEX = -16;
    public static final byte END_SYSEX = -9;
    public static final byte REALTIME = 127;
    public static final byte NON_REALTIME = 126;
    public static final byte ANY_DEVICE = 127;
    public static final byte GENERAL_INFORMATION = 6;
    public static final byte IDENTITY_REQUEST = 1;
    public static final byte IDENTITY_REPLY = 2;
    private LXMidiSource source = LXMidiSource.UNKNOWN;

    public static LXSysexMessage newIdentityRequest() {
        return LXSysexMessage.newIdentityRequest((byte)127);
    }

    public static LXSysexMessage newIdentityRequest(byte deviceId) {
        return new LXSysexMessage(new byte[]{-16, 126, deviceId, 6, 1, -9});
    }

    LXSysexMessage(byte[] data) {
        super(data);
    }

    LXSysexMessage(SysexMessage message) {
        this(message.getMessage());
    }

    @Override
    public LXSysexMessage setSource(LXMidiSource source) {
        this.source = source;
        return this;
    }

    @Override
    public LXMidiSource getSource() {
        return this.source;
    }

    @Override
    public final void dispatch(LXMidiListener listener) {
        listener.sysexReceived(this);
    }

    public String toString() {
        return "MidiSysEx:" + LXSysexMessage.bytesToString(this.getMessage());
    }

    private static String bytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X ", b));
            ++n2;
        }
        return sb.toString();
    }
}

