/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.Arrays;

public class MidiFilterParameter
extends AggregateParameter {
    public final BooleanParameter enabled = new BooleanParameter("MIDI Enabled", false).setDescription("Whether MIDI is enabled");
    public final EnumParameter<LXMidiEngine.Channel> channel = new EnumParameter<LXMidiEngine.Channel>("MIDI Channel", LXMidiEngine.Channel.OMNI).setDescription("Determines which MIDI channel is responded to");
    public final DiscreteParameter minNote = new DiscreteParameter("Min Note", 0, 128).setUnits(LXParameter.Units.MIDI_NOTE).setDescription("Minimum MIDI Note Num");
    public final DiscreteParameter noteRange = new DiscreteParameter("Note Range", 128, 0, 129).setDescription("MIDI Note Range");
    public final DiscreteParameter minVelocity = new DiscreteParameter("Min Velocity", 1, 1, 128).setDescription("Minimum MIDI Velocity");
    public final DiscreteParameter velocityRange = new DiscreteParameter("Velocity Range", 127, 0, 128).setDescription("MIDI Velocity Range");
    private final byte[] filteredNoteOnCount = new byte[128];

    public MidiFilterParameter(String label) {
        this(label, false);
    }

    public MidiFilterParameter(String label, boolean enabled) {
        super(label);
        this.enabled.setValue(enabled);
        this.addSubparameter("enabled", this.enabled);
        this.addSubparameter("channel", this.channel);
        this.addSubparameter("minNote", this.minNote);
        this.addSubparameter("noteRange", this.noteRange);
        this.addSubparameter("minVelocity", this.minVelocity);
        this.addSubparameter("velocityRange", this.velocityRange);
    }

    @Override
    public MidiFilterParameter setDescription(String description) {
        return (MidiFilterParameter)super.setDescription(description);
    }

    @Override
    protected void updateSubparameters(double value) {
        long bits = Double.doubleToRawLongBits(value);
        this.enabled.setValue(bits & 1L);
        this.channel.setValue(bits >>> 1 & 0xFFL);
        this.minNote.setValue(bits >>> 8 & 0xFFL);
        this.noteRange.setValue(bits >>> 16 & 0xFFL);
        this.minVelocity.setValue(bits >>> 24 & 0xFFL);
        this.velocityRange.setValue(bits >>> 32 & 0xFFL);
    }

    @Override
    protected void onSubparameterUpdate(LXParameter p) {
        long bits = (this.enabled.isOn() ? 1 : 0) | this.channel.getValuei() << 1 | this.minNote.getValuei() << 8 | this.noteRange.getValuei() << 16 | this.minVelocity.getValuei() << 24 | this.velocityRange.getValuei() << 32;
        this.setValue(Double.longBitsToDouble(bits));
    }

    public MidiFilterParameter resetNoteStack() {
        Arrays.fill(this.filteredNoteOnCount, (byte)0);
        return this;
    }

    public boolean filter(LXShortMessage message) {
        if (message instanceof MidiPanic) {
            return true;
        }
        if (!this.enabled.isOn()) {
            return false;
        }
        if (!this.channel.getEnum().matches(message)) {
            return false;
        }
        if (message instanceof MidiNote) {
            MidiNote note = (MidiNote)message;
            int pitch = note.getPitch();
            int minNote = this.minNote.getValuei();
            int maxNote = minNote + this.noteRange.getValuei();
            if (pitch < minNote || pitch >= maxNote) {
                return false;
            }
            if (note.isNoteOn()) {
                int velocity = note.getVelocity();
                int minVelocity = this.minVelocity.getValuei();
                int maxVelocity = minVelocity + this.velocityRange.getValuei();
                if (velocity < minVelocity || velocity >= maxVelocity) {
                    int n = pitch;
                    this.filteredNoteOnCount[n] = (byte)(this.filteredNoteOnCount[n] + 1);
                    return false;
                }
            } else {
                if (this.filteredNoteOnCount[pitch] > 0) {
                    int n = pitch;
                    this.filteredNoteOnCount[n] = (byte)(this.filteredNoteOnCount[n] - 1);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    public void midiPanic() {
        Arrays.fill(this.filteredNoteOnCount, (byte)0);
    }
}

