/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiNoteOff;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.utils.LXUtils;
import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public abstract class MidiNote
extends LXShortMessage {
    private boolean isMutable = false;
    public static final int NUM_PITCHES = 128;
    public static final int NUM_CHANNELS = 16;
    public static final int MAX_VELOCITY = 127;
    private static final String[] PITCH_STRINGS = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    protected MidiNote(int command, int channel, int pitch, int velocity) throws InvalidMidiDataException {
        super(command, channel, pitch, velocity);
    }

    protected MidiNote(ShortMessage message, int command) {
        super(message, command);
    }

    MidiNote(byte[] data) {
        super(data);
    }

    public static MidiNote constructMutable(int command, int channel, int pitch, int velocity) throws InvalidMidiDataException {
        byte[] data = new byte[]{(byte)(command & 0xF0 | channel & 0xF), (byte)(pitch & 0xFF), (byte)(velocity & 0xFF)};
        MidiNote note = switch (command) {
            case 144 -> new MidiNoteOn(data);
            case 128 -> new MidiNoteOff(data);
            default -> throw new InvalidMidiDataException("MidiNote.constructMutable must take NOTE_ON or NOTE_OFF command");
        };
        note.isMutable = true;
        return note;
    }

    public MidiNote mutableCopy() {
        try {
            return MidiNote.constructMutable(this.getCommand(), this.getChannel(), this.getPitch(), this.getVelocity());
        }
        catch (InvalidMidiDataException imdx) {
            throw new IllegalStateException("MidiNote.mutableCopy can't already hold bad data??? " + String.valueOf(this));
        }
    }

    public static String getPitchString(int pitch) {
        return PITCH_STRINGS[pitch % 12] + Integer.toString(pitch / 12 - 2);
    }

    public String getPitchString() {
        return MidiNote.getPitchString(this.getPitch());
    }

    public int getPitch() {
        return this.getData1();
    }

    public int getVelocity() {
        return this.getData2();
    }

    public double getVelocityNormalized() {
        return (double)this.getVelocity() / 127.0;
    }

    public boolean isNoteOn() {
        return this.getCommand() == 144 && this.getVelocity() > 0;
    }

    public boolean isNoteOff() {
        return !this.isNoteOn();
    }

    public void setChannel(int channel) {
        if (!this.isMutable) {
            throw new IllegalStateException("May not setPitch() on non-mutable MIDI note");
        }
        if (!LXUtils.inRange(channel, 0, 15)) {
            throw new IllegalArgumentException("Channel must fall in range [0-15]");
        }
        this.data[0] = (byte)(this.getCommand() | channel & 0xF);
    }

    public void setPitch(int pitch) {
        if (!this.isMutable) {
            throw new IllegalStateException("May not setPitch() on non-mutable MIDI note");
        }
        if (!LXUtils.inRange(pitch, 0, 127)) {
            throw new IllegalArgumentException("Pitch must fall in range [0-127]");
        }
        this.data[1] = (byte)(pitch & 0xFF);
    }

    public void setVelocity(int velocity) {
        if (!this.isMutable) {
            throw new IllegalStateException("May not setVelocity() on non-mutable MIDI note");
        }
        if (!LXUtils.inRange(velocity, 1, 127)) {
            throw new IllegalArgumentException("Velocity must fall in range [1-127]");
        }
        this.data[2] = (byte)(velocity & 0xFF);
    }

    public static class Stack {
        private int[] notes = new int[128];
        private int noteCount = 0;

        public void onMidiNote(MidiNote note) {
            int pitch = note.getPitch();
            if (note.isNoteOn()) {
                int n = pitch;
                this.notes[n] = this.notes[n] + 1;
                ++this.noteCount;
            } else if (this.notes[pitch] > 0) {
                int n = pitch;
                this.notes[n] = this.notes[n] - 1;
                --this.noteCount;
            }
        }

        public int getNoteCount() {
            return this.noteCount;
        }

        public int getNoteCount(int pitch) {
            return this.notes[pitch];
        }

        public boolean isNoteHeld() {
            return this.noteCount > 0;
        }

        public boolean isNoteHeld(int pitch) {
            return this.notes[pitch] > 0;
        }

        public void reset() {
            Arrays.fill(this.notes, 0);
            this.noteCount = 0;
        }
    }
}

