/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXShortMessage;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class MidiPitchBend
extends LXShortMessage {
    public MidiPitchBend(int channel, int msb) throws InvalidMidiDataException {
        this(channel, 0, msb);
    }

    public MidiPitchBend(int channel, int lsb, int msb) throws InvalidMidiDataException {
        super(224, channel, lsb, msb);
    }

    MidiPitchBend(ShortMessage message) {
        super(message, 224);
    }

    public int getPitchBend() {
        return this.getData1() + (this.getData2() << 7) - 8192;
    }

    public double getNormalized() {
        int pitchBend = this.getPitchBend();
        return pitchBend > 0 ? (double)pitchBend / 8191.0 : (double)pitchBend / 8192.0;
    }

    public String toString() {
        return "MidiPitchBend:" + this.getChannel() + ":Bend:" + this.getPitchBend();
    }
}

