/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi;

import heronarts.lx.midi.LXMidiDestination;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXMidiSource;
import heronarts.lx.midi.LXMidiTerminal;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.StringParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class MidiSelector<T extends LXMidiTerminal>
extends AggregateParameter {
    private static final List<LXMidiSource> SOURCE_CHANNEL_FILTERS = Arrays.asList(LXMidiSource.ALL_INS, LXMidiSource.COMPUTER_KEYBOARD, LXMidiSource.OSC);
    private static final List<MidiSelector<?>> selectors = new ArrayList();
    private static LXMidiSource[] sourceChannel = SOURCE_CHANNEL_FILTERS.toArray(new LXMidiSource[0]);
    private static LXMidiSource[] sourceDevice = new LXMidiSource[]{LXMidiSource.NONE};
    private static LXMidiDestination[] destinationDevice = new LXMidiDestination[]{LXMidiDestination.NONE};
    public final StringParameter name = new StringParameter("Name", null).setDescription("Name of the MIDI device");
    public final DiscreteParameter index = new DiscreteParameter("Index", 0, 128).setDescription("Index of the MIDI device, if there are multiple by the same name");
    public final ObjectParameter<T> terminal;
    private final LXParameterListener terminalListener;
    public boolean missingDevice = false;
    private boolean flagOptionsUpdate = false;
    private boolean flagNameUpdate = false;

    protected static void updateInputs(List<LXMidiInput> inputs) {
        ArrayList<LXMidiSource> deviceList = new ArrayList<LXMidiSource>(1 + inputs.size());
        deviceList.add(LXMidiSource.NONE);
        deviceList.addAll(inputs);
        sourceDevice = deviceList.toArray(new LXMidiSource[0]);
        ArrayList<LXMidiSource> filterList = new ArrayList<LXMidiSource>(SOURCE_CHANNEL_FILTERS.size() + inputs.size());
        filterList.addAll(SOURCE_CHANNEL_FILTERS);
        for (LXMidiInput lXMidiInput : inputs) {
            if (!lXMidiInput.channelEnabled.isOn()) continue;
            filterList.add(lXMidiInput);
        }
        sourceChannel = filterList.toArray(new LXMidiSource[0]);
        for (MidiSelector midiSelector : selectors) {
            if (!(midiSelector instanceof Source)) continue;
            midiSelector.update();
        }
    }

    protected static void updateOutputs(List<LXMidiOutput> outputs) {
        ArrayList<LXMidiDestination> deviceList = new ArrayList<LXMidiDestination>(1 + outputs.size());
        deviceList.add(LXMidiDestination.NONE);
        deviceList.addAll(outputs);
        destinationDevice = deviceList.toArray(new LXMidiDestination[0]);
        for (MidiSelector<?> selector : selectors) {
            if (!(selector instanceof Destination)) continue;
            selector.update();
        }
    }

    protected MidiSelector(String label) {
        super(label);
        this.setDescription("Receive MIDI messages from the given source");
        this.addSubparameter("index", this.index);
        this.addSubparameter("name", this.name);
        String midiLabel = this.getMidiLabel();
        this.terminal = new ObjectParameter<LXMidiTerminal>(midiLabel, this.getMidiTerminals()).setDescription("MIDI " + midiLabel);
        this.terminalListener = this::onTerminalChanged;
        this.terminal.addListener(this.terminalListener);
        selectors.add(this);
    }

    protected abstract String getMidiLabel();

    protected abstract T[] getMidiTerminals();

    void update() {
        if (this.flagOptionsUpdate) {
            throw new IllegalStateException("Re-entrancy disallowed in LXMidiSource.Selector.updateOptions()");
        }
        this.flagOptionsUpdate = true;
        LXMidiTerminal previousTerminal = (LXMidiTerminal)this.terminal.getObject();
        LXMidiTerminal[] availableTerminals = this.getMidiTerminals();
        this.terminal.setObjects(availableTerminals);
        if (this.missingDevice) {
            this.findMissingDevice();
        } else {
            boolean missing = true;
            LXMidiTerminal[] lXMidiTerminalArray = availableTerminals;
            int n = availableTerminals.length;
            int n2 = 0;
            while (n2 < n) {
                LXMidiTerminal source = lXMidiTerminalArray[n2];
                if (source == previousTerminal) {
                    missing = false;
                    this.terminal.setValue(source);
                    this.updateNameAndIndex(source);
                    break;
                }
                ++n2;
            }
            this.missingDevice = missing;
            this.bang();
        }
        this.flagOptionsUpdate = false;
    }

    private void updateNameAndIndex(T terminal) {
        if (this.flagNameUpdate) {
            throw new IllegalStateException("Re-entrancy disallowed in MidiSelector.updateNameAndIndex()");
        }
        this.flagNameUpdate = true;
        if (terminal.getMidiDevice() == null) {
            this.index.setValue(0.0);
            this.name.setValue(null);
        } else {
            String name = terminal.getName();
            int index = 0;
            LXMidiTerminal[] lXMidiTerminalArray = (LXMidiTerminal[])this.terminal.getObjects();
            int n = lXMidiTerminalArray.length;
            int n2 = 0;
            while (n2 < n) {
                LXMidiTerminal search = lXMidiTerminalArray[n2];
                if (terminal == search) break;
                if (name.equals(search.getName())) {
                    ++index;
                }
                ++n2;
            }
            this.index.setValue(index);
            this.name.setValue(name);
        }
        this.flagNameUpdate = false;
    }

    private void findMissingDevice() {
        String name = this.name.getString();
        if (name == null) {
            this.missingDevice = false;
            return;
        }
        int index = this.index.getValuei();
        int instance = 0;
        LXMidiTerminal[] lXMidiTerminalArray = (LXMidiTerminal[])this.terminal.getObjects();
        int n = lXMidiTerminalArray.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiTerminal source = lXMidiTerminalArray[n2];
            if (name.equals(source.getName())) {
                if (instance == index) {
                    this.missingDevice = false;
                    this.terminal.setValue(source);
                    this.bang();
                    return;
                }
                ++instance;
            }
            ++n2;
        }
        this.missingDevice = true;
        this.bang();
    }

    private void onTerminalChanged(LXParameter p) {
        if (this.flagOptionsUpdate) {
            return;
        }
        this.missingDevice = false;
        this.updateNameAndIndex((LXMidiTerminal)this.terminal.getObject());
        this.bang();
    }

    @Override
    protected void updateSubparameters(double value) {
    }

    @Override
    protected void onSubparameterUpdate(LXParameter p) {
        if (p == this.name && !this.flagNameUpdate) {
            this.findMissingDevice();
        }
    }

    @Override
    public void dispose() {
        this.terminal.removeListener(this.terminalListener);
        selectors.remove(this);
        super.dispose();
    }

    public static abstract class Destination
    extends MidiSelector<LXMidiDestination> {
        protected Destination(String label) {
            super(label);
        }

        public Destination setOutput(LXMidiOutput output) {
            this.terminal.setValue(output == null ? LXMidiDestination.NONE : output);
            return this;
        }

        public LXMidiOutput getOutput() {
            if (this.missingDevice) {
                return null;
            }
            return (LXMidiOutput)((LXMidiDestination)this.terminal.getObject()).getMidiDevice();
        }

        @Override
        protected String getMidiLabel() {
            return "Destination";
        }

        public static class Device
        extends Destination {
            public Device(String label) {
                super(label);
            }

            protected LXMidiDestination[] getMidiTerminals() {
                return destinationDevice;
            }
        }
    }

    public static abstract class Source
    extends MidiSelector<LXMidiSource> {
        protected Source(String label) {
            super(label);
        }

        public Source setInput(LXMidiInput input) {
            this.terminal.setValue(input == null ? LXMidiSource.NONE : input);
            return this;
        }

        public LXMidiInput getInput() {
            if (this.missingDevice) {
                return null;
            }
            return (LXMidiInput)((LXMidiSource)this.terminal.getObject()).getMidiDevice();
        }

        public boolean matches(LXMidiSource that) {
            if (this.missingDevice) {
                return false;
            }
            return ((LXMidiSource)this.terminal.getObject()).matches(that);
        }

        @Override
        protected String getMidiLabel() {
            return "Source";
        }

        public static class Channel
        extends Source {
            public Channel(String label) {
                super(label);
            }

            protected LXMidiSource[] getMidiTerminals() {
                return sourceChannel;
            }
        }

        public static class Device
        extends Source {
            public Device(String label) {
                super(label);
            }

            protected LXMidiSource[] getMidiTerminals() {
                return sourceDevice;
            }
        }
    }
}

