/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEngine;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.FocusedChannel;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiParameterControl;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.midi.surface.MixerSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@LXMidiSurface.Name(value="Akai APC40")
@LXMidiSurface.DeviceName(value="Akai APC40")
public class APC40
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final byte GENERIC_MODE = 64;
    public static final byte ABLETON_MODE = 65;
    public static final byte ABLETON_ALTERNATE_MODE = 66;
    protected static final int LED_STYLE_OFF = 0;
    protected static final int LED_STYLE_SINGLE = 1;
    protected static final int LED_STYLE_UNIPOLAR = 2;
    protected static final int LED_STYLE_BIPOLAR = 3;
    public static final int NUM_CHANNELS = 8;
    public static final int CHANNEL_FADER = 7;
    public static final int MASTER_FADER = 14;
    public static final int CROSSFADER = 15;
    public static final int CUE_LEVEL = 47;
    public static final int DEVICE_KNOB = 16;
    public static final int DEVICE_KNOB_NUM = 8;
    public static final int DEVICE_KNOB_MAX = 24;
    public static final int DEVICE_KNOB_STYLE = 24;
    public static final int DEVICE_KNOB_STYLE_MAX = 32;
    public static final int TRACK_KNOB = 48;
    public static final int TRACK_KNOB_NUM = 8;
    public static final int TRACK_KNOB_MAX = 55;
    public static final int TRACK_KNOB_STYLE = 56;
    public static final int TRACK_KNOB_STYLE_MAX = 64;
    public static final int CLIP_LAUNCH = 53;
    public static final int CLIP_LAUNCH_ROWS = 5;
    public static final int CLIP_LAUNCH_MAX = 57;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int CHANNEL_ARM = 48;
    public static final int CHANNEL_SOLO = 49;
    public static final int CHANNEL_ACTIVE = 50;
    public static final int CHANNEL_FOCUS = 51;
    public static final int CLIP_STOP = 52;
    public static final int CHANNEL_CROSSFADE_GROUP = 66;
    public static final int MASTER_FOCUS = 80;
    public static final int STOP_ALL_CLIPS = 81;
    public static final int SCENE_LAUNCH = 82;
    public static final int SCENE_LAUNCH_NUM = 5;
    public static final int SCENE_LAUNCH_MAX = 86;
    public static final int PAN = 87;
    public static final int SEND_A = 88;
    public static final int SEND_B = 89;
    public static final int SEND_C = 90;
    public static final int PLAY = 91;
    public static final int STOP = 92;
    public static final int RECORD = 93;
    public static final int BANK_SELECT_UP = 94;
    public static final int BANK_SELECT_DOWN = 95;
    public static final int BANK_SELECT_RIGHT = 96;
    public static final int BANK_SELECT_LEFT = 97;
    public static final int SHIFT = 98;
    public static final int TAP_TEMPO = 99;
    public static final int NUDGE_PLUS = 100;
    public static final int NUDGE_MINUS = 101;
    public static final int CLIP_TRACK = 58;
    public static final int DEVICE_ON_OFF = 59;
    public static final int DEVICE_LEFT = 60;
    public static final int DEVICE_RIGHT = 61;
    public static final int DETAIL_VIEW = 62;
    public static final int REC_QUANTIZE = 63;
    public static final int MIDI_OVERDUB = 64;
    public static final int METRONOME = 65;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_BLINK = 2;
    public static final int LED_GREEN = 1;
    public static final int LED_GREEN_BLINK = 2;
    public static final int LED_RED = 3;
    public static final int LED_RED_BLINK = 4;
    public static final int LED_YELLOW = 5;
    public static final int LED_YELLOW_BLINK = 6;
    private GridMode gridMode = this._getGridMode();
    private boolean shiftOn = false;
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener = new DeviceListener();
    protected final MixerSurface mixerSurface;
    private final MixerSurface.Listener mixerSurfaceListener = new MixerSurface.Listener(){

        @Override
        public void onChannelChanged(int index, LXAbstractChannel channel, LXAbstractChannel previousChannel) {
            if (previousChannel != null && !APC40.this.mixerSurface.contains(previousChannel)) {
                APC40.this.unregisterChannel(previousChannel);
            }
            if (channel != null) {
                APC40.this.registerChannel(channel);
                APC40.this.channelFaders[index].setTarget(channel.fader);
            } else {
                APC40.this.channelFaders[index].setTarget(null);
            }
            APC40.this.sendChannel(index, channel);
            APC40.this.sendChannelFocus();
        }

        @Override
        public void onGridOffsetChanged() {
            APC40.this.sendChannels();
            APC40.this.sendChannelFocus();
        }
    };
    private final FocusedChannel focusedChannel;
    public final BooleanParameter masterFaderEnabled = new BooleanParameter("Master Fader", true).setDescription("Whether the master fader is enabled");
    public final BooleanParameter crossfaderEnabled = new BooleanParameter("Crossfader", true).setDescription("Whether the A/B crossfader is enabled");
    public final BooleanParameter clipLaunchEnabled = new BooleanParameter("Clip Launch", true).setDescription("Whether the clip launch buttons are enabled");
    public final EnumParameter<LXMidiParameterControl.Mode> faderMode = new EnumParameter<LXMidiParameterControl.Mode>("Fader Mode", LXMidiParameterControl.Mode.SCALE).setDescription("Parameter control mode for faders");
    private final LXMidiParameterControl masterFader;
    private final LXMidiParameterControl crossfader;
    private final LXMidiParameterControl[] channelFaders;
    private final LXMixerEngine.Listener mixerEngineListener = new LXMixerEngine.Listener(){

        @Override
        public void channelRemoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.unregisterChannel(channel);
            APC40.this.sendChannels();
        }

        @Override
        public void channelMoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.sendChannels();
        }

        @Override
        public void channelAdded(LXMixerEngine mixer, LXAbstractChannel channel) {
            APC40.this.sendChannels();
            APC40.this.registerChannel(channel);
        }
    };
    private final LXParameterListener cueAListener = p -> this.sendNoteOn(0, 62, APC40.LED_ON(this.lx.engine.mixer.cueA.isOn()));
    private final LXParameterListener cueBListener = p -> this.sendNoteOn(0, 63, APC40.LED_ON(this.lx.engine.mixer.cueB.isOn()));
    private final LXParameterListener tempoListener = p -> this.sendNoteOn(0, 65, APC40.LED_ON(this.lx.engine.tempo.enabled.isOn()));
    private final LXParameterListener clipGridModeListener = p -> this.updateGridMode();
    private final LXParameterListener clipGridListener = p -> this.sendChannelGrid();
    private final LXParameterListener focusedChannelListener = p -> this.sendChannelFocus();
    private boolean isRegistered = false;

    private static int LED_ON(boolean condition) {
        return condition ? 1 : 0;
    }

    private GridMode _getGridMode() {
        return switch (this.lx.engine.clips.gridMode.getEnum()) {
            case LXClipEngine.GridMode.PATTERNS -> GridMode.PATTERN;
            case LXClipEngine.GridMode.CLIPS -> GridMode.CLIP;
            default -> throw new MatchException(null, null);
        };
    }

    private void updateGridMode() {
        GridMode gridMode = this._getGridMode();
        if (this.gridMode != gridMode) {
            this.gridMode = gridMode;
            this.mixerSurface.setGridMode(gridMode.engineGridMode);
            this.lx.engine.clips.gridMode.setValue((Object)gridMode.engineGridMode);
            this.sendGridMode();
            this.sendChannelGrid();
            this.sendChannelFocus();
        }
    }

    public APC40(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.masterFader = new LXMidiParameterControl(this.lx.engine.mixer.masterBus.fader);
        this.crossfader = new LXMidiParameterControl(this.lx.engine.mixer.crossfader);
        this.channelFaders = new LXMidiParameterControl[8];
        int i = 0;
        while (i < 8) {
            this.channelFaders[i] = new LXMidiParameterControl();
            ++i;
        }
        this.updateFaderMode();
        this.mixerSurface = new MixerSurface(lx, this.mixerSurfaceListener, 8, 5).setGridMode(this.gridMode.engineGridMode);
        this.focusedChannel = new FocusedChannel(lx, bus -> this.sendChannelFocus());
        this.addSetting("masterFaderEnabled", this.masterFaderEnabled);
        this.addSetting("crossfaderEnabled", this.crossfaderEnabled);
        this.addSetting("clipLaunchEnabled", this.clipLaunchEnabled);
        this.addSetting("faderMode", this.faderMode);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.faderMode) {
            this.updateFaderMode();
        }
        if (p == this.clipLaunchEnabled) {
            if (this.clipLaunchEnabled.isOn()) {
                this.sendChannels();
            } else {
                this.clearClipLaunch();
            }
        }
    }

    private void updateFaderMode() {
        LXMidiParameterControl.Mode mode = this.faderMode.getEnum();
        this.masterFader.setMode(mode);
        this.crossfader.setMode(mode);
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl channelFader = lXMidiParameterControlArray[n2];
            channelFader.setMode(mode);
            ++n2;
        }
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.setApcMode((byte)66);
            this.initialize(false);
            this.register();
        } else {
            this.deviceListener.registerDevice(null);
            if (this.isRegistered) {
                this.unregister();
            }
            this.setApcMode((byte)64);
        }
    }

    @Override
    protected void onReconnect() {
        this.setApcMode((byte)66);
        this.initialize(true);
        this.deviceListener.resend();
    }

    private void setApcMode(byte mode) {
        byte[] byArray = new byte[12];
        byArray[0] = -16;
        byArray[1] = 71;
        byArray[3] = 115;
        byArray[4] = 96;
        byArray[6] = 4;
        byArray[7] = mode;
        byArray[8] = 9;
        byArray[9] = 3;
        byArray[10] = 1;
        byArray[11] = -9;
        this.sendSysex(byArray);
    }

    private void initialize(boolean reconnect) {
        int i = 0;
        while (i < 8) {
            this.sendControlChange(0, 24 + i, 0);
            ++i;
        }
        i = 0;
        while (i < 8) {
            this.sendControlChange(0, 56 + i, 1);
            if (!reconnect) {
                this.sendControlChange(0, 48 + i, 64);
            }
            ++i;
        }
        this.sendChannels();
    }

    private void sendChannels() {
        int i = 0;
        while (i < 8) {
            this.sendChannel(i, this.getChannel(i));
            ++i;
        }
        this.sendChannelFocus();
    }

    private void sendChannelGrid() {
        int i = 0;
        while (i < 8) {
            LXAbstractChannel channel = this.getChannel(i);
            this.sendChannelPatterns(i, channel);
            this.sendChannelClips(i, channel);
            ++i;
        }
    }

    private void clearChannelGrid() {
        int i = 0;
        while (i < 8) {
            this.sendChannel(i, null);
            ++i;
        }
    }

    private void clearClipLaunch() {
        int i = 0;
        while (i < 8) {
            int j = 53;
            while (j <= 57) {
                this.sendNoteOn(i, j, 0);
                ++j;
            }
            this.sendNoteOn(i, 52, 0);
            ++i;
        }
        int j = 82;
        while (j < 86) {
            this.sendNoteOn(0, j, 0);
            ++j;
        }
    }

    private void sendChannel(int index, LXAbstractChannel channel) {
        if (channel != null) {
            this.sendNoteOn(index, 50, APC40.LED_ON(channel.enabled.isOn()));
            this.sendNoteOn(index, 66, channel.crossfadeGroup.getValuei());
            this.sendNoteOn(index, 49, APC40.LED_ON(channel.cueActive.isOn()));
            this.sendNoteOn(index, 48, APC40.LED_ON(channel.arm.isOn()));
        } else {
            this.sendNoteOn(index, 50, 0);
            this.sendNoteOn(index, 66, 0);
            this.sendNoteOn(index, 49, 0);
            this.sendNoteOn(index, 48, 0);
        }
        this.sendChannelPatterns(index, channel);
        this.sendChannelClips(index, channel);
    }

    private void sendChannelPatterns(int index, LXAbstractChannel bus) {
        if (!this.clipLaunchEnabled.isOn()) {
            return;
        }
        if (index >= 8 || this.gridMode != GridMode.PATTERN) {
            return;
        }
        if (bus instanceof LXChannel) {
            LXChannel channel = (LXChannel)bus;
            boolean isPlaylist = channel.isPlaylist();
            int baseIndex = this.mixerSurface.getGridPatternOffset();
            int endIndex = channel.patterns.size() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            int focusedIndex = channel.patterns.size() == 0 ? -1 : channel.focusedPattern.getValuei() - baseIndex;
            int y = 0;
            while (y < 5) {
                int pitch = 53 + y;
                int color = 0;
                if (isPlaylist) {
                    boolean isPending;
                    boolean bl = isPending = y < endIndex && channel.patterns.get((int)(baseIndex + y)).launch.pending.isOn();
                    if (y == activeIndex) {
                        color = 1;
                    } else if (y == nextIndex) {
                        color = 4;
                    } else if (isPending) {
                        color = 2;
                    } else if (y == focusedIndex) {
                        color = 6;
                    } else if (y < endIndex) {
                        color = 5;
                    }
                } else if (y < endIndex) {
                    color = channel.patterns.get((int)(baseIndex + y)).enabled.isOn() ? 1 : (y == focusedIndex ? 4 : 3);
                }
                this.sendNoteOn(index, pitch, color);
                ++y;
            }
        } else {
            int y = 0;
            while (y < 5) {
                this.sendNoteOn(index, 53 + y, 0);
                ++y;
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        if (!this.clipLaunchEnabled.isOn()) {
            return;
        }
        if (index >= 8 || this.gridMode != GridMode.CLIP) {
            return;
        }
        int i = 0;
        while (i < 5) {
            LXClip clip = null;
            if (channel != null) {
                clip = channel.getClip(i + this.mixerSurface.getGridClipOffset());
            }
            this.sendClip(index, channel, i, clip);
            ++i;
        }
    }

    private int getChannelClipStop(LXAbstractChannel channel) {
        return channel.stopClips.pending.isOn() ? 2 : APC40.LED_ON(channel.hasRunningClip.isOn());
    }

    private void sendChannelClipStop(int index, LXAbstractChannel channel) {
        this.sendNoteOn(index, 52, this.getChannelClipStop(channel));
    }

    private void sendClip(int channelIndex, LXAbstractChannel channel, int clipIndex, LXClip clip) {
        if (this.gridMode != GridMode.CLIP || !LXUtils.inRange(channelIndex, 0, 7) || !LXUtils.inRange(channelIndex, 0, 4)) {
            return;
        }
        int pitch = 53 + clipIndex;
        int color = 0;
        if (channel != null && clip != null) {
            color = 5;
            if (clip.isPending()) {
                color = channel.arm.isOn() ? 4 : 2;
            } else if (clip.isRunning()) {
                color = channel.arm.isOn() ? 3 : 1;
            }
        }
        this.sendNoteOn(channelIndex, pitch, color);
    }

    private void sendChannelFocus() {
        int focusedChannel = this.lx.engine.mixer.focusedChannel.getValuei();
        boolean masterFocused = focusedChannel == this.lx.engine.mixer.channels.size();
        int i = 0;
        while (i < 8) {
            this.sendNoteOn(i, 51, APC40.LED_ON(!masterFocused && i == focusedChannel));
            ++i;
        }
        this.sendNoteOn(0, 80, APC40.LED_ON(masterFocused));
    }

    private void register() {
        this.isRegistered = true;
        this.deviceListener.focusedDevice.register();
        this.mixerSurface.register();
        this.focusedChannel.register();
        this.lx.engine.mixer.addListener(this.mixerEngineListener);
        this.lx.engine.clips.numScenes.addListener(this.clipGridListener);
        this.lx.engine.clips.gridMode.addListener(this.clipGridModeListener);
        this.lx.engine.mixer.focusedChannel.addListener(this.focusedChannelListener);
        this.lx.engine.mixer.cueA.addListener(this.cueAListener, true);
        this.lx.engine.mixer.cueB.addListener(this.cueBListener, true);
        this.lx.engine.tempo.enabled.addListener(this.tempoListener, true);
        this.sendGridMode();
    }

    private void unregister() {
        this.isRegistered = false;
        this.deviceListener.focusedDevice.unregister();
        this.mixerSurface.unregister();
        this.focusedChannel.unregister();
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            this.unregisterChannel(channel);
        }
        this.lx.engine.mixer.removeListener(this.mixerEngineListener);
        this.lx.engine.mixer.focusedChannel.removeListener(this.focusedChannelListener);
        this.lx.engine.clips.numScenes.removeListener(this.clipGridListener);
        this.lx.engine.clips.gridMode.removeListener(this.clipGridModeListener);
        this.lx.engine.mixer.cueA.removeListener(this.cueAListener);
        this.lx.engine.mixer.cueB.removeListener(this.cueBListener);
        this.lx.engine.tempo.enabled.removeListener(this.tempoListener);
        this.clearChannelGrid();
    }

    private void registerChannel(LXAbstractChannel channel) {
        if (!this.channelListeners.containsKey(channel)) {
            this.channelListeners.put(channel, new ChannelListener(channel));
        }
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        return this.mixerSurface.getChannel(index);
    }

    private LXAbstractChannel getChannel(LXShortMessage message) {
        return this.getChannel(message.getChannel());
    }

    private void noteReceived(MidiNote note, boolean on) {
        LXAbstractChannel channel;
        int pitch = note.getPitch();
        switch (pitch) {
            case 98: {
                this.shiftOn = on;
                return;
            }
            case 65: {
                if (on) {
                    this.lx.engine.tempo.enabled.toggle();
                }
                return;
            }
            case 99: {
                this.lx.engine.tempo.tap.setValue(on);
                return;
            }
            case 101: {
                this.lx.engine.tempo.nudgeDown.setValue(on);
                return;
            }
            case 100: {
                this.lx.engine.tempo.nudgeUp.setValue(on);
                return;
            }
        }
        switch (pitch) {
            case 52: 
            case 60: 
            case 61: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                this.sendNoteOn(note.getChannel(), pitch, APC40.LED_ON(on));
            }
        }
        if (pitch >= 82 && pitch <= 86) {
            this.sendNoteOn(note.getChannel(), pitch, APC40.LED_ON(on));
        }
        if (!this.clipLaunchEnabled.isOn() && pitch >= 53 && pitch <= 57) {
            this.sendNoteOn(note.getChannel(), pitch, APC40.LED_ON(on));
        }
        if (on) {
            switch (pitch) {
                case 80: {
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                    this.lx.engine.mixer.focusedChannel.setValue(this.lx.engine.mixer.channels.size());
                    return;
                }
                case 97: {
                    if (this.shiftOn) {
                        this.deviceListener.focusedDevice.previousChannel();
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    } else {
                        this.mixerSurface.decrementChannel();
                    }
                    return;
                }
                case 96: {
                    if (this.shiftOn) {
                        this.deviceListener.focusedDevice.nextChannel();
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    } else {
                        this.mixerSurface.incrementChannel();
                    }
                    return;
                }
                case 94: {
                    if (this.shiftOn) {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.decrement(1, false);
                        }
                    } else {
                        this.mixerSurface.decrementGridOffset();
                    }
                    return;
                }
                case 95: {
                    if (this.shiftOn) {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.increment(1, false);
                        }
                    } else {
                        this.mixerSurface.incrementGridOffset();
                    }
                    return;
                }
                case 62: {
                    this.lx.engine.mixer.cueA.toggle();
                    return;
                }
                case 63: {
                    this.lx.engine.mixer.cueB.toggle();
                    return;
                }
                case 81: {
                    if (this.clipLaunchEnabled.isOn()) {
                        if (this.gridMode == GridMode.CLIP) {
                            this.lx.engine.clips.stopClips.trigger();
                        } else if (this.gridMode == GridMode.PATTERN) {
                            this.lx.engine.clips.launchPatternCycle.trigger();
                        }
                    }
                    return;
                }
            }
            if (pitch >= 82 && pitch <= 86) {
                if (this.clipLaunchEnabled.isOn()) {
                    int index = pitch - 82;
                    if (this.gridMode == GridMode.PATTERN) {
                        this.lx.engine.clips.launchPatternScene(index + this.mixerSurface.getGridPatternOffset());
                    } else if (this.gridMode == GridMode.CLIP) {
                        this.lx.engine.clips.launchScene(index + this.mixerSurface.getGridClipOffset());
                    }
                }
                return;
            }
            if (pitch >= 53 && pitch <= 57) {
                if (!this.clipLaunchEnabled.isOn()) {
                    return;
                }
                int channelIndex = note.getChannel();
                int index = pitch - 53;
                LXAbstractChannel channel2 = this.getChannel(channelIndex);
                if (channel2 != null) {
                    if (this.gridMode == GridMode.PATTERN) {
                        if (channel2 instanceof LXChannel) {
                            LXChannel c = (LXChannel)channel2;
                            int patternIndex = index + this.mixerSurface.getGridPatternOffset();
                            if (patternIndex < c.patterns.size()) {
                                c.focusedPattern.setValue(patternIndex);
                                if (!this.shiftOn) {
                                    if (c.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                                        c.getPattern((int)patternIndex).enabled.toggle();
                                    } else {
                                        c.getPattern((int)patternIndex).launch.trigger();
                                    }
                                }
                            }
                        }
                    } else if (this.gridMode == GridMode.CLIP) {
                        int clipIndex = index + this.mixerSurface.getGridClipOffset();
                        LXClip clip = channel2.getClip(clipIndex);
                        if (clip == null) {
                            clip = channel2.addClip(clipIndex, this.lx.engine.clips.clipSnapshotDefault.isOn() ^ this.shiftOn);
                        } else if (this.shiftOn) {
                            clip.loop.toggle();
                        } else {
                            clip.triggerAction(true);
                        }
                    }
                }
                return;
            }
        }
        if ((channel = this.getChannel(note)) == null) {
            return;
        }
        if (!on) {
            return;
        }
        switch (note.getPitch()) {
            case 48: {
                channel.arm.toggle();
                return;
            }
            case 50: {
                channel.enabled.toggle();
                return;
            }
            case 49: {
                channel.cueActive.toggle();
                return;
            }
            case 66: {
                if (this.shiftOn) {
                    channel.blendMode.increment();
                } else {
                    channel.crossfadeGroup.increment();
                }
                return;
            }
            case 52: {
                channel.stopClips.trigger();
                return;
            }
            case 51: {
                if (this.shiftOn) {
                    if (channel instanceof LXChannel) {
                        ((LXChannel)channel).autoCycleEnabled.toggle();
                    }
                } else {
                    this.lx.engine.mixer.focusedChannel.setValue(channel.getIndex());
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                }
                return;
            }
            case 58: {
                this.toggleGridMode();
                return;
            }
            case 59: {
                this.deviceListener.onDeviceOnOff();
                return;
            }
            case 60: {
                this.deviceListener.focusedDevice.previousDevice();
                return;
            }
            case 61: {
                this.deviceListener.focusedDevice.nextDevice();
                return;
            }
            case 91: {
                LXChannel patternChannel;
                LXPattern focusedPattern;
                LXBus focusedChannel = this.lx.engine.mixer.getFocusedChannel();
                if (focusedChannel instanceof LXChannel && (focusedPattern = (patternChannel = (LXChannel)focusedChannel).getFocusedPattern()) != null && patternChannel.isPlaylist()) {
                    patternChannel.goPattern(focusedPattern);
                }
                return;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: {
                return;
            }
        }
        LXMidiEngine.error("APC40 received unmapped note: " + String.valueOf(note));
    }

    private void toggleGridMode() {
        this.gridMode = this.gridMode == GridMode.PATTERN ? GridMode.CLIP : GridMode.PATTERN;
        this.mixerSurface.setGridMode(this.gridMode.engineGridMode);
        this.lx.engine.clips.gridMode.setValue((Object)this.gridMode.engineGridMode);
        this.sendChannelGrid();
        this.sendGridMode();
    }

    private void sendGridMode() {
        this.sendNoteOn(0, 58, APC40.LED_ON(this.gridMode == GridMode.CLIP));
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 47: {
                if (this.shiftOn) {
                    this.lx.engine.palette.color.primary.saturation.incrementValue(cc.getRelative());
                } else {
                    this.lx.engine.palette.color.primary.hue.incrementValue(cc.getRelative(), true);
                }
                return;
            }
            case 7: {
                int fader = cc.getChannel();
                if (this.channelFaders[fader] != null) {
                    this.channelFaders[fader].setValue(cc);
                }
                return;
            }
            case 14: {
                if (this.masterFaderEnabled.isOn()) {
                    this.masterFader.setValue(cc);
                }
                return;
            }
            case 15: {
                if (this.crossfaderEnabled.isOn()) {
                    this.crossfader.setValue(cc);
                }
                return;
            }
        }
        if (number >= 16 && number <= 24) {
            this.deviceListener.onKnob(number - 16, cc.getNormalized());
            return;
        }
        if (number >= 48 && number <= 55) {
            this.sendControlChange(cc.getChannel(), cc.getCC(), cc.getValue());
            return;
        }
        LXMidiEngine.error("APC40 unmapped CC: " + String.valueOf(cc));
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        if (this.enabled.isOn()) {
            this.setApcMode((byte)64);
        }
        this.masterFader.dispose();
        this.crossfader.dispose();
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl fader = lXMidiParameterControlArray[n2];
            fader.dispose();
            ++n2;
        }
        this.deviceListener.dispose();
        this.mixerSurface.dispose();
        super.dispose();
    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final Map<LXPattern, PatternListener> patternListeners = new HashMap<LXPattern, PatternListener>();
        private final LXAbstractChannel channel;
        private final LXParameterListener onCompositeModeChanged = this::onCompositeModeChanged;
        private final Map<LXClip, ClipListener> clipListeners = new HashMap<LXClip, ClipListener>();

        ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.addListener(this);
                c.compositeMode.addListener(this.onCompositeModeChanged);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            channel.stopClips.pending.addListener(this);
            channel.hasRunningClip.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.patterns.forEach(pattern -> {
                    PatternListener patternListener = this.patternListeners.put((LXPattern)pattern, new PatternListener((LXPattern)pattern));
                });
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.registerClip(clip);
            }
        }

        public void dispose() {
            LXAbstractChannel lXAbstractChannel = this.channel;
            if (lXAbstractChannel instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel;
                c.removeListener(this);
                c.compositeMode.removeListener(this.onCompositeModeChanged);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            this.channel.stopClips.pending.removeListener(this);
            this.channel.hasRunningClip.removeListener(this);
            LXAbstractChannel lXAbstractChannel2 = this.channel;
            if (lXAbstractChannel2 instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel2;
                c.focusedPattern.removeListener(this);
            }
            this.patternListeners.values().forEach(patternListener -> patternListener.dispose());
            this.patternListeners.clear();
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.unregisterClip(clip);
            }
        }

        private void registerClip(LXClip clip) {
            if (this.clipListeners.containsKey(clip)) {
                throw new IllegalStateException("Registered clip twice on APC40Mk2.ChannelListener: " + String.valueOf(clip));
            }
            this.clipListeners.put(clip, new ClipListener(clip));
        }

        private void unregisterClip(LXClip clip) {
            this.clipListeners.remove(clip).dispose();
        }

        private void onCompositeModeChanged(LXParameter p) {
            int index = APC40.this.mixerSurface.getIndex(this.channel);
            APC40.this.sendChannelPatterns(index, this.channel);
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = APC40.this.mixerSurface.getIndex(this.channel);
            if (p == this.channel.cueActive) {
                APC40.this.sendNoteOn(index, 49, APC40.LED_ON(this.channel.cueActive.isOn()));
            } else if (p == this.channel.enabled) {
                APC40.this.sendNoteOn(index, 50, APC40.LED_ON(this.channel.enabled.isOn()));
            } else if (p == this.channel.crossfadeGroup) {
                APC40.this.sendNoteOn(index, 66, this.channel.crossfadeGroup.getValuei());
            } else if (p == this.channel.arm) {
                APC40.this.sendNoteOn(index, 48, APC40.LED_ON(this.channel.arm.isOn()));
                APC40.this.sendChannelClips(index, this.channel);
            } else if ((p == this.channel.stopClips.pending || p == this.channel.hasRunningClip) && APC40.this.gridMode == GridMode.CLIP) {
                APC40.this.sendChannelClipStop(index, this.channel);
            }
            LXAbstractChannel lXAbstractChannel = this.channel;
            if (lXAbstractChannel instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel;
                if (p == c.focusedPattern) {
                    APC40.this.sendChannelPatterns(index, c);
                }
            }
        }

        @Override
        public void effectAdded(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectRemoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void effectMoved(LXBus channel, LXEffect effect) {
        }

        @Override
        public void indexChanged(LXAbstractChannel channel) {
        }

        @Override
        public void groupChanged(LXChannel channel, LXGroup group) {
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            this.patternListeners.put(pattern, new PatternListener(pattern));
            APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            this.patternListeners.remove(pattern).dispose();
            APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternEnabled(LXChannel channel, LXPattern pattern) {
            if (APC40.this.gridMode == GridMode.PATTERN && channel.isComposite()) {
                APC40.this.sendChannelPatterns(APC40.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            this.registerClip(clip);
            APC40.this.sendChannelClips(APC40.this.mixerSurface.getIndex(this.channel), this.channel);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            this.unregisterClip(clip);
            APC40.this.sendChannelClips(APC40.this.mixerSurface.getIndex(this.channel), this.channel);
        }

        private class ClipListener
        implements LXParameterListener {
            private final LXClip clip;

            private ClipListener(LXClip clip) {
                this.clip = clip;
                clip.running.addListener(this);
                clip.launch.pending.addListener(this);
                clip.launchAutomation.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                APC40.this.sendClip(((ChannelListener)ChannelListener.this).APC40.this.mixerSurface.getIndex(ChannelListener.this.channel), ChannelListener.this.channel, this.clip.getIndex(), this.clip);
            }

            private void dispose() {
                this.clip.running.removeListener(this);
                this.clip.launch.pending.removeListener(this);
                this.clip.launchAutomation.pending.removeListener(this);
            }
        }

        private class PatternListener
        implements LXParameterListener {
            private final LXPattern pattern;

            private PatternListener(LXPattern pattern) {
                this.pattern = pattern;
                this.pattern.launch.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                int index = ((ChannelListener)ChannelListener.this).APC40.this.mixerSurface.getIndex(ChannelListener.this.channel);
                APC40.this.sendChannelPatterns(index, ChannelListener.this.channel);
            }

            private void dispose() {
                this.pattern.launch.pending.removeListener(this);
            }
        }
    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[8];

        DeviceListener() {
            Arrays.fill(this.knobs, null);
            this.focusedDevice = new FocusedDevice(APC40.this.lx, APC40.this, this);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        void resend() {
            int i = 0;
            while (i < this.knobs.length) {
                LXListenableNormalizedParameter parameter = this.knobs[i];
                if (parameter != null) {
                    APC40.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    double normalized = parameter.getBaseNormalized();
                    APC40.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
                } else {
                    APC40.this.sendControlChange(0, 24 + i, 0);
                }
                ++i;
            }
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                isEnabled = effect.enabled.isOn();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                isEnabled = this.isPatternEnabled(pattern);
            }
            APC40.this.sendNoteOn(0, 59, APC40.LED_ON(isEnabled));
        }

        private boolean isPatternEnabled(LXPattern pattern) {
            switch (pattern.getChannel().compositeMode.getEnum()) {
                case BLEND: {
                    return pattern.enabled.isOn();
                }
            }
            return pattern == pattern.getChannel().getTargetPattern();
        }

        private void clearKnobsAfter(int i) {
            while (i < this.knobs.length) {
                APC40.this.sendControlChange(0, 24 + i, 0);
                ++i;
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device == device) {
                return;
            }
            this.unregisterDevice();
            this.device = device;
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.addListener(this);
                isEnabled = effect.isEnabled();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                pattern.enabled.addListener(this);
                isEnabled = this.isPatternEnabled(pattern);
            }
            if (this.device != null) {
                this.device.remoteControlsChanged.addListener(this);
            }
            APC40.this.sendNoteOn(0, 59, APC40.LED_ON(isEnabled));
            if (this.device == null) {
                this.clearKnobsAfter(0);
                return;
            }
            this.registerDeviceKnobs();
        }

        private void registerDeviceKnobs() {
            int i = 0;
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.device.getRemoteControls();
            int n = lXListenableNormalizedParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                LXListenableNormalizedParameter parameter = lXListenableNormalizedParameterArray[n2];
                if (i >= this.knobs.length) break;
                this.knobs[i] = parameter;
                if (parameter != null) {
                    if (!uniqueParameters.contains(parameter)) {
                        parameter.addListener(this);
                        uniqueParameters.add(parameter);
                    }
                    APC40.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    this.sendKnobValue(this.knobs[i], i);
                } else {
                    APC40.this.sendControlChange(0, 24 + i, 0);
                }
                ++i;
                ++n2;
            }
            this.clearKnobsAfter(i);
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            LXPattern pattern;
            LXEffect effect = this.device instanceof LXEffect ? (LXEffect)this.device : null;
            LXPattern lXPattern = pattern = this.device instanceof LXPattern ? (LXPattern)this.device : null;
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
            } else if (effect != null && parameter == effect.enabled) {
                APC40.this.sendNoteOn(0, 59, APC40.LED_ON(effect.enabled.isOn()));
            } else if (pattern != null && parameter == pattern.enabled) {
                APC40.this.sendNoteOn(0, 59, APC40.LED_ON(this.isPatternEnabled(pattern)));
            } else {
                int i = 0;
                while (i < this.knobs.length) {
                    if (parameter == this.knobs[i]) {
                        this.sendKnobValue(this.knobs[i], i);
                    }
                    ++i;
                }
            }
        }

        private void sendKnobValue(LXListenableNormalizedParameter knobParam, int i) {
            double normalized = knobParam.getBaseNormalized();
            if (knobParam instanceof DiscreteParameter && knobParam.isWrappable()) {
                DiscreteParameter discrete = (DiscreteParameter)knobParam;
                normalized = ((float)(discrete.getBaseValuei() - discrete.getMinValue()) + 0.5f) / (float)discrete.getRange();
            }
            APC40.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
        }

        void onDeviceOnOff() {
            if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                LXChannel channel = pattern.getChannel();
                if (channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                    pattern.enabled.toggle();
                } else {
                    pattern.getChannel().goPatternIndex(pattern.getIndex());
                }
                APC40.this.sendNoteOn(0, 59, APC40.LED_ON(this.isPatternEnabled(pattern)));
            } else if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                if (!effect.locked.isOn()) {
                    effect.enabled.toggle();
                }
            }
        }

        void onKnob(int index, double normalized) {
            if (this.knobs[index] != null) {
                if (this.knobs[index].isWrappable()) {
                    if (normalized == 0.0) {
                        normalized = 1.0;
                    } else if (normalized == 1.0) {
                        normalized = 0.0;
                    }
                }
                this.knobs[index].setNormalized(normalized);
            }
        }

        private void unregisterDevice() {
            if (this.device != null) {
                if (this.device instanceof LXEffect) {
                    LXEffect effect = (LXEffect)this.device;
                    effect.enabled.removeListener(this);
                }
                if (this.device instanceof LXPattern) {
                    LXPattern pattern = (LXPattern)this.device;
                    pattern.enabled.removeListener(this);
                }
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
                this.device = null;
            }
        }

        private void unregisterDeviceKnobs() {
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            int i = 0;
            while (i < this.knobs.length) {
                if (this.knobs[i] != null) {
                    if (!uniqueParameters.contains(this.knobs[i])) {
                        uniqueParameters.add(this.knobs[i]);
                        this.knobs[i].removeListener(this);
                    }
                    this.knobs[i] = null;
                }
                ++i;
            }
        }

        private void dispose() {
            this.unregisterDevice();
        }
    }

    public static enum GridMode {
        PATTERN(LXClipEngine.GridMode.PATTERNS),
        CLIP(LXClipEngine.GridMode.CLIPS);

        public final LXClipEngine.GridMode engineGridMode;

        private GridMode(LXClipEngine.GridMode engineGridMode) {
            this.engineGridMode = engineGridMode;
        }
    }
}

