/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEngine;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXSwatch;
import heronarts.lx.color.LinkedColorParameter;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.APC40Mk2Colors;
import heronarts.lx.midi.surface.FocusedChannel;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiParameterControl;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.midi.surface.MixerSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@LXMidiSurface.Name(value="Akai APC40 mkII")
@LXMidiSurface.DeviceName(value="APC40 mkII")
public class APC40Mk2
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final byte GENERIC_MODE = 64;
    public static final byte ABLETON_MODE = 65;
    public static final byte ABLETON_ALTERNATE_MODE = 66;
    protected static final int LED_STYLE_OFF = 0;
    protected static final int LED_STYLE_SINGLE = 1;
    protected static final int LED_STYLE_UNIPOLAR = 2;
    protected static final int LED_STYLE_BIPOLAR = 3;
    public static final int NUM_CHANNELS = 8;
    public static final int CLIP_LAUNCH_ROWS = 5;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int PALETTE_SWATCH_ROWS = 5;
    public static final int PALETTE_SWATCH_COLUMNS = 8;
    public static final int MASTER_SWATCH = -1;
    public static final int RAINBOW_GRID_COLUMNS = 72;
    public static final int RAINBOW_GRID_ROWS = 5;
    public static final int RAINBOW_HUE_STEP = 5;
    private static final int[] RAINBOW_GRID_SAT = new int[]{100, 70, 50, 100, 100};
    private static final int[] RAINBOW_GRID_BRI = new int[]{100, 100, 100, 50, 25};
    public static final int CHANNEL_FADER = 7;
    public static final int TEMPO = 13;
    public static final int MASTER_FADER = 14;
    public static final int CROSSFADER = 15;
    public static final int CUE_LEVEL = 47;
    public static final int DEVICE_KNOB = 16;
    public static final int DEVICE_KNOB_NUM = 8;
    public static final int DEVICE_KNOB_MAX = 24;
    public static final int DEVICE_KNOB_STYLE = 24;
    public static final int DEVICE_KNOB_STYLE_MAX = 32;
    public static final int CHANNEL_KNOB = 48;
    public static final int CHANNEL_KNOB_NUM = 8;
    public static final int CHANNEL_KNOB_MAX = 55;
    public static final int CHANNEL_KNOB_STYLE = 56;
    public static final int CHANNEL_KNOB_STYLE_MAX = 64;
    public static final int CLIP_LAUNCH = 0;
    public static final int CLIP_LAUNCH_NUM = 40;
    public static final int CLIP_LAUNCH_MAX = 39;
    public static final int CHANNEL_ARM = 48;
    public static final int CHANNEL_SOLO = 49;
    public static final int CHANNEL_ACTIVE = 50;
    public static final int CHANNEL_FOCUS = 51;
    public static final int CLIP_STOP = 52;
    public static final int DEVICE_LEFT = 58;
    public static final int DEVICE_RIGHT = 59;
    public static final int BANK_LEFT = 60;
    public static final int BANK_RIGHT = 61;
    public static final int DEVICE_ON_OFF = 62;
    public static final int DEVICE_LOCK = 63;
    public static final int CLIP_DEVICE_VIEW = 64;
    public static final int DETAIL_VIEW = 65;
    public static final int CHANNEL_CROSSFADE_GROUP = 66;
    public static final int MASTER_FOCUS = 80;
    public static final int STOP_ALL_CLIPS = 81;
    public static final int SCENE_LAUNCH = 82;
    public static final int SCENE_LAUNCH_NUM = 5;
    public static final int SCENE_LAUNCH_MAX = 86;
    public static final int PAN = 87;
    public static final int SENDS = 88;
    public static final int USER = 89;
    public static final int PLAY = 91;
    public static final int RECORD = 93;
    public static final int SESSION = 102;
    public static final int BANK_SELECT_UP = 94;
    public static final int BANK_SELECT_DOWN = 95;
    public static final int BANK_SELECT_RIGHT = 96;
    public static final int BANK_SELECT_LEFT = 97;
    public static final int SHIFT = 98;
    public static final int METRONOME = 90;
    public static final int TAP_TEMPO = 99;
    public static final int NUDGE_MINUS = 100;
    public static final int NUDGE_PLUS = 101;
    public static final int BANK = 103;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_GRAY = 2;
    public static final int LED_CYAN = 114;
    public static final int LED_GRAY_DIM = 117;
    public static final int LED_RED = 120;
    public static final int LED_RED_HALF = 121;
    public static final int LED_ORANGE_RED = 60;
    public static final int LED_GREEN = 122;
    public static final int LED_GREEN_HALF = 123;
    public static final int LED_YELLOW = 124;
    public static final int LED_YELLOW_HALF = 125;
    public static final int LED_AMBER = 126;
    public static final int LED_AMBER_HALF = 9;
    public static final int LED_AMBER_DIM = 10;
    public static final int LED_MODE_PRIMARY = 0;
    public static final int LED_MODE_PULSE = 10;
    public static final int LED_MODE_BLINK = 15;
    public static final int LED_CLIP_STOP_BLINK = 2;
    private boolean shiftOn = false;
    private boolean deviceLockOn = false;
    private Integer colorClipboard = null;
    private LXDynamicColor focusColor = null;
    private boolean rainbowMode = false;
    private int rainbowColumnOffset = 0;
    private boolean isAux = false;
    private final APC40Mk2Colors apc40Mk2Colors = new APC40Mk2Colors();
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener;
    private GridMode gridMode = this._getGridMode();
    protected final MixerSurface mixerSurface;
    private final MixerSurface.Listener mixerSurfaceListener = new MixerSurface.Listener(){

        @Override
        public void onChannelChanged(int index, LXAbstractChannel channel, LXAbstractChannel previousChannel) {
            if (previousChannel != null && !APC40Mk2.this.mixerSurface.contains(previousChannel)) {
                APC40Mk2.this.unregisterChannel(previousChannel);
            }
            if (channel != null) {
                APC40Mk2.this.registerChannel(channel);
                APC40Mk2.this.channelFaders[index].setTarget(channel.fader);
            } else {
                APC40Mk2.this.channelFaders[index].setTarget(null);
            }
            APC40Mk2.this.sendChannel(index, channel);
            APC40Mk2.this.sendChannelFocus();
        }

        @Override
        public void onGridOffsetChanged() {
            APC40Mk2.this.sendChannels();
            APC40Mk2.this.sendChannelFocus();
        }
    };
    private final FocusedChannel focusedChannel;
    private final FocusedChannel focusedChannelAux;
    public final BooleanParameter masterFaderEnabled = new BooleanParameter("Master Fader", true).setDescription("Whether the master fader is enabled");
    public final BooleanParameter crossfaderEnabled = new BooleanParameter("Crossfader", true).setDescription("Whether the A/B crossfader is enabled");
    public final BooleanParameter deviceControl = new BooleanParameter("Device Control", true).setDescription("Use the device knobs on the right side of the APC40mkII to control the focused device");
    public final BooleanParameter performanceLock = new BooleanParameter("Performance Lock", false).setDescription("Keep surface in Performance mode regardless of Design/Perform toggle");
    public final EnumParameter<LXMidiParameterControl.Mode> faderMode = new EnumParameter<LXMidiParameterControl.Mode>("Fader Mode", LXMidiParameterControl.Mode.SCALE).setDescription("Parameter control mode for faders");
    private final LXMidiParameterControl masterFader;
    private final LXMidiParameterControl crossfader;
    private final LXMidiParameterControl[] channelFaders;
    private static final int[] RAINBOW_GRID = APC40Mk2.makeRainbowGrid();
    private final LXParameterListener cueAListener = p -> {
        if (!this.isAuxActive()) {
            this.sendNoteOn(0, 64, this.lx.engine.mixer.cueA.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener cueBListener = p -> {
        if (!this.isAuxActive()) {
            this.sendNoteOn(0, 65, this.lx.engine.mixer.cueB.isOn() ? 1 : 0);
        }
    };
    private final LXParameterListener auxAListener = p -> {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 64, APC40Mk2.LED_ON(this.lx.engine.mixer.auxA.isOn()));
        }
    };
    private final LXParameterListener auxBListener = p -> {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 65, APC40Mk2.LED_ON(this.lx.engine.mixer.auxB.isOn()));
        }
    };
    private final LXParameterListener tempoListener = p -> this.sendNoteOn(0, 90, APC40Mk2.LED_ON(this.lx.engine.tempo.enabled.isOn()));
    private final LXParameterListener performanceModeListener = p -> this.updatePerformanceMode();
    private final LXParameterListener clipGridModeListener = p -> this.updateGridMode();
    private final LXParameterListener clipGridListener = p -> this.sendChannelGrid();
    private boolean isRegistered = false;
    private final CueState cueState = new CueState();
    private final CueState auxState = new CueState();

    private static int LED_ON(boolean condition) {
        return condition ? 1 : 0;
    }

    private GridMode _getGridMode() {
        if (this.deviceLockOn) {
            return GridMode.PALETTE;
        }
        return switch (this.lx.engine.clips.gridMode.getEnum()) {
            case LXClipEngine.GridMode.PATTERNS -> GridMode.PATTERN;
            case LXClipEngine.GridMode.CLIPS -> GridMode.CLIP;
            default -> throw new MatchException(null, null);
        };
    }

    private void updateGridMode() {
        GridMode gridMode = this._getGridMode();
        if (this.gridMode != gridMode) {
            this.gridMode = gridMode;
            this.mixerSurface.setGridMode(gridMode.engineGridMode);
            if (gridMode.engineGridMode != null) {
                this.lx.engine.clips.gridMode.setValue((Object)gridMode.engineGridMode);
            }
            this.sendBankGridMode();
            this.sendChannelGrid();
            this.sendChannelFocus();
        }
    }

    private LXListenableNormalizedParameter getActiveSubparameter(AggregateParameter agg) {
        if (agg instanceof LinkedColorParameter) {
            LinkedColorParameter lcp = (LinkedColorParameter)agg;
            if (lcp.mode.getEnum() == LinkedColorParameter.Mode.PALETTE) {
                return lcp.index;
            }
        }
        if (agg instanceof ColorParameter) {
            ColorParameter colorParameter = (ColorParameter)agg;
            if (this.shiftOn) {
                return colorParameter.saturation;
            }
            return colorParameter.hue;
        }
        LX.error("APC40Mk2 found AggregateParameter type with no subparameter: " + agg.getClass().getName());
        return null;
    }

    private void sendPerformanceLights() {
        boolean performanceMode = this.isPerformanceMode();
        this.sendNoteOn(0, 91, APC40Mk2.LED_ON(performanceMode && !this.isAux));
        this.sendNoteOn(0, 93, APC40Mk2.LED_ON(performanceMode && this.isAux));
        this.sendNoteOn(0, 102, APC40Mk2.LED_ON(performanceMode));
    }

    private void sendCueLights() {
        if (this.isAuxActive()) {
            this.sendNoteOn(0, 64, APC40Mk2.LED_ON(this.lx.engine.mixer.auxA.isOn()));
            this.sendNoteOn(0, 65, APC40Mk2.LED_ON(this.lx.engine.mixer.auxB.isOn()));
        } else {
            this.sendNoteOn(0, 64, APC40Mk2.LED_ON(this.lx.engine.mixer.cueA.isOn()));
            this.sendNoteOn(0, 65, APC40Mk2.LED_ON(this.lx.engine.mixer.cueB.isOn()));
        }
    }

    private void setAux(boolean isAux) {
        this.isAux = isAux;
        this.lx.engine.performanceMode.setValue(true);
        if (this.isDeviceControl()) {
            this.deviceListener.focusedDevice.setAux(isAux);
        }
        this.sendPerformanceLights();
        this.sendCueLights();
        this.sendChannelFocus();
        this.sendChannelCues();
    }

    public APC40Mk2(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.masterFader = new LXMidiParameterControl(this.lx.engine.mixer.masterBus.fader);
        this.crossfader = new LXMidiParameterControl(this.lx.engine.mixer.crossfader);
        this.channelFaders = new LXMidiParameterControl[8];
        int i = 0;
        while (i < 8) {
            this.channelFaders[i] = new LXMidiParameterControl();
            ++i;
        }
        this.updateFaderMode();
        this.mixerSurface = new MixerSurface(lx, this.mixerSurfaceListener, 8, 5).setGridMode(this.gridMode.engineGridMode);
        this.focusedChannel = new FocusedChannel(lx, false, bus -> this.sendChannelFocus());
        this.focusedChannelAux = new FocusedChannel(lx, true, bus -> this.sendChannelFocus());
        this.deviceListener = new DeviceListener(lx);
        this.addSetting("masterFaderEnabled", this.masterFaderEnabled);
        this.addSetting("crossfaderEnabled", this.crossfaderEnabled);
        this.addSetting("faderMode", this.faderMode);
        this.addSetting("deviceControl", this.deviceControl);
        this.addSetting("performanceLock", this.performanceLock);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.faderMode) {
            this.updateFaderMode();
        } else if (this.enabled.isOn()) {
            if (p == this.performanceLock) {
                this.deviceListener.focusedDevice.setAuxSticky(this.performanceLock.isOn());
                this.updatePerformanceMode();
            } else if (p == this.deviceControl) {
                this.onDeviceControlChanged();
            }
        }
    }

    private void updateFaderMode() {
        LXMidiParameterControl.Mode mode = this.faderMode.getEnum();
        this.masterFader.setMode(mode);
        this.crossfader.setMode(mode);
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl channelFader = lXMidiParameterControlArray[n2];
            channelFader.setMode(mode);
            ++n2;
        }
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.setApcMode((byte)66);
            this.initialize(false);
            this.register();
        } else {
            if (this.isRegistered) {
                this.unregister();
            }
            this.setApcMode((byte)64);
        }
    }

    @Override
    protected void onReconnect() {
        this.setApcMode((byte)66);
        this.initialize(true);
        if (this.isDeviceControl()) {
            this.deviceListener.resend();
        }
    }

    private void setApcMode(byte mode) {
        byte[] byArray = new byte[12];
        byArray[0] = -16;
        byArray[1] = 71;
        byArray[3] = 41;
        byArray[4] = 96;
        byArray[6] = 4;
        byArray[7] = mode;
        byArray[8] = 9;
        byArray[9] = 3;
        byArray[10] = 1;
        byArray[11] = -9;
        this.sendSysex(byArray);
    }

    private void initialize(boolean reconnect) {
        this.sendBankGridMode();
        this.sendNoteOn(0, 63, APC40Mk2.LED_ON(this.deviceLockOn));
        if (!reconnect) {
            this.resetPaletteVars();
        }
        this.sendPerformanceLights();
        this.initializeDeviceControlKnobs(reconnect);
        int i = 0;
        while (i < 8) {
            this.sendControlChange(0, 56 + i, 1);
            if (!reconnect) {
                this.sendControlChange(0, 48 + i, 64);
            }
            ++i;
        }
        this.sendChannels();
        this.cueState.reset();
        this.auxState.reset();
    }

    private void initializeDeviceControlKnobs(boolean reconnect) {
        if (this.isDeviceControl()) {
            int i = 0;
            while (i < 8) {
                this.sendControlChange(0, 24 + i, 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 8) {
                this.sendControlChange(0, 24 + i, 1);
                if (!reconnect) {
                    this.sendControlChange(0, 16 + i, 64);
                }
                ++i;
            }
        }
    }

    private void resetPaletteVars() {
        this.colorClipboard = null;
        this.focusColor = null;
        this.rainbowMode = false;
        this.clearSceneLaunch();
    }

    private void sendBankGridMode() {
        this.sendNoteOn(0, 103, APC40Mk2.LED_ON(this.gridMode == GridMode.PATTERN));
    }

    private void sendChannels() {
        int i = 0;
        while (i < 8) {
            this.sendChannel(i, this.getChannel(i));
            ++i;
        }
        this.sendChannelFocus();
    }

    private void sendChannelCues() {
        int i = 0;
        while (i < 8) {
            LXAbstractChannel channel = this.getChannel(i);
            if (channel != null) {
                this.sendNoteOn(i, 49, APC40Mk2.LED_ON(channel.cueActive.isOn()));
                this.sendNoteOn(i, 48, APC40Mk2.LED_ON(this.isPerformanceMode() ? channel.auxActive.isOn() : channel.arm.isOn()));
            } else {
                this.sendNoteOn(i, 49, 0);
                this.sendNoteOn(i, 48, 0);
            }
            ++i;
        }
    }

    private void sendChannelGrid() {
        if (!this.rainbowMode) {
            int i = 0;
            while (i < 8) {
                LXAbstractChannel channel = this.getChannel(i);
                this.sendChannelPatterns(i, channel);
                this.sendChannelClips(i, channel);
                this.sendSwatch(i);
                ++i;
            }
        }
        this.sendSwatch(-1);
    }

    private void clearChannelGrid() {
        int i = 0;
        while (i < 8) {
            this.sendChannel(i, null);
            ++i;
        }
    }

    private void sendChannel(int index, LXAbstractChannel channel) {
        if (channel != null) {
            this.sendNoteOn(index, 50, APC40Mk2.LED_ON(channel.enabled.isOn()));
            this.sendNoteOn(index, 66, channel.crossfadeGroup.getValuei());
            this.sendNoteOn(index, 49, APC40Mk2.LED_ON(channel.cueActive.isOn()));
            this.sendNoteOn(index, 48, APC40Mk2.LED_ON(this.isPerformanceMode() ? channel.auxActive.isOn() : channel.arm.isOn()));
        } else {
            this.sendNoteOn(index, 50, 0);
            this.sendNoteOn(index, 66, 0);
            this.sendNoteOn(index, 49, 0);
            this.sendNoteOn(index, 48, 0);
        }
        this.sendChannelPatterns(index, channel);
        this.sendChannelClips(index, channel);
    }

    private void sendChannelPatterns(int index, LXAbstractChannel bus) {
        if (index >= 8 || this.gridMode != GridMode.PATTERN) {
            return;
        }
        if (bus instanceof LXChannel) {
            LXChannel channel = (LXChannel)bus;
            boolean blendMode = channel.isComposite();
            int baseIndex = this.mixerSurface.getGridPatternOffset();
            int endIndex = channel.patterns.size() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            int focusedIndex = channel.patterns.size() == 0 ? -1 : channel.focusedPattern.getValuei() - baseIndex;
            int y = 0;
            while (y < 5) {
                int note = 0 + 8 * (4 - y) + index;
                int midiChannel = 0;
                int color = 0;
                if (blendMode) {
                    if (y < endIndex) {
                        color = channel.patterns.get((int)(baseIndex + y)).enabled.isOn() ? (y == focusedIndex ? 122 : 123) : (y == focusedIndex ? 125 : 117);
                    }
                } else {
                    boolean isPending;
                    boolean bl = isPending = y < endIndex && channel.patterns.get((int)(baseIndex + y)).launch.pending.isOn();
                    if (y == activeIndex) {
                        color = 60;
                    } else if (y == nextIndex) {
                        this.sendNoteOn(0, note, 60);
                        midiChannel = 10;
                        color = 9;
                    } else if (isPending) {
                        this.sendNoteOn(0, note, 60);
                        midiChannel = 15;
                        color = 0;
                    } else if (y == focusedIndex) {
                        color = 125;
                    } else if (y < endIndex) {
                        color = 117;
                    }
                }
                this.sendNoteOn(midiChannel, note, color);
                ++y;
            }
        } else {
            int y = 0;
            while (y < 5) {
                this.sendNoteOn(0, 0 + 8 * (4 - y) + index, 0);
                ++y;
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        int clipOffset = this.mixerSurface.getGridClipOffset();
        int i = 0;
        while (i < 5) {
            LXClip clip = null;
            int clipIndex = clipOffset + i;
            if (channel != null) {
                clip = channel.getClip(clipIndex);
            }
            this.sendClip(index, channel, clipIndex, clip);
            ++i;
        }
    }

    private int getChannelClipStop(LXAbstractChannel channel) {
        return channel.stopClips.pending.isOn() ? 2 : APC40Mk2.LED_ON(channel.hasRunningClip.isOn());
    }

    private void sendChannelClipStop(int index, LXAbstractChannel channel) {
        this.sendNoteOn(index, 52, this.getChannelClipStop(channel));
    }

    private void sendClip(int channelIndex, LXAbstractChannel channel, int clipIndex, LXClip clip) {
        int slotIndex = clipIndex - this.mixerSurface.getGridClipOffset();
        if (this.gridMode != GridMode.CLIP || !LXUtils.inRange(channelIndex, 0, 7) || !LXUtils.inRange(slotIndex, 0, 4)) {
            return;
        }
        int color = 0;
        int mode = 0;
        int pitch = 0 + channelIndex + 8 * (4 - slotIndex);
        if (channel != null && clip != null) {
            int n = channel.arm.isOn() ? 121 : (color = clip.loop.isOn() ? 114 : 2);
            if (clip.isPending()) {
                this.sendNoteOn(0, pitch, channel.arm.isOn() ? 120 : 122);
                mode = 15;
                color = 0;
            } else if (clip.isRunning()) {
                color = channel.arm.isOn() ? 120 : 122;
                this.sendNoteOn(0, pitch, color);
                mode = 10;
                color = channel.arm.isOn() ? 121 : (clip.loop.isOn() ? 114 : 123);
            }
        }
        this.sendNoteOn(mode, pitch, color);
    }

    private void clearSceneLaunch() {
        int i = 0;
        while (i < 5) {
            this.sendNoteOn(0, 82 + i, 0);
            ++i;
        }
    }

    private void sendDeviceOnOff() {
        if (this.isDeviceControl()) {
            this.deviceListener.sendDeviceOnOff();
        }
    }

    private void sendSwatches() {
        int i = 0;
        while (i < 8) {
            this.sendSwatch(i);
            ++i;
        }
        this.sendSwatch(-1);
    }

    private void sendSwatch(int index) {
        if (this.gridMode != GridMode.PALETTE || index >= 8) {
            return;
        }
        LXSwatch swatch = this.getSwatch(index);
        int i = 0;
        while (i < 5) {
            int color = 0;
            int mode = 0;
            int pitch = index == -1 ? 82 + i : 0 + index + 8 * (4 - i);
            if (swatch != null && i < swatch.colors.size()) {
                int palColor = swatch.colors.get(i).getColor();
                color = this.apc40Mk2Colors.nearest(palColor);
            }
            this.sendNoteOn(mode, pitch, color);
            ++i;
        }
    }

    private static int[] makeRainbowGrid() {
        int[] rainbowGrid = new int[360];
        int col = 0;
        while (col < 72) {
            int hue = col * 5;
            int row = 0;
            while (row < 5) {
                int i = col * 5 + row;
                rainbowGrid[i++] = LXColor.hsb(hue, RAINBOW_GRID_SAT[row], RAINBOW_GRID_BRI[row]);
                ++row;
            }
            ++col;
        }
        return rainbowGrid;
    }

    private int rainbowGridColor(int relCol, int row) {
        int absCol = (72 + relCol + this.rainbowColumnOffset) % 72;
        return RAINBOW_GRID[absCol * 5 + row];
    }

    private void sendRainbowPickerGrid() {
        int col = 0;
        while (col < 8) {
            int row = 0;
            while (row < 5) {
                int pitch = 0 + col + 8 * (4 - row);
                int color = this.rainbowGridColor(col, row);
                int colorId = this.apc40Mk2Colors.nearest(color);
                this.sendNoteOn(0, pitch, colorId);
                ++row;
            }
            ++col;
        }
    }

    private void updateColorKnobs() {
        int i = 0;
        while (i < this.deviceListener.knobs.length) {
            LXListenableParameter knob = this.deviceListener.knobs[i];
            if (knob instanceof ColorParameter) {
                ColorParameter cp = (ColorParameter)knob;
                LXListenableNormalizedParameter subparam = this.getActiveSubparameter(cp);
                double normalized = subparam.getNormalized();
                this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
            }
            ++i;
        }
    }

    private void sendChannelFocus() {
        int focusedChannel = this.lx.engine.mixer.focusedChannel.getValuei();
        int focusedChannelAux = this.lx.engine.mixer.focusedChannelAux.getValuei();
        boolean masterFocused = focusedChannel == this.lx.engine.mixer.channels.size();
        boolean masterFocusedAux = focusedChannelAux == this.lx.engine.mixer.channels.size();
        boolean isAuxActive = this.isAuxActive();
        int focusedChannelMain = isAuxActive ? focusedChannelAux : focusedChannel;
        boolean masterFocusedMain = isAuxActive ? masterFocusedAux : masterFocused;
        int focusedChannelAlt = isAuxActive ? focusedChannel : focusedChannelAux;
        boolean masterFocusedAlt = isAuxActive ? masterFocused : masterFocusedAux;
        int i = 0;
        while (i < 8) {
            int channelIndex = i + this.mixerSurface.getChannelIndex();
            boolean focusOn = false;
            int clipStop = 0;
            switch (this.gridMode) {
                case PALETTE: {
                    if (this.rainbowMode) break;
                    clipStop = APC40Mk2.LED_ON(i < this.lx.engine.palette.swatches.size());
                    break;
                }
                case CLIP: {
                    if (i >= this.lx.engine.mixer.channels.size()) break;
                    clipStop = this.getChannelClipStop(this.lx.engine.mixer.channels.get(channelIndex));
                    break;
                }
                case PATTERN: {
                    if (!this.isPerformanceMode()) break;
                    clipStop = APC40Mk2.LED_ON(!masterFocusedAlt && channelIndex == focusedChannelAlt);
                }
            }
            focusOn = !masterFocusedMain && channelIndex == focusedChannelMain;
            this.sendNoteOn(i, 52, clipStop);
            this.sendNoteOn(i, 51, APC40Mk2.LED_ON(focusOn));
            ++i;
        }
        this.sendNoteOn(0, 80, APC40Mk2.LED_ON(masterFocusedMain));
    }

    private boolean isPerformanceMode() {
        return this.lx.engine.performanceMode.isOn() || this.performanceLock.isOn();
    }

    private boolean isAuxActive() {
        return this.isPerformanceMode() && this.isAux;
    }

    private void updatePerformanceMode() {
        this.sendPerformanceLights();
        this.sendCueLights();
        this.sendChannelFocus();
        this.sendChannelCues();
    }

    private void register() {
        this.isRegistered = true;
        if (this.isDeviceControl()) {
            this.registerDeviceControl();
        }
        this.mixerSurface.register();
        this.focusedChannel.register();
        this.focusedChannelAux.register();
        this.lx.engine.performanceMode.addListener(this.performanceModeListener, true);
        this.lx.engine.clips.numScenes.addListener(this.clipGridListener);
        this.lx.engine.clips.gridMode.addListener(this.clipGridModeListener);
        this.lx.engine.mixer.cueA.addListener(this.cueAListener, true);
        this.lx.engine.mixer.cueB.addListener(this.cueBListener, true);
        this.lx.engine.mixer.auxA.addListener(this.auxAListener, true);
        this.lx.engine.mixer.auxB.addListener(this.auxBListener, true);
        this.lx.engine.tempo.enabled.addListener(this.tempoListener, true);
    }

    private void unregister() {
        this.isRegistered = false;
        if (this.isDeviceControl()) {
            this.unregisterDeviceControl();
        }
        this.mixerSurface.unregister();
        this.focusedChannel.unregister();
        this.focusedChannelAux.unregister();
        this.lx.engine.performanceMode.removeListener(this.performanceModeListener);
        this.lx.engine.clips.numScenes.removeListener(this.clipGridListener);
        this.lx.engine.clips.gridMode.removeListener(this.clipGridModeListener);
        this.lx.engine.mixer.cueA.removeListener(this.cueAListener);
        this.lx.engine.mixer.cueB.removeListener(this.cueBListener);
        this.lx.engine.mixer.auxA.removeListener(this.auxAListener);
        this.lx.engine.mixer.auxB.removeListener(this.auxBListener);
        this.lx.engine.tempo.enabled.removeListener(this.tempoListener);
        this.clearChannelGrid();
    }

    private boolean isDeviceControl() {
        return this.deviceControl.isOn();
    }

    private void onDeviceControlChanged() {
        if (this.isDeviceControl()) {
            this.registerDeviceControl();
        } else {
            this.unregisterDeviceControl();
            this.initializeDeviceControlKnobs(false);
        }
    }

    private void registerDeviceControl() {
        this.deviceListener.focusedDevice.register();
    }

    private void unregisterDeviceControl() {
        this.deviceListener.focusedDevice.unregister();
    }

    private void registerChannel(LXAbstractChannel channel) {
        if (!this.channelListeners.containsKey(channel)) {
            this.channelListeners.put(channel, new ChannelListener(channel));
        }
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        return this.mixerSurface.getChannel(index);
    }

    private LXAbstractChannel getChannel(LXShortMessage message) {
        return this.getChannel(message.getChannel());
    }

    private LXSwatch getSwatch(int index) {
        if (index < 0) {
            return this.lx.engine.palette.swatch;
        }
        if (index < this.lx.engine.palette.swatches.size()) {
            return this.lx.engine.palette.swatches.get(index);
        }
        return null;
    }

    private LXBus getFocusedChannel() {
        return this.isAuxActive() ? this.lx.engine.mixer.getFocusedChannelAux() : this.lx.engine.mixer.getFocusedChannel();
    }

    private DiscreteParameter getFocusedChannelTarget() {
        return this.isAuxActive() ? this.lx.engine.mixer.focusedChannelAux : this.lx.engine.mixer.focusedChannel;
    }

    private DiscreteParameter getFocusedChannelAltTarget() {
        return this.isAuxActive() ? this.lx.engine.mixer.focusedChannel : this.lx.engine.mixer.focusedChannelAux;
    }

    private void noteReceived(MidiNote note, boolean on) {
        int pitch = note.getPitch();
        switch (pitch) {
            case 98: {
                this.shiftOn = on;
                this.updateColorKnobs();
                return;
            }
            case 103: {
                if (on) {
                    if (this.shiftOn) {
                        this.lx.engine.clips.gridViewExpanded.toggle();
                    } else if (this.deviceLockOn) {
                        this.deviceLockOn = false;
                        this.sendNoteOn(note.getChannel(), 63, 0);
                        this.resetPaletteVars();
                    } else {
                        this.lx.engine.clips.gridMode.increment();
                    }
                    this.updateGridMode();
                }
                return;
            }
            case 63: {
                if (on) {
                    this.deviceLockOn = !this.deviceLockOn;
                    this.sendNoteOn(note.getChannel(), pitch, APC40Mk2.LED_ON(this.deviceLockOn));
                    if (!this.deviceLockOn) {
                        this.resetPaletteVars();
                    }
                    this.updateGridMode();
                }
                return;
            }
            case 90: {
                if (on) {
                    this.lx.engine.tempo.enabled.toggle();
                }
                return;
            }
            case 99: {
                if (this.rainbowMode) {
                    this.rainbowMode = false;
                    this.focusColor = null;
                    this.colorClipboard = null;
                    this.sendChannelFocus();
                    this.sendChannelGrid();
                } else {
                    this.lx.engine.tempo.tap.setValue(on);
                }
                return;
            }
            case 100: {
                this.lx.engine.tempo.nudgeDown.setValue(on);
                return;
            }
            case 101: {
                this.lx.engine.tempo.nudgeUp.setValue(on);
                return;
            }
        }
        switch (pitch) {
            case 52: {
                if (this.gridMode != GridMode.PATTERN || this.isPerformanceMode()) break;
                this.sendNoteOn(note.getChannel(), pitch, APC40Mk2.LED_ON(on));
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.sendNoteOn(note.getChannel(), pitch, APC40Mk2.LED_ON(on));
            }
        }
        if (LXUtils.inRange(pitch, 82, 86) && this.gridMode != GridMode.PALETTE) {
            this.sendNoteOn(note.getChannel(), pitch, on ? 122 : 0);
        }
        if (on) {
            switch (pitch) {
                case 91: {
                    this.setAux(false);
                    return;
                }
                case 93: {
                    this.setAux(true);
                    return;
                }
                case 102: {
                    this.lx.engine.performanceMode.toggle();
                    return;
                }
                case 80: {
                    this.getFocusedChannelTarget().setValue(this.lx.engine.mixer.channels.size());
                    if (!this.isAuxActive()) {
                        this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                    }
                    return;
                }
                case 97: {
                    if (this.shiftOn) {
                        this.deviceListener.focusedDevice.previousChannel();
                        if (!this.isAuxActive()) {
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                        }
                    } else {
                        this.mixerSurface.decrementChannel();
                    }
                    return;
                }
                case 96: {
                    if (this.shiftOn) {
                        this.deviceListener.focusedDevice.nextChannel();
                        if (!this.isAuxActive()) {
                            this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                        }
                    } else {
                        this.mixerSurface.incrementChannel();
                    }
                    return;
                }
                case 94: {
                    if (this.shiftOn) {
                        LXBus bus = this.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.decrement(1, false);
                        }
                    } else {
                        this.mixerSurface.decrementGridOffset();
                    }
                    return;
                }
                case 95: {
                    if (this.shiftOn) {
                        LXBus bus = this.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.increment(1, false);
                        }
                    } else {
                        this.mixerSurface.incrementGridOffset();
                    }
                    return;
                }
                case 64: {
                    if (this.isAuxActive()) {
                        this.lx.engine.mixer.auxA.toggle();
                    } else {
                        this.lx.engine.mixer.cueA.toggle();
                    }
                    return;
                }
                case 65: {
                    if (this.isAuxActive()) {
                        this.lx.engine.mixer.auxB.toggle();
                    } else {
                        this.lx.engine.mixer.cueB.toggle();
                    }
                    return;
                }
                case 81: {
                    if (this.gridMode == GridMode.PALETTE) {
                        this.colorClipboard = null;
                        this.focusColor = null;
                    } else if (this.gridMode == GridMode.CLIP) {
                        this.lx.engine.clips.stopClips.trigger();
                    } else if (this.gridMode == GridMode.PATTERN) {
                        if (this.isPerformanceMode()) {
                            this.getFocusedChannelAltTarget().setValue(this.lx.engine.mixer.channels.size());
                            if (this.isAuxActive()) {
                                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.masterBus);
                            }
                        } else {
                            this.lx.engine.clips.launchPatternCycle.trigger();
                        }
                    }
                    return;
                }
            }
            if (LXUtils.inRange(pitch, 82, 86)) {
                int index = pitch - 82;
                if (this.gridMode == GridMode.PALETTE) {
                    boolean colorChanged = false;
                    LXSwatch swatch = this.getSwatch(-1);
                    if (index > swatch.colors.size() - 1 && index < 5) {
                        swatch.addColor();
                        colorChanged = true;
                    }
                    this.focusColor = swatch.getColor(index);
                    if (this.colorClipboard != null) {
                        this.focusColor.primary.setColor(this.colorClipboard);
                        colorChanged = true;
                    }
                    if (colorChanged) {
                        this.sendSwatch(-1);
                    }
                } else if (this.gridMode == GridMode.PATTERN) {
                    this.lx.engine.clips.launchPatternScene(index + this.mixerSurface.getGridPatternOffset());
                } else if (this.gridMode == GridMode.CLIP) {
                    this.lx.engine.clips.launchScene(index + this.mixerSurface.getGridClipOffset());
                }
                return;
            }
            if (pitch >= 0 && pitch <= 39) {
                int channelIndex = (pitch - 0) % 8;
                int index = 4 - (pitch - 0) / 8;
                if (this.rainbowMode) {
                    this.colorClipboard = this.rainbowGridColor(channelIndex, index);
                    return;
                }
                if (this.gridMode == GridMode.PALETTE) {
                    LXSwatch swatch = this.getSwatch(channelIndex);
                    if (swatch != null) {
                        if (index < swatch.colors.size()) {
                            this.focusColor = swatch.colors.get(index);
                            this.colorClipboard = this.focusColor.primary.getColor();
                        } else if (index < 5) {
                            LXDynamicColor color = swatch.addColor();
                            if (this.colorClipboard != null) {
                                color.primary.setColor(this.colorClipboard);
                            } else {
                                this.colorClipboard = color.primary.getColor();
                            }
                            this.sendSwatch(channelIndex);
                        } else {
                            this.colorClipboard = null;
                        }
                    }
                    return;
                }
                LXAbstractChannel channel = this.getChannel(channelIndex);
                if (channel != null) {
                    if (this.gridMode == GridMode.PATTERN) {
                        if (channel instanceof LXChannel) {
                            LXChannel c = (LXChannel)channel;
                            int patternIndex = index + this.mixerSurface.getGridPatternOffset();
                            if (patternIndex < c.patterns.size()) {
                                c.focusedPattern.setValue(patternIndex);
                                if (!this.shiftOn) {
                                    if (c.isPlaylist()) {
                                        c.getPattern((int)patternIndex).launch.trigger();
                                    } else {
                                        c.getPattern((int)patternIndex).enabled.toggle();
                                    }
                                }
                            }
                        }
                    } else {
                        int clipIndex = index + this.mixerSurface.getGridClipOffset();
                        LXClip clip = channel.getClip(clipIndex);
                        if (clip == null) {
                            clip = channel.addClip(clipIndex, this.lx.engine.clips.clipSnapshotDefault.isOn() ^ this.shiftOn);
                        } else if (this.shiftOn) {
                            clip.loop.toggle();
                        } else {
                            clip.triggerAction(true);
                        }
                    }
                }
                return;
            }
        }
        if (this.gridMode == GridMode.PALETTE) {
            if (this.rainbowMode || !on) {
                return;
            }
            switch (note.getPitch()) {
                case 52: {
                    int swatchNum = note.getChannel();
                    if (swatchNum >= this.lx.engine.palette.swatches.size()) break;
                    this.lx.engine.palette.setSwatch(this.lx.engine.palette.swatches.get(swatchNum));
                    this.sendSwatch(-1);
                    break;
                }
                default: {
                    LXMidiEngine.error("APC40mk2 in DEV_LOCK received unmapped note: " + String.valueOf(note));
                }
            }
            return;
        }
        LXAbstractChannel channel = this.getChannel(note);
        if (channel == null) {
            return;
        }
        if (note.getPitch() == 49) {
            this.handleMultiCue(on, this.cueState, channel, false);
            return;
        }
        if (note.getPitch() == 48 && this.isPerformanceMode()) {
            this.handleMultiCue(on, this.auxState, channel, true);
            return;
        }
        if (!on) {
            return;
        }
        switch (note.getPitch()) {
            case 48: {
                if (this.isPerformanceMode()) break;
                channel.arm.toggle();
                break;
            }
            case 50: {
                channel.enabled.toggle();
                break;
            }
            case 66: {
                if (this.shiftOn) {
                    channel.blendMode.increment();
                    break;
                }
                channel.crossfadeGroup.increment();
                break;
            }
            case 52: {
                if (this.gridMode == GridMode.CLIP) {
                    channel.stopClips.trigger();
                    break;
                }
                if (this.gridMode != GridMode.PATTERN) break;
                if (this.isPerformanceMode()) {
                    this.getFocusedChannelAltTarget().setValue(channel.getIndex());
                    break;
                }
                if (!channel.isPlaylist()) break;
                ((LXChannel)channel).launchPatternCycle.trigger();
                break;
            }
            case 51: {
                if (this.shiftOn) {
                    if (!(channel instanceof LXChannel)) break;
                    ((LXChannel)channel).autoCycleEnabled.toggle();
                    break;
                }
                this.getFocusedChannelTarget().setValue(channel.getIndex());
                if (this.isAuxActive()) break;
                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                break;
            }
            case 62: {
                if (!this.isDeviceControl()) break;
                this.deviceListener.onDeviceOnOff();
                break;
            }
            case 58: {
                if (!this.isDeviceControl()) break;
                this.deviceListener.focusedDevice.previousDevice();
                break;
            }
            case 59: {
                if (!this.isDeviceControl()) break;
                this.deviceListener.focusedDevice.nextDevice();
                break;
            }
            case 60: 
            case 61: {
                if (!this.isDeviceControl()) break;
                this.deviceListener.incrementBank(pitch == 60 ? -1 : 1);
                break;
            }
            default: {
                LXMidiEngine.error("APC40mk2 received unmapped note: " + String.valueOf(note));
            }
        }
    }

    private void handleMultiCue(boolean on, CueState state, LXAbstractChannel channel, boolean aux) {
        BooleanParameter active;
        BooleanParameter booleanParameter = active = aux ? channel.auxActive : channel.cueActive;
        if (on) {
            boolean alreadyOn = active.isOn();
            boolean bl = state.singleCueStartedOn = state.cueDown == 0 && alreadyOn;
            if (alreadyOn) {
                if (state.cueDown == 0) {
                    if (aux) {
                        this.lx.engine.mixer.enableChannelAux(channel, true);
                    } else {
                        this.lx.engine.mixer.enableChannelCue(channel, true);
                    }
                } else {
                    active.setValue(false);
                }
            } else if (aux) {
                this.lx.engine.mixer.enableChannelAux(channel, state.cueDown == 0);
            } else {
                this.lx.engine.mixer.enableChannelCue(channel, state.cueDown == 0);
            }
            ++state.cueDown;
        } else {
            state.cueDown = LXUtils.max(0, state.cueDown - 1);
            if (state.singleCueStartedOn) {
                active.setValue(false);
                state.singleCueStartedOn = false;
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 13: {
                if (this.gridMode == GridMode.PALETTE) {
                    if (this.rainbowMode) {
                        this.rainbowColumnOffset = (this.rainbowColumnOffset + cc.getRelative()) % 72;
                        this.focusColor = null;
                        this.colorClipboard = null;
                    } else {
                        this.rainbowMode = true;
                        this.sendChannelFocus();
                    }
                    this.sendRainbowPickerGrid();
                } else if (this.shiftOn) {
                    this.lx.engine.tempo.adjustBpm(0.1 * (double)cc.getRelative());
                } else {
                    this.lx.engine.tempo.adjustBpm(cc.getRelative());
                }
                return;
            }
            case 47: {
                if (this.focusColor == null) {
                    this.focusColor = this.lx.engine.palette.color;
                }
                LXListenableNormalizedParameter subparam = this.getActiveSubparameter(this.focusColor.primary);
                subparam.incrementValue(cc.getRelative());
                this.colorClipboard = this.focusColor.primary.getColor();
                if (this.gridMode == GridMode.PALETTE) {
                    if (this.rainbowMode) {
                        this.sendSwatch(-1);
                    } else {
                        this.sendSwatches();
                    }
                }
                return;
            }
            case 7: {
                int fader = cc.getChannel();
                if (this.channelFaders[fader] != null) {
                    this.channelFaders[fader].setValue(cc);
                }
                return;
            }
            case 14: {
                if (this.masterFaderEnabled.isOn()) {
                    this.masterFader.setValue(cc);
                }
                return;
            }
            case 15: {
                if (this.crossfaderEnabled.isOn()) {
                    this.crossfader.setValue(cc);
                }
                return;
            }
        }
        if (number >= 16 && number <= 24) {
            if (this.isDeviceControl()) {
                this.deviceListener.onKnob(number - 16, cc.getNormalized());
            } else {
                this.echoControlChange(cc);
            }
            return;
        }
        if (number >= 48 && number <= 55) {
            this.echoControlChange(cc);
            return;
        }
    }

    private void echoControlChange(MidiControlChange cc) {
        this.sendControlChange(cc.getChannel(), cc.getCC(), cc.getValue());
    }

    @Override
    public int getRemoteControlStart() {
        return 8 * this.deviceListener.bankNumber;
    }

    @Override
    public int getRemoteControlLength() {
        return 8;
    }

    @Override
    public boolean isRemoteControlAux() {
        return this.isAuxActive();
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        if (this.enabled.isOn()) {
            this.setApcMode((byte)64);
        }
        this.masterFader.dispose();
        this.crossfader.dispose();
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl fader = lXMidiParameterControlArray[n2];
            fader.dispose();
            ++n2;
        }
        this.deviceListener.dispose();
        this.mixerSurface.dispose();
        super.dispose();
    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final Map<LXPattern, PatternListener> patternListeners = new HashMap<LXPattern, PatternListener>();
        private final LXAbstractChannel channel;
        private final LXParameterListener onCompositeModeChanged = this::onCompositeModeChanged;
        private final Map<LXClip, ClipListener> clipListeners = new HashMap<LXClip, ClipListener>();

        private ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.addListener(this);
                c.compositeMode.addListener(this.onCompositeModeChanged);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.auxActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            channel.stopClips.pending.addListener(this);
            channel.hasRunningClip.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.patterns.forEach(pattern -> {
                    PatternListener patternListener = this.patternListeners.put((LXPattern)pattern, new PatternListener((LXPattern)pattern));
                });
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.registerClip(clip);
            }
        }

        private void dispose() {
            LXAbstractChannel lXAbstractChannel = this.channel;
            if (lXAbstractChannel instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel;
                c.removeListener(this);
                c.compositeMode.removeListener(this.onCompositeModeChanged);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.auxActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            this.channel.stopClips.pending.removeListener(this);
            this.channel.hasRunningClip.removeListener(this);
            LXAbstractChannel lXAbstractChannel2 = this.channel;
            if (lXAbstractChannel2 instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel2;
                c.focusedPattern.removeListener(this);
            }
            this.patternListeners.values().forEach(patternListener -> patternListener.dispose());
            this.patternListeners.clear();
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.unregisterClip(clip);
            }
        }

        private void onCompositeModeChanged(LXParameter p) {
            int index = APC40Mk2.this.mixerSurface.getIndex(this.channel);
            APC40Mk2.this.sendChannelPatterns(index, this.channel);
            APC40Mk2.this.sendDeviceOnOff();
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = APC40Mk2.this.mixerSurface.getIndex(this.channel);
            if (p == this.channel.cueActive) {
                APC40Mk2.this.sendNoteOn(index, 49, APC40Mk2.LED_ON(this.channel.cueActive.isOn()));
            } else if (p == this.channel.auxActive) {
                if (APC40Mk2.this.isPerformanceMode()) {
                    APC40Mk2.this.sendNoteOn(index, 48, APC40Mk2.LED_ON(this.channel.auxActive.isOn()));
                }
            } else if (p == this.channel.enabled) {
                APC40Mk2.this.sendNoteOn(index, 50, APC40Mk2.LED_ON(this.channel.enabled.isOn()));
            } else if (p == this.channel.crossfadeGroup) {
                APC40Mk2.this.sendNoteOn(index, 66, this.channel.crossfadeGroup.getValuei());
            } else if (p == this.channel.arm) {
                if (!APC40Mk2.this.isPerformanceMode()) {
                    APC40Mk2.this.sendNoteOn(index, 48, APC40Mk2.LED_ON(this.channel.arm.isOn()));
                }
                APC40Mk2.this.sendChannelClips(index, this.channel);
            } else if ((p == this.channel.stopClips.pending || p == this.channel.hasRunningClip) && APC40Mk2.this.gridMode == GridMode.CLIP) {
                APC40Mk2.this.sendChannelClipStop(index, this.channel);
            }
            LXAbstractChannel lXAbstractChannel = this.channel;
            if (lXAbstractChannel instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel;
                if (p == c.focusedPattern) {
                    APC40Mk2.this.sendChannelPatterns(index, c);
                }
            }
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            this.patternListeners.put(pattern, new PatternListener(pattern));
            APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            this.patternListeners.remove(pattern).dispose();
            APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
        }

        @Override
        public void patternEnabled(LXChannel channel, LXPattern pattern) {
            if (APC40Mk2.this.gridMode == GridMode.PATTERN && channel.isComposite()) {
                APC40Mk2.this.sendChannelPatterns(APC40Mk2.this.mixerSurface.getIndex(channel), channel);
            }
        }

        private void registerClip(LXClip clip) {
            if (this.clipListeners.containsKey(clip)) {
                throw new IllegalStateException("Registered clip twice on APC40Mk2.ChannelListener: " + String.valueOf(clip));
            }
            this.clipListeners.put(clip, new ClipListener(clip));
        }

        private void unregisterClip(LXClip clip) {
            this.clipListeners.remove(clip).dispose();
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            this.registerClip(clip);
            APC40Mk2.this.sendClip(APC40Mk2.this.mixerSurface.getIndex(this.channel), this.channel, clip.getIndex(), clip);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            this.unregisterClip(clip);
            APC40Mk2.this.sendChannelClips(APC40Mk2.this.mixerSurface.getIndex(this.channel), this.channel);
        }

        private class ClipListener
        implements LXParameterListener {
            private final LXClip clip;

            private ClipListener(LXClip clip) {
                this.clip = clip;
                clip.running.addListener(this);
                clip.loop.addListener(this);
                clip.launch.pending.addListener(this);
                clip.launchAutomation.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                APC40Mk2.this.sendClip(((ChannelListener)ChannelListener.this).APC40Mk2.this.mixerSurface.getIndex(ChannelListener.this.channel), ChannelListener.this.channel, this.clip.getIndex(), this.clip);
            }

            private void dispose() {
                this.clip.running.removeListener(this);
                this.clip.loop.removeListener(this);
                this.clip.launch.pending.removeListener(this);
                this.clip.launchAutomation.pending.removeListener(this);
            }
        }

        private class PatternListener
        implements LXParameterListener {
            private final LXPattern pattern;

            private PatternListener(LXPattern pattern) {
                this.pattern = pattern;
                this.pattern.launch.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                int index = ((ChannelListener)ChannelListener.this).APC40Mk2.this.mixerSurface.getIndex(ChannelListener.this.channel);
                APC40Mk2.this.sendChannelPatterns(index, ChannelListener.this.channel);
            }

            private void dispose() {
                this.pattern.launch.pending.removeListener(this);
            }
        }
    }

    private class CueState {
        private int cueDown = 0;
        private boolean singleCueStartedOn = false;

        private CueState() {
        }

        private void reset() {
            this.cueDown = 0;
            this.singleCueStartedOn = false;
        }
    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private int bankNumber = 0;
        private final LXListenableParameter[] knobs = new LXListenableParameter[8];

        private DeviceListener(LX lx) {
            Arrays.fill(this.knobs, null);
            this.focusedDevice = new FocusedDevice(lx, APC40Mk2.this, this);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        private void resend() {
            int i = 0;
            while (i < this.knobs.length) {
                LXListenableNormalizedParameter parameter = this.parameterForKnob(this.knobs[i]);
                if (parameter != null) {
                    APC40Mk2.this.sendControlChange(0, 24 + i, parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2);
                    double normalized = parameter.getBaseNormalized();
                    APC40Mk2.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
                } else {
                    APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                }
                ++i;
            }
            this.sendDeviceOnOff();
        }

        private void sendDeviceOnOff() {
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                isEnabled = effect.enabled.isOn();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                isEnabled = this.isPatternEnabled(pattern);
            }
            APC40Mk2.this.sendNoteOn(0, 62, APC40Mk2.LED_ON(isEnabled));
        }

        private void clearKnobsAfter(int i) {
            while (i < this.knobs.length) {
                APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                ++i;
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device == device) {
                return;
            }
            this.unregisterDevice();
            this.device = device;
            this.bankNumber = 0;
            boolean isEnabled = false;
            if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                effect.enabled.addListener(this);
                isEnabled = effect.isEnabled();
            } else if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                pattern.enabled.addListener(this);
                isEnabled = this.isPatternEnabled(pattern);
            }
            if (this.device != null) {
                this.device.remoteControlsChanged.addListener(this);
            }
            APC40Mk2.this.sendNoteOn(0, 62, APC40Mk2.LED_ON(isEnabled));
            if (this.device == null) {
                this.clearKnobsAfter(0);
                return;
            }
            this.registerDeviceKnobs();
        }

        private boolean isPatternEnabled(LXPattern pattern) {
            switch (pattern.getChannel().compositeMode.getEnum()) {
                case BLEND: {
                    return pattern.enabled.isOn();
                }
            }
            return pattern == pattern.getChannel().getTargetPattern();
        }

        private void incrementBank(int amt) {
            int test;
            if (this.device != null && (test = this.bankNumber + amt) >= 0 && test * 8 < this.device.getRemoteControls().length) {
                this.bankNumber = test;
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
                this.focusedDevice.updateRemoteControlFocus();
            }
        }

        private void registerDeviceKnobs() {
            int i = 0;
            int skip = this.bankNumber * 8;
            int s = 0;
            ArrayList<LXListenableParameter> uniqueParameters = new ArrayList<LXListenableParameter>();
            if (this.device instanceof LXEffect) {
                uniqueParameters.add(((LXEffect)this.device).enabled);
            } else if (this.device instanceof LXPattern) {
                uniqueParameters.add(((LXPattern)this.device).enabled);
            }
            LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.device.getRemoteControls();
            int n = lXListenableNormalizedParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                LXListenableNormalizedParameter parameter = lXListenableNormalizedParameterArray[n2];
                if (s++ >= skip) {
                    if (i >= this.knobs.length) break;
                    if (parameter == null) {
                        this.knobs[i] = null;
                        APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                        ++i;
                    } else {
                        LXListenableNormalizedParameter knobParam;
                        AggregateParameter parent = parameter.getParentParameter();
                        if (parent != null) {
                            this.knobs[i] = parent;
                            if (!uniqueParameters.contains(parent)) {
                                uniqueParameters.add(parent);
                                for (LXListenableParameter subParam : parent.subparameters.values()) {
                                    subParam.addListener(this);
                                }
                            }
                        } else {
                            this.knobs[i] = parameter;
                            if (!uniqueParameters.contains(parameter)) {
                                uniqueParameters.add(parameter);
                                parameter.addListener(this);
                            }
                        }
                        if ((knobParam = this.parameterForKnob(this.knobs[i])) == null) {
                            APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                        } else {
                            int ledStyle = parameter.getPolarity() == LXParameter.Polarity.BIPOLAR ? 3 : 2;
                            APC40Mk2.this.sendControlChange(0, 24 + i, ledStyle);
                            this.sendKnobValue(knobParam, i);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            this.clearKnobsAfter(i);
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            LXPattern pattern;
            LXEffect effect = this.device instanceof LXEffect ? (LXEffect)this.device : null;
            LXPattern lXPattern = pattern = this.device instanceof LXPattern ? (LXPattern)this.device : null;
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
            } else {
                if (effect != null && parameter == effect.enabled) {
                    APC40Mk2.this.sendNoteOn(0, 62, APC40Mk2.LED_ON(effect.enabled.isOn()));
                } else if (pattern != null && parameter == pattern.enabled) {
                    APC40Mk2.this.sendNoteOn(0, 62, APC40Mk2.LED_ON(this.isPatternEnabled(pattern)));
                }
                int i = 0;
                while (i < this.knobs.length) {
                    LXListenableNormalizedParameter knobParam = this.parameterForKnob(this.knobs[i]);
                    if (parameter == knobParam) {
                        this.sendKnobValue(knobParam, i);
                    }
                    ++i;
                }
            }
        }

        private void sendKnobValue(LXListenableNormalizedParameter knobParam, int i) {
            double normalized = knobParam.getBaseNormalized();
            if (knobParam instanceof DiscreteParameter && knobParam.isWrappable()) {
                DiscreteParameter discrete = (DiscreteParameter)knobParam;
                normalized = ((float)(discrete.getBaseValuei() - discrete.getMinValue()) + 0.5f) / (float)discrete.getRange();
            }
            APC40Mk2.this.sendControlChange(0, 16 + i, (int)(normalized * 127.0));
        }

        private LXListenableNormalizedParameter parameterForKnob(LXListenableParameter knob) {
            if (knob == null || knob instanceof LXListenableNormalizedParameter) {
                return (LXListenableNormalizedParameter)knob;
            }
            if (knob instanceof AggregateParameter) {
                return APC40Mk2.this.getActiveSubparameter((AggregateParameter)knob);
            }
            return null;
        }

        private void onDeviceOnOff() {
            if (this.device instanceof LXPattern) {
                LXPattern pattern = (LXPattern)this.device;
                LXChannel channel = pattern.getChannel();
                if (channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
                    pattern.enabled.toggle();
                } else {
                    pattern.getChannel().goPatternIndex(pattern.getIndex());
                }
                APC40Mk2.this.sendNoteOn(0, 62, APC40Mk2.LED_ON(this.isPatternEnabled(pattern)));
            } else if (this.device instanceof LXEffect) {
                LXEffect effect = (LXEffect)this.device;
                if (!effect.locked.isOn()) {
                    effect.enabled.toggle();
                }
            }
        }

        private void onKnob(int index, double normalized) {
            LXListenableNormalizedParameter knobParam;
            LXListenableParameter knob = this.knobs[index];
            if (knob == null) {
                return;
            }
            if (knob instanceof LinkedColorParameter) {
                int palIndex;
                LinkedColorParameter lcp = (LinkedColorParameter)knob;
                if (APC40Mk2.this.focusColor != null && (palIndex = APC40Mk2.this.lx.engine.palette.swatch.colors.indexOf(APC40Mk2.this.focusColor)) >= 0) {
                    lcp.mode.setValue((Object)LinkedColorParameter.Mode.PALETTE);
                    lcp.index.setValue(palIndex + 1);
                    return;
                }
                if (APC40Mk2.this.colorClipboard != null) {
                    lcp.mode.setValue((Object)LinkedColorParameter.Mode.STATIC);
                }
            }
            if (knob instanceof ColorParameter) {
                ColorParameter cp = (ColorParameter)knob;
                if (APC40Mk2.this.focusColor != null) {
                    cp.setColor(APC40Mk2.this.focusColor.getColor());
                    return;
                }
                if (APC40Mk2.this.colorClipboard != null) {
                    cp.setColor(APC40Mk2.this.colorClipboard);
                    return;
                }
            }
            if ((knobParam = this.parameterForKnob(knob)).isWrappable()) {
                if (normalized == 0.0) {
                    normalized = 1.0;
                } else if (normalized == 1.0) {
                    normalized = 0.0;
                }
            }
            knobParam.setNormalized(normalized);
        }

        private void unregisterDevice() {
            if (this.device != null) {
                if (this.device instanceof LXEffect) {
                    LXEffect effect = (LXEffect)this.device;
                    effect.enabled.removeListener(this);
                } else if (this.device instanceof LXPattern) {
                    LXPattern pattern = (LXPattern)this.device;
                    pattern.enabled.removeListener(this);
                }
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
                this.device = null;
            }
        }

        private void unregisterDeviceKnobs() {
            if (this.device != null) {
                ArrayList<LXListenableParameter> uniqueParameters = new ArrayList<LXListenableParameter>();
                if (this.device instanceof LXEffect) {
                    uniqueParameters.add(((LXEffect)this.device).enabled);
                } else if (this.device instanceof LXPattern) {
                    uniqueParameters.add(((LXPattern)this.device).enabled);
                }
                int i = 0;
                while (i < this.knobs.length) {
                    if (this.knobs[i] != null) {
                        if (this.knobs[i] instanceof AggregateParameter) {
                            AggregateParameter ap = (AggregateParameter)this.knobs[i];
                            if (!uniqueParameters.contains(ap)) {
                                uniqueParameters.add(ap);
                                for (LXListenableParameter sub : ap.subparameters.values()) {
                                    sub.removeListener(this);
                                }
                            }
                        } else if (!uniqueParameters.contains(this.knobs[i])) {
                            uniqueParameters.add(this.knobs[i]);
                            this.knobs[i].removeListener(this);
                        }
                        this.knobs[i] = null;
                        APC40Mk2.this.sendControlChange(0, 16 + i, 0);
                        APC40Mk2.this.sendControlChange(0, 24 + i, 0);
                    }
                    ++i;
                }
            }
        }

        private void dispose() {
            this.unregisterDevice();
        }
    }

    public static enum GridMode {
        PATTERN(LXClipEngine.GridMode.PATTERNS),
        CLIP(LXClipEngine.GridMode.CLIPS),
        PALETTE(null);

        public final LXClipEngine.GridMode engineGridMode;

        public boolean isMixerSurface() {
            switch (this) {
                case PATTERN: 
                case CLIP: {
                    return true;
                }
            }
            return false;
        }

        private GridMode(LXClipEngine.GridMode engineGridMode) {
            this.engineGridMode = engineGridMode;
        }
    }
}

