/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEngine;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.FocusedChannel;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiParameterControl;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.midi.surface.MixerSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class APCminiSurface
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final int NUM_CHANNELS = 8;
    public static final double PARAMETER_INCREMENT_AMOUNT = 0.1;
    public static final int CHANNEL_FADER = 48;
    public static final int CHANNEL_FADER_MAX = 55;
    public static final int MASTER_FADER = 56;
    private final Note NOTE = new Note();
    public static final int CLIP_LAUNCH = 0;
    public static final int CLIP_LAUNCH_ROWS = 8;
    public static final int CLIP_LAUNCH_COLUMNS = 8;
    public static final int CLIP_LAUNCH_NUM = 64;
    public static final int CLIP_LAUNCH_MAX = 63;
    public static final int PARAMETER_COLUMNS = 8;
    public static final int PARAMETER_COLUMN_STRIDE = 1;
    public static final int PARAMETER_ROWS = 2;
    public static final int PARAMETER_ROW_STRIDE = -4;
    public static final int PARAMETER_NUM = 16;
    public static final int PARAMETER_START = 56;
    public static final int MIDI_CHANNEL_SINGLE = 0;
    public static final int LED_OFF = 0;
    public static final int LED_ON = 1;
    public static final int LED_BLINK = 2;
    private final Led LED = new Led();
    private ChannelButtonMode channelButtonMode = ChannelButtonMode.FOCUS;
    private GridMode gridMode = GridMode.PATTERNS;
    private boolean shiftOn = false;
    private final Map<LXAbstractChannel, ChannelListener> channelListeners = new HashMap<LXAbstractChannel, ChannelListener>();
    private final DeviceListener deviceListener = new DeviceListener();
    protected final MixerSurface mixerSurface;
    private final MixerSurface.Listener mixerSurfaceListener = new MixerSurface.Listener(){

        @Override
        public void onChannelChanged(int index, LXAbstractChannel channel, LXAbstractChannel previousChannel) {
            if (previousChannel != null && !APCminiSurface.this.mixerSurface.contains(previousChannel)) {
                APCminiSurface.this.unregisterChannel(previousChannel);
            }
            if (channel != null) {
                APCminiSurface.this.registerChannel(channel);
                APCminiSurface.this.channelFaders[index].setTarget(channel.fader);
            } else {
                APCminiSurface.this.channelFaders[index].setTarget(null);
            }
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(index, channel);
            } else if (APCminiSurface.this.isGridModeClips()) {
                APCminiSurface.this.sendChannelClips(index, channel);
            }
            APCminiSurface.this.sendChannelButton(index, channel);
        }

        @Override
        public void onGridOffsetChanged() {
            APCminiSurface.this.sendGrid();
        }
    };
    private final FocusedChannel focusedChannel;
    public final BooleanParameter masterFaderEnabled = new BooleanParameter("Master Fader", true).setDescription("Whether the master fader is enabled");
    public final EnumParameter<LXMidiParameterControl.Mode> faderMode = new EnumParameter<LXMidiParameterControl.Mode>("Fader Mode", LXMidiParameterControl.Mode.PICKUP).setDescription("Parameter control mode for faders");
    private final LXMidiParameterControl masterFader;
    private final LXMidiParameterControl[] channelFaders;
    private boolean isRegistered = false;
    private final LXParameterListener gridModeListener = p -> {
        if (this.gridMode != GridMode.PARAMETERS) {
            this.setGridMode(this.lx.engine.clips.gridMode.getEnum());
        }
    };

    protected abstract NoteDefinitions getNoteDefinitions();

    private static int LED_ON(boolean condition) {
        return condition ? 1 : 0;
    }

    protected abstract LedDefinitions getLedDefinitions();

    public APCminiSurface(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.masterFader = new LXMidiParameterControl(this.lx.engine.mixer.masterBus.fader);
        this.channelFaders = new LXMidiParameterControl[8];
        int i = 0;
        while (i < 8) {
            this.channelFaders[i] = new LXMidiParameterControl();
            ++i;
        }
        this.updateFaderMode();
        this.mixerSurface = new MixerSurface(lx, this.mixerSurfaceListener, 8, 8).setGridMode(this.gridMode.engineGridMode);
        this.focusedChannel = new FocusedChannel(lx, bus -> this.sendChannelFocus());
        this.addSetting("masterFaderEnabled", this.masterFaderEnabled);
        this.addSetting("faderMode", this.faderMode);
        this.addState("channelNumber", this.mixerSurface.channelNumber);
        this.addState("gridClipOffset", this.mixerSurface.gridClipOffset);
        this.addState("gridPatternOffset", this.mixerSurface.gridPatternOffset);
    }

    private boolean isGridModePatterns() {
        return this.gridMode == GridMode.PATTERNS;
    }

    private boolean isGridModeClips() {
        return this.gridMode == GridMode.CLIPS;
    }

    private boolean isGridModeParameters() {
        return this.gridMode == GridMode.PARAMETERS;
    }

    private void setGridMode(LXClipEngine.GridMode gridMode) {
        this.setGridMode(gridMode, true);
    }

    private void setGridMode(LXClipEngine.GridMode gridMode, boolean send) {
        this.setGridMode(switch (gridMode) {
            case LXClipEngine.GridMode.PATTERNS -> GridMode.PATTERNS;
            case LXClipEngine.GridMode.CLIPS -> GridMode.CLIPS;
            default -> throw new MatchException(null, null);
        }, send);
    }

    private void setGridMode(GridMode gridMode) {
        this.setGridMode(gridMode, true);
    }

    private void setGridMode(GridMode gridMode, boolean send) {
        if (this.gridMode != gridMode) {
            this.gridMode = gridMode;
            this.mixerSurface.setGridMode(gridMode.engineGridMode);
            if (gridMode.engineGridMode != null) {
                this.lx.engine.clips.gridMode.setValue((Object)gridMode.engineGridMode);
            }
            if (send) {
                this.sendGridModeButtons();
                this.sendGrid();
            }
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.faderMode) {
            this.updateFaderMode();
        }
    }

    private void updateFaderMode() {
        LXMidiParameterControl.Mode mode = this.faderMode.getEnum();
        this.masterFader.setMode(mode);
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl channelFader = lXMidiParameterControlArray[n2];
            channelFader.setMode(mode);
            ++n2;
        }
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.register();
        } else if (this.isRegistered) {
            this.unregister();
        }
    }

    @Override
    protected void onReconnect() {
        this.initialize();
    }

    private void initialize() {
        this.sendGrid();
        this.sendChannelButtonRow();
        this.sendSceneLaunchButtons();
    }

    private void sendGrid() {
        if (this.isGridModeParameters()) {
            this.deviceListener.resend();
        } else {
            int i = 0;
            while (i < 8) {
                LXAbstractChannel channel = this.getChannel(i);
                switch (this.gridMode) {
                    case PATTERNS: {
                        this.sendChannelPatterns(i, channel);
                        break;
                    }
                    case CLIPS: {
                        this.sendChannelClips(i, channel);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void sendChannelPatterns(int index, LXAbstractChannel bus) {
        if (index < 0 || index >= 8) {
            return;
        }
        if (bus instanceof LXChannel) {
            LXChannel channel = (LXChannel)bus;
            int baseIndex = this.mixerSurface.getGridPatternOffset();
            int endIndex = channel.patterns.size() - baseIndex;
            int focusedIndex = channel.patterns.size() == 0 ? -1 : channel.focusedPattern.getValuei() - baseIndex;
            int activeIndex = channel.getActivePatternIndex() - baseIndex;
            int nextIndex = channel.getNextPatternIndex() - baseIndex;
            boolean isPlaylist = channel.isPlaylist();
            int y = 0;
            while (y < 8) {
                int behavior = this.LED.DEFAULT_MULTI_BEHAVIOR;
                int note = 0 + 8 * (7 - y) + index;
                int color = 0;
                if (isPlaylist) {
                    boolean isPending;
                    boolean bl = isPending = y < endIndex && channel.patterns.get((int)(baseIndex + y)).launch.pending.isOn();
                    if (y == activeIndex) {
                        behavior = this.LED.PATTERN_ACTIVE_BEHAVIOR;
                        color = this.LED.PATTERN_ACTIVE_COLOR;
                    } else if (y == nextIndex) {
                        behavior = this.LED.PATTERN_TRANSITION_BEHAVIOR;
                        color = this.LED.PATTERN_TRANSITION_COLOR;
                    } else if (isPending) {
                        behavior = this.LED.PATTERN_PENDING_BEHAVIOR;
                        color = this.LED.PATTERN_PENDING_COLOR;
                    } else if (y == focusedIndex) {
                        behavior = this.LED.PATTERN_FOCUSED_BEHAVIOR;
                        color = this.LED.PATTERN_FOCUSED_COLOR;
                    } else if (y < endIndex) {
                        behavior = this.LED.PATTERN_INACTIVE_BEHAVIOR;
                        color = this.LED.PATTERN_INACTIVE_COLOR;
                    }
                } else if (y < endIndex) {
                    if (channel.patterns.get((int)(baseIndex + y)).enabled.isOn()) {
                        behavior = this.LED.PATTERN_ENABLED_BEHAVIOR;
                        color = this.LED.PATTERN_ENABLED_COLOR;
                    } else if (y == focusedIndex) {
                        behavior = this.LED.PATTERN_DISABLED_FOCUSED_BEHAVIOR;
                        color = this.LED.PATTERN_DISABLED_FOCUSED_COLOR;
                    } else {
                        behavior = this.LED.PATTERN_DISABLED_BEHAVIOR;
                        color = this.LED.PATTERN_DISABLED_COLOR;
                    }
                }
                this.sendNoteOn(behavior, note, color);
                ++y;
            }
        } else {
            int y = 0;
            while (y < 8) {
                this.sendNoteOn(this.LED.DEFAULT_MULTI_BEHAVIOR, 0 + 8 * (7 - y) + index, 0);
                ++y;
            }
        }
    }

    private void sendChannelClips(int index, LXAbstractChannel channel) {
        if (index < 0 || index >= 8) {
            return;
        }
        int i = 0;
        while (i < 8) {
            LXClip clip = null;
            if (channel != null) {
                clip = channel.getClip(i + this.mixerSurface.getGridClipOffset());
            }
            this.sendClip(index, channel, i, clip);
            ++i;
        }
    }

    private void sendClip(int channelIndex, LXAbstractChannel channel, int clipIndex, LXClip clip) {
        if (!this.isGridModeClips() || channelIndex < 0 || channelIndex >= 8 || clipIndex < 0 || clipIndex >= 8) {
            return;
        }
        int behavior = this.LED.DEFAULT_MULTI_BEHAVIOR;
        int color = 0;
        int pitch = 0 + channelIndex + 8 * (7 - clipIndex);
        if (channel != null && clip != null) {
            if (clip.isPending()) {
                if (channel.arm.isOn()) {
                    behavior = this.LED.CLIP_RECORD_PENDING_BEHAVIOR;
                    color = this.LED.CLIP_RECORD_PENDING_COLOR;
                } else {
                    behavior = this.LED.CLIP_PLAY_PENDING_BEHAVIOR;
                    color = this.LED.CLIP_PLAY_PENDING_COLOR;
                }
            } else if (channel.arm.isOn()) {
                if (clip.isRunning()) {
                    behavior = this.LED.CLIP_RECORD_BEHAVIOR;
                    color = this.LED.CLIP_RECORD_COLOR;
                } else {
                    behavior = this.LED.CLIP_ARM_BEHAVIOR;
                    color = this.LED.CLIP_ARM_COLOR;
                }
            } else if (clip.isRunning()) {
                behavior = this.LED.CLIP_PLAY_BEHAVIOR;
                color = this.LED.CLIP_PLAY_COLOR;
            } else {
                behavior = this.LED.CLIP_INACTIVE_BEHAVIOR;
                color = this.LED.CLIP_INACTIVE_COLOR;
            }
        }
        this.sendNoteOn(behavior, pitch, color);
    }

    private void sendChannelFocus() {
        if (this.channelButtonMode == ChannelButtonMode.FOCUS && !this.shiftOn) {
            this.sendChannelButtonRow();
        }
    }

    private void setChannelButtonMode(ChannelButtonMode mode) {
        this.channelButtonMode = mode;
        this.sendSceneLaunchButtons();
    }

    private void sendChannelButtonRow() {
        int i = 0;
        while (i < 8) {
            this.sendChannelButton(i, this.getChannel(i));
            ++i;
        }
    }

    private void sendSceneLaunchButtons() {
        if (this.shiftOn) {
            this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON_MODE_FOCUS, APCminiSurface.LED_ON(this.channelButtonMode == ChannelButtonMode.FOCUS));
            this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON_MODE_ENABLED, APCminiSurface.LED_ON(this.channelButtonMode == ChannelButtonMode.ENABLED));
            this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON_MODE_CUE, APCminiSurface.LED_ON(this.channelButtonMode == ChannelButtonMode.CUE));
            this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON_MODE_ARM, APCminiSurface.LED_ON(this.channelButtonMode == ChannelButtonMode.ARM));
            this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON_MODE_CLIP_STOP, APCminiSurface.LED_ON(this.channelButtonMode == ChannelButtonMode.CLIP_STOP));
            this.sendNoteOn(0, this.NOTE.DRUM_MODE, 0);
            this.sendNoteOn(0, this.NOTE.NOTE_MODE, 0);
            this.sendNoteOn(0, this.NOTE.STOP_ALL_CLIPS, 0);
        } else {
            this.clearSceneLaunchButtons();
        }
    }

    private void clearSceneLaunchButtons() {
        this.sendNoteOn(0, this.NOTE.CLIP_STOP, 0);
        this.sendNoteOn(0, this.NOTE.SOLO, 0);
        this.sendNoteOn(0, this.NOTE.MUTE, 0);
        this.sendNoteOn(0, this.NOTE.REC_ARM, 0);
        this.sendNoteOn(0, this.NOTE.SELECT, 0);
        this.sendNoteOn(0, this.NOTE.DRUM_MODE, 0);
        this.sendNoteOn(0, this.NOTE.NOTE_MODE, 0);
        this.sendNoteOn(0, this.NOTE.STOP_ALL_CLIPS, 0);
    }

    private void sendGridModeButtons() {
        if (this.shiftOn) {
            this.sendNoteOn(0, this.NOTE.GRID_MODE_PATTERNS, APCminiSurface.LED_ON(this.gridMode == GridMode.PATTERNS));
            this.sendNoteOn(0, this.NOTE.GRID_MODE_CLIPS, APCminiSurface.LED_ON(this.gridMode == GridMode.CLIPS));
            this.sendNoteOn(0, this.NOTE.FADER_CTRL_SEND, 0);
            this.sendNoteOn(0, this.NOTE.GRID_MODE_PARAMETERS, APCminiSurface.LED_ON(this.gridMode == GridMode.PARAMETERS));
        }
    }

    private void sendChannelButton(int index, LXAbstractChannel channel) {
        int noteNumber = index + this.NOTE.CHANNEL_BUTTON;
        int color = 0;
        if (this.shiftOn) {
            if (noteNumber == this.NOTE.GRID_MODE_PATTERNS) {
                color = APCminiSurface.LED_ON(this.gridMode == GridMode.PATTERNS);
            } else if (noteNumber == this.NOTE.GRID_MODE_CLIPS) {
                color = APCminiSurface.LED_ON(this.gridMode == GridMode.CLIPS);
            } else if (noteNumber == this.NOTE.GRID_MODE_PARAMETERS) {
                color = APCminiSurface.LED_ON(this.gridMode == GridMode.PARAMETERS);
            }
        } else if (channel != null) {
            switch (this.channelButtonMode) {
                case FOCUS: {
                    color = APCminiSurface.LED_ON(channel == this.lx.engine.mixer.getFocusedChannel());
                    break;
                }
                case ENABLED: {
                    color = APCminiSurface.LED_ON(channel.enabled.isOn());
                    break;
                }
                case CUE: {
                    color = APCminiSurface.LED_ON(channel.cueActive.isOn());
                    break;
                }
                case ARM: {
                    color = APCminiSurface.LED_ON(channel.arm.isOn());
                    break;
                }
                case CLIP_STOP: {
                    color = channel.stopClips.pending.isOn() ? this.LED.CLIP_STOP_PENDING_COLOR : APCminiSurface.LED_ON(channel.hasRunningClip.isOn());
                }
            }
        }
        this.sendNoteOn(0, this.NOTE.CHANNEL_BUTTON + index, color);
    }

    private void register() {
        this.isRegistered = true;
        this.setGridMode(this.lx.engine.clips.gridMode.getEnum(), false);
        this.mixerSurface.register();
        this.focusedChannel.register();
        this.deviceListener.focusedDevice.register();
        this.lx.engine.clips.gridMode.addListener(this.gridModeListener);
    }

    private void unregister() {
        this.isRegistered = false;
        this.mixerSurface.unregister();
        this.deviceListener.focusedDevice.unregister();
        this.focusedChannel.unregister();
        this.lx.engine.clips.gridMode.removeListener(this.gridModeListener);
        this.clearSceneLaunchButtons();
    }

    private void registerChannel(LXAbstractChannel channel) {
        if (!this.channelListeners.containsKey(channel)) {
            this.channelListeners.put(channel, new ChannelListener(channel));
        }
    }

    private void unregisterChannel(LXAbstractChannel channel) {
        ChannelListener channelListener = this.channelListeners.remove(channel);
        if (channelListener != null) {
            channelListener.dispose();
        }
    }

    private LXAbstractChannel getChannel(int index) {
        return this.mixerSurface.getChannel(index);
    }

    private void noteReceived(MidiNote note, boolean on) {
        int pitch = note.getPitch();
        if (pitch == this.NOTE.SHIFT) {
            this.shiftOn = on;
            this.sendChannelButtonRow();
            this.sendSceneLaunchButtons();
            return;
        }
        if (LXUtils.inRange(pitch, 0, 63)) {
            if (on) {
                this.gridNoteOnReceived(note);
            }
            return;
        }
        if (LXUtils.inRange(pitch, this.NOTE.SCENE_LAUNCH, this.NOTE.SCENE_LAUNCH_MAX)) {
            this.sceneLaunchNoteReceived(note, on);
            return;
        }
        if (LXUtils.inRange(pitch, this.NOTE.CHANNEL_BUTTON, this.NOTE.CHANNEL_BUTTON_MAX)) {
            this.channelButtonNoteReceived(note, on);
            return;
        }
        LXMidiEngine.error("APCminiMk2 received unmapped note: " + String.valueOf(note));
    }

    private void gridNoteOnReceived(MidiNote note) {
        int pitch = note.getPitch();
        int channelIndex = (pitch - 0) % 8;
        int index = 7 - (pitch - 0) / 8;
        if (this.isGridModeParameters()) {
            if (!this.shiftOn) {
                this.deviceListener.onParameterButton(channelIndex, index);
            }
        } else {
            LXAbstractChannel channel = this.getChannel(channelIndex);
            if (channel != null) {
                if (this.isGridModeClips()) {
                    int clipIndex = index + this.mixerSurface.getGridClipOffset();
                    LXClip clip = channel.getClip(clipIndex);
                    if (clip == null) {
                        clip = channel.addClip(clipIndex, this.lx.engine.clips.clipSnapshotDefault.isOn() ^ this.shiftOn);
                    } else if (this.shiftOn) {
                        this.lx.engine.clips.setFocusedClip(clip);
                    } else {
                        clip.triggerAction(true);
                    }
                } else if (this.isGridModePatterns() && channel instanceof LXChannel) {
                    LXChannel c = (LXChannel)channel;
                    int target = index + this.mixerSurface.getGridPatternOffset();
                    if (target < c.patterns.size()) {
                        c.focusedPattern.setValue(target);
                        if (!this.shiftOn) {
                            if (channel.isPlaylist()) {
                                c.getPattern((int)target).launch.trigger();
                            } else {
                                c.getPattern((int)target).enabled.toggle();
                            }
                        }
                    }
                }
            }
        }
    }

    private void sceneLaunchNoteReceived(MidiNote note, boolean on) {
        int pitch = note.getPitch();
        if (this.shiftOn) {
            if (pitch == this.NOTE.STOP_ALL_CLIPS) {
                this.sendNoteOn(0, pitch, APCminiSurface.LED_ON(on));
            }
            if (on) {
                if (pitch == this.NOTE.CHANNEL_BUTTON_MODE_FOCUS) {
                    this.setChannelButtonMode(ChannelButtonMode.FOCUS);
                } else if (pitch == this.NOTE.CHANNEL_BUTTON_MODE_ENABLED) {
                    this.setChannelButtonMode(ChannelButtonMode.ENABLED);
                } else if (pitch == this.NOTE.CHANNEL_BUTTON_MODE_CUE) {
                    this.setChannelButtonMode(ChannelButtonMode.CUE);
                } else if (pitch == this.NOTE.CHANNEL_BUTTON_MODE_ARM) {
                    this.setChannelButtonMode(ChannelButtonMode.ARM);
                } else if (pitch == this.NOTE.CHANNEL_BUTTON_MODE_CLIP_STOP) {
                    this.setChannelButtonMode(ChannelButtonMode.CLIP_STOP);
                } else if (pitch != this.NOTE.DRUM_MODE && pitch != this.NOTE.NOTE_MODE && pitch == this.NOTE.STOP_ALL_CLIPS) {
                    if (this.isGridModePatterns()) {
                        this.lx.engine.clips.launchPatternCycle.trigger();
                    } else if (this.isGridModeClips()) {
                        this.lx.engine.clips.stopClips.trigger();
                    }
                }
            }
        } else {
            this.sendNoteOn(0, pitch, APCminiSurface.LED_ON(on));
            if (this.isGridModeClips()) {
                this.lx.engine.clips.launchScene(pitch - this.NOTE.SCENE_LAUNCH + this.mixerSurface.getGridClipOffset());
            } else if (this.isGridModePatterns()) {
                this.lx.engine.clips.launchPatternScene(pitch - this.NOTE.SCENE_LAUNCH + this.mixerSurface.getGridPatternOffset());
            }
        }
    }

    private void channelButtonNoteReceived(MidiNote note, boolean on) {
        LXAbstractChannel channel;
        int pitch = note.getPitch();
        if (this.shiftOn) {
            if (this.NOTE.isSelect(pitch)) {
                this.sendNoteOn(0, pitch, APCminiSurface.LED_ON(on));
            }
            if (on) {
                if (pitch == this.NOTE.SELECT_LEFT) {
                    if (this.isGridModeParameters()) {
                        this.deviceListener.focusedDevice.previousDevice();
                    } else {
                        this.mixerSurface.channelNumber.decrement();
                    }
                } else if (pitch == this.NOTE.SELECT_RIGHT) {
                    if (this.isGridModeParameters()) {
                        this.deviceListener.focusedDevice.nextDevice();
                    } else {
                        this.mixerSurface.channelNumber.increment();
                    }
                } else if (pitch == this.NOTE.SELECT_UP) {
                    if (this.isGridModeParameters()) {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.decrement(1, false);
                        }
                    } else {
                        this.mixerSurface.decrementGridOffset();
                    }
                } else if (pitch == this.NOTE.SELECT_DOWN) {
                    if (this.isGridModeParameters()) {
                        LXBus bus = this.lx.engine.mixer.getFocusedChannel();
                        if (bus instanceof LXChannel) {
                            ((LXChannel)bus).focusedPattern.increment(1, false);
                        }
                    } else {
                        this.mixerSurface.incrementGridOffset();
                    }
                } else if (pitch == this.NOTE.GRID_MODE_PATTERNS) {
                    this.setGridMode(GridMode.PATTERNS);
                } else if (pitch == this.NOTE.GRID_MODE_CLIPS) {
                    this.setGridMode(GridMode.CLIPS);
                } else if (pitch == this.NOTE.GRID_MODE_PARAMETERS) {
                    this.setGridMode(GridMode.PARAMETERS);
                }
            }
        } else if (on && (channel = this.getChannel(pitch - this.NOTE.CHANNEL_BUTTON)) != null) {
            switch (this.channelButtonMode) {
                case FOCUS: {
                    this.lx.engine.mixer.focusedChannel.setValue(channel.getIndex());
                    this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                    break;
                }
                case ENABLED: {
                    channel.enabled.toggle();
                    break;
                }
                case CUE: {
                    channel.cueActive.toggle();
                    break;
                }
                case ARM: {
                    channel.arm.toggle();
                    break;
                }
                case CLIP_STOP: {
                    if (this.isGridModePatterns()) {
                        if (!channel.isPlaylist()) break;
                        ((LXChannel)channel).launchPatternCycle.trigger();
                        break;
                    }
                    if (!this.isGridModeClips()) break;
                    channel.stopClips.trigger();
                }
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int number = cc.getCC();
        switch (number) {
            case 56: {
                if (this.masterFaderEnabled.isOn()) {
                    this.masterFader.setValue(cc);
                }
                return;
            }
        }
        if (number >= 48 && number <= 55) {
            int channel = number - 48;
            this.channelFaders[channel].setValue(cc);
            return;
        }
        LXMidiEngine.error("APCmini unmapped control change: " + String.valueOf(cc));
    }

    @Override
    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
        this.masterFader.dispose();
        LXMidiParameterControl[] lXMidiParameterControlArray = this.channelFaders;
        int n = this.channelFaders.length;
        int n2 = 0;
        while (n2 < n) {
            LXMidiParameterControl fader = lXMidiParameterControlArray[n2];
            fader.dispose();
            ++n2;
        }
        this.deviceListener.dispose();
        this.mixerSurface.dispose();
        super.dispose();
    }

    public static enum ChannelButtonMode {
        ARM,
        CLIP_STOP,
        CUE,
        ENABLED,
        FOCUS;

    }

    private class ChannelListener
    implements LXChannel.Listener,
    LXBus.ClipListener,
    LXParameterListener {
        private final Map<LXPattern, PatternListener> patternListeners = new HashMap<LXPattern, PatternListener>();
        private final LXAbstractChannel channel;
        private final LXParameterListener onCompositeModeChanged = this::onCompositeModeChanged;
        private final Map<LXClip, ClipListener> clipListeners = new HashMap<LXClip, ClipListener>();

        ChannelListener(LXAbstractChannel channel) {
            this.channel = channel;
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.addListener(this);
                c.compositeMode.addListener(this.onCompositeModeChanged);
            } else {
                channel.addListener(this);
            }
            channel.addClipListener(this);
            channel.cueActive.addListener(this);
            channel.enabled.addListener(this);
            channel.crossfadeGroup.addListener(this);
            channel.arm.addListener(this);
            channel.stopClips.pending.addListener(this);
            channel.hasRunningClip.addListener(this);
            if (channel instanceof LXChannel) {
                LXChannel c = (LXChannel)channel;
                c.focusedPattern.addListener(this);
                c.patterns.forEach(pattern -> {
                    PatternListener patternListener = this.patternListeners.put((LXPattern)pattern, new PatternListener((LXPattern)pattern));
                });
            }
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.registerClip(clip);
            }
        }

        private void onCompositeModeChanged(LXParameter p) {
            if (APCminiSurface.this.isGridModePatterns()) {
                int index = APCminiSurface.this.mixerSurface.getIndex(this.channel);
                APCminiSurface.this.sendChannelPatterns(index, this.channel);
            }
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            int index = APCminiSurface.this.mixerSurface.getIndex(this.channel);
            if (p == this.channel.cueActive) {
                if (APCminiSurface.this.channelButtonMode == ChannelButtonMode.CUE) {
                    APCminiSurface.this.sendNoteOn(0, APCminiSurface.this.NOTE.CHANNEL_BUTTON + index, APCminiSurface.LED_ON(this.channel.cueActive.isOn()));
                }
            } else if (p == this.channel.enabled) {
                if (APCminiSurface.this.channelButtonMode == ChannelButtonMode.ENABLED) {
                    APCminiSurface.this.sendNoteOn(0, APCminiSurface.this.NOTE.CHANNEL_BUTTON + index, APCminiSurface.LED_ON(this.channel.enabled.isOn()));
                }
            } else if (p == this.channel.crossfadeGroup) {
                APCminiSurface.this.sendNoteOn(0, APCminiSurface.this.NOTE.CHANNEL_BUTTON + index, 0);
            } else if (p == this.channel.arm) {
                APCminiSurface.this.sendNoteOn(0, APCminiSurface.this.NOTE.CHANNEL_BUTTON + index, APCminiSurface.LED_ON(this.channel.arm.isOn()));
                APCminiSurface.this.sendChannelClips(index, this.channel);
            } else if (p == this.channel.stopClips.pending || p == this.channel.hasRunningClip) {
                APCminiSurface.this.sendChannelButton(index, this.channel);
            }
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                if (p == c.focusedPattern) {
                    APCminiSurface.this.sendChannelPatterns(index, c);
                }
            }
        }

        public void dispose() {
            LXAbstractChannel lXAbstractChannel = this.channel;
            if (lXAbstractChannel instanceof LXChannel) {
                LXChannel c = (LXChannel)lXAbstractChannel;
                c.removeListener(this);
                c.compositeMode.removeListener(this.onCompositeModeChanged);
            } else {
                this.channel.removeListener(this);
            }
            this.channel.removeClipListener(this);
            this.channel.cueActive.removeListener(this);
            this.channel.enabled.removeListener(this);
            this.channel.crossfadeGroup.removeListener(this);
            this.channel.arm.removeListener(this);
            this.channel.stopClips.pending.removeListener(this);
            this.channel.hasRunningClip.removeListener(this);
            if (this.channel instanceof LXChannel) {
                LXChannel c = (LXChannel)this.channel;
                c.focusedPattern.removeListener(this);
            }
            this.patternListeners.values().forEach(patternListener -> patternListener.dispose());
            this.patternListeners.clear();
            for (LXClip clip : this.channel.clips) {
                if (clip == null) continue;
                this.unregisterClip(clip);
            }
        }

        private void registerClip(LXClip clip) {
            if (this.clipListeners.containsKey(clip)) {
                throw new IllegalStateException("Registered clip twice on APC40Mk2.ChannelListener: " + String.valueOf(clip));
            }
            this.clipListeners.put(clip, new ClipListener(clip));
        }

        private void unregisterClip(LXClip clip) {
            this.clipListeners.remove(clip).dispose();
        }

        @Override
        public void patternAdded(LXChannel channel, LXPattern pattern) {
            this.patternListeners.put(pattern, new PatternListener(pattern));
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            this.patternListeners.remove(pattern).dispose();
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void patternMoved(LXChannel channel, LXPattern pattern) {
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void patternDidChange(LXChannel channel, LXPattern pattern) {
            if (APCminiSurface.this.isGridModePatterns()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void patternEnabled(LXChannel channel, LXPattern pattern) {
            if (APCminiSurface.this.isGridModePatterns() && channel.isComposite()) {
                APCminiSurface.this.sendChannelPatterns(APCminiSurface.this.mixerSurface.getIndex(channel), channel);
            }
        }

        @Override
        public void clipAdded(LXBus bus, LXClip clip) {
            this.registerClip(clip);
            APCminiSurface.this.sendClip(APCminiSurface.this.mixerSurface.getIndex(this.channel), this.channel, clip.getIndex(), clip);
        }

        @Override
        public void clipRemoved(LXBus bus, LXClip clip) {
            this.unregisterClip(clip);
            APCminiSurface.this.sendChannelClips(APCminiSurface.this.mixerSurface.getIndex(this.channel), this.channel);
        }

        private class ClipListener
        implements LXParameterListener {
            private final LXClip clip;

            private ClipListener(LXClip clip) {
                this.clip = clip;
                clip.running.addListener(this);
                clip.launch.pending.addListener(this);
                clip.launchAutomation.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                APCminiSurface.this.sendClip(((ChannelListener)ChannelListener.this).APCminiSurface.this.mixerSurface.getIndex(ChannelListener.this.channel), ChannelListener.this.channel, this.clip.getIndex(), this.clip);
            }

            private void dispose() {
                this.clip.running.removeListener(this);
                this.clip.launch.pending.removeListener(this);
                this.clip.launchAutomation.pending.removeListener(this);
            }
        }

        private class PatternListener
        implements LXParameterListener {
            private final LXPattern pattern;

            private PatternListener(LXPattern pattern) {
                this.pattern = pattern;
                this.pattern.launch.pending.addListener(this);
            }

            @Override
            public void onParameterChanged(LXParameter parameter) {
                int index = ((ChannelListener)ChannelListener.this).APCminiSurface.this.mixerSurface.getIndex(ChannelListener.this.channel);
                APCminiSurface.this.sendChannelPatterns(index, ChannelListener.this.channel);
            }

            private void dispose() {
                this.pattern.launch.pending.removeListener(this);
            }
        }
    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[16];

        private DeviceListener() {
            Arrays.fill(this.knobs, null);
            this.focusedDevice = new FocusedDevice(APCminiSurface.this.lx, APCminiSurface.this, this);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device != device) {
                this.unregisterDevice(false);
                this.device = device;
                int i = 0;
                if (this.device != null) {
                    LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.getDeviceRemoteControls();
                    int n = lXListenableNormalizedParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LXListenableNormalizedParameter parameter = lXListenableNormalizedParameterArray[n2];
                        if (i >= this.knobs.length) break;
                        this.knobs[i] = parameter;
                        int patternButton = this.getParameterButton(i);
                        if (parameter != null) {
                            parameter.addListener(this);
                            if (APCminiSurface.this.isGridModeParameters()) {
                                APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_INCREMENT_BEHAVIOR, patternButton, APCminiSurface.this.LED.PARAMETER_INCREMENT_COLOR);
                                APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_DECREMENT_BEHAVIOR, patternButton - 8, APCminiSurface.this.LED.PARAMETER_DECREMENT_COLOR);
                                if (parameter.isDefault()) {
                                    APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_ISDEFAULT_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_ISDEFAULT_COLOR);
                                } else {
                                    APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_RESET_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_RESET_COLOR);
                                }
                                APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 24, 0);
                            }
                        } else if (APCminiSurface.this.isGridModeParameters()) {
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton, 0);
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 8, 0);
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 16, 0);
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 24, 0);
                        }
                        ++i;
                        ++n2;
                    }
                    this.device.controlSurfaceSemaphore.increment();
                }
                if (APCminiSurface.this.isGridModeParameters()) {
                    while (i < this.knobs.length) {
                        int patternButton = this.getParameterButton(i);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton, 0);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 8, 0);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 16, 0);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 24, 0);
                        ++i;
                    }
                }
            }
        }

        private LXListenableNormalizedParameter[] getDeviceRemoteControls() {
            return this.device.getRemoteControls();
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            if (APCminiSurface.this.isGridModeParameters()) {
                int i = 0;
                while (i < this.knobs.length) {
                    if (parameter == this.knobs[i]) {
                        int patternButton = this.getParameterButton(i);
                        if (((LXListenableNormalizedParameter)parameter).isDefault()) {
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_ISDEFAULT_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_ISDEFAULT_COLOR);
                            break;
                        }
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_RESET_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_RESET_COLOR);
                        break;
                    }
                    ++i;
                }
            }
        }

        private void resend() {
            if (APCminiSurface.this.isGridModeParameters()) {
                int i = 0;
                while (i < this.knobs.length) {
                    LXListenableNormalizedParameter parameter = this.knobs[i];
                    int patternButton = this.getParameterButton(i);
                    if (parameter != null) {
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_INCREMENT_BEHAVIOR, patternButton, APCminiSurface.this.LED.PARAMETER_INCREMENT_COLOR);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_DECREMENT_BEHAVIOR, patternButton - 8, APCminiSurface.this.LED.PARAMETER_DECREMENT_COLOR);
                        if (parameter.isDefault()) {
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_ISDEFAULT_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_ISDEFAULT_COLOR);
                        } else {
                            APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.PARAMETER_RESET_BEHAVIOR, patternButton - 16, APCminiSurface.this.LED.PARAMETER_RESET_COLOR);
                        }
                    } else {
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton, 0);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 8, 0);
                        APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 16, 0);
                    }
                    APCminiSurface.this.sendNoteOn(APCminiSurface.this.LED.DEFAULT_MULTI_BEHAVIOR, patternButton - 24, 0);
                    ++i;
                }
            }
        }

        private int getParameterButton(int index) {
            int row = index / 8;
            int column = index % 8;
            return 56 + row * 8 * -4 + column * 1;
        }

        private void onParameterButton(int columnIndex, int rowIndex) {
            int paramIndex = 0;
            int button = rowIndex;
            while (button > 3) {
                paramIndex += 8;
                button -= 4;
            }
            LXListenableNormalizedParameter param = this.knobs[paramIndex += columnIndex];
            if (param != null) {
                switch (button) {
                    case 0: {
                        if (param instanceof BooleanParameter) {
                            ((BooleanParameter)param).setValue(true);
                            break;
                        }
                        if (param instanceof DiscreteParameter) {
                            ((DiscreteParameter)param).increment();
                            break;
                        }
                        param.setNormalized(param.getNormalized() + 0.1);
                        break;
                    }
                    case 1: {
                        if (param instanceof BooleanParameter) {
                            ((BooleanParameter)param).setValue(false);
                            break;
                        }
                        if (param instanceof DiscreteParameter) {
                            ((DiscreteParameter)param).decrement();
                            break;
                        }
                        param.setNormalized(param.getNormalized() - 0.1);
                        break;
                    }
                    case 2: {
                        param.reset();
                    }
                }
            }
        }

        private void unregisterDevice(boolean clearParams) {
            if (this.device != null) {
                int i = 0;
                while (i < this.knobs.length) {
                    if (this.knobs[i] != null) {
                        this.knobs[i].removeListener(this);
                        this.knobs[i] = null;
                        if (APCminiSurface.this.isGridModeParameters() && clearParams) {
                            int patternButton = this.getParameterButton(i);
                            APCminiSurface.this.sendNoteOn(0, patternButton, 0);
                            APCminiSurface.this.sendNoteOn(0, patternButton - 8, 0);
                            APCminiSurface.this.sendNoteOn(0, patternButton - 16, 0);
                            APCminiSurface.this.sendNoteOn(0, patternButton - 24, 0);
                        }
                    }
                    ++i;
                }
                this.device.controlSurfaceSemaphore.decrement();
            }
            this.device = null;
        }

        private void dispose() {
            this.unregisterDevice(true);
        }
    }

    public static enum GridMode {
        PATTERNS(LXClipEngine.GridMode.PATTERNS),
        CLIPS(LXClipEngine.GridMode.CLIPS),
        PARAMETERS(null);

        public final LXClipEngine.GridMode engineGridMode;

        private GridMode(LXClipEngine.GridMode engineGridMode) {
            this.engineGridMode = engineGridMode;
        }
    }

    private final class Led {
        public final int DEFAULT_MULTI_BEHAVIOR;
        public final int PARAMETER_INCREMENT_BEHAVIOR;
        public final int PARAMETER_INCREMENT_COLOR;
        public final int PARAMETER_DECREMENT_BEHAVIOR;
        public final int PARAMETER_DECREMENT_COLOR;
        public final int PARAMETER_ISDEFAULT_BEHAVIOR;
        public final int PARAMETER_ISDEFAULT_COLOR;
        public final int PARAMETER_RESET_BEHAVIOR;
        public final int PARAMETER_RESET_COLOR;
        public final int PATTERN_ACTIVE_BEHAVIOR;
        public final int PATTERN_ACTIVE_COLOR;
        public final int PATTERN_ENABLED_BEHAVIOR;
        public final int PATTERN_ENABLED_COLOR;
        public final int PATTERN_DISABLED_BEHAVIOR;
        public final int PATTERN_DISABLED_COLOR;
        public final int PATTERN_DISABLED_FOCUSED_BEHAVIOR;
        public final int PATTERN_DISABLED_FOCUSED_COLOR;
        public final int PATTERN_FOCUSED_BEHAVIOR;
        public final int PATTERN_FOCUSED_COLOR;
        public final int PATTERN_INACTIVE_BEHAVIOR;
        public final int PATTERN_INACTIVE_COLOR;
        public final int PATTERN_TRANSITION_BEHAVIOR;
        public final int PATTERN_TRANSITION_COLOR;
        public final int PATTERN_PENDING_BEHAVIOR;
        public final int PATTERN_PENDING_COLOR;
        public final int CLIP_RECORD_BEHAVIOR;
        public final int CLIP_RECORD_COLOR;
        public final int CLIP_RECORD_PENDING_BEHAVIOR;
        public final int CLIP_RECORD_PENDING_COLOR;
        public final int CLIP_ARM_BEHAVIOR;
        public final int CLIP_ARM_COLOR;
        public final int CLIP_INACTIVE_BEHAVIOR;
        public final int CLIP_INACTIVE_COLOR;
        public final int CLIP_PLAY_BEHAVIOR;
        public final int CLIP_PLAY_COLOR;
        public final int CLIP_PLAY_PENDING_BEHAVIOR;
        public final int CLIP_PLAY_PENDING_COLOR;
        public final int CLIP_STOP_PENDING_COLOR;

        private Led() {
            LedDefinitions def = APCminiSurface.this.getLedDefinitions();
            this.DEFAULT_MULTI_BEHAVIOR = def.getDefaultMultiBehavior();
            this.PARAMETER_INCREMENT_BEHAVIOR = def.getParameterIncrementBehavior();
            this.PARAMETER_INCREMENT_COLOR = def.getParameterIncrementColor();
            this.PARAMETER_DECREMENT_BEHAVIOR = def.getParameterDecrementBehavior();
            this.PARAMETER_DECREMENT_COLOR = def.getParameterDecrementColor();
            this.PARAMETER_ISDEFAULT_BEHAVIOR = def.getParameterIsDefaultBehavior();
            this.PARAMETER_ISDEFAULT_COLOR = def.getParameterIsDefaultColor();
            this.PARAMETER_RESET_BEHAVIOR = def.getParameterResetBehavior();
            this.PARAMETER_RESET_COLOR = def.getParameterResetColor();
            this.PATTERN_ACTIVE_BEHAVIOR = def.getPatternActiveBehavior();
            this.PATTERN_ACTIVE_COLOR = def.getPatternActiveColor();
            this.PATTERN_ENABLED_BEHAVIOR = def.getPatternEnabledBehavior();
            this.PATTERN_ENABLED_COLOR = def.getPatternEnabledColor();
            this.PATTERN_DISABLED_BEHAVIOR = def.getPatternDisabledBehavior();
            this.PATTERN_DISABLED_COLOR = def.getPatternDisabledColor();
            this.PATTERN_DISABLED_FOCUSED_BEHAVIOR = def.getPatternDisabledFocusedBehavior();
            this.PATTERN_DISABLED_FOCUSED_COLOR = def.getPatternDisabledFocusedColor();
            this.PATTERN_FOCUSED_BEHAVIOR = def.getPatternFocusedBehavior();
            this.PATTERN_FOCUSED_COLOR = def.getPatternFocusedColor();
            this.PATTERN_INACTIVE_BEHAVIOR = def.getPatternInactiveBehavior();
            this.PATTERN_INACTIVE_COLOR = def.getPatternInactiveColor();
            this.PATTERN_TRANSITION_BEHAVIOR = def.getPatternTransitionBehavior();
            this.PATTERN_TRANSITION_COLOR = def.getPatternTransitionColor();
            this.PATTERN_PENDING_BEHAVIOR = def.getPatternPendingBehavior();
            this.PATTERN_PENDING_COLOR = def.getPatternPendingColor();
            this.CLIP_RECORD_BEHAVIOR = def.getClipRecordBehavior();
            this.CLIP_RECORD_COLOR = def.getClipRecordColor();
            this.CLIP_RECORD_PENDING_BEHAVIOR = def.getClipRecordPendingBehavior();
            this.CLIP_RECORD_PENDING_COLOR = def.getClipRecordPendingColor();
            this.CLIP_ARM_BEHAVIOR = def.getClipArmBehavior();
            this.CLIP_ARM_COLOR = def.getClipArmColor();
            this.CLIP_INACTIVE_BEHAVIOR = def.getClipInactiveBehavior();
            this.CLIP_INACTIVE_COLOR = def.getClipInactiveColor();
            this.CLIP_PLAY_BEHAVIOR = def.getClipPlayBehavior();
            this.CLIP_PLAY_COLOR = def.getClipPlayColor();
            this.CLIP_PLAY_PENDING_BEHAVIOR = def.getClipPlayPendingBehavior();
            this.CLIP_PLAY_PENDING_COLOR = def.getClipPlayPendingColor();
            this.CLIP_STOP_PENDING_COLOR = def.getClipStopPendingColor();
        }
    }

    static interface LedDefinitions {
        public int getDefaultMultiBehavior();

        public int getParameterIncrementBehavior();

        public int getParameterIncrementColor();

        public int getParameterDecrementBehavior();

        public int getParameterDecrementColor();

        public int getParameterIsDefaultBehavior();

        public int getParameterIsDefaultColor();

        public int getParameterResetBehavior();

        public int getParameterResetColor();

        public int getPatternActiveBehavior();

        public int getPatternActiveColor();

        public int getPatternEnabledBehavior();

        public int getPatternEnabledColor();

        public int getPatternDisabledBehavior();

        public int getPatternDisabledColor();

        public int getPatternDisabledFocusedBehavior();

        public int getPatternDisabledFocusedColor();

        public int getPatternFocusedBehavior();

        public int getPatternFocusedColor();

        public int getPatternInactiveBehavior();

        public int getPatternInactiveColor();

        public int getPatternTransitionBehavior();

        public int getPatternTransitionColor();

        public int getPatternPendingBehavior();

        public int getPatternPendingColor();

        public int getClipRecordBehavior();

        public int getClipRecordColor();

        public int getClipRecordPendingBehavior();

        public int getClipRecordPendingColor();

        public int getClipArmBehavior();

        public int getClipArmColor();

        public int getClipInactiveBehavior();

        public int getClipInactiveColor();

        public int getClipPlayBehavior();

        public int getClipPlayColor();

        public int getClipPlayPendingBehavior();

        public int getClipPlayPendingColor();

        public int getClipStopPendingColor();
    }

    private class Note {
        public final int SHIFT;
        public final int CLIP_STOP;
        public final int SOLO;
        public final int MUTE;
        public final int REC_ARM;
        public final int SELECT;
        public final int DRUM_MODE;
        public final int NOTE_MODE;
        public final int STOP_ALL_CLIPS;
        public final int FADER_CTRL_VOLUME;
        public final int FADER_CTRL_PAN;
        public final int FADER_CTRL_SEND;
        public final int FADER_CTRL_DEVICE;
        public final int SELECT_UP;
        public final int SELECT_DOWN;
        public final int SELECT_LEFT;
        public final int SELECT_RIGHT;
        public final int CHANNEL_BUTTON;
        public final int CHANNEL_BUTTON_MAX;
        public final int GRID_MODE_PATTERNS;
        public final int GRID_MODE_CLIPS;
        public final int GRID_MODE_PARAMETERS;
        public static final int SCENE_LAUNCH_NUM = 8;
        public final int SCENE_LAUNCH;
        public final int SCENE_LAUNCH_MAX;
        public final int CHANNEL_BUTTON_MODE_FOCUS;
        public final int CHANNEL_BUTTON_MODE_ENABLED;
        public final int CHANNEL_BUTTON_MODE_CUE;
        public final int CHANNEL_BUTTON_MODE_ARM;
        public final int CHANNEL_BUTTON_MODE_CLIP_STOP;

        private Note() {
            NoteDefinitions def = APCminiSurface.this.getNoteDefinitions();
            this.SHIFT = def.getShift();
            this.CLIP_STOP = def.getClipStop();
            this.SOLO = def.getSolo();
            this.MUTE = def.getMute();
            this.REC_ARM = def.getRecArm();
            this.SELECT = def.getSelect();
            this.DRUM_MODE = def.getDrumMode();
            this.NOTE_MODE = def.getNoteMode();
            this.STOP_ALL_CLIPS = def.getStopAllClips();
            this.CHANNEL_BUTTON_MODE_FOCUS = this.SELECT;
            this.CHANNEL_BUTTON_MODE_ENABLED = this.MUTE;
            this.CHANNEL_BUTTON_MODE_CUE = this.SOLO;
            this.CHANNEL_BUTTON_MODE_ARM = this.REC_ARM;
            this.CHANNEL_BUTTON_MODE_CLIP_STOP = this.CLIP_STOP;
            this.SCENE_LAUNCH = this.CLIP_STOP;
            this.SCENE_LAUNCH_MAX = this.SCENE_LAUNCH + 8 - 1;
            this.FADER_CTRL_VOLUME = def.getFaderCtrlVolume();
            this.FADER_CTRL_PAN = def.getFaderCtrlPan();
            this.FADER_CTRL_SEND = def.getFaderCtrlSend();
            this.FADER_CTRL_DEVICE = def.getFaderCtrlDevice();
            this.SELECT_UP = def.getSelectUp();
            this.SELECT_DOWN = def.getSelectDown();
            this.SELECT_LEFT = def.getSelectLeft();
            this.SELECT_RIGHT = def.getSelectRight();
            this.GRID_MODE_PATTERNS = this.FADER_CTRL_VOLUME;
            this.GRID_MODE_CLIPS = this.FADER_CTRL_PAN;
            this.GRID_MODE_PARAMETERS = this.FADER_CTRL_DEVICE;
            this.CHANNEL_BUTTON = def.getChannelButton();
            this.CHANNEL_BUTTON_MAX = this.CHANNEL_BUTTON + 8 - 1;
        }

        public boolean isSelect(int pitch) {
            return pitch == this.SELECT_UP || pitch == this.SELECT_DOWN || pitch == this.SELECT_LEFT || pitch == this.SELECT_RIGHT;
        }
    }

    static interface NoteDefinitions {
        public int getShift();

        public int getClipStop();

        public int getSolo();

        public int getMute();

        public int getRecArm();

        public int getSelect();

        public int getDrumMode();

        public int getNoteMode();

        public int getStopAllClips();

        public int getFaderCtrlVolume();

        public int getFaderCtrlPan();

        public int getFaderCtrlSend();

        public int getFaderCtrlDevice();

        public int getSelectUp();

        public int getSelectDown();

        public int getSelectLeft();

        public int getSelectRight();

        public int getChannelButton();
    }
}

