/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;

@LXMidiSurface.Name(value="Pioneer DJM-V10")
@LXMidiSurface.DeviceName(value="DJM-V10")
public class DJMV10
extends LXMidiSurface {
    public final EnumParameter<MidiChannel> midiChannel = new EnumParameter<MidiChannel>("MIDI Channel", MidiChannel.CH1);
    public static final Channel[] ALL_CHANNELS = Channel.values();
    public static final int SLIDE_LEFT = 0;
    public static final int SLIDE_CENTER = 64;
    public static final int SLIDE_RIGHT = 127;
    public static final int TRIM1 = 1;
    public static final int TRIM2 = 6;
    public static final int TRIM3 = 12;
    public static final int TRIM4 = 80;
    public static final int TRIM5 = 96;
    public static final int TRIM6 = 119;
    public static final int COMP1 = 70;
    public static final int COMP2 = 71;
    public static final int COMP3 = 72;
    public static final int COMP4 = 73;
    public static final int COMP5 = 74;
    public static final int COMP6 = 75;
    public static final int HIGH1 = 2;
    public static final int HIGH2 = 7;
    public static final int HIGH3 = 14;
    public static final int HIGH4 = 81;
    public static final int HIGH5 = 48;
    public static final int HIGH6 = 56;
    public static final int MID_HIGH1 = 3;
    public static final int MID_HIGH2 = 8;
    public static final int MID_HIGH3 = 15;
    public static final int MID_HIGH4 = 92;
    public static final int MID_HIGH5 = 49;
    public static final int MID_HIGH6 = 60;
    public static final int MID_LOW1 = 28;
    public static final int MID_LOW2 = 29;
    public static final int MID_LOW3 = 16;
    public static final int MID_LOW4 = 93;
    public static final int MID_LOW5 = 52;
    public static final int MID_LOW6 = 89;
    public static final int LOW1 = 4;
    public static final int LOW2 = 9;
    public static final int LOW3 = 21;
    public static final int LOW4 = 82;
    public static final int LOW5 = 63;
    public static final int LOW6 = 90;
    public static final int FILTER_RESONANCE = 44;
    public static final int FILTER1 = 32;
    public static final int FILTER2 = 33;
    public static final int FILTER3 = 34;
    public static final int FILTER4 = 35;
    public static final int FILTER5 = 36;
    public static final int FILTER6 = 37;
    public static final int FILTER_MASTER = 38;
    public static final int SEND1 = 5;
    public static final int SEND2 = 10;
    public static final int SEND3 = 22;
    public static final int SEND4 = 83;
    public static final int SEND5 = 101;
    public static final int SEND6 = 118;
    public static final int SEND_SIZE_FEEDBACK = 108;
    public static final int SEND_TIME = 105;
    public static final int SEND_TONE = 106;
    public static final int SEND_MASTER_MIX_LEVEL = 107;
    public static final int CHANNEL_FADER1 = 17;
    public static final int CHANNEL_FADER2 = 18;
    public static final int CHANNEL_FADER3 = 19;
    public static final int CHANNEL_FADER4 = 20;
    public static final int CHANNEL_FADER5 = 109;
    public static final int CHANNEL_FADER6 = 110;
    public static final int CROSSFADER = 11;
    public static final int CROSSFADER_ASSIGN1 = 65;
    public static final int CROSSFADER_ASSIGN2 = 66;
    public static final int CROSSFADER_ASSIGN3 = 67;
    public static final int CROSSFADER_ASSIGN4 = 68;
    public static final int CROSSFADER_ASSIGN5 = 84;
    public static final int CROSSFADER_ASSIGN6 = 88;
    public static final int CHANNEL_FADER_CURVE = 94;
    public static final int CROSSFADER_CURVE = 95;
    public static final int MASTER_FADER = 24;
    public static final int BOOTH_FADER = 25;
    public static final int BOOTH_EQ_HI = 111;
    public static final int BOOTH_EQ_LOW = 115;
    public static final int ISOLATOR_HI = 39;
    public static final int ISOLATOR_MID = 40;
    public static final int ISOLATOR_LOW = 41;
    public static final int MULTIIO_LEVEL = 113;
    public static final int XPAD_SLIDER = 116;
    public static final int XPAD_BEAT = 117;
    public static final int BEAT_LEFT = 76;
    public static final int BEAT_RIGHT = 77;
    public static final int BEAT_TAP_TEMPO = 78;
    public static final int TIME_MSB = 13;
    public static final int TIME_LSB = 45;
    public static final int FX_LOW = 104;
    public static final int FX_MID = 103;
    public static final int FX_HIGH = 102;
    public static final int FX_TYPE_DELAY = 42;
    public static final int FX_TYPE_ECHO = 55;
    public static final int FX_TYPE_PINGPONG = 51;
    public static final int FX_TYPE_SPIRAL = 43;
    public static final int FX_TYPE_HELIX = 62;
    public static final int FX_TYPE_REVERB = 54;
    public static final int FX_TYPE_SHIMMER = 58;
    public static final int FX_TYPE_FLANGER = 50;
    public static final int FX_TYPE_PHASER = 57;
    public static final int FX_TYPE_FILTER = 59;
    public static final int FX_TYPE_TRANS = 53;
    public static final int FX_TYPE_ROLL = 46;
    public static final int FX_TYPE_PITCH = 47;
    public static final int FX_TYPE_VINYLBRAKE = 61;
    public static final int FX_LEVEL = 91;
    public static final int FX_ONOFF = 114;
    public static final int MIC_TALKOVER = 79;
    public static final int MIC_EQ_LOW = 31;
    public static final int MIC_EQ_HIGH = 30;
    public static final int PHONES_MIX_A = 27;
    public static final int PHONES_LEVEL_A = 26;
    public static final int PHONES_MIX_B = 85;
    public static final int PHONES_LEVEL_B = 86;
    public static final int FILTER_LPF = 13;
    public static final int FILTER_HPF = 14;
    public static final int BEAT_FX_ASSIGN1 = 1;
    public static final int BEAT_FX_ASSIGN2 = 2;
    public static final int BEAT_FX_ASSIGN3 = 3;
    public static final int BEAT_FX_ASSIGN4 = 4;
    public static final int BEAT_FX_ASSIGN5 = 5;
    public static final int BEAT_FX_ASSIGN6 = 6;
    public static final int BEAT_FX_ASSIGN_MIC = 16;
    public static final int BEAT_FX_ASSIGN_MASTER = 17;
    public static final int SEND_MASTER_MIX = 44;
    public static final int SEND_SHORT_DELAY = 19;
    public static final int SEND_LONG_DELAY = 20;
    public static final int SEND_DUB_ECHO = 47;
    public static final int SEND_REVERB = 45;
    public static final int SEND_EXTERNAL1 = 46;
    public static final int SEND_EXTERNAL2 = 21;
    public static final int CUE1_A = 7;
    public static final int CUE2_A = 8;
    public static final int CUE3_A = 9;
    public static final int CUE4_A = 10;
    public static final int CUE5_A = 11;
    public static final int CUE6_A = 12;
    public static final int CUE_MASTER_A = 30;
    public static final int CUE_LINK_A = 31;
    public static final int PHONES_PRE_EQ_A = 32;
    public static final int PHONES_MONO_SPLIT_A = 33;
    public static final int CUE1_B = 22;
    public static final int CUE2_B = 23;
    public static final int CUE3_B = 24;
    public static final int CUE4_B = 25;
    public static final int CUE5_B = 26;
    public static final int CUE6_B = 27;
    public static final int CUE_MASTER_B = 28;
    public static final int CUE_LINK_B = 29;
    public static final int ISOLATOR_ON = 18;
    public static final int MULTIIO_CH_SELECT_MIC = 40;
    public static final int MULTIIO_CH_SELECT_1 = 34;
    public static final int MULTIIO_CH_SELECT_2 = 35;
    public static final int MULTIIO_CH_SELECT_3 = 36;
    public static final int MULTIIO_CH_SELECT_4 = 37;
    public static final int MULTIIO_CH_SELECT_5 = 38;
    public static final int MULTIIO_CH_SELECT_6 = 39;
    public static final int MULTIIO_CH_SELECT_MASTER = 41;
    public static final int MULTIIO_MODE = 48;
    public static final int AUTO_TAP = 42;
    public static final int QUANTIZE = 118;
    public static final int XPAD_TOUCH = 43;
    public static final int INPUT1_A = 53;
    public static final int INPUT1_B = 66;
    public static final int INPUT1_DIGITAL = 50;
    public static final int INPUT1_LINE = 51;
    public static final int INPUT1_PHONO = 52;
    public static final int INPUT1_BUILTIN = 81;
    public static final int INPUT1_EXT1 = 82;
    public static final int INPUT1_EXT2 = 83;
    public static final int INPUT2_A = 57;
    public static final int INPUT2_B = 68;
    public static final int INPUT2_DIGITAL = 54;
    public static final int INPUT2_LINE = 55;
    public static final int INPUT2_PHONO = 69;
    public static final int INPUT2_BUILTIN = 84;
    public static final int INPUT2_EXT1 = 85;
    public static final int INPUT2_EXT2 = 86;
    public static final int INPUT3_A = 61;
    public static final int INPUT3_B = 70;
    public static final int INPUT3_DIGITAL = 58;
    public static final int INPUT3_LINE = 59;
    public static final int INPUT3_PHONO = 60;
    public static final int INPUT3_BUILTIN = 87;
    public static final int INPUT3_EXT1 = 88;
    public static final int INPUT3_EXT2 = 89;
    public static final int INPUT4_A = 65;
    public static final int INPUT4_B = 72;
    public static final int INPUT4_DIGITAL = 62;
    public static final int INPUT4_LINE = 63;
    public static final int INPUT4_PHONO = 64;
    public static final int INPUT4_BUILTIN = 90;
    public static final int INPUT4_EXT1 = 91;
    public static final int INPUT4_EXT2 = 92;
    public static final int INPUT5_A = 95;
    public static final int INPUT5_B = 96;
    public static final int INPUT5_DIGITAL = 93;
    public static final int INPUT5_LINE = 94;
    public static final int INPUT5_PHONO = 97;
    public static final int INPUT5_BUILTIN = 98;
    public static final int INPUT5_EXT1 = 99;
    public static final int INPUT5_EXT2 = 100;
    public static final int INPUT6_A = 104;
    public static final int INPUT6_B = 105;
    public static final int INPUT6_DIGITAL = 101;
    public static final int INPUT6_LINE = 102;
    public static final int INPUT6_PHONO = 103;
    public static final int INPUT6_BUILTIN = 106;
    public static final int INPUT6_EXT1 = 107;
    public static final int INPUT6_EXT2 = 108;
    public final BoundedParameter low1raw = new BoundedParameter("low1raw");
    public final BoundedParameter low2raw = new BoundedParameter("low2raw");
    public final BoundedParameter low3raw = new BoundedParameter("low3raw");
    public final BoundedParameter low4raw = new BoundedParameter("low4raw");
    public final BoundedParameter low5raw = new BoundedParameter("low5raw");
    public final BoundedParameter low6raw = new BoundedParameter("low6raw");
    public final BoundedParameter midLow1raw = new BoundedParameter("midLow1raw");
    public final BoundedParameter midLow2raw = new BoundedParameter("midLow2raw");
    public final BoundedParameter midLow3raw = new BoundedParameter("midLow3raw");
    public final BoundedParameter midLow4raw = new BoundedParameter("midLow4raw");
    public final BoundedParameter midLow5raw = new BoundedParameter("midLow5raw");
    public final BoundedParameter midLow6raw = new BoundedParameter("midLow6raw");
    public final BoundedParameter midHigh1raw = new BoundedParameter("midHigh1raw");
    public final BoundedParameter midHigh2raw = new BoundedParameter("midHigh2raw");
    public final BoundedParameter midHigh3raw = new BoundedParameter("midHigh3raw");
    public final BoundedParameter midHigh4raw = new BoundedParameter("midHigh4raw");
    public final BoundedParameter midHigh5raw = new BoundedParameter("midHigh5raw");
    public final BoundedParameter midHigh6raw = new BoundedParameter("midHigh6raw");
    public final BoundedParameter high1raw = new BoundedParameter("high1raw");
    public final BoundedParameter high2raw = new BoundedParameter("high2raw");
    public final BoundedParameter high3raw = new BoundedParameter("high3raw");
    public final BoundedParameter high4raw = new BoundedParameter("high4raw");
    public final BoundedParameter high5raw = new BoundedParameter("high5raw");
    public final BoundedParameter high6raw = new BoundedParameter("high6raw");
    public final BoundedParameter fade1 = new BoundedParameter("fade1", 1.0);
    public final BoundedParameter fade2 = new BoundedParameter("fade2", 1.0);
    public final BoundedParameter fade3 = new BoundedParameter("fade3", 1.0);
    public final BoundedParameter fade4 = new BoundedParameter("fade4", 1.0);
    public final BoundedParameter fade5 = new BoundedParameter("fade5", 1.0);
    public final BoundedParameter fade6 = new BoundedParameter("fade6", 1.0);
    public final BoundedParameter masterFader = new BoundedParameter("masterFader");
    public final BoundedParameter boothMonitor = new BoundedParameter("boothMonitor");
    public final BoundedParameter crossfader = new BoundedParameter("crossFader");
    public final BoundedParameter send1raw = new BoundedParameter("send1raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter send2raw = new BoundedParameter("send2raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter send3raw = new BoundedParameter("send3raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter send4raw = new BoundedParameter("send4raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter send5raw = new BoundedParameter("send5raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter send6raw = new BoundedParameter("send6raw").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BoundedParameter sendSizeFeedback = new BoundedParameter("sendSizeFeedback", 0.55, 0.1, 1.0);
    public final BoundedParameter sendSensitivity = new BoundedParameter("SendSensitivity", 2.0, 1.0, 3.0).setDescription("Send knob sensitivity. Adjust per DJ.");
    public final BoundedParameter low1 = new BoundedParameter("low1");
    public final BoundedParameter low2 = new BoundedParameter("low2");
    public final BoundedParameter low3 = new BoundedParameter("low3");
    public final BoundedParameter low4 = new BoundedParameter("low4");
    public final BoundedParameter low5 = new BoundedParameter("low5");
    public final BoundedParameter low6 = new BoundedParameter("low6");
    public final BoundedParameter midLow1 = new BoundedParameter("midLow1");
    public final BoundedParameter midLow2 = new BoundedParameter("midLow2");
    public final BoundedParameter midLow3 = new BoundedParameter("midLow3");
    public final BoundedParameter midLow4 = new BoundedParameter("midLow4");
    public final BoundedParameter midLow5 = new BoundedParameter("midLow5");
    public final BoundedParameter midLow6 = new BoundedParameter("midLow6");
    public final BoundedParameter midHigh1 = new BoundedParameter("midHigh1");
    public final BoundedParameter midHigh2 = new BoundedParameter("midHigh2");
    public final BoundedParameter midHigh3 = new BoundedParameter("midHigh3");
    public final BoundedParameter midHigh4 = new BoundedParameter("midHigh4");
    public final BoundedParameter midHigh5 = new BoundedParameter("midHigh5");
    public final BoundedParameter midHigh6 = new BoundedParameter("midHigh6");
    public final BoundedParameter high1 = new BoundedParameter("high1");
    public final BoundedParameter high2 = new BoundedParameter("high2");
    public final BoundedParameter high3 = new BoundedParameter("high3");
    public final BoundedParameter high4 = new BoundedParameter("high4");
    public final BoundedParameter high5 = new BoundedParameter("high5");
    public final BoundedParameter high6 = new BoundedParameter("high6");
    public final BoundedParameter eqRangeMax = new BoundedParameter("EQmax", 0.5).setDescription("Equalizer knob value that will act as a maximum position. Adjust per DJ. Defaults to center.");
    public final BoundedParameter low1net = new BoundedParameter("low1net");
    public final BoundedParameter low2net = new BoundedParameter("low2net");
    public final BoundedParameter low3net = new BoundedParameter("low3net");
    public final BoundedParameter low4net = new BoundedParameter("low4net");
    public final BoundedParameter low5net = new BoundedParameter("low5net");
    public final BoundedParameter low6net = new BoundedParameter("low6net");
    public final BoundedParameter midLow1net = new BoundedParameter("midLow1net");
    public final BoundedParameter midLow2net = new BoundedParameter("midLow2net");
    public final BoundedParameter midLow3net = new BoundedParameter("midLow3net");
    public final BoundedParameter midLow4net = new BoundedParameter("midLow4net");
    public final BoundedParameter midLow5net = new BoundedParameter("midLow5net");
    public final BoundedParameter midLow6net = new BoundedParameter("midLow6net");
    public final BoundedParameter midHigh1net = new BoundedParameter("midHigh1net");
    public final BoundedParameter midHigh2net = new BoundedParameter("midHigh2net");
    public final BoundedParameter midHigh3net = new BoundedParameter("midHigh3net");
    public final BoundedParameter midHigh4net = new BoundedParameter("midHigh4net");
    public final BoundedParameter midHigh5net = new BoundedParameter("midHigh5net");
    public final BoundedParameter midHigh6net = new BoundedParameter("midHigh6net");
    public final BoundedParameter high1net = new BoundedParameter("high1net");
    public final BoundedParameter high2net = new BoundedParameter("high2net");
    public final BoundedParameter high3net = new BoundedParameter("high3net");
    public final BoundedParameter high4net = new BoundedParameter("high4net");
    public final BoundedParameter high5net = new BoundedParameter("high5net");
    public final BoundedParameter high6net = new BoundedParameter("high6net");
    public final BoundedParameter send1 = new BoundedParameter("send1");
    public final BoundedParameter send2 = new BoundedParameter("send2");
    public final BoundedParameter send3 = new BoundedParameter("send3");
    public final BoundedParameter send4 = new BoundedParameter("send4");
    public final BoundedParameter send5 = new BoundedParameter("send5");
    public final BoundedParameter send6 = new BoundedParameter("send6");
    public final BoundedParameter level1net = new BoundedParameter("level1net", 0.0, 4.0);
    public final BoundedParameter level2net = new BoundedParameter("level2net", 0.0, 4.0);
    public final BoundedParameter level3net = new BoundedParameter("level3net", 0.0, 4.0);
    public final BoundedParameter level4net = new BoundedParameter("level4net", 0.0, 4.0);
    public final BoundedParameter level5net = new BoundedParameter("level5net", 0.0, 4.0);
    public final BoundedParameter level6net = new BoundedParameter("level6net", 0.0, 4.0);
    private BoundedParameter[] lowraw = new BoundedParameter[]{this.low1raw, this.low2raw, this.low3raw, this.low4raw, this.low5raw, this.low6raw};
    private BoundedParameter[] midLowraw = new BoundedParameter[]{this.midLow1raw, this.midLow2raw, this.midLow3raw, this.midLow4raw, this.midLow5raw, this.midLow6raw};
    private BoundedParameter[] midHighraw = new BoundedParameter[]{this.midHigh1raw, this.midHigh2raw, this.midHigh3raw, this.midHigh4raw, this.midHigh5raw, this.midHigh6raw};
    private BoundedParameter[] highraw = new BoundedParameter[]{this.high1raw, this.high2raw, this.high3raw, this.high4raw, this.high5raw, this.high6raw};
    private BoundedParameter[] low = new BoundedParameter[]{this.low1, this.low2, this.low3, this.low4, this.low5, this.low6};
    private BoundedParameter[] midLow = new BoundedParameter[]{this.midLow1, this.midLow2, this.midLow3, this.midLow4, this.midLow5, this.midLow6};
    private BoundedParameter[] midHigh = new BoundedParameter[]{this.midHigh1, this.midHigh2, this.midHigh3, this.midHigh4, this.midHigh5, this.midHigh6};
    private BoundedParameter[] high = new BoundedParameter[]{this.high1, this.high2, this.high3, this.high4, this.high5, this.high6};
    private BoundedParameter[] lowNnet = new BoundedParameter[]{this.low1net, this.low2net, this.low3net, this.low4net, this.low5net, this.low6net};
    private BoundedParameter[] midLowNnet = new BoundedParameter[]{this.midLow1net, this.midLow2net, this.midLow3net, this.midLow4net, this.midLow5net, this.midLow6net};
    private BoundedParameter[] midHighNnet = new BoundedParameter[]{this.midHigh1net, this.midHigh2net, this.midHigh3net, this.midHigh4net, this.midHigh5net, this.midHigh6net};
    private BoundedParameter[] highNnet = new BoundedParameter[]{this.high1net, this.high2net, this.high3net, this.high4net, this.high5net, this.high6net};
    private BoundedParameter[] fade = new BoundedParameter[]{this.fade1, this.fade2, this.fade3, this.fade4, this.fade5, this.fade6};
    private BoundedParameter[] levelNnet = new BoundedParameter[]{this.level1net, this.level2net, this.level3net, this.level4net, this.level5net, this.level6net};
    private BoundedParameter[] sendraw = new BoundedParameter[]{this.send1raw, this.send2raw, this.send3raw, this.send4raw, this.send5raw, this.send6raw};
    private BoundedParameter[] send = new BoundedParameter[]{this.send1, this.send2, this.send3, this.send4, this.send5, this.send6};
    public final EnumParameter<Channel> aChannel = new EnumParameter<Channel>("A Channel", Channel.TWO);
    public final EnumParameter<Channel> bChannel = new EnumParameter<Channel>("B Channel", Channel.THREE);
    public final BoundedParameter lowA = new BoundedParameter("lowA");
    public final BoundedParameter lowB = new BoundedParameter("lowB");
    public final BoundedParameter midLowA = new BoundedParameter("midLowA");
    public final BoundedParameter midLowB = new BoundedParameter("midLowB");
    public final BoundedParameter midHighA = new BoundedParameter("midHighA");
    public final BoundedParameter midHighB = new BoundedParameter("midHighB");
    public final BoundedParameter highA = new BoundedParameter("highA");
    public final BoundedParameter highB = new BoundedParameter("highB");
    public final BoundedParameter lowAnet = new BoundedParameter("lowA");
    public final BoundedParameter lowBnet = new BoundedParameter("lowB");
    public final BoundedParameter midLowAnet = new BoundedParameter("midLowA");
    public final BoundedParameter midLowBnet = new BoundedParameter("midLowB");
    public final BoundedParameter midHighAnet = new BoundedParameter("midHighA");
    public final BoundedParameter midHighBnet = new BoundedParameter("midHighB");
    public final BoundedParameter highAnet = new BoundedParameter("highA");
    public final BoundedParameter highBnet = new BoundedParameter("highB");
    public final BoundedParameter fadeA = new BoundedParameter("fadeA");
    public final BoundedParameter fadeB = new BoundedParameter("fadeB");
    public final BoundedParameter sendA = new BoundedParameter("sendA");
    public final BoundedParameter sendB = new BoundedParameter("sendB");
    public final BoundedParameter levelAnet = new BoundedParameter("levelAnet", 0.0, 3.0);
    public final BoundedParameter levelBnet = new BoundedParameter("levelBnet", 0.0, 3.0);
    public final BoundedParameter lowNet = new BoundedParameter("lowNet");
    public final BoundedParameter midLowNet = new BoundedParameter("midLowNet");
    public final BoundedParameter midHighNet = new BoundedParameter("midHighNet");
    public final BoundedParameter highNet = new BoundedParameter("highNet");
    public final BoundedParameter smartXF = new BoundedParameter("SmartXF").setDescription("Crossfader position calculated using relative levels of A vs B");
    public final EnumParameter<XFMode> xfMode = new EnumParameter<XFMode>("Crossfader Sync", XFMode.OFF).setDescription("Mode for following DJM-V10 crossfader with LX");
    private final LXParameterListener aChannelListener = p -> {
        this.updateAeq();
        this.updateAsend();
        this.updateLowNet();
        this.updateMidLowNet();
        this.updateMidHighNet();
        this.updateHighNet();
    };
    private final LXParameterListener bChannelListener = p -> {
        this.updateBeq();
        this.updateBsend();
        this.updateLowNet();
        this.updateMidLowNet();
        this.updateMidHighNet();
        this.updateHighNet();
    };
    private final LXParameterListener sendSensitivityListener = p -> this.recalculateAllSends();
    private final LXParameterListener eqRangeMaxListener = p -> this.recalculateAllEq();
    private final LXParameterListener smartXFListener = p -> {
        if (this.xfMode.getEnum() == XFMode.SMART) {
            this.lx.engine.mixer.crossfader.setNormalized(this.smartXF.getNormalized());
        }
    };
    private final LXParameterListener xfModeListener = p -> {
        XFMode mode = this.xfMode.getEnum();
        if (mode == XFMode.DIRECT) {
            this.lx.engine.mixer.crossfader.setNormalized(this.crossfader.getNormalized());
        } else if (mode == XFMode.SMART) {
            this.lx.engine.mixer.crossfader.setNormalized(this.smartXF.getNormalized());
        }
    };

    public DJMV10(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.addSetting("midiChannel", this.midiChannel);
        this.addSetting("xfMode", this.xfMode);
        this.addSetting("aChannel", this.aChannel);
        this.addSetting("bChannel", this.bChannel);
        this.aChannel.addListener(this.aChannelListener);
        this.bChannel.addListener(this.bChannelListener);
        this.sendSensitivity.addListener(this.sendSensitivityListener);
        this.eqRangeMax.addListener(this.eqRangeMaxListener);
        this.smartXF.addListener(this.smartXFListener);
        this.xfMode.addListener(this.xfModeListener);
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.initialize();
        }
    }

    private void initialize() {
        this.sendSizeFeedback.setNormalized(0.5);
        Channel[] channelArray = ALL_CHANNELS;
        int n = ALL_CHANNELS.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            this.updateLow(channel, 0.5);
            this.updateMidLow(channel, 0.5);
            this.updateMidHigh(channel, 0.5);
            this.updateHigh(channel, 0.5);
            this.updateFade(channel, 0.0);
            this.updateSend(channel, 0.0);
            ++n2;
        }
    }

    protected void recalculateAllEq() {
        Channel[] channelArray = ALL_CHANNELS;
        int n = ALL_CHANNELS.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            int c = channel.getIndex();
            this.low[c].setValue(this.scaleEq(this.lowraw[c].getValue()));
            this.midLow[c].setValue(this.scaleEq(this.midLowraw[c].getValue()));
            this.midHigh[c].setValue(this.scaleEq(this.midHighraw[c].getValue()));
            this.high[c].setValue(this.scaleEq(this.highraw[c].getValue()));
            this.lowNnet[c].setValue(this.low[c].getValue() * this.fade[c].getValue());
            this.midLowNnet[c].setValue(this.midLow[c].getValue() * this.fade[c].getValue());
            this.midHighNnet[c].setValue(this.midHigh[c].getValue() * this.fade[c].getValue());
            this.highNnet[c].setValue(this.high[c].getValue() * this.fade[c].getValue());
            this.updateLevelNet(channel);
            ++n2;
        }
        this.updateAeq();
        this.updateBeq();
        this.updateLowNet();
        this.updateMidLowNet();
        this.updateMidHighNet();
        this.updateHighNet();
    }

    protected double scaleEq(double value) {
        return LXUtils.constrain(value / this.eqRangeMax.getValue(), 0.0, 1.0);
    }

    protected void updateLow(Channel channel, double value) {
        int c = channel.getIndex();
        this.lowraw[c].setValue(value);
        this.low[c].setValue(this.scaleEq(value));
        this.lowNnet[c].setValue(this.low[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateLowNet();
    }

    protected void updateMidLow(Channel channel, double value) {
        int c = channel.getIndex();
        this.midLowraw[c].setValue(value);
        this.midLow[c].setValue(this.scaleEq(value));
        this.midLowNnet[c].setValue(this.midLow[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateMidLowNet();
    }

    protected void updateMidHigh(Channel channel, double value) {
        int c = channel.getIndex();
        this.midHighraw[c].setValue(value);
        this.midHigh[c].setValue(this.scaleEq(value));
        this.midHighNnet[c].setValue(this.midHigh[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateMidHighNet();
    }

    protected void updateHigh(Channel channel, double value) {
        int c = channel.getIndex();
        this.highraw[c].setValue(value);
        this.high[c].setValue(this.scaleEq(value));
        this.highNnet[c].setValue(this.high[c].getValue() * this.fade[c].getValue());
        this.updateLevelNet(channel);
        this.updateABeq(channel);
        this.updateHighNet();
    }

    protected void updateFade(Channel channel, double value) {
        int c = channel.getIndex();
        this.fade[c].setValue(value);
        this.lowNnet[c].setValue(this.low[c].getValue() * value);
        this.midLowNnet[c].setValue(this.midLow[c].getValue() * value);
        this.midHighNnet[c].setValue(this.midHigh[c].getValue() * value);
        this.highNnet[c].setValue(this.high[c].getValue() * value);
        this.updateLevelNet(channel);
        this.updateABeq(channel);
    }

    protected void updateLevelNet(Channel channel) {
        int c = channel.getIndex();
        this.levelNnet[c].setValue(this.fade[c].getValue() * (this.low[c].getValue() + this.midLow[c].getValue() + this.midHigh[c].getValue() + this.high[c].getValue()));
    }

    protected void updateLowNet() {
        this.lowNet.setValue(Math.max(this.lowAnet.getValue(), this.lowBnet.getValue()));
    }

    protected void updateMidLowNet() {
        this.midLowNet.setValue(Math.max(this.midLowAnet.getValue(), this.midLowBnet.getValue()));
    }

    protected void updateMidHighNet() {
        this.midHighNet.setValue(Math.max(this.midHighAnet.getValue(), this.midHighBnet.getValue()));
    }

    protected void updateHighNet() {
        this.highNet.setValue(Math.max(this.highAnet.getValue(), this.highBnet.getValue()));
    }

    protected void updateABeq(Channel channel) {
        if (this.aChannel.getEnum().equals((Object)channel)) {
            this.updateAeq(channel);
        }
        if (this.bChannel.getEnum().equals((Object)channel)) {
            this.updateBeq(channel);
        }
    }

    protected void updateAeq() {
        this.updateAeq(this.aChannel.getEnum());
    }

    protected void updateBeq() {
        this.updateBeq(this.bChannel.getEnum());
    }

    protected void updateAeq(Channel channel) {
        int c = channel.getIndex();
        this.lowA.setValue(this.low[c].getValue());
        this.midLowA.setValue(this.midLow[c].getValue());
        this.midHighA.setValue(this.midHigh[c].getValue());
        this.highA.setValue(this.high[c].getValue());
        this.fadeA.setValue(this.fade[c].getValue());
        this.lowAnet.setValue(this.lowNnet[c].getValue());
        this.midLowAnet.setValue(this.midLowNnet[c].getValue());
        this.midHighAnet.setValue(this.midHighNnet[c].getValue());
        this.highAnet.setValue(this.highNnet[c].getValue());
        this.levelAnet.setValue(this.levelNnet[c].getValue());
        this.updateSmartXF();
    }

    protected void updateBeq(Channel channel) {
        int c = channel.getIndex();
        this.lowB.setValue(this.low[c].getValue());
        this.midLowB.setValue(this.midLow[c].getValue());
        this.midHighB.setValue(this.midHigh[c].getValue());
        this.highB.setValue(this.high[c].getValue());
        this.fadeB.setValue(this.fade[c].getValue());
        this.lowBnet.setValue(this.lowNnet[c].getValue());
        this.midLowBnet.setValue(this.midLowNnet[c].getValue());
        this.midHighBnet.setValue(this.midHighNnet[c].getValue());
        this.highBnet.setValue(this.highNnet[c].getValue());
        this.levelBnet.setValue(this.levelNnet[c].getValue());
        this.updateSmartXF();
    }

    protected void updateSmartXF() {
        double levA = this.levelAnet.getNormalized();
        double levB = this.levelBnet.getNormalized();
        if (levA != 0.0 || levB != 0.0) {
            this.smartXF.setValue(levA > levB ? levB / (levA + levB) : 1.0 - levA / (levA + levB));
        }
    }

    protected void recalculateAllSends() {
        Channel[] channelArray = ALL_CHANNELS;
        int n = ALL_CHANNELS.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            int c = channel.getIndex();
            double value = this.sendraw[c].getValue();
            this.send[c].setValue(value * this.sendSizeFeedback.getValue() * this.sendSensitivity.getValue());
            ++n2;
        }
        this.updateAsend();
        this.updateBsend();
    }

    protected void updateSend(Channel channel, double value) {
        int c = channel.getIndex();
        this.sendraw[c].setValue(value);
        this.send[c].setValue(value * this.sendSizeFeedback.getValue() * this.sendSensitivity.getValue());
        this.updateABsend(channel);
    }

    protected void updateABsend(Channel channel) {
        if (this.aChannel.getEnum().equals((Object)channel)) {
            this.updateAsend(channel);
        }
        if (this.bChannel.getEnum().equals((Object)channel)) {
            this.updateBsend(channel);
        }
    }

    protected void updateAsend() {
        this.updateAsend(this.aChannel.getEnum());
    }

    protected void updateBsend() {
        this.updateBsend(this.bChannel.getEnum());
    }

    protected void updateAsend(Channel channel) {
        this.sendA.setValue(this.send[channel.getIndex()].getValue());
    }

    protected void updateBsend(Channel channel) {
        this.sendB.setValue(this.send[channel.getIndex()].getValue());
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        MidiChannel midiChannel = this.midiChannel.getEnum();
        if (cc.getChannel() == midiChannel.index || midiChannel == MidiChannel.ANY) {
            int number = cc.getCC();
            switch (number) {
                case 4: {
                    this.updateLow(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 9: {
                    this.updateLow(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 21: {
                    this.updateLow(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 82: {
                    this.updateLow(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 63: {
                    this.updateLow(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 90: {
                    this.updateLow(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 28: {
                    this.updateMidLow(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 29: {
                    this.updateMidLow(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 16: {
                    this.updateMidLow(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 93: {
                    this.updateMidLow(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 52: {
                    this.updateMidLow(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 89: {
                    this.updateMidLow(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 3: {
                    this.updateMidHigh(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 8: {
                    this.updateMidHigh(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 15: {
                    this.updateMidHigh(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 92: {
                    this.updateMidHigh(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 49: {
                    this.updateMidHigh(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 60: {
                    this.updateMidHigh(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 2: {
                    this.updateHigh(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 7: {
                    this.updateHigh(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 14: {
                    this.updateHigh(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 81: {
                    this.updateHigh(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 48: {
                    this.updateHigh(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 56: {
                    this.updateHigh(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 17: {
                    this.updateFade(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 18: {
                    this.updateFade(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 19: {
                    this.updateFade(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 20: {
                    this.updateFade(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 109: {
                    this.updateFade(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 110: {
                    this.updateFade(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 24: {
                    this.masterFader.setNormalized(cc.getNormalized());
                    return;
                }
                case 25: {
                    this.boothMonitor.setNormalized(cc.getNormalized());
                    return;
                }
                case 11: {
                    this.crossfader.setNormalized(cc.getNormalized());
                    if (this.xfMode.getEnum() == XFMode.DIRECT) {
                        this.lx.engine.mixer.crossfader.setNormalized(cc.getNormalized());
                    }
                    return;
                }
                case 5: {
                    this.updateSend(Channel.ONE, cc.getNormalized());
                    return;
                }
                case 10: {
                    this.updateSend(Channel.TWO, cc.getNormalized());
                    return;
                }
                case 22: {
                    this.updateSend(Channel.THREE, cc.getNormalized());
                    return;
                }
                case 83: {
                    this.updateSend(Channel.FOUR, cc.getNormalized());
                    return;
                }
                case 101: {
                    this.updateSend(Channel.FIVE, cc.getNormalized());
                    return;
                }
                case 118: {
                    this.updateSend(Channel.SIX, cc.getNormalized());
                    return;
                }
                case 108: {
                    this.sendSizeFeedback.setNormalized(cc.getNormalized());
                    this.recalculateAllSends();
                    return;
                }
                case 1: 
                case 6: 
                case 12: 
                case 13: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 55: 
                case 57: 
                case 58: 
                case 59: 
                case 61: 
                case 62: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 84: 
                case 85: 
                case 86: 
                case 88: 
                case 91: 
                case 94: 
                case 95: 
                case 96: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 119: {
                    return;
                }
            }
            LXMidiEngine.error("DJM-V10 UNMAPPED CC: " + String.valueOf(cc));
        }
    }

    private void noteReceived(MidiNote note, boolean on) {
        MidiChannel midiChannel = this.midiChannel.getEnum();
        if (note.getChannel() == midiChannel.index || midiChannel == MidiChannel.ANY) {
            int pitch = note.getPitch();
            switch (pitch) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 68: 
                case 69: 
                case 70: 
                case 72: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 118: {
                    return;
                }
            }
            LXMidiEngine.error("DJM-V10 UNMAPPED Note: " + String.valueOf(note) + " " + on);
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void programChangeReceived(MidiProgramChange pc) {
    }

    @Override
    public void pitchBendReceived(MidiPitchBend pitchBend) {
    }

    @Override
    public void aftertouchReceived(MidiAftertouch aftertouch) {
    }

    @Override
    public void dispose() {
        this.aChannel.removeListener(this.aChannelListener);
        this.bChannel.removeListener(this.bChannelListener);
        this.sendSensitivity.removeListener(this.sendSensitivityListener);
        this.eqRangeMax.removeListener(this.eqRangeMaxListener);
        this.smartXF.removeListener(this.smartXFListener);
        this.xfMode.removeListener(this.xfModeListener);
        super.dispose();
    }

    public static enum Channel {
        ONE(0),
        TWO(1),
        THREE(2),
        FOUR(3),
        FIVE(4),
        SIX(5);

        private final int index;
        private final String label;

        private Channel(int index) {
            this.index = index;
            this.label = Integer.toString(this.index + 1);
        }

        public String toString() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum MidiChannel {
        CH1(0),
        CH2(1),
        CH3(2),
        CH4(3),
        CH5(4),
        CH6(5),
        CH7(6),
        CH8(7),
        CH9(8),
        CH10(9),
        CH11(10),
        CH12(11),
        CH13(12),
        CH14(13),
        CH15(14),
        CH16(15),
        ANY(99);

        private final int index;
        private final String label;

        private MidiChannel(int index) {
            this.index = index;
            this.label = index == 99 ? "Any" : Integer.toString(this.index + 1);
        }

        public String toString() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum XFMode {
        OFF("Off"),
        DIRECT("Direct"),
        SMART("Smart");

        private final String label;

        private XFMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

