/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;

public class FocusedChannel {
    private final LX lx;
    private final Listener listener;
    private final boolean isAux;
    private final LXParameterListener focusListener = this::onChannelFocused;
    private LXChannel focusedChannel = null;

    public FocusedChannel(LX lx, Listener listener) {
        this(lx, false, listener);
    }

    public FocusedChannel(LX lx, boolean isAux, Listener listener) {
        this.lx = lx;
        this.isAux = isAux;
        this.listener = listener;
    }

    private void setFocusedChannel(LXBus channel) {
        if (this.focusedChannel != null) {
            this.focusedChannel.controlSurfaceSemaphore.decrement();
            this.focusedChannel = null;
        }
        if (channel instanceof LXChannel) {
            this.focusedChannel = (LXChannel)channel;
            this.focusedChannel.controlSurfaceSemaphore.increment();
        }
        this.listener.onChannelFocused(channel);
    }

    private void onChannelFocused(LXParameter p) {
        LXBus bus = this.isAux ? this.lx.engine.mixer.getFocusedChannelAux() : this.lx.engine.mixer.getFocusedChannel();
        this.setFocusedChannel(bus);
    }

    public void register() {
        (this.isAux ? this.lx.engine.mixer.focusedChannelAux : this.lx.engine.mixer.focusedChannel).addListener(this.focusListener, true);
    }

    public void unregister() {
        (this.isAux ? this.lx.engine.mixer.focusedChannelAux : this.lx.engine.mixer.focusedChannel).removeListener(this.focusListener);
        this.setFocusedChannel(null);
    }

    public static interface Listener {
        public void onChannelFocused(LXBus var1);
    }
}

