/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.pattern.LXPattern;
import java.util.HashMap;
import java.util.Map;

public class FocusedDevice {
    private final LX lx;
    private final LXMidiSurface surface;
    private final Listener listener;
    private LXBus bus = null;
    private LXDeviceComponent device = null;
    private final Map<LXListenableParameter, LXParameterListener> listeners = new HashMap<LXListenableParameter, LXParameterListener>();
    private boolean isAux = false;
    private boolean isAuxSticky = false;
    private boolean isRegistered = false;
    private final LXParameterListener _onChannelFocusChange = p -> this.onChannelFocusChange();
    private final LXChannel.Listener channelListener = new LXChannel.Listener(){

        @Override
        public void effectRemoved(LXBus channel, LXEffect effect) {
            if (FocusedDevice.this.device == effect) {
                FocusedDevice.this.registerDefaultBusDevice();
            }
        }

        @Override
        public void patternRemoved(LXChannel channel, LXPattern pattern) {
            if (FocusedDevice.this.device == pattern) {
                FocusedDevice.this.registerDefaultBusDevice();
            }
        }
    };

    public FocusedDevice(LX lx, Listener listener) {
        this(lx, null, listener);
    }

    public FocusedDevice(LX lx, LXMidiSurface surface, Listener listener) {
        this.lx = lx;
        this.surface = surface;
        this.listener = listener;
    }

    public boolean isAux() {
        return this.isAux;
    }

    public FocusedDevice toggleAux() {
        return this.setAux(!this.isAux);
    }

    public FocusedDevice setAux(boolean isAux) {
        this.isAux = isAux;
        if (this.isRegistered) {
            this.onChannelFocusChange();
            this.updateRemoteControlFocus();
        }
        return this;
    }

    public FocusedDevice setAuxSticky(boolean isAuxSticky) {
        this.isAuxSticky = isAuxSticky;
        return this;
    }

    private void addListener(LXListenableParameter parameter, LXParameterListener listener) {
        if (this.listeners.containsKey(parameter)) {
            throw new IllegalArgumentException("Cannot add duplicate parameter listener for " + String.valueOf(parameter));
        }
        parameter.addListener(listener);
        this.listeners.put(parameter, listener);
    }

    private void removeListener(LXListenableParameter parameter) {
        LXParameterListener listener = this.listeners.remove(parameter);
        if (listener == null) {
            throw new IllegalArgumentException("Cannot remove non-existent listener for " + String.valueOf(parameter));
        }
        parameter.removeListener(listener);
    }

    public void register() {
        if (this.isRegistered) {
            throw new IllegalStateException("Cannot double-register FocusedDevice");
        }
        this.addListener(this.lx.engine.performanceMode, this._onChannelFocusChange);
        this.addListener(this.lx.engine.mixer.focusedChannel, this._onChannelFocusChange);
        this.addListener(this.lx.engine.mixer.focusedChannelAux, this._onChannelFocusChange);
        this.registerBus(this.getFocusedChannel());
        this.isRegistered = true;
    }

    public void unregister() {
        if (!this.isRegistered) {
            throw new IllegalStateException("Cannot unregister non-registered FocusedDevice");
        }
        this.unregisterDevice(true);
        this.unregisterBus();
        for (Map.Entry<LXListenableParameter, LXParameterListener> entry : this.listeners.entrySet()) {
            entry.getKey().removeListener(entry.getValue());
        }
        this.listeners.clear();
        this.isRegistered = false;
    }

    public LXBus getFocusedChannel() {
        int channel = this.getFocusedChannelTarget().getValuei();
        if (channel == this.lx.engine.mixer.channels.size()) {
            return this.lx.engine.mixer.masterBus;
        }
        return this.lx.engine.mixer.channels.get(channel);
    }

    public boolean isAuxActive() {
        return this.isAux && (this.isAuxSticky || this.lx.engine.performanceMode.isOn());
    }

    public DiscreteParameter getFocusedChannelTarget() {
        if (this.isAuxActive()) {
            return this.lx.engine.mixer.focusedChannelAux;
        }
        return this.lx.engine.mixer.focusedChannel;
    }

    private void onChannelFocusChange() {
        this.registerBus(this.getFocusedChannel());
    }

    private boolean isBusEffect(LXDeviceComponent device) {
        return device instanceof LXEffect && ((LXEffect)device).isBusEffect();
    }

    private void registerBus(LXBus bus) {
        if (this.bus != bus) {
            this.unregisterBus();
            this.bus = bus;
            if (bus != null) {
                if (bus instanceof LXChannel) {
                    LXChannel channel = (LXChannel)bus;
                    channel.addListener(this.channelListener);
                    this.addListener(channel.focusedPattern, p -> {
                        if (!this.isBusEffect(this.device)) {
                            this.registerDevice(channel.getFocusedPattern());
                        }
                    });
                } else {
                    bus.addListener(this.channelListener);
                }
            }
            this.registerDefaultBusDevice();
        }
    }

    private void unregisterBus() {
        if (this.bus != null) {
            if (this.bus instanceof LXChannel) {
                LXChannel channel = (LXChannel)this.bus;
                channel.removeListener(this.channelListener);
                this.removeListener(channel.focusedPattern);
            } else {
                this.bus.removeListener(this.channelListener);
            }
            this.bus = null;
        }
    }

    private void registerDefaultBusDevice() {
        LXPattern focusedPattern;
        if (this.bus instanceof LXChannel && (focusedPattern = ((LXChannel)this.bus).getFocusedPattern()) != null) {
            this.registerDevice(focusedPattern);
            return;
        }
        if (!this.bus.effects.isEmpty()) {
            this.registerDevice(this.bus.effects.get(0));
        } else {
            this.registerDevice(null);
        }
    }

    public void previousChannel() {
        this.getFocusedChannelTarget().decrement();
    }

    public void nextChannel() {
        this.getFocusedChannelTarget().increment();
    }

    public void previousDevice() {
        if (this.bus == null) {
            return;
        }
        if (this.device instanceof LXEffect) {
            LXChannel channel;
            LXPattern pattern;
            LXEffect effect = (LXEffect)this.device;
            int effectIndex = effect.getIndex();
            if (effectIndex > 0) {
                this.registerDevice(effect.getContainer().getEffect(effectIndex - 1));
            } else if (this.bus instanceof LXChannel && (pattern = (channel = (LXChannel)this.bus).getFocusedPattern()) != null) {
                if (effect.isBusEffect() && !pattern.effects.isEmpty()) {
                    this.registerDevice(pattern.effects.get(pattern.effects.size() - 1));
                } else {
                    this.registerDevice(pattern);
                }
            }
        }
    }

    public void nextDevice() {
        if (this.bus == null) {
            return;
        }
        if (this.device instanceof LXEffect) {
            LXEffect effect = (LXEffect)this.device;
            int nextIndex = effect.getIndex() + 1;
            if (effect.isPatternEffect()) {
                LXPattern pattern = effect.getPattern();
                if (nextIndex < pattern.effects.size()) {
                    this.registerDevice(pattern.effects.get(nextIndex));
                } else if (!this.bus.effects.isEmpty()) {
                    this.registerDevice(this.bus.effects.get(0));
                }
            } else if (nextIndex < this.bus.effects.size()) {
                this.registerDevice(this.bus.effects.get(nextIndex));
            }
        } else if (this.bus instanceof LXChannel) {
            LXPattern focusedPattern = ((LXChannel)this.bus).getFocusedPattern();
            if (focusedPattern != null && !focusedPattern.effects.isEmpty()) {
                this.registerDevice(focusedPattern.effects.get(0));
            } else if (!this.bus.effects.isEmpty()) {
                this.registerDevice(this.bus.effects.get(0));
            }
        } else if (!this.bus.effects.isEmpty()) {
            this.registerDevice(this.bus.effects.get(0));
        }
    }

    public LXDeviceComponent getDevice() {
        return this.device;
    }

    public void updateRemoteControlFocus() {
        if (this.device != null && this.surface != null) {
            this.device.controlSurfaceSemaphore.bang();
        }
    }

    private void registerDevice(LXDeviceComponent device) {
        if (this.device != device) {
            this.unregisterDevice(false);
            this.device = device;
            this.listener.onDeviceFocused(device);
            if (this.device != null && this.surface != null) {
                this.device.addControlSurface(this.surface);
            }
        }
    }

    private void unregisterDevice(boolean notify) {
        if (this.device != null) {
            if (this.surface != null) {
                this.device.removeControlSurface(this.surface);
            }
            this.device = null;
            if (notify) {
                this.listener.onDeviceFocused(null);
            }
        }
    }

    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
        }
    }

    public static interface Listener {
        public void onDeviceFocused(LXDeviceComponent var1);
    }
}

