/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;

public class LXMidiParameterControl {
    private Mode mode = Mode.DIRECT;
    private LXListenableNormalizedParameter target = null;
    private int lastControlValue = -1;
    private boolean isPickedUp = false;
    private int pickupDirection = 0;
    private boolean internalUpdate = false;
    private final LXParameterListener listener = this::onTargetChanged;

    public LXMidiParameterControl() {
        this(null);
    }

    public LXMidiParameterControl(LXListenableNormalizedParameter target) {
        this.setTarget(target);
    }

    public LXMidiParameterControl setMode(Mode mode) {
        this.mode = mode;
        if (this.mode == Mode.PICKUP) {
            this.resetPickup();
        }
        return this;
    }

    public void setValue(MidiControlChange cc) {
        this.internalUpdate = true;
        int ccValue = cc.getValue();
        if (this.target != null) {
            switch (this.mode) {
                case DIRECT: {
                    this.target.setNormalized(cc.getNormalized());
                    break;
                }
                case PICKUP: {
                    if (!this.isPickedUp) {
                        int newPickupDirection = Integer.compare(this.getTargetMidiValue(), ccValue);
                        if (this.lastControlValue < 0) {
                            this.pickupDirection = newPickupDirection;
                            this.isPickedUp = newPickupDirection == 0;
                        } else {
                            boolean bl = this.isPickedUp = newPickupDirection == 0 || newPickupDirection != this.pickupDirection;
                        }
                    }
                    if (!this.isPickedUp) break;
                    this.target.setNormalized(cc.getNormalized());
                    break;
                }
                case SCALE: {
                    if (this.lastControlValue >= 0) {
                        double targetNormalized = this.target.getBaseNormalized();
                        if (ccValue > this.lastControlValue) {
                            this.target.setNormalized(LXUtils.lerp(targetNormalized, 1.0, (double)(ccValue - this.lastControlValue) / (double)(127 - this.lastControlValue)));
                            break;
                        }
                        if (ccValue >= this.lastControlValue) break;
                        this.target.setNormalized(LXUtils.lerp(targetNormalized, 0.0, (double)(this.lastControlValue - ccValue) / (double)this.lastControlValue));
                        break;
                    }
                    if (ccValue == 0) {
                        this.target.setNormalized(0.0);
                        break;
                    }
                    if (ccValue != 127) break;
                    this.target.setNormalized(1.0);
                }
            }
        }
        this.lastControlValue = ccValue;
        this.internalUpdate = false;
    }

    private int getTargetMidiValue() {
        if (this.target == null) {
            return -1;
        }
        return (int)Math.round(this.target.getBaseNormalized() * 127.0);
    }

    public void setTarget(LXListenableNormalizedParameter parameter) {
        if (this.target != null) {
            this.target.removeListener(this.listener);
        }
        this.target = parameter;
        this.isPickedUp = false;
        this.pickupDirection = 0;
        if (this.target != null) {
            this.resetPickup();
            this.target.addListener(this.listener);
        }
    }

    private void resetPickup() {
        this.pickupDirection = Integer.compare(this.getTargetMidiValue(), this.lastControlValue);
        this.isPickedUp = this.pickupDirection == 0;
    }

    private void onTargetChanged(LXParameter p) {
        if (!this.internalUpdate) {
            this.pickupDirection = Integer.compare(this.getTargetMidiValue(), this.lastControlValue);
            this.isPickedUp = this.pickupDirection == 0;
        }
    }

    public void dispose() {
        this.setTarget(null);
        this.lastControlValue = -1;
    }

    public static enum Mode {
        DIRECT("Direct"),
        PICKUP("Pickup"),
        SCALE("Scale");

        public final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

