/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXSysexMessage;
import heronarts.lx.midi.MidiAftertouch;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.MidiPitchBend;
import heronarts.lx.midi.MidiProgramChange;
import heronarts.lx.midi.MidiSelector;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Map;

public abstract class LXMidiSurface
extends LXComponent
implements LXMidiListener,
LXSerializable,
LXParameterListener {
    protected final LX lx;
    private LXMidiInput input;
    private LXMidiOutput output;
    public final MidiSelector.Source.Device sourceDevice = new MidiSelector.Source.Device("Source");
    public final MidiSelector.Destination.Device destinationDevice;
    public final BooleanParameter enabled = new BooleanParameter("Enabled").setMappable(false).setDescription("Whether the control surface is enabled");
    public final BooleanParameter connected = new BooleanParameter("Connected", false).setMappable(false).setDescription("Whether the control surface is connected");
    protected final LXParameter.Collection mutableSettings = new LXParameter.Collection();
    public final Map<String, LXParameter> settings = Collections.unmodifiableMap(this.mutableSettings);
    protected final LXParameter.Collection mutableState = new LXParameter.Collection();
    public final Map<String, LXParameter> state = Collections.unmodifiableMap(this.mutableState);
    private boolean _enabled = false;
    private boolean remember = false;
    private boolean hasInputListener = false;
    private final LXParameterListener onInputConnected = p -> {
        if (this.input.connected.isOn()) {
            this.input.open();
        }
        this._setConnected();
    };
    private final LXParameterListener onOutputConnected = p -> {
        if (this.output.connected.isOn()) {
            this.output.open();
        }
        this._setConnected();
    };
    public static final String KEY_CLASS = "class";
    public static final String KEY_NAME = "name";
    public static final String KEY_SETTINGS = "settings";
    public static final String KEY_STATE = "state";

    protected LXMidiSurface(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx);
        this.lx = lx;
        this.sourceDevice.setInput(input);
        this.addParameter("sourceDevice", this.sourceDevice);
        if (this instanceof Bidirectional) {
            this.destinationDevice = new MidiSelector.Destination.Device("Destination");
            this.destinationDevice.setOutput(output);
            this.addParameter("destinationDevice", this.destinationDevice);
        } else {
            this.destinationDevice = null;
        }
        this.setInput(input);
        this.setOutput(output);
        this.enabled.addListener(p -> {
            this.remember = false;
            boolean on = this.enabled.isOn();
            if (on) {
                this.setInputState(on);
                this._enabled = on;
                this.onEnable(on);
            } else {
                this.onEnable(on);
                this._enabled = on;
                this.setInputState(on);
            }
            lX.engine.midi.saveDevices();
        });
        this.connected.addListener(p -> {
            if (this.connected.isOn() && this._enabled) {
                this.onReconnect();
            }
        });
    }

    public LXMidiSurface setRememberFlag() {
        this.remember = true;
        return this;
    }

    public boolean hasRememberFlag() {
        return this.remember;
    }

    public LXMidiSurface initializeDefaultIO() {
        String deviceName = this.getDeviceName();
        this.sourceDevice.setInput(this.lx.engine.midi.findInput(deviceName));
        if (this instanceof Bidirectional) {
            this.destinationDevice.setOutput(this.lx.engine.midi.findOutput(deviceName));
        }
        return this;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.sourceDevice) {
            this.setInput(this.sourceDevice.getInput());
        } else if (p == this.destinationDevice) {
            this.setOutput(this.destinationDevice.getOutput());
        }
        this.lx.engine.midi.saveDevices();
    }

    private void setInputState(boolean on) {
        if (this.input == null) {
            return;
        }
        if (on) {
            if (!this.hasInputListener) {
                this.input.addListener(this);
                this.hasInputListener = true;
            }
        } else if (this.hasInputListener) {
            this.input.removeListener(this);
            this.hasInputListener = false;
        }
    }

    private void _setConnected() {
        boolean connected;
        boolean bl = connected = this.input != null && this.input.connected.isOn();
        if (connected && this instanceof Bidirectional) {
            connected = this.output != null && this.output.connected.isOn();
        }
        this.connected.setValue(connected);
    }

    private LXMidiSurface setInput(LXMidiInput input) {
        if (this.input != null) {
            this.setInputState(false);
            this.input.connected.removeListener(this.onInputConnected);
            this.input = null;
        }
        this._setConnected();
        this.input = input;
        if (this.input != null) {
            this.setInputState(this._enabled);
            this.input.connected.addListener(this.onInputConnected, true);
        }
        return this;
    }

    private LXMidiSurface setOutput(LXMidiOutput output) {
        if (this.output != null) {
            this.output.connected.removeListener(this.onOutputConnected);
            this.output = null;
        }
        this._setConnected();
        this.output = output;
        if (this.output != null) {
            this.output.connected.addListener(this.onOutputConnected, true);
        }
        return this;
    }

    protected void addSetting(String key, LXListenableParameter setting) {
        if (this.mutableSettings.containsKey(key)) {
            throw new IllegalStateException("Cannot add setting twice:" + key);
        }
        this.mutableSettings.put(key, setting);
        setting.addListener(this);
    }

    protected void addState(String key, LXListenableParameter state) {
        if (this.mutableState.containsKey(key)) {
            throw new IllegalStateException("Cannot add saved state twice:" + key);
        }
        this.mutableState.put(key, state);
        state.addListener(this);
    }

    @Deprecated
    public String getName() {
        return this.getDeviceName();
    }

    public String getDeviceName() {
        return LXMidiSurface.getDeviceName(this.getClass());
    }

    public static String getDeviceName(Class<? extends LXMidiSurface> surfaceClass) {
        DeviceName annotation = surfaceClass.getAnnotation(DeviceName.class);
        if (annotation != null) {
            return annotation.value();
        }
        return surfaceClass.getSimpleName();
    }

    public String getSurfaceName() {
        return LXMidiSurface.getSurfaceName(this.getClass());
    }

    public static String getSurfaceName(Class<? extends LXMidiSurface> clazz) {
        Name annotation = clazz.getAnnotation(Name.class);
        if (annotation != null) {
            return annotation.value();
        }
        return clazz.getSimpleName();
    }

    public LXMidiInput getInput() {
        return this.input;
    }

    public LXMidiOutput getOutput() {
        return this.output;
    }

    protected void onEnable(boolean isOn) {
    }

    protected void onReconnect() {
    }

    protected void sendNoteOn(int channel, int note, int velocity) {
        if (this._enabled && this.output != null) {
            this.output.sendNoteOn(channel, note, velocity);
        }
    }

    protected void sendControlChange(int channel, int cc, int value) {
        if (this._enabled && this.output != null) {
            this.output.sendControlChange(channel, cc, value);
        }
    }

    protected void sendSysex(byte[] sysex) {
        if (this._enabled && this.output != null) {
            this.output.sendSysex(sysex);
        }
    }

    public int getRemoteControlStart() {
        return 0;
    }

    public int getRemoteControlLength() {
        return 0;
    }

    public boolean isRemoteControlAux() {
        return false;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        JsonElement stateElem;
        JsonElement settingsElem;
        super.load(lx, obj);
        if (obj.has(KEY_SETTINGS) && (settingsElem = obj.get(KEY_SETTINGS)).isJsonObject()) {
            LXSerializable.Utils.loadParameters(settingsElem.getAsJsonObject(), this.mutableSettings);
        }
        if (obj.has(KEY_STATE) && (stateElem = obj.get(KEY_STATE)).isJsonObject()) {
            LXSerializable.Utils.loadParameters(stateElem.getAsJsonObject(), this.mutableState);
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_NAME, this.getDeviceName());
        if (!this.settings.isEmpty()) {
            obj.add(KEY_SETTINGS, (JsonElement)LXSerializable.Utils.saveParameters(this.mutableSettings));
        }
        if (!this.state.isEmpty()) {
            obj.add(KEY_STATE, (JsonElement)LXSerializable.Utils.saveParameters(this.mutableState));
        }
    }

    public boolean matches(JsonObject surface) {
        String surfaceClass;
        String string = surfaceClass = surface.has(KEY_CLASS) ? surface.get(KEY_CLASS).getAsString() : null;
        return this.getDeviceName().equals(surface.get(KEY_NAME).getAsString()) && (surfaceClass == null || surfaceClass.equals(this.getClass().getName()));
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
    }

    @Override
    public void noteOffReceived(MidiNote note) {
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
    }

    @Override
    public void programChangeReceived(MidiProgramChange pc) {
    }

    @Override
    public void pitchBendReceived(MidiPitchBend pitchBend) {
    }

    @Override
    public void aftertouchReceived(MidiAftertouch aftertouch) {
    }

    @Override
    public void sysexReceived(LXSysexMessage sysex) {
    }

    @Override
    public void dispose() {
        this.setOutput(null);
        this.setInput(null);
        for (LXParameter setting : this.settings.values()) {
            ((LXListenableParameter)setting).removeListener(this);
            setting.dispose();
        }
        for (LXParameter state : this.state.values()) {
            ((LXListenableParameter)state).removeListener(this);
            state.dispose();
        }
        this.mutableState.clear();
        this.mutableSettings.clear();
        super.dispose();
    }

    public static interface Bidirectional {
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DeviceName {
        public String value();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public String value();
    }
}

