/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.command.LXCommand;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.LXSysexMessage;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.surface.FocusedDevice;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@LXMidiSurface.Name(value="DJTT Midi Fighter Twister")
@LXMidiSurface.DeviceName(value="Midi Fighter Twister")
public class MidiFighterTwister
extends LXMidiSurface
implements LXMidiSurface.Bidirectional {
    public static final int CHANNEL_ROTARY_ENCODER = 0;
    public static final int CHANNEL_SWITCH_AND_COLOR = 1;
    public static final int CHANNEL_ANIMATIONS_AND_BRIGHTNESS = 2;
    public static final int CHANNEL_SYSTEM = 3;
    public static final int CHANNEL_SHIFT = 4;
    public static final int CHANNEL_SWITCH_ANIMATION = 5;
    public static final int CHANNEL_SEQUENCER = 7;
    public static final int DEVICE_KNOB = 0;
    public static final int DEVICE_KNOB_PER_BANK = 16;
    public static final int DEVICE_KNOB_NUM = 64;
    public static final int DEVICE_KNOB_MAX = 64;
    public static final int KNOB_DECREMENT_VERYFAST = 61;
    public static final int KNOB_DECREMENT_FAST = 62;
    public static final int KNOB_DECREMENT = 63;
    public static final int KNOB_INCREMENT = 65;
    public static final int KNOB_INCREMENT_FAST = 66;
    public static final int KNOB_INCREMENT_VERYFAST = 67;
    public static final int KNOB_TICKS_PER_DISCRETE_INCREMENT = 8;
    public static final int BANK1 = 0;
    public static final int BANK2 = 1;
    public static final int BANK3 = 2;
    public static final int BANK4 = 3;
    public static final int BANK1_LEFT1 = 8;
    public static final int BANK1_LEFT2 = 9;
    public static final int BANK1_LEFT3 = 10;
    public static final int BANK1_RIGHT1 = 11;
    public static final int BANK1_RIGHT2 = 12;
    public static final int BANK1_RIGHT3 = 13;
    public static final int BANK2_LEFT1 = 14;
    public static final int BANK2_LEFT2 = 15;
    public static final int BANK2_LEFT3 = 16;
    public static final int BANK2_RIGHT1 = 17;
    public static final int BANK2_RIGHT2 = 18;
    public static final int BANK2_RIGHT3 = 19;
    public static final int BANK3_LEFT1 = 20;
    public static final int BANK3_LEFT2 = 21;
    public static final int BANK3_LEFT3 = 22;
    public static final int BANK3_RIGHT1 = 23;
    public static final int BANK3_RIGHT2 = 24;
    public static final int BANK3_RIGHT3 = 25;
    public static final int BANK4_LEFT1 = 26;
    public static final int BANK4_LEFT2 = 27;
    public static final int BANK4_LEFT3 = 28;
    public static final int BANK4_RIGHT1 = 29;
    public static final int BANK4_RIGHT2 = 30;
    public static final int BANK4_RIGHT3 = 31;
    public static final int RGB_INACTIVE_COLOR = 0;
    public static final int RGB_ACTIVE_COLOR = 127;
    public static final int RGB_BLUE = 1;
    public static final int RGB_GREEN = 50;
    public static final int RGB_RED = 80;
    public static final int RGB_PRIMARY = 1;
    public static final int RGB_AUX = 80;
    public static final int RGB_USER = 50;
    public static final int RGB_ANIMATION_NONE = 0;
    public static final int RGB_TOGGLE_EVERY_8_BEATS = 1;
    public static final int RGB_TOGGLE_EVERY_4_BEATS = 2;
    public static final int RGB_TOGGLE_EVERY_2_BEATS = 3;
    public static final int RGB_TOGGLE_EVERY_BEAT = 4;
    public static final int RGB_TOGGLE_EVERY_HALF_BEAT = 5;
    public static final int RGB_TOGGLE_EVERY_QUARTER_BEAT = 6;
    public static final int RGB_TOGGLE_EVERY_EIGTH_BEAT = 7;
    public static final int RGB_TOGGLE_EVERY_SIXTEENTH_BEAT = 8;
    public static final int RGB_PULSE_EVERY_8_BEATS = 10;
    public static final int RGB_PULSE_EVERY_4_BEATS = 11;
    public static final int RGB_PULSE_EVERY_2_BEATS = 12;
    public static final int RGB_PULSE_EVERY_BEAT = 13;
    public static final int RGB_PULSE_EVERY_HALF_BEAT = 14;
    public static final int RGB_PULSE_EVERY_QUARTER_BEAT = 15;
    public static final int RGB_PULSE_EVERY_EIGTH_BEAT = 16;
    public static final int RGB_BRIGHTNESS_OFF = 17;
    public static final int RGB_BRIGHTNESS_MID = 32;
    public static final int RGB_BRIGHTNESS_MAX = 47;
    public static final int INDICATOR_ANIMATION_NONE = 48;
    public static final int INDICATOR_TOGGLE_EVERY_8_BEATS = 49;
    public static final int INDICATOR_TOGGLE_EVERY_4_BEATS = 50;
    public static final int INDICATOR_TOGGLE_EVERY_2_BEATS = 51;
    public static final int INDICATOR_TOGGLE_EVERY_BEAT = 52;
    public static final int INDICATOR_TOGGLE_EVERY_HALF_BEAT = 53;
    public static final int INDICATOR_TOGGLE_EVERY_QUARTER_BEAT = 54;
    public static final int INDICATOR_TOGGLE_EVERY_EIGTH_BEAT = 55;
    public static final int INDICATOR_TOGGLE_EVERY_SIXTEENTH_BEAT = 56;
    public static final int INDICATOR_PULSE_EVERY_8_BEATS = 57;
    public static final int INDICATOR_PULSE_EVERY_4_BEATS = 58;
    public static final int INDICATOR_PULSE_EVERY_2_BEATS = 59;
    public static final int INDICATOR_PULSE_EVERY_BEAT = 60;
    public static final int INDICATOR_PULSE_EVERY_HALF_BEAT = 61;
    public static final int INDICATOR_PULSE_EVERY_QUARTER_BEAT = 62;
    public static final int INDICATOR_PULSE_EVERY_EIGTH_BEAT = 63;
    public static final int INDICATOR_PULSE_EVERY_SIXTEENTH_BEAT = 64;
    public static final int INDICATOR_BRIGHTNESS_OFF = 65;
    public static final int INDICATOR_BRIGHTNESS_25 = 72;
    public static final int INDICATOR_BRIGHTNESS_MID = 80;
    public static final int INDICATOR_BRIGHTNESS_MAX = 95;
    public static final int RAINBOW_CYCLE = 127;
    public static final int BANK_OFF = 0;
    public static final int BANK_ON = 127;
    public final EnumParameter<KnobClickMode> knobClickMode = new EnumParameter<KnobClickMode>("Knob Click", KnobClickMode.RESET).setDescription("How to edit parameters when a knob is pressed");
    public final EnumParameter<FocusMode> focusMode = new EnumParameter<FocusMode>("Focus Buttons", FocusMode.DEVICE).setDescription("How to change focus on bottom side button press");
    public final DiscreteParameter currentBank = new DiscreteParameter("Bank", 0, 0, 4).setDescription("Which bank is selected on the MFT");
    public final BooleanParameter isAux = new BooleanParameter("Aux", false).setDescription("Whether this MFT controls the primary or aux channel");
    public static final byte MIDI_MFR_ID_0 = 0;
    public static final byte MIDI_MFR_ID_1 = 1;
    public static final byte MIDI_MFR_ID_2 = 121;
    public static final byte SYSEX_COMMAND_PUSH_CONF = 1;
    public static final byte SYSEX_COMMAND_PULL_CONF = 2;
    public static final byte SYSEX_COMMAND_SYSTEM = 3;
    public static final byte SYSEX_COMMAND_BULK_XFER = 4;
    public static final int CFG_COUNT_ENC = 15;
    public static final int CFG_COUNT_GLOBAL = 12;
    public static final byte CFG_FALSE = 0;
    public static final byte CFG_TRUE = 1;
    public static final byte CFG_GLOBAL_SSACTION_CCHOLD = 0;
    public static final byte CFG_GLOBAL_SSACTION_CCTOGGLE = 1;
    public static final byte CFG_GLOBAL_SSACTION_NOTEHOLD = 2;
    public static final byte CFG_GLOBAL_SSACTION_NOTETOGGLE = 3;
    public static final byte CFG_GLOBAL_SSACTION_SHIFTPAGE1 = 4;
    public static final byte CFG_GLOBAL_SSACTION_SHIFTPAGE2 = 5;
    public static final byte CFG_GLOBAL_SSACTION_BANKUP = 6;
    public static final byte CFG_GLOBAL_SSACTION_BANKDOWN = 7;
    public static final byte CFG_GLOBAL_SSACTION_BANK1 = 8;
    public static final byte CFG_GLOBAL_SSACTION_BANK2 = 9;
    public static final byte CFG_GLOBAL_SSACTION_BANK3 = 10;
    public static final byte CFG_GLOBAL_SSACTION_BANK4 = 11;
    public static final byte CFG_GLOBAL_SSACTION_CYCLE_BANK = 12;
    public static final byte CFG_ENC_CONTROLTYPE_ENCODER = 0;
    public static final byte CFG_ENC_CONTROLTYPE_SWITCH = 1;
    public static final byte CFG_ENC_CONTROLTYPE_SHIFT = 2;
    public static final byte CFG_ENC_MOVEMENTTYPE_DIRECT_HIGHRESOLUTION = 0;
    public static final byte CFG_ENC_MOVEMENTTYPE_EMULATION_RESPONSIVE = 1;
    public static final byte CFG_ENC_MOVEMENTTYPE_VELOCITYSENSITIVE = 2;
    public static final byte CFG_ENC_SWACTION_CCHOLD = 0;
    public static final byte CFG_ENC_SWACTION_CCTOGGLE = 1;
    public static final byte CFG_ENC_SWACTION_NOTEHOLD = 2;
    public static final byte CFG_ENC_SWACTION_NOTETOGGLE = 3;
    public static final byte CFG_ENC_SWACTION_ENCRESETVALUE = 4;
    public static final byte CFG_ENC_SWACTION_ENCFINEADJUST = 5;
    public static final byte CFG_ENC_SWACTION_SHIFTHOLD = 6;
    public static final byte CFG_ENC_SWACTION_SHIFTTOGGLE = 7;
    public static final byte CFG_ENC_MIDITYPE_SENDNOTE = 0;
    public static final byte CFG_ENC_MIDITYPE_SENDCC = 1;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENC = 2;
    public static final byte CFG_ENC_MIDITYPE_SENDNOTEOFF = 3;
    public static final byte CFG_ENC_MIDITYPE_SENDSWITCHVELCONTROL = 3;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENCMOUSEEMUDRAG = 4;
    public static final byte CFG_ENC_MIDITYPE_SENDRELENCMOUSEEMUSCROLL = 5;
    public static final byte CFG_ENC_INDICATORTYPE_DOT = 0;
    public static final byte CFG_ENC_INDICATORTYPE_BAR = 1;
    public static final byte CFG_ENC_INDICATORTYPE_BLENDEDBAR = 2;
    public static final byte CFG_ENC_INDICATORTYPE_BLENDEDDOT = 3;
    private boolean versionOK = true;
    private final Config userConfig = new Config();
    private final Config lxConfig = new Config();
    private final DeviceListener deviceListener;
    private boolean inUpdateBank = false;
    private boolean initializing = false;
    private boolean reconnecting = false;
    private boolean initialized = false;

    public MidiFighterTwister(LX lx, LXMidiInput input, LXMidiOutput output) {
        super(lx, input, output);
        this.deviceListener = new DeviceListener(lx);
        this.addSetting("knobClickMode", this.knobClickMode);
        this.addSetting("focusMode", this.focusMode);
        this.addSetting("isAux", this.isAux);
        this.addSetting("currentBank", this.currentBank);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (this.isAux == p) {
            this.deviceListener.focusedDevice.setAux(this.isAux.isOn());
            if (this.enabled.isOn()) {
                this.deviceListener.resend();
            }
        } else if (this.currentBank == p) {
            this.updateBank(this.currentBank.getValuei(), false);
        }
    }

    private void updateBank(int bank, boolean fromHardware) {
        if (this.inUpdateBank) {
            return;
        }
        this.inUpdateBank = true;
        if (fromHardware) {
            this.lx.command.perform(new LXCommand.Parameter.SetValue(this.currentBank, bank));
        } else {
            this.sendControlChange(3, bank, 127);
        }
        this.inUpdateBank = false;
        this.deviceListener.focusedDevice.updateRemoteControlFocus();
    }

    @Override
    protected void onEnable(boolean on) {
        if (on) {
            this.initializing = true;
            this.reconnecting = false;
            this.initialize();
        } else {
            if (this.deviceListener.isRegistered) {
                this.deviceListener.unregister();
            }
            this.restoreConfig();
        }
    }

    @Override
    protected void onReconnect() {
        if (this.initialized) {
            this.initializing = false;
            this.reconnecting = true;
        } else {
            this.initializing = true;
            this.reconnecting = false;
        }
        this.initialize();
    }

    private void initialize() {
        this.userConfig.pull();
    }

    private void initializeComplete() {
        if (!this.initializing && !this.reconnecting) {
            return;
        }
        this.initialized = true;
        if (this.initializing) {
            this.initializing = false;
            this.lxConfig.initializeLXDefaults();
            this.deviceListener.register();
        } else if (this.reconnecting) {
            this.reconnecting = false;
            this.deviceListener.resend(true);
        }
    }

    private void restoreConfig() {
        this.initializing = false;
        this.reconnecting = false;
        if (this.initialized) {
            this.initialized = false;
            int i = 0;
            while (i < 64) {
                this.sendControlChange(2, 0 + i, 48);
                this.sendControlChange(2, 0 + i, 95);
                this.sendControlChange(0, 0 + i, 0);
                this.sendControlChange(2, 0 + i, 47);
                this.sendControlChange(1, 0 + i, 50);
                ++i;
            }
            this.sendControlChange(3, 0, 127);
            if (this.userConfig.initialized) {
                this.userConfig.sendAll();
            }
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteReceived(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteReceived(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int channel = cc.getChannel();
        int number = cc.getCC();
        int value = cc.getValue();
        switch (channel) {
            case 0: {
                if (number >= 0 && number <= 64) {
                    int iKnob = number - 0;
                    if (value == 65 || value == 66 || value == 67) {
                        this.deviceListener.onKnobIncrement(iKnob, true);
                    } else if (value == 63 || value == 62 || value == 61) {
                        this.deviceListener.onKnobIncrement(iKnob, false);
                    } else {
                        LXMidiEngine.error("Received value " + value + " on MFT encoder " + number + ". Confirm Encoder MIDI Type is ENC 3FH/41H and controller is clean.");
                        if (value > 67) {
                            this.deviceListener.onKnobIncrement(iKnob, true);
                        } else if (value < 61) {
                            this.deviceListener.onKnobIncrement(iKnob, false);
                        }
                    }
                    return;
                }
                LXMidiEngine.error("MFT Unknown Knob: " + number);
                break;
            }
            case 1: {
                if (number >= 0 && number <= 64) {
                    this.deviceListener.onSwitch(number - 0, cc.getNormalized() > 0.0);
                    return;
                }
                LXMidiEngine.error("MFT Unknown Switch: " + number);
                break;
            }
            case 3: {
                switch (number) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (value == 127) {
                            this.updateBank(number, true);
                        }
                        return;
                    }
                    case 8: 
                    case 14: 
                    case 20: 
                    case 26: {
                        this.lx.command.perform(new LXCommand.Parameter.Increment(this.focusMode));
                        return;
                    }
                    case 11: 
                    case 17: 
                    case 23: 
                    case 29: {
                        this.lx.command.perform(new LXCommand.Parameter.Toggle(this.isAux));
                        return;
                    }
                    case 9: 
                    case 15: 
                    case 21: 
                    case 27: {
                        return;
                    }
                    case 12: 
                    case 18: 
                    case 24: 
                    case 30: {
                        return;
                    }
                    case 10: 
                    case 16: 
                    case 22: 
                    case 28: {
                        if (this.focusMode.getEnum() == FocusMode.CHANNEL) {
                            this.deviceListener.focusedDevice.previousChannel();
                            if (!this.isAux()) {
                                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                            }
                        } else {
                            this.deviceListener.focusedDevice.previousDevice();
                        }
                        return;
                    }
                    case 13: 
                    case 19: 
                    case 25: 
                    case 31: {
                        if (this.focusMode.getEnum() == FocusMode.CHANNEL) {
                            this.deviceListener.focusedDevice.nextChannel();
                            if (!this.isAux()) {
                                this.lx.engine.mixer.selectChannel(this.lx.engine.mixer.getFocusedChannel());
                            }
                        } else {
                            this.deviceListener.focusedDevice.nextDevice();
                        }
                        return;
                    }
                }
                LXMidiEngine.error("Unrecognized midi number " + number + " on system channel from MFT. Check your configuration with Midifighter Utility.");
                return;
            }
            default: {
                LXMidiEngine.error("Unrecognized midi channel " + channel + " from MFT. Check your configuration with Midifighter Utility.");
            }
        }
    }

    private void noteReceived(MidiNote note, boolean on) {
        LXMidiEngine.error("MFT UNMAPPED Note: " + String.valueOf(note) + " " + on);
    }

    @Override
    public void sysexReceived(LXSysexMessage sysex) {
        if (this.userConfig.isPulling()) {
            this.userConfig.sysexReceived(sysex);
        }
    }

    private boolean isAux() {
        return this.isAux.isOn();
    }

    @Override
    public int getRemoteControlStart() {
        return this.currentBank.getValuei() * 16;
    }

    @Override
    public int getRemoteControlLength() {
        return 16;
    }

    @Override
    public boolean isRemoteControlAux() {
        return this.isAux();
    }

    @Override
    public void dispose() {
        this.deviceListener.dispose();
        this.restoreConfig();
        super.dispose();
    }

    private class Config {
        private static final int CONFIG_PULL_TIMEOUT_MS = 1000;
        private static final int PART_SIZE_BYTES = 24;
        private static final int PULL_STEP_NONE = -3;
        private static final int PULL_STEP_IDENTITY = -2;
        private static final int PULL_STEP_GLOBAL = -1;
        private static final int PULL_STEP_FIRST_ENCODER = 0;
        private static final int NUM_PULL_ENCODERS = 64;
        private int pullStep = -3;
        private Encoder pullingEncoder;
        private LXEngine.Timer pullTimer;
        private boolean initialized = false;
        private final Map<Byte, Byte> global = new LinkedHashMap<Byte, Byte>();
        private final Map<Byte, Byte> encoderBulkResponse = new LinkedHashMap<Byte, Byte>();
        private final Encoder[] encoders = new Encoder[64];

        private Config() {
            this.initGlobal();
            int i = 0;
            while (i < 64) {
                this.encoders[i] = new Encoder(i);
                ++i;
            }
        }

        private void initGlobal() {
            this.global.clear();
            int g = 0;
            while (g <= 24) {
                this.global.put((byte)g, (byte)0);
                ++g;
            }
            this.global.put((byte)31, (byte)0);
            this.global.put((byte)32, (byte)0);
        }

        public boolean isPulling() {
            return this.pullStep != -3;
        }

        private void pull() {
            if (MidiFighterTwister.this.connected.isOn()) {
                if (this.pullStep != -3) {
                    this.pullTimer.cancel();
                    this.encoderBulkResponse.clear();
                    this.pullingEncoder = null;
                }
                this.pullStep = -2;
                this.pullTimer = MidiFighterTwister.this.lx.engine.addTimeout(1000.0, this::timedOut);
                LXSysexMessage sysex = LXSysexMessage.newIdentityRequest();
                MidiFighterTwister.this.sendSysex(sysex.getMessage());
            } else {
                MidiFighterTwister.this.initializeComplete();
            }
        }

        private void timedOut() {
            LXMidiEngine.error("MFT config pull exceeded timeout (1000ms)");
            this.pullTimer = null;
            this.pullStep = -3;
            this.encoderBulkResponse.clear();
            this.pullingEncoder = null;
            MidiFighterTwister.this.initializeComplete();
        }

        private void sysexReceived(LXSysexMessage sysex) {
            if (this.pullStep == -2) {
                if (this.handleIdentitySysex(sysex)) {
                    this.pullNext();
                }
            } else if (this.pullStep == -1) {
                if (this.handleGlobalSysex(sysex)) {
                    this.pullNext();
                }
            } else if (this.pullStep >= 0 && this.handleEncoderSysex(sysex)) {
                this.pullNext();
            }
        }

        private void pullNext() {
            ++this.pullStep;
            if (this.pullStep == -1) {
                this.pullTimer.reset();
                this.pullGlobal();
            } else if (this.pullStep < 64) {
                this.pullTimer.reset();
                this.pullingEncoder = this.encoders[this.pullStep];
                this.pullingEncoder.pull();
            } else {
                this.pullTimer.cancel();
                this.pullTimer = null;
                this.pullStep = -3;
                this.pullingEncoder = null;
                this.initialized = true;
                MidiFighterTwister.this.initializeComplete();
            }
        }

        private void pullGlobal() {
            byte[] payload = new byte[]{-16, 0, 1, 121, 2, 0, -9};
            MidiFighterTwister.this.sendSysex(payload);
        }

        private boolean handleIdentitySysex(LXSysexMessage sysex) {
            if (sysex.getLength() < 17) {
                return false;
            }
            byte[] m = sysex.getMessage();
            if (m[0] != -16 || m[1] != 126 || m[3] != 6 || m[4] != 2) {
                LXMidiEngine.error("Invalid sysex header for identity response");
                return false;
            }
            if (m[5] != 0 || m[6] != 1 || m[7] != 121) {
                LXMidiEngine.error("Invalid manufacturer ID in sysex identity response");
                return false;
            }
            if (m[8] != 5 || m[9] != 0) {
                LXMidiEngine.error("Device ID does not match MidiFighterTwister");
                return false;
            }
            int year = this.byteNumber(m[12]) * 100 + this.byteNumber(m[13]);
            MidiFighterTwister.this.versionOK = year > 2016;
            return true;
        }

        private boolean handleGlobalSysex(LXSysexMessage sysex) {
            int length = sysex.getLength();
            if (length < 6) {
                return false;
            }
            byte[] m = sysex.getMessage();
            if (m[0] != -16 || m[1] != 0 || m[2] != 1 || m[3] != 121 || m[4] != 2 || m[5] != 1) {
                LXMidiEngine.error("Invalid sysex header for global config pull");
                return false;
            }
            this.initGlobal();
            int i = 6;
            while (i < length - 1) {
                Byte address = m[i];
                Byte value = m[i + 1];
                this.global.put(address, value);
                i += 2;
            }
            return true;
        }

        private boolean handleEncoderSysex(LXSysexMessage sysex) {
            if (sysex.getLength() < 11) {
                return false;
            }
            byte[] m = sysex.getMessage();
            if (m[0] != -16 || m[1] != 0 || m[2] != 1 || m[3] != 121 || m[4] != 4 || m[5] != 0) {
                LXMidiEngine.error("Invalid sysex response header for encoder pull");
                return false;
            }
            byte tagEncoder = m[6];
            if (tagEncoder != this.pullingEncoder.sysexTag) {
                LXMidiEngine.error(String.format("Sysex encoder response (%02X) did not match expected (%d)", tagEncoder, this.pullStep + 1));
                return false;
            }
            byte part = m[7];
            byte totalParts = m[8];
            byte payloadSize = m[9];
            int i = 0;
            while (i < payloadSize - 1) {
                Byte address = m[10 + i];
                Byte value = m[11 + i];
                if (!this.encoderBulkResponse.containsKey(address)) {
                    this.encoderBulkResponse.put(address, value);
                } else {
                    LXMidiEngine.error("MFT sysex encoder response contained duplicate setting: " + String.valueOf(address));
                }
                i += 2;
            }
            if (part == totalParts) {
                Encoder encoder = this.encoders[this.pullStep];
                encoder.setBulk(this.encoderBulkResponse);
                if (this.pullStep == 0) {
                    for (Map.Entry<Byte, Byte> entry : this.encoderBulkResponse.entrySet()) {
                        this.global.put(entry.getKey(), entry.getValue());
                    }
                }
                this.encoderBulkResponse.clear();
                return true;
            }
            return false;
        }

        private int byteNumber(byte b) {
            return ((b & 0xF0) >> 4) * 10 + (b & 0xF);
        }

        private void sendAll() {
            this.sendEncoders(true);
            this.sendGlobal();
        }

        private void sendModified() {
            if (this.sendEncoders(false)) {
                this.sendGlobal();
            }
        }

        private boolean sendEncoders(boolean forceAll) {
            if (!this.initialized) {
                LXMidiEngine.error("Cannot push empty config to MFT device");
                return false;
            }
            if (!MidiFighterTwister.this.versionOK) {
                LXMidiEngine.error("Cannot push config to MFT device running old firmware");
                return false;
            }
            boolean modified = false;
            int i = 0;
            while (i < this.encoders.length) {
                if (this.encoders[i].isModified || forceAll) {
                    this.encoders[i].send(forceAll);
                    modified = true;
                }
                ++i;
            }
            return modified;
        }

        private void sendGlobal() {
            if (!this.initialized) {
                LXMidiEngine.error("Cannot push empty config to MFT device");
                return;
            }
            if (!MidiFighterTwister.this.versionOK) {
                LXMidiEngine.error("Cannot push config to MFT device running old firmware");
                return;
            }
            byte[] sysex = new byte[this.global.size() * 2 + 6];
            sysex[0] = -16;
            sysex[1] = 0;
            sysex[2] = 1;
            sysex[3] = 121;
            sysex[4] = 1;
            int iSys = 5;
            for (Map.Entry<Byte, Byte> g : this.global.entrySet()) {
                sysex[iSys++] = g.getKey();
                sysex[iSys++] = g.getValue();
            }
            sysex[iSys] = -9;
            MidiFighterTwister.this.sendSysex(sysex);
        }

        private void initializeLXDefaults() {
            this.initGlobal();
            this.global.put((byte)0, (byte)4);
            this.global.put((byte)1, (byte)1);
            this.global.put((byte)2, (byte)1);
            this.global.put((byte)3, (byte)7);
            this.global.put((byte)4, (byte)1);
            this.global.put((byte)5, (byte)1);
            this.global.put((byte)6, (byte)6);
            this.global.put((byte)7, (byte)1);
            this.global.put((byte)8, (byte)63);
            this.global.put((byte)9, (byte)127);
            this.global.put((byte)10, (byte)0);
            this.global.put((byte)11, (byte)0);
            this.global.put((byte)12, (byte)0);
            this.global.put((byte)13, (byte)2);
            this.global.put((byte)14, (byte)0);
            this.global.put((byte)15, (byte)0);
            this.global.put((byte)16, (byte)1);
            this.global.put((byte)17, (byte)0);
            this.global.put((byte)18, (byte)2);
            this.global.put((byte)19, (byte)51);
            this.global.put((byte)20, (byte)1);
            this.global.put((byte)21, (byte)63);
            this.global.put((byte)22, (byte)2);
            this.global.put((byte)23, (byte)0);
            this.global.put((byte)24, (byte)0);
            this.global.put((byte)31, (byte)127);
            this.global.put((byte)32, (byte)127);
            int i = 0;
            while (i < this.encoders.length) {
                Encoder enc = this.encoders[i];
                enc.setDetent(false);
                enc.set("movement", (byte)0);
                enc.set("switch_action_type", (byte)0);
                enc.set("switch_midi_channel", (byte)2);
                enc.set("switch_midi_number", (byte)enc.encoderIndex);
                enc.set("switch_midi_type", (byte)0);
                enc.set("encoder_midi_channel", (byte)1);
                enc.set("encoder_midi_number", (byte)enc.encoderIndex);
                enc.set("encoder_midi_type", (byte)2);
                enc.set("active_color", (byte)51);
                enc.set("inactive_color", (byte)1);
                enc.set("detent_color", (byte)63);
                enc.set("indicator_display_type", (byte)2);
                enc.set("is_super_knob", (byte)0);
                enc.set("encoder_shift_midi_channel", (byte)0);
                enc.isModified = true;
                ++i;
            }
            this.initialized = true;
        }

        private void initializeUserDefaults() {
            this.initGlobal();
            this.global.put((byte)0, (byte)4);
            this.global.put((byte)1, (byte)1);
            this.global.put((byte)2, (byte)1);
            this.global.put((byte)3, (byte)7);
            this.global.put((byte)4, (byte)1);
            this.global.put((byte)5, (byte)1);
            this.global.put((byte)6, (byte)6);
            this.global.put((byte)7, (byte)1);
            this.global.put((byte)8, (byte)63);
            this.global.put((byte)9, (byte)127);
            this.global.put((byte)10, (byte)0);
            this.global.put((byte)11, (byte)0);
            this.global.put((byte)12, (byte)0);
            this.global.put((byte)13, (byte)2);
            this.global.put((byte)14, (byte)0);
            this.global.put((byte)15, (byte)0);
            this.global.put((byte)16, (byte)1);
            this.global.put((byte)17, (byte)0);
            this.global.put((byte)18, (byte)1);
            this.global.put((byte)19, (byte)51);
            this.global.put((byte)20, (byte)1);
            this.global.put((byte)21, (byte)63);
            this.global.put((byte)22, (byte)2);
            this.global.put((byte)23, (byte)0);
            this.global.put((byte)24, (byte)0);
            this.global.put((byte)31, (byte)127);
            this.global.put((byte)32, (byte)127);
            int i = 0;
            while (i < this.encoders.length) {
                Encoder enc = this.encoders[i];
                enc.setDetent(false);
                enc.set("movement", (byte)0);
                enc.set("switch_action_type", (byte)2);
                enc.set("switch_midi_channel", (byte)2);
                enc.set("switch_midi_number", (byte)enc.encoderIndex);
                enc.set("switch_midi_type", (byte)0);
                enc.set("encoder_midi_channel", (byte)1);
                enc.set("encoder_midi_number", (byte)enc.encoderIndex);
                enc.set("encoder_midi_type", (byte)1);
                enc.set("active_color", (byte)51);
                enc.set("inactive_color", (byte)50);
                enc.set("detent_color", (byte)63);
                enc.set("indicator_display_type", (byte)2);
                enc.set("is_super_knob", (byte)0);
                enc.set("encoder_shift_midi_channel", (byte)0);
                ++i;
            }
            this.initialized = true;
        }

        private String bytesToString(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02X ", b));
                ++n2;
            }
            return sb.toString();
        }

        private class Encoder {
            private final int encoderIndex;
            private final byte sysexTag;
            private boolean isModified = false;
            private final Map<String, Setting> settings = new LinkedHashMap<String, Setting>();
            private final Map<Byte, Setting> settingsByAddress = new LinkedHashMap<Byte, Setting>();
            private final Setting has_detent;

            private Setting addSetting(String name, int address) {
                Setting setting = new Setting((byte)address);
                this.settings.put(name, setting);
                this.settingsByAddress.put(setting.address, setting);
                return setting;
            }

            private Encoder(int encoderIndex) {
                this.encoderIndex = encoderIndex;
                this.sysexTag = (byte)(encoderIndex + 1);
                this.has_detent = this.addSetting("has_detent", 10);
                this.addSetting("movement", 11);
                this.addSetting("switch_action_type", 12);
                this.addSetting("switch_midi_channel", 13);
                this.addSetting("switch_midi_number", 14);
                this.addSetting("switch_midi_type", 15);
                this.addSetting("encoder_midi_channel", 16);
                this.addSetting("encoder_midi_number", 17);
                this.addSetting("encoder_midi_type", 18);
                this.addSetting("active_color", 19);
                this.addSetting("inactive_color", 20);
                this.addSetting("detent_color", 21);
                this.addSetting("indicator_display_type", 22);
                this.addSetting("is_super_knob", 23);
                this.addSetting("encoder_shift_midi_channel", 24);
            }

            private void setDetent(boolean value) {
                this.set("has_detent", value ? (byte)1 : 0);
            }

            private void set(String setting, byte value) {
                this.isModified = this.settings.get(setting).setValue(value) || this.isModified;
            }

            private void send(boolean forceAll) {
                if (!this.isModified && !forceAll) {
                    return;
                }
                ArrayList<Byte> configData = new ArrayList<Byte>();
                for (Setting setting : this.settings.values()) {
                    if (!setting.isModified && !forceAll) continue;
                    configData.add(setting.address);
                    configData.add(setting.value);
                }
                if (!configData.isEmpty()) {
                    int bytesRemaining = configData.size();
                    int total = (bytesRemaining + 24 - 1) / 24;
                    int iConfig = 0;
                    int part = 1;
                    while (part <= total) {
                        int size = LXUtils.min(bytesRemaining, 24);
                        bytesRemaining -= 24;
                        byte[] payload = new byte[size + 11];
                        payload[0] = -16;
                        payload[1] = 0;
                        payload[2] = 1;
                        payload[3] = 121;
                        payload[4] = 4;
                        payload[5] = 0;
                        payload[6] = this.sysexTag;
                        payload[7] = (byte)part;
                        payload[8] = (byte)total;
                        payload[9] = (byte)size;
                        payload[payload.length - 1] = -9;
                        int idx = 10;
                        while (idx < size + 10) {
                            payload[idx] = (Byte)configData.get(iConfig++);
                            ++idx;
                        }
                        MidiFighterTwister.this.sendSysex(payload);
                        ++part;
                    }
                }
                this.isModified = false;
                for (Setting setting : this.settings.values()) {
                    setting.resetModified();
                }
            }

            private void pull() {
                byte[] payload = new byte[]{-16, 0, 1, 121, 4, 1, this.sysexTag, -9};
                MidiFighterTwister.this.sendSysex(payload);
            }

            private void setBulk(Map<Byte, Byte> bulkResponse) {
                LinkedHashMap<Byte, Setting> settingsCopy = new LinkedHashMap<Byte, Setting>(this.settingsByAddress);
                for (Map.Entry<Byte, Byte> entry : bulkResponse.entrySet()) {
                    Byte address = entry.getKey();
                    Byte value = entry.getValue();
                    Setting setting = (Setting)settingsCopy.remove(address);
                    if (setting == null) {
                        LXMidiEngine.error("MFT encoder pulled unknown setting. Is this a new firmware?");
                        setting = this.addSetting("unknown", address.byteValue());
                    }
                    setting.setValue(value);
                    setting.resetModified();
                }
                for (Map.Entry<Byte, Byte> entry : settingsCopy.entrySet()) {
                    LXMidiEngine.error("Known MFT encoder setting was not found in bulk pull: " + String.valueOf(entry.getKey()));
                    ((Setting)((Object)entry.getValue())).resetModified();
                }
                this.isModified = false;
            }

            private class Setting {
                private final byte address;
                private byte value;
                private boolean isModified;

                private Setting(byte address) {
                    this.address = address;
                    this.value = 0;
                    this.isModified = false;
                }

                private boolean setValue(byte value) {
                    if (this.value != value) {
                        this.value = value;
                        this.isModified = true;
                    }
                    return this.isModified;
                }

                private void resetModified() {
                    this.isModified = false;
                }
            }
        }
    }

    private class DeviceListener
    implements FocusedDevice.Listener,
    LXParameterListener {
        private final FocusedDevice focusedDevice;
        private LXDeviceComponent device = null;
        private final LXListenableNormalizedParameter[] knobs = new LXListenableNormalizedParameter[64];
        private final int[] knobTicks = new int[64];
        private final int[] knobIncrementSize = new int[64];
        private static final double KNOB_INCREMENT_AMOUNT = 0.007874015748031496;
        private final double[] tempValues = new double[64];
        private boolean isRegistered = false;

        private DeviceListener(LX lx) {
            int i = 0;
            while (i < this.knobs.length) {
                this.knobs[i] = null;
                this.knobTicks[i] = 0;
                this.knobIncrementSize[i] = 1;
                ++i;
            }
            this.focusedDevice = new FocusedDevice(lx, MidiFighterTwister.this, this);
            this.focusedDevice.setAuxSticky(true);
        }

        @Override
        public void onDeviceFocused(LXDeviceComponent device) {
            this.registerDevice(device);
        }

        private void resend() {
            this.resend(false);
        }

        private void resend(boolean forceAll) {
            LXListenableNormalizedParameter parameter;
            boolean isAux = MidiFighterTwister.this.isAux();
            int i = 0;
            while (i < this.knobs.length) {
                Config.Encoder enc;
                parameter = this.knobs[i];
                Config.Encoder encoder = enc = i < MidiFighterTwister.this.lxConfig.encoders.length ? MidiFighterTwister.this.lxConfig.encoders[i] : null;
                if (parameter != null && enc != null) {
                    enc.setDetent(parameter.getPolarity() == LXParameter.Polarity.BIPOLAR);
                } else if (enc != null) {
                    enc.setDetent(false);
                }
                ++i;
            }
            if (forceAll) {
                MidiFighterTwister.this.lxConfig.sendAll();
                MidiFighterTwister.this.sendControlChange(3, MidiFighterTwister.this.currentBank.getValuei(), 127);
            } else {
                MidiFighterTwister.this.lxConfig.sendModified();
            }
            i = 0;
            while (i < this.knobs.length) {
                parameter = this.knobs[i];
                if (parameter != null) {
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 95);
                    double normalized = parameter.getBaseNormalized();
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 47);
                    MidiFighterTwister.this.sendControlChange(1, 0 + i, isAux ? 80 : 1);
                } else {
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                    if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                        MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                    } else {
                        MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                    }
                    MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
                }
                ++i;
            }
        }

        private void registerDevice(LXDeviceComponent device) {
            if (this.device != device) {
                this.unregisterDevice();
                this.device = device;
                if (this.device != null) {
                    this.device.remoteControlsChanged.addListener(this);
                }
                this.registerDeviceKnobs();
            }
        }

        private void registerDeviceKnobs() {
            int e = 0;
            if (this.device != null) {
                LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.device.getRemoteControls();
                int n = lXListenableNormalizedParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LXListenableNormalizedParameter parameter = lXListenableNormalizedParameterArray[n2];
                    if (e >= this.knobs.length || e >= MidiFighterTwister.this.lxConfig.encoders.length) break;
                    Config.Encoder enc = MidiFighterTwister.this.lxConfig.encoders[e];
                    if (parameter != null) {
                        enc.setDetent(parameter.getPolarity() == LXParameter.Polarity.BIPOLAR);
                    } else {
                        enc.setDetent(false);
                    }
                    ++e;
                    ++n2;
                }
            }
            MidiFighterTwister.this.lxConfig.sendModified();
            int i = 0;
            if (this.device != null) {
                boolean isAux = MidiFighterTwister.this.isAux();
                ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
                LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.device.getRemoteControls();
                int n = lXListenableNormalizedParameterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LXListenableNormalizedParameter parameter = lXListenableNormalizedParameterArray[n3];
                    if (i >= this.knobs.length) break;
                    this.knobs[i] = parameter;
                    this.knobTicks[i] = 0;
                    if (parameter != null) {
                        DiscreteParameter discrete;
                        if (parameter instanceof DiscreteParameter && (discrete = (DiscreteParameter)parameter).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                            this.knobTicks[i] = (int)(parameter.getNormalized() * 127.0);
                            this.knobIncrementSize[i] = LXUtils.max(1, (int)(127L / discrete.getRange()));
                        }
                        if (!uniqueParameters.contains(parameter)) {
                            parameter.addListener(this);
                            uniqueParameters.add(parameter);
                        }
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 95);
                        double normalized = parameter.getBaseNormalized();
                        MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 47);
                        if (parameter instanceof LXCompoundModulation.Target && ((LXCompoundModulation.Target)((Object)parameter)).getModulations().size() > 0) {
                            MidiFighterTwister.this.sendControlChange(2, 0 + i, 12);
                        } else {
                            MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                        }
                    } else {
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                        if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                            MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                        } else {
                            MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                        }
                        MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
                    }
                    MidiFighterTwister.this.sendControlChange(1, 0 + i, isAux ? 80 : 1);
                    ++i;
                    ++n3;
                }
            }
            while (i < this.knobs.length) {
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 0);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 48);
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 72);
                if (i <= MidiFighterTwister.this.lxConfig.encoders.length && MidiFighterTwister.this.lxConfig.encoders[i].has_detent.value == 1) {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 63);
                } else {
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, 0);
                }
                MidiFighterTwister.this.sendControlChange(2, 0 + i, 17);
                ++i;
            }
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            if (parameter == this.device.remoteControlsChanged) {
                this.unregisterDeviceKnobs();
                this.registerDeviceKnobs();
                return;
            }
            int i = 0;
            while (i < this.knobs.length) {
                if (parameter == this.knobs[i]) {
                    double normalized = this.knobs[i].getBaseNormalized();
                    if (parameter instanceof DiscreteParameter && ((DiscreteParameter)parameter).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                        this.knobTicks[i] = (int)(normalized * 127.0);
                    }
                    MidiFighterTwister.this.sendControlChange(0, 0 + i, (int)(normalized * 127.0));
                }
                ++i;
            }
        }

        private void onKnobIncrement(int index, boolean isUp) {
            LXListenableNormalizedParameter knob = this.knobs[index];
            if (knob != null) {
                if (knob instanceof DiscreteParameter) {
                    if (((DiscreteParameter)knob).getIncrementMode() == DiscreteParameter.IncrementMode.NORMALIZED) {
                        int value = this.knobTicks[index] + (isUp ? 1 : -1);
                        if (knob.isWrappable()) {
                            if (value < 0 - this.knobIncrementSize[index] || value > 127 + this.knobIncrementSize[index]) {
                                value = value < 0 ? 127 : 0;
                            }
                            this.knobTicks[index] = value;
                            value = LXUtils.constrain(value, 0, 127);
                        } else {
                            this.knobTicks[index] = value = LXUtils.constrain(value, 0, 127);
                        }
                        knob.setNormalized((double)value / 127.0);
                    } else {
                        this.knobTicks[index] = isUp ? LXUtils.max(this.knobTicks[index], 0) + 1 : LXUtils.min(this.knobTicks[index], 0) - 1;
                        if (this.knobTicks[index] == 8 * (isUp ? 1 : -1)) {
                            this.knobTicks[index] = 0;
                            if (isUp) {
                                ((DiscreteParameter)knob).increment();
                            } else {
                                ((DiscreteParameter)knob).decrement();
                            }
                        }
                    }
                } else {
                    knob.incrementNormalized(0.007874015748031496 * (double)(isUp ? 1 : -1));
                }
            }
        }

        private void onSwitch(int index, boolean isPressed) {
            if (this.knobs[index] != null) {
                LXListenableNormalizedParameter p = this.knobs[index];
                if (p instanceof BooleanParameter) {
                    BooleanParameter bp = (BooleanParameter)p;
                    if (bp.getMode() == BooleanParameter.Mode.MOMENTARY) {
                        bp.setValue(isPressed);
                    } else if (isPressed) {
                        bp.toggle();
                    }
                } else if (isPressed) {
                    switch (MidiFighterTwister.this.knobClickMode.getEnum()) {
                        case RESET: {
                            p.reset();
                            break;
                        }
                        case TEMPORARY: {
                            this.tempValues[index] = p.getBaseNormalized();
                        }
                    }
                } else {
                    switch (MidiFighterTwister.this.knobClickMode.getEnum()) {
                        case RESET: {
                            break;
                        }
                        case TEMPORARY: {
                            p.setNormalized(this.tempValues[index]);
                        }
                    }
                }
            }
        }

        private void unregisterDevice() {
            if (this.device != null) {
                this.device.remoteControlsChanged.removeListener(this);
                this.unregisterDeviceKnobs();
            }
            this.device = null;
        }

        private void unregisterDeviceKnobs() {
            ArrayList<LXListenableNormalizedParameter> uniqueParameters = new ArrayList<LXListenableNormalizedParameter>();
            int i = 0;
            while (i < this.knobs.length) {
                if (this.knobs[i] != null) {
                    if (!uniqueParameters.contains(this.knobs[i])) {
                        uniqueParameters.add(this.knobs[i]);
                        this.knobs[i].removeListener(this);
                    }
                    this.knobs[i] = null;
                    this.knobTicks[i] = 0;
                    this.knobIncrementSize[i] = 1;
                }
                ++i;
            }
        }

        private void register() {
            this.isRegistered = true;
            this.focusedDevice.register();
        }

        private void unregister() {
            this.isRegistered = false;
            this.focusedDevice.unregister();
        }

        private void dispose() {
            this.focusedDevice.dispose();
        }
    }

    public static enum FocusMode {
        DEVICE("Device"),
        CHANNEL("Channel");

        private final String label;

        private FocusMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum KnobClickMode {
        RESET("Reset"),
        TEMPORARY("Temporary Edit");

        private final String label;

        private KnobClickMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

