/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.surface;

import heronarts.lx.LX;
import heronarts.lx.clip.LXClipEngine;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.utils.LXUtils;

public class MixerSurface
implements LXParameterListener {
    private final LX lx;
    private final Listener listener;
    public final int bankWidth;
    private int bankHeight = 0;
    public final DiscreteParameter channelNumber = new DiscreteParameter("Channel Num", 1, 2).setDescription("Channel number that the mixer surface begins at");
    public final DiscreteParameter gridClipOffset = new DiscreteParameter("Grid Clip Offset", 0, 1).setDescription("Row offset for grid clip triggering");
    public final DiscreteParameter gridPatternOffset = new DiscreteParameter("Grid Pattern Offset", 0, 1).setDescription("Row offset for grid pattern triggering");
    private final LXAbstractChannel[] channels;
    private boolean hasGrid = false;
    private LXClipEngine.GridMode gridMode = LXClipEngine.GridMode.PATTERNS;
    private final LXParameterListener onChannelIndexChanged = this::onChannelIndexChanged;
    private final LXParameterListener onGridOffsetChanged = this::onGridOffsetChanged;
    private final LXMixerEngine.Listener mixerEngineListener = new LXMixerEngine.Listener(){

        @Override
        public void channelAdded(LXMixerEngine mixer, LXAbstractChannel channel) {
            MixerSurface.this.setChannelIndexRange();
            MixerSurface.this.refreshChannels();
        }

        @Override
        public void channelMoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            MixerSurface.this.refreshChannels();
        }

        @Override
        public void channelRemoved(LXMixerEngine mixer, LXAbstractChannel channel) {
            MixerSurface.this.setChannelIndexRange();
            MixerSurface.this.refreshChannels();
        }
    };
    private boolean isRegistered = false;

    public MixerSurface(LX lx, Listener listener, int bankWidth) {
        this(lx, listener, bankWidth, 0);
    }

    public MixerSurface(LX lx, Listener listener, int bankWidth, int bankHeight) {
        this.lx = lx;
        this.listener = listener;
        this.bankWidth = bankWidth;
        this.bankHeight = bankHeight;
        this.channels = new LXAbstractChannel[bankWidth];
        this.setChannelIndexRange();
        lx.engine.clips.numScenes.addListener(this, true);
        lx.engine.clips.numPatterns.addListener(this, true);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.lx.engine.clips.numScenes) {
            this.gridClipOffset.setRange(this.lx.engine.clips.numScenes.getValuei());
        } else if (p == this.lx.engine.clips.numPatterns) {
            this.gridPatternOffset.setRange(this.lx.engine.clips.numPatterns.getValuei());
        }
    }

    public MixerSurface setGridMode(LXClipEngine.GridMode gridMode) {
        if (this.gridMode != gridMode) {
            this.hasGrid = gridMode != null;
            this.gridMode = gridMode;
            if (this.isRegistered) {
                this.lx.engine.clips.controlSurfaceSemaphore.bang();
            }
        }
        return this;
    }

    public boolean hasGrid() {
        return this.hasGrid;
    }

    public LXClipEngine.GridMode getGridMode() {
        return this.gridMode;
    }

    private void setChannelIndexRange() {
        this.channelNumber.setRange(1, LXUtils.max(2, 1 + this.lx.engine.mixer.channels.size()));
    }

    public int getChannelIndex() {
        return this.channelNumber.getValuei() - 1;
    }

    public void incrementGridOffset() {
        switch (this.gridMode) {
            case CLIPS: {
                this.gridClipOffset.increment();
                break;
            }
            case PATTERNS: {
                this.gridPatternOffset.increment();
            }
        }
    }

    public void decrementGridOffset() {
        switch (this.gridMode) {
            case CLIPS: {
                this.gridClipOffset.decrement();
                break;
            }
            case PATTERNS: {
                this.gridPatternOffset.decrement();
            }
        }
    }

    public int getGridOffset() {
        switch (this.gridMode) {
            case CLIPS: {
                return this.gridClipOffset.getValuei();
            }
            case PATTERNS: {
                return this.gridPatternOffset.getValuei();
            }
        }
        return 0;
    }

    public int getGridClipOffset() {
        return this.gridClipOffset.getValuei();
    }

    public int getGridPatternOffset() {
        return this.gridPatternOffset.getValuei();
    }

    public int getBankWidth() {
        return this.bankWidth;
    }

    public int getBankHeight() {
        return this.bankHeight;
    }

    public void incrementChannel() {
        this.channelNumber.increment(1);
    }

    public void decrementChannel() {
        this.channelNumber.decrement(1);
    }

    public void incrementBank() {
        this.channelNumber.increment(this.bankWidth);
    }

    public void decrementBank() {
        this.channelNumber.decrement(this.bankWidth);
    }

    private void onChannelIndexChanged(LXParameter p) {
        if (this.isRegistered) {
            this.lx.engine.clips.controlSurfaceSemaphore.bang();
            this.refreshChannels();
        }
    }

    private void onGridOffsetChanged(LXParameter p) {
        if (this.isRegistered) {
            this.listener.onGridOffsetChanged();
            this.lx.engine.clips.controlSurfaceSemaphore.bang();
        }
    }

    public LXAbstractChannel getChannel(int index) {
        if (index >= 0 && index < this.channels.length) {
            return this.channels[index];
        }
        return null;
    }

    public boolean contains(LXAbstractChannel channel) {
        LXAbstractChannel[] lXAbstractChannelArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            LXAbstractChannel contains = lXAbstractChannelArray[n2];
            if (contains == channel) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getIndex(LXAbstractChannel channel) {
        int i = 0;
        while (i < this.channels.length) {
            if (this.channels[i] == channel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void register() {
        if (this.isRegistered) {
            throw new IllegalStateException("Cannot double-register MixerSurface");
        }
        this.setChannelIndexRange();
        this.channelNumber.addListener(this.onChannelIndexChanged);
        this.gridClipOffset.addListener(this.onGridOffsetChanged);
        this.gridPatternOffset.addListener(this.onGridOffsetChanged);
        this.lx.engine.clips.addControlSurface(this);
        this.lx.engine.mixer.addListener(this.mixerEngineListener);
        this.refreshChannels();
        this.isRegistered = true;
    }

    public void unregister() {
        if (!this.isRegistered) {
            throw new IllegalStateException("Cannot unregister non-registered MixerSurface");
        }
        this.channelNumber.removeListener(this.onChannelIndexChanged);
        this.gridClipOffset.removeListener(this.onGridOffsetChanged);
        this.gridPatternOffset.removeListener(this.onGridOffsetChanged);
        this.lx.engine.mixer.removeListener(this.mixerEngineListener);
        this.lx.engine.clips.removeControlSurface(this);
        this.clearChannels();
        this.isRegistered = false;
    }

    private void clearChannels() {
        int i = 0;
        while (i < this.channels.length) {
            this.setChannel(i, null);
            ++i;
        }
    }

    private void setChannel(int index, LXAbstractChannel channel) {
        if (index < 0 || index >= this.bankWidth) {
            throw new IllegalArgumentException("setChannel() index must be in bounds: " + index);
        }
        if (this.channels[index] != channel) {
            LXAbstractChannel previous = this.channels[index];
            this.channels[index] = channel;
            this.listener.onChannelChanged(index, channel, previous);
        }
    }

    private void refreshChannels() {
        int indexOffset = this.getChannelIndex();
        int numChannels = this.lx.engine.mixer.channels.size();
        int i = 0;
        while (i < this.bankWidth) {
            int targetIndex = indexOffset + i;
            this.setChannel(i, targetIndex < numChannels ? this.lx.engine.mixer.channels.get(targetIndex) : null);
            ++i;
        }
    }

    public void dispose() {
        if (this.isRegistered) {
            this.unregister();
            this.isRegistered = false;
        }
        this.lx.engine.clips.numScenes.removeListener(this);
        this.lx.engine.clips.numPatterns.removeListener(this);
    }

    public static interface Listener {
        public void onChannelChanged(int var1, LXAbstractChannel var2, LXAbstractChannel var3);

        public void onGridOffsetChanged();
    }
}

