/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.template;

import heronarts.lx.LX;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.Arrays;

@LXMidiTemplate.Name(value="Akai MPD218")
@LXMidiTemplate.DeviceName(value="MPD218")
public class AkaiMPD218
extends LXMidiTemplate
implements LXMidiTemplate.Bidirectional {
    public static final int NUM_BANKS = 3;
    public static final int NUM_PADS = 16;
    public static final int NUM_KNOBS = 6;
    private static final int[] NOTE_TO_PAD = new int[128];
    private static final int[] CC_TO_KNOB = new int[128];
    private static final int PAD_BANK_A = 36;
    private static final int PAD_BANK_B = 52;
    private static final int PAD_BANK_C = 68;
    private static final int KNOB_BANK_A1 = 3;
    private static final int KNOB_BANK_A2 = 9;
    private static final int KNOB_BANK_A3 = 12;
    private static final int KNOB_BANK_A4 = 13;
    private static final int KNOB_BANK_A5 = 14;
    private static final int KNOB_BANK_A6 = 15;
    private static final int KNOB_BANK_B = 16;
    private static final int KNOB_BANK_C = 22;
    private static final int[] KNOB_TO_CC = new int[]{3, 9, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    public final EnumParameter<Bank> bank = new EnumParameter<Bank>("Bank", Bank.A).setDescription("Which MPD bank is visible for editing");
    public final BooleanParameter[] pads = new BooleanParameter[48];
    public final Knob[] knobs = new Knob[18];

    static {
        Arrays.fill(NOTE_TO_PAD, -1);
        Arrays.fill(CC_TO_KNOB, -1);
        int i = 0;
        while (i < 16) {
            AkaiMPD218.NOTE_TO_PAD[36 + i] = i;
            AkaiMPD218.NOTE_TO_PAD[52 + i] = 16 + i;
            AkaiMPD218.NOTE_TO_PAD[68 + i] = 32 + i;
            ++i;
        }
        i = 0;
        while (i < 6) {
            AkaiMPD218.CC_TO_KNOB[16 + i] = 6 + i;
            AkaiMPD218.CC_TO_KNOB[22 + i] = 12 + i;
            ++i;
        }
        AkaiMPD218.CC_TO_KNOB[3] = 0;
        AkaiMPD218.CC_TO_KNOB[9] = 1;
        AkaiMPD218.CC_TO_KNOB[12] = 2;
        AkaiMPD218.CC_TO_KNOB[13] = 3;
        AkaiMPD218.CC_TO_KNOB[14] = 4;
        AkaiMPD218.CC_TO_KNOB[15] = 5;
    }

    public AkaiMPD218(LX lx) {
        super(lx);
        Bank[] bankArray = Bank.values();
        int n = bankArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String label;
            Bank bank = bankArray[n2];
            int i = 0;
            while (i < 16) {
                label = bank.toString() + (i + 1);
                index = bank.ordinal() * 16 + i;
                this.pads[index] = new Pad("P" + label);
                this.addParameter("pad-" + label, this.pads[index]);
                ++i;
            }
            i = 0;
            while (i < 6) {
                label = bank.toString() + (i + 1);
                index = bank.ordinal() * 6 + i;
                this.knobs[index] = new Knob(label, KNOB_TO_CC[index]);
                this.addParameter("knob-" + label, this.knobs[index]);
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p instanceof Knob) {
            Knob knob = (Knob)p;
            this.sendControlChange(0, knob.cc, (int)Math.round(127.0 * knob.getValue()));
        }
    }

    @Override
    protected void initializeOutput() {
        int cc = 0;
        while (cc < CC_TO_KNOB.length) {
            int knob = CC_TO_KNOB[cc];
            if (knob >= 0) {
                this.sendControlChange(0, cc, (int)Math.round(127.0 * this.knobs[knob].getValue()));
            }
            ++cc;
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        int pad = NOTE_TO_PAD[note.getPitch()];
        if (pad >= 0) {
            this.pads[pad].setValue(true);
        }
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        int pad = NOTE_TO_PAD[note.getPitch()];
        if (pad >= 0) {
            this.pads[pad].setValue(false);
        }
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int knob = CC_TO_KNOB[cc.getCC()];
        if (knob >= 0) {
            this.knobs[knob].setNormalized(cc.getNormalized());
        }
    }

    @Override
    public void midiPanicReceived() {
        BooleanParameter[] booleanParameterArray = this.pads;
        int n = this.pads.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanParameter pad = booleanParameterArray[n2];
            pad.setValue(false);
            ++n2;
        }
    }

    public static enum Bank {
        A,
        B,
        C;

    }

    private class Knob
    extends BoundedParameter {
        private final int cc;

        private Knob(String label, int cc) {
            super(label, 0.0);
            this.setUnits(LXParameter.Units.PERCENT_NORMALIZED);
            this.setDescription("MPD218 knob " + label);
            this.cc = cc;
        }
    }

    private class Pad
    extends BooleanParameter {
        private Pad(String label) {
            super(label, false);
            this.setMode(BooleanParameter.Mode.MOMENTARY);
            this.setDescription("MPD218 pad " + label);
        }
    }
}

