/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.template;

import heronarts.lx.LX;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;

@LXMidiTemplate.Name(value="Akai MIDIMIX")
@LXMidiTemplate.DeviceName(value="MIDI Mix")
public class AkaiMidiMix
extends LXMidiTemplate
implements LXMidiTemplate.Bidirectional {
    public static final int NUM_CHANNELS = 8;
    public static final int KNOBS_PER_CHANNEL = 3;
    public static final int NUM_KNOBS = 24;
    public static final int NUM_FADERS = 9;
    public static final int MASTER_FADER = 8;
    public final BoundedParameter[] knobs = new BoundedParameter[24];
    public final BoundedParameter[] faders = new BoundedParameter[9];
    public final Toggle[] mute = new Toggle[8];
    public final Toggle[] solo = new Toggle[8];
    public final Toggle[] arm = new Toggle[8];
    private final BoundedParameter[] controlMap = new BoundedParameter[128];
    private final BooleanParameter[] noteMap = new BooleanParameter[128];

    public AkaiMidiMix(LX lx) {
        super(lx);
        int i = 0;
        while (i < 24) {
            String knobId = 1 + i / 3 + "-" + (1 + i % 3);
            this.knobs[i] = new BoundedParameter("Knob " + knobId, 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("MIDI Mix knob " + (i + 1));
            this.addParameter("knob-" + knobId, this.knobs[i]);
            int col = i / 3;
            int row = i % 3;
            if (col < 4) {
                this.controlMap[16 + 4 * col + row] = this.knobs[i];
            } else {
                this.controlMap[46 + 4 * (col - 4) + row] = this.knobs[i];
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.faders[i] = new BoundedParameter("Fader " + String.valueOf(i == 8 ? "M" : Integer.valueOf(i + 1)), 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("MIDI Mix fader " + (i + 1));
            this.addParameter("fader-" + (i + 1), this.faders[i]);
            if (i < 4) {
                this.controlMap[19 + 4 * i] = this.faders[i];
            } else if (i < 8) {
                this.controlMap[49 + 4 * (i - 4)] = this.faders[i];
            } else {
                this.controlMap[62] = this.faders[i];
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            int note = 1 + 3 * i;
            this.mute[i] = new Toggle("Mute " + (i + 1), true, note);
            this.addParameter("mute-" + (i + 1), this.mute[i]);
            this.noteMap[note] = this.mute[i];
            ++i;
        }
        i = 0;
        while (i < 8) {
            int note = 2 + 3 * i;
            this.solo[i] = new Toggle("Solo " + (i + 1), false, note);
            this.addParameter("solo-" + (i + 1), this.solo[i]);
            this.noteMap[note] = this.solo[i];
            ++i;
        }
        i = 0;
        while (i < 8) {
            int note = 3 + 3 * i;
            this.arm[i] = new Toggle("Arm " + (i + 1), false, note);
            this.addParameter("arm-" + (i + 1), this.arm[i]);
            this.noteMap[note] = this.arm[i];
            ++i;
        }
    }

    @Override
    protected void initializeOutput() {
        int i = 0;
        while (i < this.noteMap.length) {
            if (this.noteMap[i] != null) {
                this.sendNoteOn(0, i, this.noteMap[i].isOn() ? 127 : 0);
            }
            ++i;
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p instanceof Toggle) {
            Toggle toggle = (Toggle)p;
            this.sendNoteOn(0, toggle.note, toggle.isOn() ? 127 : 0);
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        BooleanParameter button = this.noteMap[note.getPitch()];
        if (button != null) {
            button.toggle();
        }
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        BoundedParameter control = this.controlMap[cc.getCC()];
        if (control != null) {
            control.setValue(cc.getNormalized());
        }
    }

    private class Toggle
    extends BooleanParameter {
        private final int note;

        private Toggle(String label, boolean def, int note) {
            super(label, def);
            this.note = note;
        }
    }
}

