/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.template;

import heronarts.lx.LX;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

@LXMidiTemplate.Name(value="DJTT Midi Fighter Twister")
@LXMidiTemplate.DeviceName(value="Midi Fighter Twister")
public class DJTTMidiFighterTwister
extends LXMidiTemplate
implements LXMidiTemplate.Bidirectional {
    public static final int NUM_KNOBS = 16;
    public static final int KNOB_CHANNEL = 0;
    public static final int SWITCH_CHANNEL = 1;
    public final Knob[] knobs = new Knob[16];
    public final Switch[] switches = new Switch[16];

    public DJTTMidiFighterTwister(LX lx) {
        super(lx);
        int i = 0;
        while (i < 16) {
            this.knobs[i] = new Knob(i);
            this.switches[i] = new Switch(i);
            ++i;
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p instanceof Knob) {
            Knob knob = (Knob)p;
            this.sendControlChange(0, knob.index, (int)Math.round(knob.getNormalized() * 127.0));
        } else if (p instanceof Switch) {
            Switch s = (Switch)p;
            this.sendControlChange(1, s.index, s.isOn() ? 127 : 0);
        }
    }

    @Override
    protected void initializeOutput() {
        LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.knobs;
        int n = this.knobs.length;
        int n2 = 0;
        while (n2 < n) {
            Knob knob = lXListenableNormalizedParameterArray[n2];
            this.sendControlChange(0, knob.index, (int)Math.round(knob.getNormalized() * 127.0));
            ++n2;
        }
        lXListenableNormalizedParameterArray = this.switches;
        n = this.switches.length;
        n2 = 0;
        while (n2 < n) {
            LXListenableNormalizedParameter s = lXListenableNormalizedParameterArray[n2];
            this.sendControlChange(1, ((Switch)s).index, ((BooleanParameter)s).isOn() ? 127 : 0);
            ++n2;
        }
    }

    private void setSwitch(MidiNote note, boolean on) {
        int pitch;
        if (note.getChannel() == 1 && (pitch = note.getPitch()) < 16) {
            this.switches[pitch].setValue(on);
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.setSwitch(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.setSwitch(note, false);
    }

    @Override
    public void midiPanicReceived() {
        Switch[] switchArray = this.switches;
        int n = this.switches.length;
        int n2 = 0;
        while (n2 < n) {
            Switch s = switchArray[n2];
            s.setValue(false);
            ++n2;
        }
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        int knobIndex = cc.getCC();
        if (knobIndex < 16) {
            switch (cc.getChannel()) {
                case 0: {
                    this.knobs[knobIndex].setNormalized(cc.getNormalized());
                    break;
                }
                case 1: {
                    this.switches[knobIndex].setValue(cc.getValue() > 0);
                }
            }
        }
    }

    public class Knob
    extends BoundedParameter {
        public final int index;

        private Knob(int index) {
            super("K" + (index + 1));
            this.index = index;
            this.setUnits(LXParameter.Units.PERCENT_NORMALIZED);
            this.setDescription("Knob " + (index + 1));
            DJTTMidiFighterTwister.this.addParameter("knob-" + (index + 1), this);
        }
    }

    public class Switch
    extends BooleanParameter {
        public final int index;

        private Switch(int index) {
            super("S" + (index + 1));
            this.index = index;
            this.setMode(BooleanParameter.Mode.MOMENTARY);
            this.setDescription("Switch " + (index + 1));
            DJTTMidiFighterTwister.this.addParameter("Switch-" + (index + 1), this);
        }
    }
}

