/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.template;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.midi.LXMidiInput;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXMidiOutput;
import heronarts.lx.midi.MidiSelector;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class LXMidiTemplate
extends LXComponent
implements LXComponent.Renamable,
LXMidiListener {
    public final MidiSelector.Source.Device sourceDevice = new MidiSelector.Source.Device("Source");
    public final MidiSelector.Destination.Device destinationDevice;
    public final BooleanParameter connected = new BooleanParameter("Connected", false).setDescription("Active when the device is connected");
    private LXMidiInput input = null;
    private LXMidiOutput output = null;
    private final LXParameterListener onConnected = p -> {
        boolean connected;
        boolean bl = connected = this.input != null && this.input.connected.isOn();
        if (connected && this instanceof Bidirectional) {
            connected = this.output != null && this.output.connected.isOn();
        }
        this.connected.setValue(connected);
    };

    protected LXMidiTemplate(LX lx) {
        super(lx);
        this.label.setValue(this.getTemplateName());
        this.setParent(lx.engine.midi);
        this.addParameter("sourceDevice", this.sourceDevice);
        if (this instanceof Bidirectional) {
            this.destinationDevice = new MidiSelector.Destination.Device("Destination");
            this.addParameter("destinationDevice", this.destinationDevice);
        } else {
            this.destinationDevice = null;
        }
    }

    public int getIndex() {
        return this.lx.engine.midi.templates.indexOf(this);
    }

    @Override
    public String getPath() {
        return "template/" + (this.getIndex() + 1);
    }

    public LXMidiTemplate initializeDefaultIO() {
        DeviceName annotation = this.getClass().getAnnotation(DeviceName.class);
        if (annotation != null) {
            String deviceName = annotation.value();
            this.sourceDevice.setInput(this.lx.engine.midi.findInput(deviceName));
            if (this instanceof Bidirectional) {
                this.destinationDevice.setOutput(this.lx.engine.midi.findOutput(deviceName));
            }
        }
        return this;
    }

    public String getTemplateName() {
        return LXMidiTemplate.getTemplateName(this.getClass());
    }

    public static String getTemplateName(Class<? extends LXMidiTemplate> templateClass) {
        Name annotation = templateClass.getAnnotation(Name.class);
        if (annotation != null) {
            return annotation.value();
        }
        return templateClass.getSimpleName();
    }

    protected void initializeOutput() {
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.sourceDevice) {
            this.setInput(this.sourceDevice.getInput());
        } else if (p == this.destinationDevice) {
            this.setOutput(this.destinationDevice.getOutput());
        }
    }

    private void setInput(LXMidiInput input) {
        if (this.input != null) {
            this.input.connected.removeListener(this.onConnected);
            this.input.removeListener(this);
            this.connected.setValue(false);
            this.input = null;
        }
        this.input = input;
        if (this.input != null) {
            this.input.addListener(this);
            this.input.connected.addListener(this.onConnected, true);
            this.input.open();
        }
    }

    private void setOutput(LXMidiOutput output) {
        if (this.output != null) {
            this.output.connected.removeListener(this.onConnected);
            this.connected.setValue(false);
            this.output = null;
        }
        this.output = output;
        if (this.output != null) {
            this.output.open();
            this.output.connected.addListener(this.onConnected, true);
            this.initializeOutput();
        }
    }

    protected void sendNoteOn(int channel, int note, int velocity) {
        if (this.output != null) {
            this.output.sendNoteOn(channel, note, velocity);
        }
    }

    protected void sendControlChange(int channel, int cc, int value) {
        if (this.output != null) {
            this.output.sendControlChange(channel, cc, value);
        }
    }

    protected void sendSysex(byte[] sysex) {
        if (this.output != null) {
            this.output.sendSysex(sysex);
        }
    }

    @Override
    public void dispose() {
        this.setOutput(null);
        this.setInput(null);
        super.dispose();
    }

    public static interface Bidirectional {
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DeviceName {
        public String value();
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public String value();
    }
}

