/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.midi.template;

import heronarts.lx.LX;
import heronarts.lx.midi.MidiControlChange;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.midi.template.LXMidiTemplate;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;

@LXMidiTemplate.Name(value="Novation Launchkey MK3 37")
@LXMidiTemplate.DeviceName(value="Launchkey MK3 37 LKMK3 MIDI Out")
public class NovationLaunchkeyMk337
extends LXMidiTemplate {
    private static final int NUM_KNOBS = 8;
    private static final int KNOB_CHANNEL = 0;
    private static final int KNOB_1 = 21;
    private static final int NUM_PADS = 16;
    private static final int PAD_CHANNEL = 9;
    private static final int PAD_1 = 36;
    private static final int BUTTON_CHANNEL = 15;
    public final BoundedParameter[] knobs = new BoundedParameter[8];
    public final BooleanParameter[] pads = new BooleanParameter[16];
    private final BooleanParameter[] buttonMap = new BooleanParameter[128];
    private final List<BooleanParameter> buttons = new ArrayList<BooleanParameter>();
    public final BooleanParameter capture = this.button("capture", "Capture", 74);
    public final BooleanParameter quantise = this.button("quantise", "Quantise", 75);
    public final BooleanParameter click = this.button("click", "Click", 76);
    public final BooleanParameter undo = this.button("undo", "Undo", 77);
    public final BooleanParameter play = this.button("play", "Play", 115);
    public final BooleanParameter stop = this.button("stop", "Stop", 116);
    public final BooleanParameter rec = this.button("Rec", "Rec", 117);
    public final BooleanParameter loop = this.button("loop", "Loop", 118);
    public final BooleanParameter up = this.button("up", "\u25b2", 106);
    public final BooleanParameter down = this.button("down", "\u25bc", 107);
    public final BooleanParameter right = this.button("right", ">", 104);
    public final BooleanParameter ssm = this.button("ssm", "S", 105);
    private final int[] PAD_MAP;

    private BooleanParameter button(String path, String label, int cc) {
        BooleanParameter button = new BooleanParameter(label).setMode(BooleanParameter.Mode.MOMENTARY).setDescription(label + " button");
        this.addParameter(path, button);
        this.buttonMap[cc] = button;
        this.buttons.add(button);
        return button;
    }

    public NovationLaunchkeyMk337(LX lx) {
        super(lx);
        String label;
        int[] nArray = new int[16];
        nArray[0] = 8;
        nArray[1] = 9;
        nArray[2] = 10;
        nArray[3] = 11;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 12;
        nArray[9] = 13;
        nArray[10] = 14;
        nArray[11] = 15;
        nArray[12] = 4;
        nArray[13] = 5;
        nArray[14] = 6;
        nArray[15] = 7;
        this.PAD_MAP = nArray;
        int i = 0;
        while (i < 8) {
            label = "K" + (i + 1);
            this.knobs[i] = new BoundedParameter(label).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Knob " + (i + 1));
            this.addParameter(label, this.knobs[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            label = "P" + (i + 1);
            this.pads[i] = new BooleanParameter(label).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Pad " + (i + 1));
            this.addParameter(label, this.pads[i]);
            ++i;
        }
    }

    private void setPad(MidiNote note, boolean value) {
        int padIndex;
        if (note.getChannel() == 9 && LXUtils.inRange(padIndex = note.getPitch() - 36, 0, 15)) {
            this.pads[this.PAD_MAP[padIndex]].setValue(value);
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.setPad(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.setPad(note, false);
    }

    @Override
    public void controlChangeReceived(MidiControlChange cc) {
        switch (cc.getChannel()) {
            case 0: {
                int knobIndex = cc.getCC() - 21;
                if (!LXUtils.inRange(knobIndex, 0, 7)) break;
                this.knobs[knobIndex].setNormalized(cc.getNormalized());
                break;
            }
            case 15: {
                BooleanParameter button = this.buttonMap[cc.getCC()];
                if (button == null) break;
                button.setNormalized(cc.getNormalized());
            }
        }
    }

    @Override
    public void midiPanicReceived() {
        BooleanParameter[] booleanParameterArray = this.pads;
        int n = this.pads.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanParameter pad = booleanParameterArray[n2];
            pad.setValue(false);
            ++n2;
        }
        for (BooleanParameter button : this.buttons) {
            button.setValue(false);
        }
    }
}

