/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiFilterParameter;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.midi.MidiSelector;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.model.LXModel;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.structure.view.LXViewDefinition;
import heronarts.lx.structure.view.LXViewEngine;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class LXAbstractChannel
extends LXBus
implements LXComponent.Renamable {
    private final List<MidiListener> midiListeners = new ArrayList<MidiListener>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    boolean isAnimating;
    protected int index;
    protected final ModelBuffer blendBuffer;
    protected int[] colors;
    public final BooleanParameter enabled = new BooleanParameter("On", true).setDescription("Sets whether this channel is on or off");
    public final BooleanParameter autoMute = new BooleanParameter("Auto-Mute", false).setDescription("Whether to disable channel processing if fader is off");
    public final BooleanParameter isAutoMuted = new BooleanParameter("Auto-Muted", false).setDescription("Set to true by the engine when the channel is auto-disabled");
    public final EnumParameter<CrossfadeGroup> crossfadeGroup = new EnumParameter<CrossfadeGroup>("Group", CrossfadeGroup.BYPASS).setDescription("Assigns this channel to crossfader group A or B");
    public final BooleanParameter cueActive = new BooleanParameter("Cue", false).setDescription("Toggles the channel CUE state, determining whether it is shown in the preview window");
    public final BooleanParameter auxActive = new BooleanParameter("Aux", false).setDescription("Toggles the channel AUX state, determining whether it is shown in the auxiliary window");
    public final MidiSelector.Source.Channel midiSource = new MidiSelector.Source.Channel("MIDI Source");
    public final MidiFilterParameter midiFilter = new MidiFilterParameter("MIDI Filter", false).setDescription("Filter controls for incoming MIDI messages");
    public final ObjectParameter<LXBlend> blendMode;
    private LXBlend activeBlend;
    int performanceWarningFrameCount = 0;
    public final BooleanParameter performanceWarning = new BooleanParameter("Warning", false).setDescription("Set to true by the engine if this channel is using too many CPU resources");
    public final LXViewEngine.Selector view;
    final ChannelThread thread = new ChannelThread();
    private static int channelThreadCount = 1;

    @Override
    protected LXModulatorComponent.Profiler constructProfiler() {
        return new Profiler();
    }

    protected LXAbstractChannel(LX lx, int index, String label) {
        super(lx, label);
        this.index = index;
        this.label.setDescription("The name of this channel");
        this.blendBuffer = new ModelBuffer(lx);
        this.colors = this.blendBuffer.getArray();
        this.autoMute.setValue(lx.engine.mixer.autoMuteDefault.isOn());
        this.blendMode = new ObjectParameter<LXBlend>("Blend", new LXBlend[1]).setDescription("Specifies the blending function used for the channel fader");
        this.updateChannelBlendOptions();
        this.addParameter("enabled", this.enabled);
        this.addParameter("cue", this.cueActive);
        this.addParameter("aux", this.auxActive);
        this.addParameter("crossfadeGroup", this.crossfadeGroup);
        this.addParameter("blendMode", this.blendMode);
        this.addParameter("autoMute", this.autoMute);
        this.addParameter("midiSource", this.midiSource);
        this.addParameter("midiFilter", this.midiFilter);
        this.addLegacyParameter("midiMonitor", this.midiFilter.enabled);
        this.addLegacyParameter("midiChannel", this.midiFilter.channel);
        this.view = lx.structure.views.newViewSelector("View", "Model view selector for this channel");
        this.addParameter("view", this.view);
    }

    public LXAbstractChannel addMidiListener(MidiListener listener) {
        Objects.requireNonNull(listener, "May not add null LXChannel.MidiListener");
        if (this.midiListeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXChannel.MidiListener: " + String.valueOf(listener));
        }
        this.midiListeners.add(listener);
        return this;
    }

    public LXAbstractChannel removeMidiListener(MidiListener listener) {
        if (!this.midiListeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXChannel.MidiListener: " + String.valueOf(listener));
        }
        this.midiListeners.remove(listener);
        return this;
    }

    public boolean isPlaylist() {
        return false;
    }

    public boolean isComposite() {
        return false;
    }

    private void disposeChannelBlendOptions() {
        LXBlend[] lXBlendArray = this.blendMode.getObjects();
        int n = lXBlendArray.length;
        int n2 = 0;
        while (n2 < n) {
            LXBlend blend = lXBlendArray[n2];
            if (blend != null) {
                LX.dispose(blend);
            }
            ++n2;
        }
    }

    void updateChannelBlendOptions() {
        this.disposeChannelBlendOptions();
        this.blendMode.setObjects((LXBlend[])this.lx.engine.mixer.instantiateChannelBlends(this));
        this.activeBlend = this.blendMode.getObject();
        this.activeBlend.onActive();
    }

    public LXModel getModelView() {
        LXViewDefinition view = (LXViewDefinition)this.view.getObject();
        if (view != null) {
            return view.getModelView();
        }
        return this.getModel();
    }

    @Override
    public String getPath() {
        return "channel/" + (this.index + 1);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.cueActive) {
            if (this.cueActive.isOn()) {
                this.lx.engine.mixer.cueA.setValue(false);
                this.lx.engine.mixer.cueB.setValue(false);
                if (this.lx.flags.focusChannelOnCue) {
                    this.lx.engine.mixer.selectChannel(this);
                    this.lx.engine.mixer.setFocusedChannel(this);
                }
            }
        } else if (p == this.autoMute) {
            if (!this.autoMute.isOn()) {
                this.isAutoMuted.setValue(false);
            }
        } else if (p == this.auxActive) {
            if (this.auxActive.isOn()) {
                this.lx.engine.mixer.auxA.setValue(false);
                this.lx.engine.mixer.auxB.setValue(false);
                this.lx.engine.mixer.setFocusedChannelAux(this);
            }
        } else if (p == this.blendMode) {
            this.activeBlend.onInactive();
            this.activeBlend = this.blendMode.getObject();
            this.activeBlend.onActive();
        }
    }

    public void midiMessage(LXShortMessage message) {
        for (MidiListener listener : this.midiListeners) {
            listener.midiReceived(this, message);
        }
        this.midiDispatch(message);
    }

    public void midiDispatch(LXShortMessage message) {
        for (LXEffect effect : this.effects) {
            if (!(message instanceof MidiPanic) && !effect.enabled.isOn()) continue;
            effect.midiDispatch(message);
        }
    }

    private boolean isAnimating() {
        if (this.cueActive.isOn()) {
            return true;
        }
        if (!this.enabled.isOn()) {
            return false;
        }
        if (this.isAutoMuted.isOn()) {
            return false;
        }
        if (this instanceof LXGroup) {
            return true;
        }
        LXGroup group = this.getGroup();
        return group == null || group.isAnimating;
    }

    @Override
    public void loop(double deltaMs) {
        this.isAutoMuted.setValue(this.autoMute.isOn() && this.fader.getValue() == 0.0);
        this.isAnimating = this.isAnimating();
        super.loop(deltaMs, this.isAnimating);
    }

    public final void addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXAbstractChannel.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXAbstractChannel.Listener: " + String.valueOf(listener));
        }
        super.addListener(listener);
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXAbstractChannel.Listener: " + String.valueOf(listener));
        }
        super.removeListener(listener);
        this.listeners.remove(listener);
    }

    final LXAbstractChannel setIndex(int index) {
        if (this.index != index) {
            this.index = index;
            for (Listener listener : this.listeners) {
                listener.indexChanged(this);
            }
        }
        return this;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    int[] getColors() {
        return this.colors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ChannelThread channelThread = this.thread;
        synchronized (channelThread) {
            this.thread.interrupt();
        }
        super.dispose();
        this.disposeChannelBlendOptions();
        this.blendBuffer.dispose();
        this.midiListeners.forEach(listener -> LX.warning("Stranded LXAbstractChannel.MidiListener: " + String.valueOf(listener)));
        this.listeners.forEach(listener -> LX.warning("Stranded LXAbstractChannel.Listener: " + String.valueOf(listener)));
        this.midiListeners.clear();
        this.listeners.clear();
    }

    @Override
    public void postProcessPreset(LX lx, JsonObject obj) {
        super.postProcessPreset(lx, obj);
        LXSerializable.Utils.stripParameter(obj, this.enabled);
        LXSerializable.Utils.stripParameter(obj, this.crossfadeGroup);
        LXSerializable.Utils.stripParameter(obj, this.cueActive);
        LXSerializable.Utils.stripParameter(obj, this.auxActive);
    }

    private void loadLegacyView(LX lx, JsonObject obj) {
        String viewSelector;
        boolean viewEnabled;
        JsonObject params;
        if (obj.has("parameters") && (params = obj.getAsJsonObject("parameters")).has("viewEnabled") && (viewEnabled = params.get("viewEnabled").getAsBoolean()) && params.has("viewSelector") && !LXUtils.isEmpty(viewSelector = params.get("viewSelector").getAsString())) {
            LXViewDefinition view = lx.structure.views.addView();
            view.label.setValue(this.getLabel());
            LXSerializable.Utils.loadInt(view.normalization, params, "viewNormalization");
            view.selector.setValue(viewSelector);
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        this.loadLegacyView(lx, obj);
    }

    class ChannelThread
    extends Thread {
        boolean hasStarted;
        boolean workReady;
        double deltaMs;
        Signal signal;

        ChannelThread() {
            super("LXChannel thread #" + channelThreadCount++);
            this.hasStarted = false;
            this.workReady = true;
            this.signal = new Signal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LX.log("LXEngine Channel thread started [" + LXAbstractChannel.this.getLabel() + "]");
            while (!this.isInterrupted()) {
                Object object = this;
                synchronized (object) {
                    try {
                        while (!this.workReady) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ix) {
                        break;
                    }
                    this.workReady = false;
                }
                LXAbstractChannel.this.loop(this.deltaMs);
                object = this.signal;
                synchronized (object) {
                    this.signal.workDone = true;
                    this.signal.notify();
                }
            }
            LX.log("LXEngine Channel thread finished [" + LXAbstractChannel.this.getLabel() + "]");
        }

        class Signal {
            boolean workDone = false;

            Signal() {
            }
        }
    }

    public static enum CrossfadeGroup {
        BYPASS,
        A,
        B;

    }

    public static interface Listener
    extends LXBus.Listener {
        default public void indexChanged(LXAbstractChannel channel) {
        }
    }

    public static interface MidiListener {
        public void midiReceived(LXAbstractChannel var1, LXShortMessage var2);
    }

    public class Profiler
    extends LXBus.Profiler {
        public long blendNanos;
    }
}

