/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXModelComponent;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMasterBus;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.modulation.LXModulationContainer;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.QuantizedTriggerParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class LXBus
extends LXModelComponent
implements LXPresetComponent,
LXOscComponent,
LXModulationContainer,
LXEffect.Container {
    public final LXModulationEngine modulation;
    public final CompoundParameter fader = new CompoundParameter("Fader", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the alpha level of the output of this channel");
    public final BooleanParameter arm = new BooleanParameter("Arm").setDescription("Arms the channel for clip recording");
    public final BooleanParameter selected = new BooleanParameter("Selected").setDescription("Whether the channel is selected");
    public final QuantizedTriggerParameter stopClips = new QuantizedTriggerParameter(this.lx, "Stop Clips", this::_stopClipsQuantized).onSchedule(this::_stopClipsScheduled).setDescription("Stops all clips running on the bus");
    public final BooleanParameter controlsExpandedCue = new BooleanParameter("Expanded Cue", true).setDescription("Whether the control elements for this channel are expanded in cue view");
    public final BooleanParameter controlsExpandedAux = new BooleanParameter("Expanded Aux", true).setDescription("Whether the control elements for this channel are expanded in aux view");
    public final BooleanParameter modulationExpanded = new BooleanParameter("Modulation Expanded", false).setDescription("Whether the device modulation section is expanded");
    protected final List<LXEffect> mutableEffects = new ArrayList<LXEffect>();
    public final List<LXEffect> effects = Collections.unmodifiableList(this.mutableEffects);
    private final List<LXClip> mutableClips = new ArrayList<LXClip>();
    public final List<LXClip> clips = Collections.unmodifiableList(this.mutableClips);
    private LXClip runningClip = null;
    public final BooleanParameter hasRunningClip = new BooleanParameter("Clip Running", false).setDescription("Flag indicates when a clip is active on this bus");
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<ClipListener> clipListeners = new ArrayList<ClipListener>();
    public static final String PATH_EFFECT = "effect";
    private static final String KEY_EFFECTS = "effects";
    private static final String KEY_CLIPS = "clips";

    @Override
    protected LXModulatorComponent.Profiler constructProfiler() {
        return new Profiler();
    }

    LXBus(LX lx) {
        this(lx, null);
    }

    LXBus(LX lx, String label) {
        super(lx, label);
        this.modulation = new LXModulationEngine(lx);
        this.addChild("modulation", this.modulation);
        this.addArray(PATH_EFFECT, this.effects);
        this.addParameter("fader", this.fader);
        this.addArray("clip", this.clips);
        this.addParameter("arm", this.arm);
        this.addParameter("selected", this.selected);
        this.addParameter("stopClips", this.stopClips);
        if (!(this instanceof LXMasterBus)) {
            this.stopClips.setQuantization(lx.engine.tempo.launchQuantization);
        }
        this.addInternalParameter("controlsExpandedCue", this.controlsExpandedCue);
        this.addInternalParameter("controlsExpandedAux", this.controlsExpandedAux);
        this.addInternalParameter("modulationExpanded", this.modulationExpanded);
    }

    public abstract int getIndex();

    protected void setMixer(LXMixerEngine mixer) {
        this.setParent(mixer);
    }

    public final void addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXBus.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXBus.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered Bus.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
    }

    public LXBus addClipListener(ClipListener listener) {
        Objects.requireNonNull(listener, "May not add null LXBus.ClipListener");
        if (this.clipListeners.contains(listener)) {
            throw new IllegalStateException("May not remove add duplicate LXBus.ClipListener: " + String.valueOf(listener));
        }
        this.clipListeners.add(listener);
        return this;
    }

    public LXBus removeClipListener(ClipListener listener) {
        if (!this.clipListeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXBus.ClipListener: " + String.valueOf(listener));
        }
        this.clipListeners.remove(listener);
        return this;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_EFFECT)) {
            String effectId = parts[index + 1];
            if (effectId.matches("\\d+")) {
                return this.effects.get(Integer.parseInt(effectId) - 1).handleOscMessage(message, parts, index + 2);
            }
            for (LXEffect effect : this.effects) {
                if (!effect.getOscLabel().equals(effectId)) continue;
                return effect.handleOscMessage(message, parts, index + 2);
            }
            LXOscEngine.error("Channel " + this.getLabel() + " does not have effect at path: " + effectId + " (" + String.valueOf(message) + ")");
            return false;
        }
        return super.handleOscMessage(message, parts, index);
    }

    @Override
    public LXModulationEngine getModulationEngine() {
        return this.modulation;
    }

    @Override
    public BooleanParameter getModulationExpanded() {
        return this.modulationExpanded;
    }

    public LXGroup getGroup() {
        return null;
    }

    public boolean isGroup() {
        return this instanceof LXGroup;
    }

    public boolean isEmptyGroup() {
        return this.isGroup() && ((LXGroup)this).channels.size() == 0;
    }

    public boolean isChannel() {
        return this instanceof LXChannel;
    }

    public boolean isInGroup() {
        return this.getGroup() != null;
    }

    @Override
    public final LXBus addEffect(LXEffect effect, int index) {
        if (index > this.mutableEffects.size()) {
            throw new IllegalArgumentException("Illegal effect index: " + index);
        }
        if (index < 0) {
            index = this.mutableEffects.size();
        }
        this.mutableEffects.add(index, effect);
        effect.setBus(this);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectAdded(this, effect);
        }
        return this;
    }

    @Override
    public final LXBus removeEffect(LXEffect effect) {
        int index = this.mutableEffects.indexOf(effect);
        if (index >= 0) {
            effect.setIndex(-1);
            this.mutableEffects.remove(index);
            while (index < this.mutableEffects.size()) {
                this.mutableEffects.get(index).setIndex(index);
                ++index;
            }
            for (Listener listener : this.listeners) {
                listener.effectRemoved(this, effect);
            }
            LX.dispose(effect);
        }
        return this;
    }

    private void _reindexEffects() {
        int i = 0;
        for (LXEffect e : this.mutableEffects) {
            e.setIndex(i++);
        }
    }

    @Override
    public LXBus moveEffect(LXEffect effect, int index) {
        if (index < 0 || index >= this.mutableEffects.size()) {
            throw new IllegalArgumentException("Cannot move effect to invalid index: " + index);
        }
        if (!this.mutableEffects.contains(effect)) {
            throw new IllegalStateException("Cannot move effect that is not on channel: " + String.valueOf(this) + " " + String.valueOf(effect));
        }
        this.mutableEffects.remove(effect);
        this.mutableEffects.add(index, effect);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectMoved(this, effect);
        }
        return this;
    }

    @Override
    public final List<LXEffect> getEffects() {
        return this.effects;
    }

    public LXClip getClip(int index) {
        if (index >= this.lx.engine.clips.numScenes.getValuei()) {
            return null;
        }
        if (index < this.clips.size()) {
            return this.clips.get(index);
        }
        return null;
    }

    public LXClip addClip() {
        return this.addClip(this.mutableClips.size());
    }

    public LXClip addClip(int index) {
        return this.addClip(index, false);
    }

    public LXClip addClip(int index, boolean enableSnapshot) {
        return this.addClip(null, index, enableSnapshot);
    }

    public LXClip addClip(JsonObject clipObj, int index) {
        return this.addClip(clipObj, index, false);
    }

    /*
     * Unable to fully structure code
     */
    private LXClip addClip(JsonObject clipObj, int index, boolean enableSnapshot) {
        if (index >= 128) {
            throw new IllegalArgumentException("Cannot add clip at index >= 128");
        }
        if (this.getClip(index) == null) ** GOTO lbl7
        throw new IllegalStateException("Cannot add clip at index " + index + " which already holds a clip: " + String.valueOf(this));
lbl-1000:
        // 1 sources

        {
            this.mutableClips.add(null);
lbl7:
            // 2 sources

            ** while (this.mutableClips.size() <= index)
        }
lbl8:
        // 1 sources

        clip = this.constructClip(index);
        if (clipObj != null) {
            clip.load(this.lx, clipObj);
        } else {
            clip.snapshotEnabled.setValue(enableSnapshot);
            clip.label.setValue(this.getClipLabel() + "-" + (index + 1));
        }
        this.mutableClips.set(index, clip);
        for (ClipListener listener : this.clipListeners) {
            listener.clipAdded(this, clip);
        }
        return clip;
    }

    public void onClipStart(LXClip clip) {
        if (this.runningClip != null) {
            LX.error(new IllegalStateException("LXBus.onClipStart() called while another clip still running: " + String.valueOf(clip)));
        }
        this.runningClip = clip;
        this.hasRunningClip.setValue(true);
    }

    public void onClipStop(LXClip clip) {
        if (this.runningClip != clip) {
            LX.error(new IllegalStateException("LXBus.onClipStop() called for clip that wasn't started here? " + String.valueOf(clip)));
        }
        this.hasRunningClip.setValue(false);
        this.runningClip = null;
    }

    public LXClip getRunningClip() {
        return this.runningClip;
    }

    protected String getClipLabel() {
        return "Clip";
    }

    private void _stopClipsScheduled() {
        boolean hasStoppingClip = false;
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            if (clip.isRunning()) {
                clip.stop.trigger();
                hasStoppingClip = true;
            }
            clip.launch.cancel();
            clip.launchAutomation.cancel();
        }
        if (!hasStoppingClip) {
            this.stopClips.cancel();
        }
    }

    private void _stopClipsQuantized(boolean quantized) {
        if (!quantized) {
            this.stopClips();
        }
    }

    public LXBus stopClips() {
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clip.stop();
        }
        return this;
    }

    protected abstract LXClip constructClip(int var1);

    public void removeClip(LXClip clip) {
        int index = this.mutableClips.indexOf(clip);
        if (index < 0) {
            throw new IllegalArgumentException("Clip is not owned by channel: " + String.valueOf(clip) + " " + String.valueOf(this));
        }
        this.removeClip(index);
    }

    public void removeClip(int index) {
        LXClip clip = this.getClip(index);
        if (clip != null) {
            this.mutableClips.set(index, null);
            if (this.lx.engine.clips.getFocusedClip() == clip) {
                this.lx.engine.clips.setFocusedClip(null);
            }
            for (ClipListener listener : this.clipListeners) {
                listener.clipRemoved(this, clip);
            }
            LX.dispose(clip);
        }
    }

    @Override
    public void loop(double deltaMs) {
        this.loop(deltaMs, true);
    }

    protected void loop(double deltaMs, boolean runComponents) {
        long loopStart = System.nanoTime();
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clip.loop(deltaMs);
        }
        if (runComponents) {
            this.modulation.loop(deltaMs);
            super.loop(deltaMs);
        }
        this.profiler.loopNanos = System.nanoTime() - loopStart;
    }

    protected void disposeClips() {
        for (LXClip clip : this.mutableClips) {
            if (clip == null) continue;
            LX.dispose(clip);
        }
        this.mutableClips.clear();
    }

    @Override
    public void dispose() {
        this.disposeClips();
        for (LXEffect effect : this.mutableEffects) {
            LX.dispose(effect);
        }
        this.mutableEffects.clear();
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXBus.Listener: " + String.valueOf(listener)));
        this.clipListeners.forEach(listener -> LX.warning("Stranded LXBus.ClipListener: " + String.valueOf(listener)));
        this.listeners.clear();
        this.clipListeners.clear();
    }

    @Override
    public Class<?> getPresetClass() {
        return LXBus.class;
    }

    @Override
    public void postProcessPreset(LX lx, JsonObject obj) {
        LXSerializable.Utils.stripParameter(obj, this.fader);
        LXSerializable.Utils.stripParameter(obj, this.arm);
        LXSerializable.Utils.stripParameter(obj, this.selected);
    }

    public void clear() {
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            this.removeClip(clip);
        }
        int i = this.mutableEffects.size() - 1;
        while (i >= 0) {
            this.removeEffect(this.mutableEffects.get(i));
            --i;
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_EFFECTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableEffects));
        JsonArray clipsArr = new JsonArray();
        for (LXClip clip : this.clips) {
            if (clip == null) continue;
            clipsArr.add((JsonElement)LXSerializable.Utils.toObject(lx, clip));
        }
        obj.add(KEY_CLIPS, (JsonElement)clipsArr);
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.clear();
        if (obj.has(KEY_EFFECTS)) {
            for (JsonElement effectElement : obj.getAsJsonArray(KEY_EFFECTS)) {
                this.loadEffect(this.lx, (JsonObject)effectElement, -1);
            }
        }
        if (obj.has(KEY_CLIPS)) {
            JsonArray clipsArr = obj.get(KEY_CLIPS).getAsJsonArray();
            for (JsonElement clipElem : clipsArr) {
                JsonObject clipObj = clipElem.getAsJsonObject();
                int clipIndex = clipObj.get("index").getAsInt();
                LXClip clip = this.addClip(clipIndex);
                clip.load(lx, clipObj);
            }
        }
        super.load(lx, obj);
    }

    public static interface ClipListener {
        public void clipAdded(LXBus var1, LXClip var2);

        public void clipRemoved(LXBus var1, LXClip var2);
    }

    public static interface Listener {
        default public void effectAdded(LXBus channel, LXEffect effect) {
        }

        default public void effectRemoved(LXBus channel, LXEffect effect) {
        }

        default public void effectMoved(LXBus channel, LXEffect effect) {
        }
    }

    public class Profiler
    extends LXModulatorComponent.Profiler {
        public long effectNanos;

        @Override
        public long renderNanos() {
            return super.renderNanos() + this.effectNanos;
        }
    }
}

