/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.ModelBuffer;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.clip.LXChannelClip;
import heronarts.lx.clip.LXClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXGroup;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.model.LXModel;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.QuantizedTriggerParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LXChannel
extends LXAbstractChannel {
    public static final int NO_PATTERN_INDEX = -1;
    private final ArrayList<Listener> listeners = new ArrayList();
    private boolean inListener = false;
    private final List<Listener> addListeners = new ArrayList<Listener>();
    private final List<Listener> removeListeners = new ArrayList<Listener>();
    public final DiscreteParameter focusedPattern;
    public final BooleanParameter controlsExpanded = new BooleanParameter("Expanded", true).setDescription("Whether the control elements for the channel device are expanded");
    public final EnumParameter<CompositeMode> compositeMode = new EnumParameter<CompositeMode>("Composite Mode", CompositeMode.PLAYLIST).setDescription("Pattern compositing mode, patterns either act as an ordered playlist or are all blended together");
    public final BooleanParameter compositeDampingEnabled = new BooleanParameter("Damping", true).setDescription("Whether damping is enabled when a pattern is enabled or disabled");
    public final CompoundParameter compositeDampingTimeSecs = new CompoundParameter("Damping Time", 0.1, 0.05, 5.0).setUnits(LXParameter.Units.SECONDS).setDescription("Damping time when a pattern is enabled/disabled in blend mode");
    public final BooleanParameter autoCycleEnabled = new BooleanParameter("Auto-Cycle", false).setDescription("When enabled, this channel will automatically cycle between its patterns");
    public final EnumParameter<AutoCycleMode> autoCycleMode = new EnumParameter<AutoCycleMode>("Auto-Cycle Mode", AutoCycleMode.NEXT).setDescription("Mode of auto cycling");
    public final BoundedParameter autoCycleTimeSecs = new BoundedParameter("Cycle Time", 60.0, 0.1, 14400.0).setDescription("Sets the number of seconds after which the channel cycles to the next pattern").setUnits(LXParameter.Units.SECONDS);
    public final BoundedParameter transitionTimeSecs = new BoundedParameter("Transition Time", 5.0, 0.05, 180.0).setDescription("Sets the duration of blending transitions between patterns").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter transitionEnabled = new BooleanParameter("Transitions", false).setDescription("When enabled, transitions between patterns use a blend");
    public final ObjectParameter<LXBlend> transitionBlendMode;
    private final List<LXPattern> mutablePatterns = new ArrayList<LXPattern>();
    public final List<LXPattern> patterns = Collections.unmodifiableList(this.mutablePatterns);
    public final MutableParameter controlSurfaceSemaphore = new MutableParameter("Control-Surfaces", 0.0).setDescription("How many control surfaces are controlling this component");
    public final TriggerParameter triggerPatternCycle = new TriggerParameter("Trigger Pattern Cycle", this::onTriggerPatternCycle).setDescription("Triggers a pattern change on the channel");
    public final QuantizedTriggerParameter launchPatternCycle = new QuantizedTriggerParameter.Launch(this.lx, "Launch Pattern Cycle", this.triggerPatternCycle::trigger).setDescription("Launches a pattern change on the channel");
    public final BooleanParameter viewPatternLabel = new BooleanParameter("View Pattern Label", false).setDescription("Whether to show the active pattern as channel label");
    protected final ModelBuffer renderBuffer;
    private double autoCycleProgress = 0.0;
    private double transitionProgress = 0.0;
    private int activePatternIndex = -1;
    private int nextPatternIndex = -1;
    private LXGroup group = null;
    private LXBlend transition = null;
    private long transitionMillis = 0L;
    public static final String PATH_PATTERN = "pattern";
    public static final String PATH_ACTIVE = "active";
    public static final String PATH_ACTIVE_PATTERN = "activePattern";
    public static final String PATH_NEXT_PATTERN = "nextPattern";
    private final List<LXPattern> randomEligible = new ArrayList<LXPattern>();
    private static final String KEY_PATTERNS = "patterns";
    private static final String KEY_PATTERN_INDEX = "patternIndex";
    private static final String KEY_GROUP = "group";
    protected static final String KEY_IS_GROUP = "isGroup";

    public LXChannel(LX lx, int index, LXPattern[] patterns) {
        super(lx, index, "Channel-" + (index + 1));
        this.renderBuffer = new ModelBuffer(lx);
        this.focusedPattern = new DiscreteParameter("Focused Pattern", 0, Math.max(1, patterns.length)).setDescription("Which pattern has focus in the UI");
        this.transitionBlendMode = new ObjectParameter<LXBlend>("Transition Blend", new LXBlend[1]).setDescription("Specifies the blending function used for transitions between patterns on the channel");
        this.updateTransitionBlendOptions();
        this.transitionMillis = lx.engine.nowMillis;
        this._updatePatterns(patterns);
        this.addArray(PATH_PATTERN, this.patterns);
        this.addInternalParameter("controlsExpanded", this.controlsExpanded);
        this.addInternalParameter("viewPatternLabel", this.viewPatternLabel);
        this.addParameter("compositeMode", this.compositeMode);
        this.addParameter("compositeDampingEnabled", this.compositeDampingEnabled);
        this.addParameter("compositeDampingTimeSecs", this.compositeDampingTimeSecs);
        this.addParameter("autoCycleEnabled", this.autoCycleEnabled);
        this.addParameter("autoCycleMode", this.autoCycleMode);
        this.addParameter("autoCycleTimeSecs", this.autoCycleTimeSecs);
        this.addParameter("transitionEnabled", this.transitionEnabled);
        this.addParameter("transitionTimeSecs", this.transitionTimeSecs);
        this.addParameter("transitionBlendMode", this.transitionBlendMode);
        this.addParameter("focusedPattern", this.focusedPattern);
        this.addParameter("triggerPatternCycle", this.triggerPatternCycle);
        this.addParameter("launchPatternCycle", this.launchPatternCycle);
    }

    @Override
    public boolean isPlaylist() {
        return this.compositeMode.getEnum() == CompositeMode.PLAYLIST;
    }

    @Override
    public boolean isComposite() {
        return this.compositeMode.getEnum() == CompositeMode.BLEND;
    }

    private void disposeTransitionBlendOptions() {
        LXBlend[] lXBlendArray = this.transitionBlendMode.getObjects();
        int n = lXBlendArray.length;
        int n2 = 0;
        while (n2 < n) {
            LXBlend blend = lXBlendArray[n2];
            if (blend != null) {
                LX.dispose(blend);
            }
            ++n2;
        }
    }

    void updateTransitionBlendOptions() {
        this.disposeTransitionBlendOptions();
        this.transitionBlendMode.setObjects((LXBlend[])this.lx.engine.mixer.instantiateTransitionBlends(this));
    }

    @Override
    void updateChannelBlendOptions() {
        super.updateChannelBlendOptions();
        if (this.patterns != null) {
            for (LXPattern pattern : this.patterns) {
                pattern.updateCompositeBlendOptions();
            }
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.autoCycleEnabled) {
            if (this.transition == null) {
                this.transitionMillis = this.lx.engine.nowMillis;
            }
        } else if (p == this.compositeMode) {
            if (this.transition != null) {
                this.finishTransition();
            }
            LXPattern activePattern = this.getActivePattern();
            if (this.compositeMode.getEnum() == CompositeMode.BLEND) {
                for (LXPattern pattern : this.patterns) {
                    pattern.initCompositeDamping(pattern == activePattern);
                }
            } else {
                for (LXPattern pattern : this.patterns) {
                    if (pattern == activePattern || !(pattern.getCompositeDampingLevel() > 0.0)) continue;
                    pattern.deactivate(LXMixerEngine.patternFriendAccess);
                }
                if (activePattern != null && !activePattern.enabled.isOn()) {
                    activePattern.activate(LXMixerEngine.patternFriendAccess);
                }
            }
        }
    }

    public void onPatternEnabled(LXPattern pattern) {
        this.listeners.forEach(listener -> listener.patternEnabled(this, pattern));
    }

    private void onTriggerPatternCycle() {
        if (this.transition != null) {
            this.finishTransition();
        } else {
            this.doPatternCycle();
        }
    }

    @Override
    public LXModel getModelView() {
        if (this.group != null && this.view.isDefault()) {
            return this.group.getModelView();
        }
        return super.getModelView();
    }

    public final void addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXChannel.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXChannel.Listener: " + String.valueOf(listener));
        }
        if (this.inListener) {
            this.addListeners.add(listener);
            return;
        }
        super.addListener(listener);
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXChannel.Listener: " + String.valueOf(listener));
        }
        if (this.inListener) {
            this.removeListeners.add(listener);
            return;
        }
        super.removeListener(listener);
        this.listeners.remove(listener);
    }

    private void _processReentrantListenerChanges() {
        if (!this.removeListeners.isEmpty()) {
            this.removeListeners.forEach(listener -> this.removeListener((Listener)listener));
            this.removeListeners.clear();
        }
        if (!this.addListeners.isEmpty()) {
            this.addListeners.forEach(listener -> this.addListener((Listener)listener));
            this.addListeners.clear();
        }
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_PATTERN)) {
            String patternId = parts[index + 1];
            LXPattern pattern = null;
            if (patternId.equals(PATH_ACTIVE)) {
                pattern = this.getActivePattern();
            } else if (patternId.matches("\\d+")) {
                pattern = this.patterns.get(Integer.parseInt(patternId) - 1);
            } else {
                for (LXPattern p : this.patterns) {
                    if (!p.getOscLabel().equals(patternId)) continue;
                    pattern = p;
                    break;
                }
            }
            if (pattern == null) {
                LXOscEngine.error("Channel " + this.getLabel() + " has no pattern at path: " + patternId);
                return false;
            }
            return pattern.handleOscMessage(message, parts, index + 2);
        }
        if (path.equals(PATH_ACTIVE_PATTERN) || path.equals(PATH_NEXT_PATTERN)) {
            this.goPatternIndex(message.getInt());
            return true;
        }
        return super.handleOscMessage(message, parts, index);
    }

    @Override
    public void midiDispatch(LXShortMessage message) {
        if (message instanceof MidiPanic) {
            for (LXPattern pattern : this.patterns) {
                pattern.midiDispatch(message);
            }
        } else {
            switch (this.compositeMode.getEnum()) {
                case PLAYLIST: {
                    LXPattern nextPattern;
                    LXPattern activePattern = this.getActivePattern();
                    if (activePattern != null) {
                        activePattern.midiDispatch(message);
                    }
                    if ((nextPattern = this.getNextPattern()) != null && nextPattern != activePattern) {
                        nextPattern.midiDispatch(message);
                    }
                    break;
                }
                case BLEND: {
                    for (LXPattern pattern : this.patterns) {
                        if (!pattern.enabled.isOn()) continue;
                        pattern.midiDispatch(message);
                    }
                    break;
                }
            }
        }
        super.midiDispatch(message);
    }

    LXChannel setGroup(LXGroup group) {
        if (this.group != group) {
            this.group = group;
            this.listeners.forEach(listener -> listener.groupChanged(this, group));
        }
        return this;
    }

    @Override
    public LXGroup getGroup() {
        return this.group;
    }

    @Override
    protected LXClip constructClip(int index) {
        return new LXChannelClip(this.lx, this, index);
    }

    public final List<LXPattern> getPatterns() {
        return this.patterns;
    }

    public final LXPattern getPattern(int index) {
        return this.patterns.get(index);
    }

    public final LXPattern getPattern(String label) {
        for (LXPattern pattern : this.patterns) {
            if (!pattern.getLabel().equals(label)) continue;
            return pattern;
        }
        return null;
    }

    public final LXPattern getPatternByClassName(String className) {
        for (LXPattern pattern : this.patterns) {
            if (!pattern.getClass().getName().equals(className)) continue;
            return pattern;
        }
        return null;
    }

    public final LXChannel setPatterns(LXPattern[] patterns) {
        LXPattern active;
        if (this.transition != null) {
            this.finishTransition();
        } else {
            active = this.getActivePattern();
            if (active != null) {
                active.deactivate(LXMixerEngine.patternFriendAccess);
            }
        }
        this._updatePatterns(patterns);
        this.nextPatternIndex = this.patterns.isEmpty() ? -1 : 0;
        this.activePatternIndex = this.nextPatternIndex;
        this.transition = null;
        active = this.getActivePattern();
        if (active != null) {
            active.activate(LXMixerEngine.patternFriendAccess);
        }
        return this;
    }

    public final LXChannel addPattern(LXPattern pattern) {
        return this.addPattern(pattern, -1);
    }

    public final LXChannel addPattern(LXPattern pattern, int index) {
        LXPattern activePattern;
        if (index > this.mutablePatterns.size()) {
            throw new IllegalArgumentException("Invalid pattern index: " + index);
        }
        pattern.setChannel(this);
        LXPattern focusedPattern = this.getFocusedPattern();
        if (index < 0) {
            pattern.setIndex(this.mutablePatterns.size());
            this.mutablePatterns.add(pattern);
        } else {
            pattern.setIndex(index);
            activePattern = this.getActivePattern();
            LXPattern nextPattern = this.getNextPattern();
            this.mutablePatterns.add(index, pattern);
            int i = index + 1;
            while (i < this.mutablePatterns.size()) {
                this.mutablePatterns.get(i).setIndex(i);
                ++i;
            }
            if (activePattern != null) {
                this.activePatternIndex = activePattern.getIndex();
            }
            if (nextPattern != null) {
                this.nextPatternIndex = nextPattern.getIndex();
            }
        }
        this.focusedPattern.setRange(Math.max(1, this.mutablePatterns.size()));
        if (focusedPattern != null) {
            this.focusedPattern.setValue(focusedPattern.getIndex());
        } else {
            this.focusedPattern.bang();
        }
        this.inListener = true;
        this.listeners.forEach(listener -> listener.patternAdded(this, pattern));
        this.inListener = false;
        this._processReentrantListenerChanges();
        this.lx.engine.clips.updatePatternGridSize();
        if (this.mutablePatterns.size() == 1) {
            this.nextPatternIndex = 0;
            this.activePatternIndex = 0;
            this.focusedPattern.bang();
            activePattern = this.getActivePattern();
            activePattern.activate(LXMixerEngine.patternFriendAccess);
            this.listeners.forEach(listener -> listener.patternDidChange(this, activePattern));
        } else if (this.compositeMode.getEnum() == CompositeMode.BLEND && pattern.enabled.isOn()) {
            pattern.activate(LXMixerEngine.patternFriendAccess);
        }
        return this;
    }

    public final LXChannel removePattern(LXPattern pattern) {
        int index = this.mutablePatterns.indexOf(pattern);
        if (index < 0) {
            return this;
        }
        boolean wasActive = this.activePatternIndex == index;
        boolean wasNext = this.transition != null && this.nextPatternIndex == index;
        boolean activateNext = false;
        int focusedPatternIndex = this.focusedPattern.getValuei();
        if (this.transition != null) {
            if (wasNext) {
                this.cancelTransition();
            } else if (wasActive) {
                this.finishTransition();
            }
        } else if (wasActive) {
            pattern.deactivate(LXMixerEngine.patternFriendAccess);
            activateNext = true;
        }
        this.mutablePatterns.remove(index);
        int i = index;
        while (i < this.mutablePatterns.size()) {
            this.mutablePatterns.get(i).setIndex(i);
            ++i;
        }
        if (this.activePatternIndex > index) {
            --this.activePatternIndex;
        } else if (this.activePatternIndex >= this.mutablePatterns.size()) {
            this.activePatternIndex = this.mutablePatterns.size() - 1;
        }
        if (this.nextPatternIndex > index) {
            --this.nextPatternIndex;
        } else if (this.nextPatternIndex >= this.mutablePatterns.size()) {
            this.nextPatternIndex = this.mutablePatterns.size() - 1;
        }
        if (focusedPatternIndex > index) {
            --focusedPatternIndex;
        } else if (focusedPatternIndex >= this.mutablePatterns.size()) {
            focusedPatternIndex = this.mutablePatterns.size() - 1;
        }
        if (focusedPatternIndex >= 0 && this.focusedPattern.getValuei() != focusedPatternIndex) {
            this.focusedPattern.setValue(focusedPatternIndex);
        } else {
            this.focusedPattern.bang();
        }
        this.focusedPattern.setRange(Math.max(1, this.mutablePatterns.size()));
        this.inListener = true;
        this.listeners.forEach(listener -> listener.patternRemoved(this, pattern));
        this.inListener = false;
        this._processReentrantListenerChanges();
        this.lx.engine.clips.updatePatternGridSize();
        if (activateNext && !this.patterns.isEmpty()) {
            LXPattern newActive = this.getActivePattern();
            newActive.activate(LXMixerEngine.patternFriendAccess);
            this.listeners.forEach(listener -> listener.patternDidChange(this, newActive));
            this.lx.engine.osc.sendMessage(this.getOscAddress() + "/activePattern", newActive.getIndex());
        }
        LX.dispose(pattern);
        return this;
    }

    private void _updatePatterns(LXPattern[] patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException("May not set null pattern array");
        }
        int i = this.mutablePatterns.size() - 1;
        while (i >= 0) {
            this.removePattern(this.mutablePatterns.get(i));
            --i;
        }
        LXPattern[] lXPatternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            LXPattern pattern = lXPatternArray[n2];
            if (pattern == null) {
                throw new IllegalArgumentException("Pattern array may not include null elements");
            }
            this.addPattern(pattern);
            ++n2;
        }
    }

    public LXChannel movePattern(LXPattern pattern, int index) {
        LXPattern focusedPattern = this.getFocusedPattern();
        LXPattern activePattern = this.getActivePattern();
        LXPattern nextPattern = this.getNextPattern();
        this.mutablePatterns.remove(pattern);
        this.mutablePatterns.add(index, pattern);
        int i = 0;
        for (LXPattern p : this.mutablePatterns) {
            p.setIndex(i++);
        }
        this.activePatternIndex = activePattern.getIndex();
        this.nextPatternIndex = nextPattern.getIndex();
        this.listeners.forEach(listener -> listener.patternMoved(this, pattern));
        if (pattern == focusedPattern) {
            this.focusedPattern.setValue(pattern.getIndex());
        }
        return this;
    }

    public final int getFocusedPatternIndex() {
        return this.focusedPattern.getValuei();
    }

    public final LXPattern getFocusedPattern() {
        if (this.patterns.isEmpty()) {
            return null;
        }
        return this.patterns.get(this.focusedPattern.getValuei());
    }

    @Override
    public String getClipLabel() {
        LXPattern pattern = this.getActivePattern();
        if (pattern != null) {
            return pattern.getLabel();
        }
        return super.getClipLabel();
    }

    public final int getActivePatternIndex() {
        return this.activePatternIndex;
    }

    public final LXPattern getActivePattern() {
        return this.activePatternIndex >= 0 ? this.mutablePatterns.get(this.activePatternIndex) : null;
    }

    public final LXPattern getTargetPattern() {
        return this.transition != null ? this.getNextPattern() : this.getActivePattern();
    }

    public final int getNextPatternIndex() {
        return this.nextPatternIndex;
    }

    public final LXPattern getNextPattern() {
        return this.nextPatternIndex >= 0 ? this.mutablePatterns.get(this.nextPatternIndex) : null;
    }

    public boolean isInTransition() {
        return this.transition != null;
    }

    public final LXChannel goPreviousPattern() {
        if (this.transition != null) {
            return this;
        }
        if (this.patterns.size() <= 1) {
            return this;
        }
        this.nextPatternIndex = this.activePatternIndex - 1;
        if (this.nextPatternIndex < 0) {
            this.nextPatternIndex = this.mutablePatterns.size() - 1;
        }
        this.startTransition();
        return this;
    }

    public final LXChannel goNextPattern() {
        if (this.transition != null) {
            return this;
        }
        if (this.patterns.size() <= 1) {
            return this;
        }
        this.nextPatternIndex = this.activePatternIndex;
        do {
            this.nextPatternIndex = (this.nextPatternIndex + 1) % this.patterns.size();
        } while (this.nextPatternIndex != this.activePatternIndex && !this.getNextPattern().isAutoCycleEligible());
        if (this.nextPatternIndex != this.activePatternIndex) {
            this.startTransition();
        }
        return this;
    }

    public final LXChannel goPattern(LXPattern pattern) {
        return this.goPattern(pattern, false);
    }

    public final LXChannel goPattern(LXPattern pattern, boolean skipTransition) {
        int index = this.patterns.indexOf(pattern);
        if (index >= 0) {
            this.goPatternIndex(index);
        }
        if (skipTransition && this.transition != null) {
            this.finishTransition();
        }
        return this;
    }

    public final LXChannel goRandomPattern() {
        if (this.transition != null) {
            return this;
        }
        if (this.patterns.size() <= 1) {
            return this;
        }
        LXPattern activePattern = this.getActivePattern();
        this.randomEligible.clear();
        for (LXPattern pattern : this.patterns) {
            if (pattern == activePattern || !pattern.isAutoCycleEligible()) continue;
            this.randomEligible.add(pattern);
        }
        int numEligible = this.randomEligible.size();
        if (numEligible > 0) {
            return this.goPattern(this.randomEligible.get(LXUtils.constrain((int)LXUtils.random(0.0, numEligible), 0, numEligible - 1)));
        }
        return this;
    }

    public final LXChannel goPatternIndex(int index) {
        if (!this.isPlaylist()) {
            return this;
        }
        if (index < 0 || index >= this.patterns.size()) {
            LX.error(new Exception(), "Illegal pattern index " + index + " passed to LXChannel.goPatternIndex() ");
            return this;
        }
        if (this.transition != null) {
            this.finishTransition();
        }
        this.nextPatternIndex = index;
        this.startTransition();
        return this;
    }

    public LXBus disableAutoCycle() {
        this.autoCycleEnabled.setValue(false);
        return this;
    }

    public LXBus enableAutoCycle(double autoCycleThreshold) {
        this.autoCycleTimeSecs.setValue(autoCycleThreshold);
        this.autoCycleEnabled.setValue(true);
        return this;
    }

    public double getAutoCycleProgress() {
        return this.autoCycleProgress;
    }

    public double getTransitionProgress() {
        return this.transitionProgress;
    }

    private void startTransition() {
        LXPattern nextPattern;
        LXPattern activePattern = this.getActivePattern();
        if (activePattern == (nextPattern = this.getNextPattern())) {
            return;
        }
        nextPattern.activate(LXMixerEngine.patternFriendAccess);
        this.listeners.forEach(listener -> listener.patternWillChange(this, activePattern, nextPattern));
        this.lx.engine.osc.sendMessage(this.getOscAddress() + "/nextPattern", nextPattern.getIndex());
        if (this.transitionEnabled.isOn()) {
            this.transition = this.transitionBlendMode.getObject();
            this.transition.onActive();
            nextPattern.onTransitionStart();
            this.transitionMillis = this.lx.engine.nowMillis;
        } else {
            this.finishTransition();
        }
    }

    private void cancelTransition() {
        if (this.transition != null) {
            LXPattern nextPattern = this.getNextPattern();
            nextPattern.onTransitionEnd();
            nextPattern.deactivate(LXMixerEngine.patternFriendAccess);
            this.transition.onInactive();
            this.transition = null;
            this.transitionMillis = this.lx.engine.nowMillis;
            LXPattern activePattern = this.getActivePattern();
            this.listeners.forEach(listener -> listener.patternDidChange(this, activePattern));
            this.lx.engine.osc.sendMessage(this.getOscAddress() + "/activePattern", activePattern.getIndex());
            this.lx.engine.osc.sendMessage(this.getOscAddress() + "/nextPattern", -1);
        }
    }

    private void finishTransition() {
        this.getActivePattern().deactivate(LXMixerEngine.patternFriendAccess);
        this.activePatternIndex = this.nextPatternIndex;
        LXPattern activePattern = this.getActivePattern();
        if (this.transition != null) {
            activePattern.onTransitionEnd();
            this.transition.onInactive();
        }
        this.transition = null;
        this.transitionMillis = this.lx.engine.nowMillis;
        this.listeners.forEach(listener -> listener.patternDidChange(this, activePattern));
        this.lx.engine.osc.sendMessage(this.getOscAddress() + "/activePattern", activePattern.getIndex());
        this.lx.engine.osc.sendMessage(this.getOscAddress() + "/nextPattern", -1);
        if (this.lx.flags.focusActivePattern) {
            this.focusedPattern.setValue(this.activePatternIndex);
        }
    }

    private void doPatternCycle() {
        switch (this.autoCycleMode.getEnum()) {
            case NEXT: {
                this.goNextPattern();
                break;
            }
            case RANDOM: {
                this.goRandomPattern();
            }
        }
    }

    @Override
    public void loop(double deltaMs) {
        long loopStart = System.nanoTime();
        super.loop(deltaMs);
        if (!this.isAnimating) {
            this.profiler.loopNanos = System.nanoTime() - loopStart;
            return;
        }
        this.colors = this.blendBuffer.getArray();
        this.blendBuffer.copyFrom(this.lx.engine.mixer.backgroundTransparent);
        if (this.compositeMode.getEnum() == CompositeMode.BLEND) {
            boolean dampingEnabled = this.compositeDampingEnabled.isOn();
            double dampingTimeSecs = this.compositeDampingTimeSecs.getValue();
            for (LXPattern pattern : this.patterns) {
                pattern.updateCompositeDamping(deltaMs, dampingEnabled, dampingTimeSecs);
                double patternDamping = pattern.getCompositeDampingLevel();
                if (patternDamping == 0.0) continue;
                LXModel patternView = pattern.getModelView();
                pattern.setBuffer(this.renderBuffer);
                pattern.setModel(patternView);
                pattern.loop(deltaMs);
                pattern.compositeMode.getObject().blend(this.colors, pattern.getColors(), patternDamping * pattern.compositeLevel.getValue(), this.colors, patternView);
            }
        } else {
            if (this.transition != null) {
                boolean shouldFinish;
                boolean bl = shouldFinish = !this.transitionEnabled.isOn();
                if (!shouldFinish) {
                    double transitionMs = this.lx.engine.nowMillis - this.transitionMillis;
                    double transitionDone = 1000.0 * this.transitionTimeSecs.getValue();
                    boolean bl2 = shouldFinish = transitionMs >= transitionDone;
                }
                if (shouldFinish) {
                    this.finishTransition();
                }
            }
            LXPattern activePattern = this.getActivePattern();
            if (this.transition == null) {
                BoundedParameter autoCycleTimeParam = this.autoCycleTimeSecs;
                if (activePattern != null && activePattern.hasCustomCycleTime.isOn()) {
                    autoCycleTimeParam = activePattern.customCycleTimeSecs;
                }
                this.autoCycleProgress = (double)(this.lx.engine.nowMillis - this.transitionMillis) / (1000.0 * autoCycleTimeParam.getValue());
                if (this.autoCycleProgress >= 1.0) {
                    this.autoCycleProgress = 1.0;
                    if (this.autoCycleEnabled.isOn()) {
                        this.doPatternCycle();
                    }
                }
            }
            if (activePattern != null) {
                activePattern.setBuffer(this.blendBuffer);
                activePattern.setModel(activePattern.getModelView());
                activePattern.loop(deltaMs);
            } else {
                this.blendBuffer.copyFrom(this.lx.engine.mixer.backgroundBlack);
            }
            if (this.transition != null) {
                this.autoCycleProgress = 1.0;
                this.transitionProgress = (double)(this.lx.engine.nowMillis - this.transitionMillis) / (1000.0 * this.transitionTimeSecs.getValue());
                LXPattern nextPattern = this.getNextPattern();
                nextPattern.setBuffer(this.renderBuffer);
                nextPattern.setModel(nextPattern.getModelView());
                nextPattern.loop(deltaMs);
                this.transition.loop(deltaMs);
                this.transition.lerp(this.colors, this.renderBuffer.getArray(), this.transitionProgress, this.colors, this.getModelView());
            } else {
                this.transitionProgress = 0.0;
            }
        }
        this.profiler.loopNanos = System.nanoTime() - loopStart;
        long effectStart = System.nanoTime();
        if (!this.mutableEffects.isEmpty()) {
            for (LXEffect effect : this.mutableEffects) {
                effect.setBuffer(this.blendBuffer);
                effect.setModel(effect.getModelView());
                effect.loop(deltaMs);
            }
        }
        ((LXBus.Profiler)this.profiler).effectNanos = System.nanoTime() - effectStart;
    }

    @Override
    public void dispose() {
        this.disposeClips();
        this.nextPatternIndex = -1;
        this.activePatternIndex = -1;
        this.focusedPattern.setValue(0.0);
        for (LXPattern pattern : this.mutablePatterns) {
            LX.dispose(pattern);
        }
        this.mutablePatterns.clear();
        if (this.thread.hasStarted) {
            this.thread.interrupt();
        }
        this.renderBuffer.dispose();
        super.dispose();
        this.disposeTransitionBlendOptions();
        this.listeners.forEach(listener -> LX.warning("Stranded LXChannel.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    @Override
    public Class<?> getPresetClass() {
        return this.getClass();
    }

    @Override
    public void postProcessPreset(LX lx, JsonObject obj) {
        super.postProcessPreset(lx, obj);
        obj.remove(KEY_GROUP);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_PATTERN_INDEX, (Number)this.activePatternIndex);
        obj.add(KEY_PATTERNS, (JsonElement)LXSerializable.Utils.toArray(lx, this.patterns));
        if (this.group != null) {
            obj.addProperty(KEY_GROUP, (Number)this.group.getId());
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        LXPattern activePattern;
        int patternIndex;
        int i = this.mutablePatterns.size() - 1;
        while (i >= 0) {
            this.removePattern(this.mutablePatterns.get(i));
            --i;
        }
        if (obj.has(KEY_GROUP)) {
            int groupId = obj.get(KEY_GROUP).getAsInt();
            LXComponent group = lx.getProjectComponent(groupId);
            if (group instanceof LXGroup) {
                ((LXGroup)group).addChannel(this);
            } else {
                LX.error("Group ID " + groupId + " not found when restoring channel: " + String.valueOf(this));
            }
        }
        JsonArray patternsArray = obj.getAsJsonArray(KEY_PATTERNS);
        for (JsonElement patternElement : patternsArray) {
            JsonObject patternObj = (JsonObject)patternElement;
            this.loadPattern(patternObj, -1);
        }
        this.nextPatternIndex = -1;
        this.activePatternIndex = -1;
        if (obj.has(KEY_PATTERN_INDEX) && (patternIndex = obj.get(KEY_PATTERN_INDEX).getAsInt()) < this.patterns.size()) {
            this.activePatternIndex = this.nextPatternIndex = patternIndex;
        }
        if ((activePattern = this.getActivePattern()) != null) {
            this.listeners.forEach(listener -> listener.patternDidChange(this, activePattern));
            this.lx.engine.osc.sendMessage(this.getOscAddress() + "/activePattern", activePattern.getIndex());
        }
        super.load(lx, obj);
    }

    public LXPattern loadPattern(JsonObject patternObj, int index) {
        LXPattern pattern;
        String patternClass = patternObj.get("class").getAsString();
        try {
            pattern = this.lx.instantiatePattern(patternClass);
        }
        catch (LX.InstantiationException x) {
            LX.error("Using placeholder class for missing pattern: " + patternClass);
            pattern = new LXPattern.Placeholder(this.lx, x);
            this.lx.pushError(x, patternClass + " could not be loaded. " + x.getMessage());
        }
        pattern.load(this.lx, patternObj);
        this.addPattern(pattern, index);
        return pattern;
    }

    public static enum AutoCycleMode {
        NEXT("Next"),
        RANDOM("Random");

        public final String label;

        private AutoCycleMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum CompositeMode {
        PLAYLIST("Playlist"),
        BLEND("Blend");

        public final String label;

        private CompositeMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface Listener
    extends LXAbstractChannel.Listener {
        default public void groupChanged(LXChannel channel, LXGroup group) {
        }

        default public void patternAdded(LXChannel channel, LXPattern pattern) {
        }

        default public void patternRemoved(LXChannel channel, LXPattern pattern) {
        }

        default public void patternMoved(LXChannel channel, LXPattern pattern) {
        }

        default public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
        }

        default public void patternDidChange(LXChannel channel, LXPattern pattern) {
        }

        default public void patternEnabled(LXChannel channel, LXPattern pattern) {
        }
    }
}

