/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.mixer;

import heronarts.lx.LX;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXGroupClip;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.parameter.LXParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LXGroup
extends LXAbstractChannel {
    private final List<LXChannel> mutableChannels = new ArrayList<LXChannel>();
    public final List<LXChannel> channels = Collections.unmodifiableList(this.mutableChannels);

    @Override
    protected LXModulatorComponent.Profiler constructProfiler() {
        return new Profiler();
    }

    public LXGroup(LX lx, int index) {
        super(lx, index, "Group-" + (index + 1));
    }

    @Override
    protected LXClip constructClip(int index) {
        return new LXGroupClip(this.lx, this, index);
    }

    public LXGroup addChannel(LXChannel channel) {
        if (this.channels.contains(channel)) {
            throw new IllegalStateException("Cannot add channel to group twice: " + String.valueOf(channel) + " " + String.valueOf(this));
        }
        this.mutableChannels.add(channel);
        channel.setGroup(this);
        return this;
    }

    LXGroup removeChannel(LXChannel channel) {
        if (!this.channels.contains(channel)) {
            throw new IllegalStateException("Cannot remove channel not in group: " + String.valueOf(channel) + " " + String.valueOf(this));
        }
        this.mutableChannels.remove(channel);
        channel.setGroup(null);
        return this;
    }

    public LXChannel getLastChannel() {
        int index = -1;
        LXChannel last = null;
        for (LXChannel channel : this.channels) {
            int channelIndex = channel.getIndex();
            if (channelIndex <= index) continue;
            index = channelIndex;
            last = channel;
        }
        return last;
    }

    public void ungroup() {
        int i = this.channels.size() - 1;
        while (i >= 0) {
            this.removeChannel(this.channels.get(i));
            --i;
        }
        this.lx.engine.mixer.removeChannel(this);
    }

    @Override
    public void onParameterChanged(LXParameter parameter) {
        super.onParameterChanged(parameter);
        if (parameter == this.selected && this.selected.isOn()) {
            for (LXChannel channel : this.channels) {
                channel.selected.setValue(false);
            }
        }
    }

    void afterLoop(double deltaMs) {
        long compositeStart = System.nanoTime();
        this.blendBuffer.copyFrom(this.lx.engine.mixer.backgroundTransparent);
        this.colors = this.blendBuffer.getArray();
        for (LXChannel channel : this.channels) {
            if (!channel.enabled.isOn()) continue;
            ((LXBlend)channel.blendMode.getObject()).blend(this.colors, channel.getColors(), channel.fader.getValue(), this.colors, channel.getModelView());
        }
        ((Profiler)this.profiler).compositeNanos = System.nanoTime() - compositeStart;
        long effectStart = System.nanoTime();
        if (this.effects.size() > 0) {
            for (LXEffect effect : this.effects) {
                effect.setBuffer(this.blendBuffer);
                effect.setModel(effect.getModelView());
                effect.loop(deltaMs);
            }
        }
        ((LXBus.Profiler)this.profiler).effectNanos = System.nanoTime() - effectStart;
    }

    @Override
    public void dispose() {
        if (!this.channels.isEmpty()) {
            throw new IllegalStateException("Cannot dispose of LXGroup that still has channels");
        }
        super.dispose();
    }

    public class Profiler
    extends LXAbstractChannel.Profiler {
        public long compositeNanos;

        public Profiler() {
            super(LXGroup.this);
        }
    }
}

