/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.transform.LXVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GridModel
extends LXModel {
    public final Point[] points;
    public final List<Strip> rows;
    public final List<Strip> columns;
    public final Metrics metrics;
    public final int width;
    public final int height;
    public final float xSpacing;
    public final float ySpacing;

    public GridModel(Metrics metrics) {
        super(metrics.toPoints(), "grid");
        this.metrics = metrics;
        this.width = metrics.width;
        this.height = metrics.height;
        this.xSpacing = metrics.spacing.x;
        this.ySpacing = metrics.spacing.y;
        this.points = new Point[((LXModel)this).points.length];
        System.arraycopy(((LXModel)this).points, 0, this.points, 0, ((LXModel)this).points.length);
        ArrayList<Strip> rows = new ArrayList<Strip>();
        int y = 0;
        while (y < this.height) {
            ArrayList<LXPoint> row = new ArrayList<LXPoint>();
            int x = 0;
            while (x < this.width) {
                row.add(this.points[x + y * this.width]);
                ++x;
            }
            rows.add(new Strip(y, row));
            ++y;
        }
        this.rows = Collections.unmodifiableList(rows);
        ArrayList<Strip> columns = new ArrayList<Strip>();
        int x = 0;
        while (x < this.width) {
            ArrayList<LXPoint> column = new ArrayList<LXPoint>();
            int y2 = 0;
            while (y2 < this.height) {
                column.add(this.points[x + y2 * this.width]);
                ++y2;
            }
            columns.add(new Strip(x, column));
            ++x;
        }
        this.columns = Collections.unmodifiableList(columns);
    }

    public GridModel(int width, int height) {
        this(width, height, 1.0f, 1.0f);
    }

    public GridModel(int width, int height, float xSpacing, float ySpacing) {
        this(new Metrics(width, height).setSpacing(xSpacing, ySpacing));
    }

    public Point getPoint(int x, int y) {
        return this.points[y * this.width + x];
    }

    public static class Metrics {
        public final int width;
        public final int height;
        private final LXVector origin = new LXVector(0.0f, 0.0f, 0.0f);
        private final LXVector spacing = new LXVector(1.0f, 1.0f, 0.0f);

        public Metrics(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Metrics setXSpacing(float xSpacing) {
            this.spacing.x = xSpacing;
            return this;
        }

        public Metrics setYSpacing(float ySpacing) {
            this.spacing.y = ySpacing;
            return this;
        }

        public Metrics setSpacing(float xSpacing, float ySpacing) {
            this.spacing.x = xSpacing;
            this.spacing.y = ySpacing;
            return this;
        }

        public float xSpacing() {
            return this.xSpacing();
        }

        public float ySpacing() {
            return this.ySpacing();
        }

        public Metrics setOrigin(float x, float y, float z) {
            this.origin.set(x, y, z);
            return this;
        }

        public Metrics setOrigin(LXVector v) {
            this.origin.set(v);
            return this;
        }

        private List<LXPoint> toPoints() {
            ArrayList<LXPoint> points = new ArrayList<LXPoint>(this.width * this.height);
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    points.add(new Point(x, y, this.origin.x + (float)x * this.spacing.x, this.origin.y + (float)y * this.spacing.y, this.origin.z));
                    ++x;
                }
                ++y;
            }
            return points;
        }
    }

    public static class Point
    extends LXPoint {
        public final int xi;
        public final int yi;

        public Point(int xi, int yi, float x, float y, float z) {
            super(x, y, z);
            this.xi = xi;
            this.yi = yi;
        }
    }

    public class Strip
    extends LXModel {
        public int index;
        public final Point[] points;

        public Strip(int index, List<LXPoint> pointList) {
            super(pointList);
            this.index = index;
            LXPoint[] points = ((LXModel)this).points;
            this.points = new Point[points.length];
            System.arraycopy(points, 0, this.points, 0, points.length);
        }
    }
}

