/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.model.LXModelBuilder;
import heronarts.lx.model.LXNormalizationBounds;
import heronarts.lx.model.LXPoint;
import heronarts.lx.model.LXView;
import heronarts.lx.output.LXOutput;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LXModel
extends LXNormalizationBounds
implements LXSerializable {
    private Map<GeometryFunction, float[]> geometryCache = new HashMap<GeometryFunction, float[]>();
    public final LXMatrix transform = new LXMatrix();
    public final LXPoint[] points;
    private final List<LXPoint> pointList;
    public final Map<String, String> metaData;
    public final LXModel[] children;
    private final Map<String, List<LXModel>> childDict = new HashMap<String, List<LXModel>>();
    private final Map<String, List<LXModel>> subDict = new HashMap<String, List<LXModel>>();
    final List<LXView> derivedViews = new ArrayList<LXView>();
    public LXView cueView = null;
    public final List<LXOutput> outputs;
    public final List<String> tags;
    public final List<Mesh> meshes;
    private LXModel parent;
    private int generation = 0;
    public final int size;
    @Deprecated
    public final LXVector center = new LXVector(0.0f, 0.0f, 0.0f);
    @Deprecated
    public final LXVector average = new LXVector(0.0f, 0.0f, 0.0f);
    public float ax;
    public float ay;
    public float az;
    public float rMin;
    public float rMax;
    public float rRange;
    public float rcMin;
    public float rcMax;
    public float rcRange;
    public float azimuth;
    public float elevation;
    private LXNormalizationBounds normalizationBounds;
    private static final List<LXModel> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private final List<Listener> listeners = new ArrayList<Listener>();

    public LXModel() {
        this(new ArrayList<LXPoint>());
    }

    public LXModel(List<LXPoint> points) {
        this(points, new LXModel[0]);
    }

    public LXModel(List<LXPoint> points, String ... tags) {
        this(points, new LXModel[0], (LXNormalizationBounds)null, (Map<String, String>)null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, Map<String, String> metaData, String ... tags) {
        this(points, new LXModel[0], metaData, tags);
    }

    public LXModel(List<LXPoint> points, LXModel[] children) {
        this(points, children, "model");
    }

    public LXModel(List<LXPoint> points, LXModel[] children, String ... tags) {
        this(points, children, (LXNormalizationBounds)null, (Map<String, String>)null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, String ... tags) {
        this(points, children, bounds, true, null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, boolean setChildBounds, String ... tags) {
        this(points, children, bounds, setChildBounds, null, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, Map<String, String> metaData, String ... tags) {
        this(points, children, null, metaData, Arrays.asList(tags));
    }

    public LXModel(List<LXPoint> points, LXModel[] children, Map<String, String> metaData, List<String> tags) {
        this(points, children, null, metaData, tags, null);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, Map<String, String> metaData, List<String> tags, List<Mesh> meshes) {
        this(points, children, null, metaData, tags, meshes);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, Map<String, String> metaData, List<String> tags) {
        this(points, children, bounds, metaData, tags, null);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, boolean setChildBounds, Map<String, String> metaData, List<String> tags) {
        this(points, children, bounds, setChildBounds, metaData, tags, null);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, Map<String, String> metaData, List<String> tags, List<Mesh> meshes) {
        this(points, children, bounds, true, metaData, tags, meshes);
    }

    public LXModel(List<LXPoint> points, LXModel[] children, LXNormalizationBounds bounds, boolean setChildBounds, Map<String, String> metaData, List<String> tags, List<Mesh> meshes) {
        this.tags = LXModel.validateTags(tags);
        this.pointList = Collections.unmodifiableList(new ArrayList<LXPoint>(points));
        this.setNormalizationBounds(bounds != null ? bounds : this);
        this.children = (LXModel[])children.clone();
        this.addChildren(this.children, setChildBounds);
        this.points = this.pointList.toArray(new LXPoint[0]);
        this.size = this.points.length;
        this.outputs = Collections.unmodifiableList(new ArrayList());
        this.meshes = meshes == null ? null : Collections.unmodifiableList(new ArrayList<Mesh>(meshes));
        HashMap<String, String> mutableMetadata = new HashMap<String, String>();
        if (metaData != null) {
            mutableMetadata.putAll(metaData);
        }
        this.metaData = Collections.unmodifiableMap(mutableMetadata);
        this.recomputeGeometry();
    }

    public LXModel(LXModel[] children) {
        this(children, null);
    }

    public LXModel(LXModel[] children, LXNormalizationBounds bounds) {
        this(children, bounds, "model");
    }

    public LXModel(LXModel[] children, LXNormalizationBounds bounds, String ... tags) {
        this(children, bounds, Arrays.asList(tags));
    }

    private LXModel(LXModel[] children, LXNormalizationBounds bounds, List<String> tags) {
        this.tags = LXModel.validateTags(tags);
        ArrayList<LXPoint> _points = new ArrayList<LXPoint>();
        LXModel[] lXModelArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            LXModel child = lXModelArray[n2];
            LXPoint[] lXPointArray = child.points;
            int n3 = child.points.length;
            int n4 = 0;
            while (n4 < n3) {
                LXPoint p = lXPointArray[n4];
                _points.add(p);
                ++n4;
            }
            ++n2;
        }
        this.setNormalizationBounds(bounds != null ? bounds : this);
        this.children = (LXModel[])children.clone();
        this.addChildren(this.children);
        this.points = _points.toArray(new LXPoint[0]);
        this.pointList = Collections.unmodifiableList(_points);
        this.size = _points.size();
        this.outputs = Collections.unmodifiableList(new ArrayList());
        this.metaData = Collections.unmodifiableMap(new HashMap());
        this.meshes = null;
        this.recomputeGeometry();
    }

    @Deprecated
    public LXModel(LXModelBuilder builder) {
        this(builder, true);
    }

    @Deprecated
    protected LXModel(LXModelBuilder builder, boolean isRoot) {
        if (builder.model != null) {
            throw new IllegalStateException("LXModelBuilder may only be used once: " + String.valueOf(builder));
        }
        this.tags = LXModel.validateTags(builder.tags);
        this.children = new LXModel[builder.children.size()];
        ArrayList<LXPoint> _points = new ArrayList<LXPoint>(builder.points);
        int ci = 0;
        for (LXModelBuilder child : builder.children) {
            this.children[ci++] = new LXModel(child, false);
            for (LXPoint p : child.points) {
                _points.add(p);
            }
        }
        this.addChildren(this.children);
        if (isRoot) {
            this.setNormalizationBounds(this);
        }
        this.points = _points.toArray(new LXPoint[0]);
        this.pointList = Collections.unmodifiableList(_points);
        this.size = this.points.length;
        this.outputs = Collections.unmodifiableList(new ArrayList<LXOutput>(builder.outputs));
        this.metaData = Collections.unmodifiableMap(new HashMap());
        this.meshes = null;
        this.recomputeGeometry();
        if (isRoot) {
            this.reindexPoints();
            this.normalizePoints();
        }
        builder.model = this;
    }

    public static List<String> validateTags(List<String> tags) {
        Objects.requireNonNull(tags, "May not construct LXModel with null tags");
        ArrayList<String> _tags = new ArrayList<String>(tags.size());
        for (String tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("May not pass null tag to LXModel");
            }
            if ((tag = tag.trim()).isEmpty()) {
                throw new IllegalArgumentException("May not pass empty string tag to LXModel");
            }
            if (!Tag.isValid(tag)) {
                throw new IllegalArgumentException("May not pass invalid tag to LXModel: " + tag);
            }
            if (_tags.contains(tag)) continue;
            _tags.add(tag);
        }
        return Collections.unmodifiableList(_tags);
    }

    private void setNormalizationBounds(LXNormalizationBounds normalizationBounds) {
        this.normalizationBounds = normalizationBounds;
        if (this.children != null) {
            LXModel[] lXModelArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                LXModel child = lXModelArray[n2];
                child.setNormalizationBounds(normalizationBounds);
                ++n2;
            }
        }
    }

    void setNormalizationOrientation(LXModel model) {
        this.normalizationBounds.setOrientation(model);
        this.recomputeGeometry();
    }

    public LXNormalizationBounds getNormalizationBounds() {
        return this.normalizationBounds;
    }

    public LXModel getRoot() {
        LXModel root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public LXModel getMainRoot() {
        return this.getRoot();
    }

    public LXModel getParent() {
        return this.parent;
    }

    public boolean contains(LXModel descendant) {
        LXModel child;
        LXModel[] lXModelArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            child = lXModelArray[n2];
            if (child == descendant) {
                return true;
            }
            ++n2;
        }
        lXModelArray = this.children;
        n = this.children.length;
        n2 = 0;
        while (n2 < n) {
            child = lXModelArray[n2];
            if (child.contains(descendant)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getPath() {
        String firstTag;
        LXModel parent = this.parent;
        boolean hasTag = !this.tags.isEmpty();
        String string = firstTag = hasTag ? this.tags.get(0) : "";
        if (parent == null) {
            return "/" + firstTag;
        }
        int index = 0;
        if (hasTag) {
            for (LXModel child : parent.childDict.get(firstTag)) {
                if (child != this) {
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            LXModel[] lXModelArray = parent.children;
            int n = parent.children.length;
            int n2 = 0;
            while (n2 < n) {
                LXModel child = lXModelArray[n2];
                if (child != this) {
                    ++index;
                    ++n2;
                    continue;
                }
                break;
            }
        }
        return parent.getPath() + "/" + firstTag + "[" + index + "]";
    }

    public LXModel reindexPoints() {
        int index = 0;
        LXPoint[] lXPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            p.index = index++;
            ++n2;
        }
        return this;
    }

    private void addChildren(LXModel[] children) {
        this.addChildren(children, true);
    }

    private void addChildren(LXModel[] children, boolean setChildBounds) {
        if (setChildBounds) {
            LXModel[] lXModelArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                LXModel child = lXModelArray[n2];
                child.parent = this;
                child.setNormalizationBounds(this.normalizationBounds);
                ++n2;
            }
        }
        this.addSubmodels(children, this.childDict, false);
        this.addSubmodels(children, this.subDict, true);
    }

    private void addSubmodels(LXModel[] submodels, Map<String, List<LXModel>> dict, boolean recurse) {
        LXModel[] lXModelArray = submodels;
        int n = submodels.length;
        int n2 = 0;
        while (n2 < n) {
            LXModel submodel = lXModelArray[n2];
            for (String tag : submodel.tags) {
                List<LXModel> sub = dict.get(tag);
                if (sub == null) {
                    sub = new ArrayList<LXModel>();
                    dict.put(tag, sub);
                }
                sub.add(submodel);
            }
            if (recurse) {
                this.addSubmodels(submodel.children, dict, recurse);
            }
            ++n2;
        }
    }

    public List<LXModel> children(String tag) {
        List<LXModel> children = this.childDict.get(tag);
        return children == null ? EMPTY_LIST : children;
    }

    public LXModel child(String tag, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("LXModel.child(index) may not be negative: " + index);
        }
        List<LXModel> children = this.childDict.get(tag);
        return children != null && children.size() > index ? children.get(index) : null;
    }

    public List<LXModel> sub(String tag) {
        List<LXModel> sub = this.subDict.get(tag);
        return sub == null ? EMPTY_LIST : sub;
    }

    public LXModel sub(String tag, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("LXModel.sub(index) may not be negative: " + index);
        }
        List<LXModel> sub = this.subDict.get(tag);
        return sub != null && sub.size() > index ? sub.get(index) : null;
    }

    public LXModel ancestor(String tag) {
        LXModel parent = this.getParent();
        while (parent != null) {
            if (parent.tags.contains(tag)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    public String meta(String key) {
        return this.metaData.get(key);
    }

    public final LXModel addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXModel.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public final LXModel removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXModel.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXModel update() {
        return this.update(true, false);
    }

    public LXModel update(boolean normalize) {
        return this.update(normalize, false);
    }

    public LXModel update(boolean normalize, boolean recurse) {
        if (recurse) {
            LXModel[] lXModelArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                LXModel submodel = lXModelArray[n2];
                submodel.update(false, true);
                ++n2;
            }
        }
        this.recomputeGeometry();
        if (normalize) {
            this.normalizePoints();
        }
        for (Map.Entry<GeometryFunction, float[]> entry : this.geometryCache.entrySet()) {
            this.computeGeometry(entry.getKey(), entry.getValue());
        }
        for (LXView view : this.derivedViews) {
            LXPoint[] lXPointArray = this.points;
            int n = this.points.length;
            int n3 = 0;
            while (n3 < n) {
                LXPoint p = lXPointArray[n3];
                LXPoint clone = view.clonedPoints.get(p.index);
                if (clone != null) {
                    clone.set(p);
                }
                ++n3;
            }
            boolean normalizeView = normalize && view.normalization == LXView.Normalization.RELATIVE;
            view.update(normalizeView, recurse);
        }
        this.bang();
        for (LXView view : this.derivedViews) {
            view.bang();
        }
        return this;
    }

    public LXModel bang() {
        ++this.generation;
        for (Listener listener : this.listeners) {
            listener.modelGenerationUpdated(this);
        }
        return this;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int[] toIndexBuffer() {
        return this.toIndexBuffer(0, this.points.length);
    }

    public int[] toIndexBuffer(int offset, int length) {
        if (offset < 0 || offset + length > this.points.length) {
            throw new IllegalArgumentException("Index buffer cannot exceed points array length - offset:" + offset + " length:" + length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Index buffer length cannot be negative: " + length);
        }
        int[] indexBuffer = new int[length];
        int i = 0;
        while (i < length) {
            indexBuffer[i] = this.points[offset + i].index;
            ++i;
        }
        return indexBuffer;
    }

    private void recomputeGeometry() {
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        float xMin = 0.0f;
        float xMax = 0.0f;
        float yMin = 0.0f;
        float yMax = 0.0f;
        float zMin = 0.0f;
        float zMax = 0.0f;
        float rMin = 0.0f;
        float rMax = 0.0f;
        boolean firstPoint = true;
        LXPoint[] lXPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            float px = this.normalizationBounds.px(p);
            float py = this.normalizationBounds.py(p);
            float pz = this.normalizationBounds.pz(p);
            float pr = (float)Math.sqrt(px * px + py * py + pz * pz);
            ax += px;
            ay += py;
            az += pz;
            if (firstPoint) {
                xMin = xMax = px;
                yMin = yMax = py;
                zMin = zMax = pz;
                rMin = rMax = p.r;
                firstPoint = false;
            } else {
                if (px < xMin) {
                    xMin = px;
                }
                if (px > xMax) {
                    xMax = px;
                }
                if (py < yMin) {
                    yMin = py;
                }
                if (py > yMax) {
                    yMax = py;
                }
                if (pz < zMin) {
                    zMin = pz;
                }
                if (pz > zMax) {
                    zMax = pz;
                }
                if (pr < rMin) {
                    rMin = pr;
                }
                if (pr > rMax) {
                    rMax = pr;
                }
            }
            ++n2;
        }
        this.ax = ax / (float)Math.max(1, this.points.length);
        this.ay = ay / (float)Math.max(1, this.points.length);
        this.az = az / (float)Math.max(1, this.points.length);
        this.xMin = xMin;
        this.xMax = xMax;
        this.xRange = xMax - xMin;
        this.yMin = yMin;
        this.yMax = yMax;
        this.yRange = yMax - yMin;
        this.zMin = zMin;
        this.zMax = zMax;
        this.zRange = zMax - zMin;
        this.rMin = rMin;
        this.rMax = rMax;
        this.rRange = rMax - rMin;
        this.cx = xMin + 0.5f * this.xRange;
        this.cy = yMin + 0.5f * this.yRange;
        this.cz = zMin + 0.5f * this.zRange;
        this.center.set(this.cx, this.cy, this.cz);
        this.average.set(this.ax, this.ay, this.az);
        this.azimuth = (float)((Math.PI * 2 + Math.atan2(this.cx, this.cz)) % (Math.PI * 2));
        this.elevation = (float)Math.atan2(this.cy, Math.sqrt(this.cx * this.cx + this.cz * this.cz));
    }

    public LXModel normalizePoints() {
        LXPoint p;
        LXPoint[] lXPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p2 = lXPointArray[n2];
            p2.normalize(this.normalizationBounds, this);
            ++n2;
        }
        float rcMin = 0.0f;
        float rcMax = 0.0f;
        boolean firstPoint = true;
        LXPoint[] lXPointArray2 = this.points;
        int n3 = this.points.length;
        int n4 = 0;
        while (n4 < n3) {
            p = lXPointArray2[n4];
            if (firstPoint) {
                rcMin = p.rc;
                rcMax = p.rc;
                firstPoint = false;
            } else {
                if (p.rc < rcMin) {
                    rcMin = p.rc;
                }
                if (p.rc > rcMax) {
                    rcMax = p.rc;
                }
            }
            ++n4;
        }
        this.rcMin = rcMin;
        this.rcMax = rcMax;
        this.rcRange = rcMax - rcMin;
        if (rcMax == 0.0f) {
            lXPointArray2 = this.points;
            n3 = this.points.length;
            n4 = 0;
            while (n4 < n3) {
                p = lXPointArray2[n4];
                p.rcn = 0.5f;
                ++n4;
            }
        } else {
            lXPointArray2 = this.points;
            n3 = this.points.length;
            n4 = 0;
            while (n4 < n3) {
                p = lXPointArray2[n4];
                p.rcn = p.rc / this.rcMax;
                ++n4;
            }
        }
        return this;
    }

    public List<LXPoint> getPoints() {
        return this.pointList;
    }

    public float[] getGeometry(Geometry geometry) {
        return this.getGeometry(geometry.function);
    }

    public float[] getGeometry(GeometryFunction function) {
        float[] arr = null;
        LXModel root = this.getRoot();
        if (root.normalizationBounds == this.normalizationBounds) {
            arr = root.geometryCache.get(function);
        }
        if (arr == null && (arr = this.geometryCache.get(function)) == null) {
            arr = this.computeGeometry(function);
            this.geometryCache.put(function, arr);
        }
        return arr;
    }

    public float[] computeGeometry(GeometryFunction function) {
        return this.computeGeometry(function, new float[this.getMainRoot().size]);
    }

    private float[] computeGeometry(GeometryFunction function, float[] arr) {
        LXPoint[] lXPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            arr[p.index] = function.compute(this, p);
            ++n2;
        }
        return arr;
    }

    @Override
    public void save(LX lx, JsonObject object) {
        object.addProperty("class", this.getClass().getName());
    }

    @Override
    public void load(LX lx, JsonObject object) {
    }

    public void dispose() {
        while (!this.derivedViews.isEmpty()) {
            this.derivedViews.get(this.derivedViews.size() - 1).dispose();
        }
        LXModel[] lXModelArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            LXModel child = lXModelArray[n2];
            child.dispose();
            ++n2;
        }
        this.listeners.clear();
    }

    public void debugPrint(PrintStream out) {
        this._debugPrint(out, "+ ");
    }

    private void _debugPrint(PrintStream out, String indent) {
        out.print(indent + "[");
        boolean first = true;
        for (String string : this.tags) {
            if (first) {
                first = false;
            } else {
                out.print(", ");
            }
            out.print(string);
        }
        out.print("] {");
        first = true;
        for (Map.Entry entry : this.metaData.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.print(", ");
            }
            out.print((String)entry.getKey() + ": " + (String)entry.getValue());
        }
        out.println("}");
        LXModel[] lXModelArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            LXModel lXModel = lXModelArray[n2];
            lXModel._debugPrint(out, "  " + indent);
            ++n2;
        }
    }

    public static enum Geometry {
        RADIUS_3D_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, p.zn, 0.5f, 0.5f, 0.5f)),
        RADIUS_XY_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, 0.5f, 0.5f)),
        RADIUS_XZ_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.zn, 0.5f, 0.5f)),
        RADIUS_YZ_CENTER_NORMALIZED((model, p) -> LXUtils.distf(p.yn, p.zn, 0.5f, 0.5f)),
        RADIUS_3D_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, p.zn, 0.0f, 0.0f, 0.0f)),
        RADIUS_XY_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.yn, 0.0f, 0.0f)),
        RADIUS_XZ_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.xn, p.zn, 0.0f, 0.0f)),
        RADIUS_YZ_ORIGIN_NORMALIZED((model, p) -> LXUtils.distf(p.yn, p.zn, 0.0f, 0.0f)),
        RADIUS_3D_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.y, p.z, 0.0f, 0.0f, 0.0f)),
        RADIUS_XY_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.y, 0.0f, 0.0f)),
        RADIUS_XZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.x, p.z, 0.0f, 0.0f)),
        RADIUS_YZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.distf(p.y, p.z, 0.0f, 0.0f)),
        AZIMUTH_XZ_CENTER_NORMALIZED((model, p) -> LXUtils.atan2pf(p.xn - 0.5f, p.zn - 0.5f)),
        ELEVATION_XZ_CENTER_NORMALIZED((model, p) -> (float)Math.atan2(p.yn - 0.5f, LXUtils.distf(p.xn, p.zn, 0.5f, 0.5f))),
        AZIMUTH_XZ_ORIGIN_ABSOLUTE((model, p) -> LXUtils.atan2pf(p.x, p.z)),
        ELEVATION_XZ_ORIGIN_ABSOLUTE((model, p) -> (float)Math.atan2(p.y, LXUtils.distf(p.x, p.z, 0.0f, 0.0f))),
        THETA_XY_ORIGIN_ABSOLUTE((model, p) -> LXUtils.atan2pf(p.y, p.x)),
        THETA_XY_CENTER_NORMALIZED((model, p) -> LXUtils.atan2pf(p.yn - 0.5f, p.xn - 0.5f));

        public final GeometryFunction function;

        private Geometry(GeometryFunction compute) {
            this.function = compute;
        }
    }

    public static interface GeometryFunction {
        public float compute(LXModel var1, LXPoint var2);
    }

    public static interface Listener {
        public void modelGenerationUpdated(LXModel var1);
    }

    public static class Mesh {
        public final Type type;
        public final int color;
        public final List<LXVector> vertices;
        public final File file;

        public Mesh(Type type, List<LXVector> vertices, int color) {
            this.type = type;
            this.vertices = Collections.unmodifiableList(vertices);
            this.color = color;
            this.file = null;
        }

        public Mesh(Type type, File meshFile, int color) {
            this.type = type;
            this.vertices = null;
            this.color = color;
            this.file = meshFile;
        }

        public static enum Type {
            UNIFORM_FILL;

        }
    }

    public static class Tag {
        public static final String MODEL = "model";
        public static final String VIEW = "view";
        public static final String GRID = "grid";
        public static final String ROW = "row";
        public static final String COLUMN = "column";
        public static final String STRIP = "strip";
        public static final String POINT = "point";
        public static final String POINTS = "points";
        public static final String ARC = "arc";
        public static final String SPIRAL = "spiral";
        public static final String VALID_TAG_REGEX = "[A-Za-z0-9_\\.\\-/]+";
        public static final String VALID_TEXT_FIELD_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.-/ ,";

        public static boolean isValid(String tag) {
            return tag.matches(VALID_TAG_REGEX);
        }
    }
}

